/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.search;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.visuals.search.DefaultSearchPanel;
import com.sas.metadata.logical.visuals.search.SearchEventListener;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Search;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.search.SearchFolder;
import com.sas.wadmin.search.SearchResultsTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SearchViewPanel
extends WAPanel
implements WsSelectionProvider,
WsActionContextInterface {
    public static final String SEARCH_CONTEXT = "Search";
    private static final String DividerLocationKey = "Search.DividerLocation.x";
    private static final String SearchResultsTableKey = "Search.ResultsTable";
    private JSplitPane m_spltMain;
    private DefaultSearchPanel m_pnlSearch;
    private SearchResultsTableModel m_model;
    private WsTable m_table;
    private ServerInterface m_transaction;
    private Search m_mdoSearch;
    private SearchFolder m_folder;
    private List<PublicObjectInterface> m_lResults;
    private boolean m_bDataMoved;
    private WsAbstractAction m_propertiesAction;
    private Object[] m_aSelectedObjects;
    private boolean m_bSplitLocationSet;

    public SearchViewPanel() {
        this.initialize();
    }

    public SearchViewPanel(Search searchFolder) {
        this.m_mdoSearch = searchFolder;
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.m_pnlSearch = new DefaultSearchPanel();
        this.m_pnlSearch.addSearchListener((SearchEventListener)new SearchListener());
        try {
            this.m_pnlSearch.configurePublicTypes(this.getSupportedPublicTypes());
            this.m_pnlSearch.loadInitialData();
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (LogicalTypeException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        this.m_pnlSearch.layoutComponents();
        this.m_model = new SearchResultsTableModel();
        this.m_table = new WsTable((WsAbstractTableModel)this.m_model);
        this.m_table.setEditable(false);
        this.m_table.setRowHeaderVisible(false);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.getRowModel().getSelectionModel().addListSelectionListener(new SelectionChangedListener());
        this.m_table.setDefaultAction((Action)new DefaultAction());
        this.m_table.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new TableContextMenuListener());
        this.m_table.restoreSettings(SearchResultsTableKey);
        JScrollPane scroll = new JScrollPane((Component)this.m_table);
        this.m_spltMain = new JSplitPane(1, true, (Component)this.m_pnlSearch, scroll);
        this.add(this.m_spltMain, "Center");
        WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
        if (actionsMgr != null) {
            this.m_propertiesAction = actionsMgr.getAction("Application:Properties");
        }
        this.m_aSelectedObjects = new Object[0];
        this.setHelpProduct("searchview");
        this.setHelpTopic("about");
    }

    private List<String> getSupportedPublicTypes() throws RemoteException, LogicalTypeException {
        ArrayList<String> list = new ArrayList<String>();
        TypeInterface[] types = Factory.getInstance().getTypesSupported();
        for (int i = 0; i < types.length; ++i) {
            list.add(types[i].getPublicType());
        }
        return list;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.m_mdoSearch == null) {
            return;
        }
        OMIServer server = Workspace.getWorkspace().getConnectionManager().getMetadataServer();
        try {
            this.m_transaction = server.newChild(true);
            String key = this.m_mdoSearch.getFQID() + "/" + this.m_mdoSearch.getCMetadataType();
            this.m_folder = (SearchFolder)this.m_transaction.fetch(key, true);
            this.m_pnlSearch.setSearchFolder(this.m_folder);
            this.m_lResults = this.m_folder.getSearchResults();
        }
        catch (ServiceException ex) {
            throw new MdException((Throwable)ex);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_bDataMoved) {
            return;
        }
        this.m_bDataMoved = true;
        this.m_pnlSearch.setSearchButtonAsDefaultButton();
        if (this.m_mdoSearch == null) {
            return;
        }
        try {
            this.m_pnlSearch.setPreviousValues();
            this.m_model.setObjects(this.m_lResults);
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException((ServiceException)ex);
        }
        catch (LogicalTypeException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        if (this.m_propertiesAction != null) {
            this.m_propertiesAction.setActive(bActive);
        }
        WsAbstractApplicationActionsManager.getInstance().setSelectionProvider((WsSelectionProvider)(bActive ? this : null));
    }

    public void saveSettingsAndCleanUp() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.setPropertyInt(DividerLocationKey, this.m_spltMain.getDividerLocation());
        this.m_table.saveSettings(SearchResultsTableKey);
        if (this.m_transaction != null) {
            try {
                this.m_transaction.destroy();
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public void doLayout() {
        if (!this.m_bSplitLocationSet) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            int xLocation = appDefaults.getPropertyInt(DividerLocationKey, -1);
            if (xLocation > 0) {
                this.m_spltMain.setDividerLocation(xLocation);
            }
            this.m_bSplitLocationSet = true;
        }
        super.doLayout();
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.add(WsSelectionChangedListener.class, lsnr);
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.remove(WsSelectionChangedListener.class, lsnr);
    }

    public Object[] getSelectedObjects() {
        return this.m_aSelectedObjects;
    }

    private void selectionChanged() {
        int[] aSelectedRows = this.m_table.getSelectedRows();
        this.m_table.convertRowIndexesToModel(aSelectedRows);
        this.m_aSelectedObjects = new Object[aSelectedRows.length];
        for (int iSelectedRow = 0; iSelectedRow < aSelectedRows.length; ++iSelectedRow) {
            this.m_aSelectedObjects[iSelectedRow] = this.m_model.getSimpleObject(aSelectedRows[iSelectedRow]);
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent((WsSelectionProvider)this);
        WsSelectionChangedListener[] aListeners = (WsSelectionChangedListener[])this.listenerList.getListeners(WsSelectionChangedListener.class);
        for (int iListener = aListeners.length - 1; iListener >= 0; --iListener) {
            aListeners[iListener].selectionChanged(ev);
        }
    }

    public void addContextMenuItems(JPopupMenu mnuPopup) {
    }

    public String getType() {
        return SEARCH_CONTEXT;
    }

    private void performDefaultAction() {
        if (this.m_aSelectedObjects.length == 1) {
            WsAbstractApplicationActionsManager.getInstance().performDefaultActionFor((Object)this, this.m_aSelectedObjects[0], (WsActionContextInterface)this);
        }
    }

    private void showContextMenu(MouseEvent e) {
        JPopupMenu menu = WsAbstractApplicationActionsManager.getInstance().createPopupMenuFor((WsActionContextInterface)this);
        if (menu.getComponentCount() != 0) {
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class TableContextMenuListener
    implements WsPopupMenuRequestListener {
        private TableContextMenuListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            SearchViewPanel.this.showContextMenu(e);
        }
    }

    private class SelectionChangedListener
    implements ListSelectionListener {
        private SelectionChangedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            SearchViewPanel.this.selectionChanged();
        }
    }

    private class SearchListener
    implements SearchEventListener {
        private SearchListener() {
        }

        public void searchCompleted(List<PublicObjectInterface> objects) {
            try {
                SearchViewPanel.this.m_model.setObjects(objects);
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (LogicalTypeException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }

        public void searchStarted() {
            SearchViewPanel.this.m_model.clear();
        }

        public void searchCanceled() {
        }
    }

    private class DefaultAction
    extends AbstractAction {
        private DefaultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchViewPanel.this.performDefaultAction();
        }
    }
}

