/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.sascodeimporter;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.sascodeimporter.AnalyzeCode;
import com.sas.wadmin.sascodeimporter.SASCodeImporterLogPanel;
import com.sas.wadmin.sascodeimporter.SASCodeItem;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class SASCodeImporterTab
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(SASCodeImporterTab.class);
    private JPanel m_pnlImportOptions;
    private ButtonGroup m_bgpImportOptions;
    private JRadioButton m_rbnImport;
    private JRadioButton m_rbnAnalyze;
    private ActionListener m_lsrImportOptions;
    private WATextArea m_txtOptionDescription;
    private JLabel m_lblWaring;
    private JButton m_btnAdd;
    private JButton m_btnRemove;
    private JButton m_btnUp;
    private JButton m_btnDown;
    private JButton m_btnBrowse;
    private WsAbstractAction m_actAdd;
    private WsAbstractAction m_actRemove;
    private WsAbstractAction m_actUp;
    private WsAbstractAction m_actDown;
    private WsAbstractAction m_actBrowse;
    private JPanel m_pnlFiles;
    private JLabel m_lblFiles;
    private DefaultListModel m_mdlFiles;
    private JList m_lstFiles;
    private JScrollPane m_scrFiles;
    private ListSelectionListener m_lsrFiles;
    private JPanel m_pnlLocation;
    private JLabel m_lblLocation;
    private WATextField m_txtLocation;
    private JCheckBox m_chkExpandMacros;
    private JCheckBox m_chkRegisterWorkTables;
    private PathUrl m_pthParent;
    private boolean m_bErrors;

    public SASCodeImporterTab() {
        this.setName(bundle.getString("SASCodeImporterTab.Name.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("import_sas_code");
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_rbnImport = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"SASCodeImporterTab.Import", (int)1);
        this.m_rbnAnalyze = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"SASCodeImporterTab.Analyze", (int)1);
        this.m_lsrImportOptions = new ImportButtonGroupListener();
        this.m_rbnImport.addActionListener(this.m_lsrImportOptions);
        this.m_rbnAnalyze.addActionListener(this.m_lsrImportOptions);
        this.m_txtOptionDescription = new WATextArea();
        this.m_txtOptionDescription.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.m_txtOptionDescription.setBehavior(1);
        this.m_txtOptionDescription.setFont(this.m_rbnImport.getFont());
        this.m_txtOptionDescription.setAutosize(true);
        this.m_txtOptionDescription.setColumns(40);
        this.m_lblWaring = new JLabel(bundle.getString("SASCodeImporterTab.WarningLabel.txt"));
        this.m_pnlImportOptions = new JPanel();
        this.m_bgpImportOptions = new ButtonGroup();
        this.m_bgpImportOptions.add(this.m_rbnImport);
        this.m_bgpImportOptions.add(this.m_rbnAnalyze);
        this.m_rbnImport.setSelected(true);
        this.m_actAdd = new AddAction();
        this.m_actRemove = new RemoveAction();
        this.m_actUp = new MoveUpAction();
        this.m_actDown = new MoveDownAction();
        this.m_actBrowse = new BrowseAction();
        this.m_btnAdd = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAdd);
        this.m_btnRemove = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actRemove);
        this.m_btnUp = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actUp);
        this.m_btnDown = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actDown);
        this.m_btnBrowse = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actBrowse);
        this.m_pnlFiles = new JPanel();
        this.m_lblFiles = new JLabel(bundle.getString("SASCodeImporterTab.FileListLabel.txt"));
        this.m_mdlFiles = new DefaultListModel();
        this.m_lstFiles = new JList(this.m_mdlFiles);
        this.m_scrFiles = new JScrollPane(this.m_lstFiles);
        this.m_lsrFiles = new FileSelectionListener();
        this.m_lstFiles.setSelectionMode(2);
        this.m_lstFiles.addListSelectionListener(this.m_lsrFiles);
        this.m_pnlLocation = new JPanel();
        this.m_lblLocation = new JLabel(bundle.getString("SASCodeImporterTab.Location.txt"));
        this.m_txtLocation = new WATextField();
        this.m_txtLocation.setEditable(false);
        this.m_chkExpandMacros = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeImporterTab.ExpandMacros", (int)5);
        this.m_chkRegisterWorkTables = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeImporterTab.RegisterWorkTables", (int)5);
        this.updateActions();
    }

    protected void layoutWidgets() {
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new BoxLayout(pnlButtons, 1));
        pnlButtons.add(this.m_rbnImport);
        pnlButtons.add(this.m_rbnAnalyze);
        this.m_pnlImportOptions.setLayout(new GridBagLayout());
        this.m_pnlImportOptions.add((Component)pnlButtons, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlImportOptions.add((Component)this.m_txtOptionDescription, new GridBagConstraints(1, 0, 1, 2, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.m_pnlFiles.setLayout(new GridBagLayout());
        this.m_pnlFiles.add((Component)this.m_lblFiles, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.m_pnlFiles.add((Component)this.m_scrFiles, new GridBagConstraints(0, 1, 1, 5, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlFiles.add((Component)this.m_btnAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_pnlFiles.add((Component)this.m_btnRemove, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_pnlFiles.add((Component)new JPanel(), new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.m_pnlFiles.add((Component)this.m_btnUp, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlFiles.add((Component)this.m_btnDown, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlLocation.setLayout(new GridBagLayout());
        this.m_pnlLocation.add((Component)this.m_lblLocation, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlLocation.add((Component)this.m_txtLocation, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlLocation.add((Component)this.m_btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_pnlImportOptions, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblWaring, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_pnlFiles, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_pnlLocation, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_chkExpandMacros, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_chkRegisterWorkTables, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateActions() {
        if (this.m_rbnImport.isSelected()) {
            this.m_txtOptionDescription.setText(bundle.getString("SASCodeImporterTab.ImportDescription.txt"));
        } else {
            this.m_txtOptionDescription.setText(bundle.getString("SASCodeImporterTab.AnalyzeDescription.txt"));
        }
        int[] aSelectedIndices = this.m_lstFiles.getSelectedIndices();
        int iFiles = this.m_mdlFiles.size();
        this.m_actRemove.setEnabled(aSelectedIndices.length > 0);
        this.m_actUp.setEnabled(aSelectedIndices.length == 1 && aSelectedIndices[0] != 0);
        this.m_actDown.setEnabled(aSelectedIndices.length == 1 && aSelectedIndices[0] != iFiles - 1);
        this.m_txtLocation.setEnabled(this.m_rbnImport.isSelected());
        this.m_actBrowse.setEnabled(this.m_rbnImport.isSelected());
    }

    public void setFolder(Tree tree) {
        try {
            String strPath = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)tree.getObjectStore(), (PrimaryType)tree, true);
            this.m_pthParent = WsMetadataUtil.getPathURLFromString((UserContextInterface)Workspace.getWorkspace().getUserContext(), (String)strPath);
            this.m_txtLocation.setText(this.m_pthParent.getDisplayPath());
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            Workspace.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
    }

    public String[] getFileList() {
        String[] fileList = new String[this.m_mdlFiles.size()];
        for (int i = 0; i < this.m_mdlFiles.size(); ++i) {
            fileList[i] = (String)this.m_mdlFiles.get(i);
        }
        return fileList;
    }

    public void moveDataToStore() {
        int showLog;
        if (this.m_mdlFiles.isEmpty()) {
            return;
        }
        SASCodeItem.Action action = this.m_rbnImport.isSelected() ? SASCodeItem.Action.IMPORT : SASCodeItem.Action.ANALYZE;
        ArrayList<SASCodeItem> items = new ArrayList<SASCodeItem>();
        for (int i = 0; i < this.m_mdlFiles.size(); ++i) {
            SASCodeItem item = new SASCodeItem((String)this.m_mdlFiles.get(i), action, this.m_chkExpandMacros.isSelected(), this.m_chkRegisterWorkTables.isSelected());
            items.add(item);
        }
        if (this.processFiles(items) && (showLog = this.m_bErrors ? MessageUtil.displayMessage((String)bundle.getString("SASCodeImporterTab.OperationComplete.Errors.txt"), (String)bundle.getString("SASCodeImporterTab.OperationComplete.txt"), (int)0, (int)0) : MessageUtil.displayMessage((String)bundle.getString("SASCodeImporterTab.OperationComplete.NoErrors.txt"), (String)bundle.getString("SASCodeImporterTab.OperationComplete.txt"), (int)3, (int)0)) == 0) {
            SASCodeImporterLogPanel logPanel = new SASCodeImporterLogPanel(items);
            WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("SASCodeImporterTab.ConversionLogs.txt"), true);
            dlg.setOKButtonVisible(false);
            dlg.setCancelButtonVisible(false);
            dlg.setCloseButtonVisible(true);
            dlg.setResizable(true);
            dlg.setMainPanel((WAPanel)logPanel);
            dlg.show();
        }
    }

    public boolean validateData() {
        if (this.m_mdlFiles.isEmpty()) {
            MessageUtil.displayMessage((String)bundle.getString("SASCodeImporterTab.Error.NoFiles.txt"), (int)0);
            return false;
        }
        if (this.m_rbnImport.isSelected() && this.m_pthParent == null) {
            MessageUtil.displayMessage((String)bundle.getString("SASCodeImporterTab.Error.FolderRequired.txt"), (int)0);
            return false;
        }
        return true;
    }

    private boolean processFiles(List<SASCodeItem> items) {
        final List<SASCodeItem> runItems = items;
        final OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", bundle.getString("SASCodeImporterTab.OpRequestTitle.txt"));
        request.setDelayBeforeProgressCancelDialog(200);
        Runnable runAnalyze = new Runnable(){

            @Override
            public void run() {
                SASCodeImporterTab.this.doAnalyze(request, runItems);
            }
        };
        request.execute(runAnalyze);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doAnalyze(OpRequestUI request, List<SASCodeItem> items) {
        request.displayMessage(bundle.getString("SASCodeImporterTab.OpRequestMessage.Initializing.txt"));
        this.m_bErrors = false;
        WsAppServer appServer = null;
        try {
            for (SASCodeItem item : items) {
                if (item.needsConversion() && appServer == null) {
                    appServer = WsAppServer.createDefaultAppServer();
                    Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
                    if (parent != null) {
                        parent.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    try {
                        appServer.open();
                    }
                    catch (WsAppServerFailException e) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                        boolean bl = false;
                        if (appServer == null) return bl;
                        appServer.dispose();
                        return bl;
                    }
                    finally {
                        if (parent != null) {
                            parent.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                AnalyzeCode analyze = new AnalyzeCode(appServer, item, request);
                analyze.setPathUrl(this.m_pthParent);
                try {
                    item._convertResult = SASCodeItem.Result.SUCCESS;
                    item._parseResult = SASCodeItem.Result.ERROR;
                    analyze.runAnalyze();
                    if (item._convertResult != SASCodeItem.Result.ERROR && item._parseResult != SASCodeItem.Result.ERROR) continue;
                    this.m_bErrors = true;
                }
                catch (OutOfMemoryError jme) {
                    MessageUtil.displayMessage((String)bundle.formatString("SASCodeImporterTab.OutOfMemory.Error.txt", (Object)jme.getLocalizedMessage()), (int)0);
                    item._convertResult = SASCodeItem.Result.ERROR;
                    this.m_bErrors = true;
                    Workspace.getDefaultLogger().error((Object)"Memory Error", (Throwable)jme);
                }
                catch (GenericError e1) {
                    Workspace.getDefaultLogger().error((Object)"GenericError", (Throwable)e1);
                    item._convertResult = SASCodeItem.Result.ERROR;
                    this.m_bErrors = true;
                }
                catch (IOException e1) {
                    Workspace.getDefaultLogger().error((Object)"IOException", (Throwable)e1);
                    item._convertResult = SASCodeItem.Result.ERROR;
                    this.m_bErrors = true;
                }
                catch (WsAppServerFailException e1) {
                    Workspace.getDefaultLogger().error((Object)"WsAppServerFailException", (Throwable)e1);
                    item._convertResult = SASCodeItem.Result.ERROR;
                    this.m_bErrors = true;
                }
                catch (WsAppServerCodeException e1) {
                    Workspace.getDefaultLogger().error((Object)"WsAppServerCodeException", (Throwable)e1);
                    item._convertResult = SASCodeItem.Result.ERROR;
                    this.m_bErrors = true;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
        }
    }

    private class SCAFileFilter
    extends FileFilter {
        private SCAFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName();
            return filename.endsWith(".sca");
        }

        @Override
        public String getDescription() {
            return bundle.formatString("SASCodeImporterTab.SCAFileFilter.fmt", (Object)".sca");
        }
    }

    private class SASFileFilter
    extends FileFilter {
        private SASFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName();
            return filename.endsWith(".sas");
        }

        @Override
        public String getDescription() {
            return bundle.formatString("SASCodeImporterTab.SASFileFilter.fmt", (Object)".sas");
        }
    }

    private class ImportButtonGroupListener
    implements ActionListener {
        private ImportButtonGroupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SASCodeImporterTab.this.updateActions();
        }
    }

    private class FileSelectionListener
    implements ListSelectionListener {
        private FileSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SASCodeImporterTab.this.updateActions();
        }
    }

    private class BrowseAction
    extends WsAbstractAction {
        public BrowseAction() {
            super(bundle, "SASCodeImporterTab.Browse", 0);
        }

        public void actionPerformed(ActionEvent e) {
            PathUrl folder = WsMetadataUtil.promptForPathUrl((String)SASCodeImporterTab.this.m_txtLocation.getText(), (boolean)false);
            if (folder != null) {
                SASCodeImporterTab.this.m_pthParent = folder;
                SASCodeImporterTab.this.m_txtLocation.setText(folder.getDisplayPath());
            }
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "SASCodeImporterTab.MoveDown", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedIndices = SASCodeImporterTab.this.m_lstFiles.getSelectedIndices();
            if (aSelectedIndices.length == 1) {
                int iSelectedIndex = aSelectedIndices[0];
                Object selectedFile = SASCodeImporterTab.this.m_mdlFiles.remove(iSelectedIndex);
                SASCodeImporterTab.this.m_mdlFiles.add(iSelectedIndex + 1, selectedFile);
                SASCodeImporterTab.this.m_lstFiles.setSelectedIndex(iSelectedIndex + 1);
            }
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "SASCodeImporterTab.MoveUp", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedIndices = SASCodeImporterTab.this.m_lstFiles.getSelectedIndices();
            if (aSelectedIndices.length == 1) {
                int iSelectedIndex = aSelectedIndices[0];
                Object selectedFile = SASCodeImporterTab.this.m_mdlFiles.remove(iSelectedIndex);
                SASCodeImporterTab.this.m_mdlFiles.add(iSelectedIndex - 1, selectedFile);
                SASCodeImporterTab.this.m_lstFiles.setSelectedIndex(iSelectedIndex - 1);
            }
        }
    }

    private class RemoveAction
    extends WsAbstractAction {
        public RemoveAction() {
            super(bundle, "SASCodeImporterTab.Remove", 0);
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedIndices = SASCodeImporterTab.this.m_lstFiles.getSelectedIndices();
            if (aSelectedIndices.length > 0) {
                for (int i = aSelectedIndices.length - 1; i >= 0; --i) {
                    SASCodeImporterTab.this.m_mdlFiles.remove(aSelectedIndices[i]);
                }
            }
        }
    }

    private class AddAction
    extends WsAbstractAction {
        public AddAction() {
            super(bundle, "SASCodeImporterTab.Add", 0);
        }

        public void actionPerformed(ActionEvent e) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            String sDefaultPath = appDefaults.getPropertyString("SASCodeImporterTab.DefaultFolder", System.getProperty("user.home"));
            JFileChooser fileChooser = new JFileChooser(sDefaultPath);
            SASFileFilter sasFilter = new SASFileFilter();
            SCAFileFilter scaFilter = new SCAFileFilter();
            fileChooser.addChoosableFileFilter(sasFilter);
            fileChooser.addChoosableFileFilter(scaFilter);
            fileChooser.setFileFilter(sasFilter);
            fileChooser.setDialogTitle(bundle.getString("SASCodeImporterTab.FileSelector.txt"));
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(true);
            if (fileChooser.showOpenDialog((Component)Workspace.getWorkspace()) == 0) {
                File[] selectedFiles = fileChooser.getSelectedFiles();
                for (int i = 0; i < selectedFiles.length; ++i) {
                    SASCodeImporterTab.this.m_mdlFiles.addElement(selectedFiles[i].getPath());
                }
                appDefaults.setPropertyString("SASCodeImporterTab.DefaultFolder", fileChooser.getCurrentDirectory().getPath());
            }
        }
    }
}

