/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.sascodeimporter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;

public class ParseLogger {
    private static final int INDENT_SIZE = 5;
    private StringBuilder _log = new StringBuilder();

    public void log(Level level, int indentLevel, String msg) {
        this._log.append((Object)level).append(" - ").append(this.getIndentation(indentLevel)).append(msg).append("\n");
    }

    public void info(String msg) {
        this.info(0, msg);
    }

    public void info(int indentLevel, String msg) {
        this.log(Level.INFO, indentLevel, msg);
    }

    public void warn(String msg) {
        this.warn(0, msg);
    }

    public void warn(int indentLevel, String msg) {
        this.log(Level.WARN, indentLevel, msg);
    }

    public void error(String msg) {
        this.error(0, msg);
    }

    public void error(int indentLevel, String msg) {
        this.log(Level.ERROR, indentLevel, msg);
    }

    public void error(Throwable t) {
        this.error(0, this.getStackTrace(t));
    }

    public void error(int indentLevel, Throwable t) {
        this.error(indentLevel, this.getStackTrace(t));
    }

    public String toString() {
        return this._log.toString();
    }

    private String getIndentation(int level) {
        if (level == 0) {
            return "";
        }
        char[] indentation = new char[level * 5];
        Arrays.fill(indentation, ' ');
        return String.valueOf(indentation);
    }

    private String getStackTrace(Throwable t) {
        StringWriter stackTrace = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTrace);
        t.printStackTrace(printWriter);
        return ((Object)stackTrace).toString();
    }

    public static enum Level {
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");

        private final String _name;

        private Level(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

