/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.run;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IJob;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelCreatedEvent;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelFactory;
import com.sas.wadmin.run.RunModelFactoryListener;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.validate.ValidateEvent;
import com.sas.wadmin.validate.ValidateModel;
import com.sas.wadmin.validate.ValidateModelEvent;
import com.sas.wadmin.validate.ValidateModelListener;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RuntimeStatusTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(RuntimeStatusTableModel.class);
    private static final Date MISSING_DATE = new Date(Long.MAX_VALUE);
    private static final String STATUS_RUNNING = bundle.getString("RuntimeStatusTableModel.Status.Running.txt");
    private static final String STATUS_STOPPING = bundle.getString("RuntimeStatusTableModel.Status.Stopping.txt");
    private static final String STATUS_STOPPED = bundle.getString("RuntimeStatusTableModel.Status.Stopped.txt");
    private static final String STATUS_PAUSED = bundle.getString("RuntimeStatusTableModel.Status.Paused.txt");
    private static final String STATUS_COMPLETE = bundle.getString("RuntimeStatusTableModel.Status.Complete.txt");
    private static final int JOB_COLUMN = 0;
    private static final int STATUS_COLUMN = 1;
    private static final int STARTTIME_COLUMN = 2;
    private static final int ENDTIME_COLUMN = 3;
    private static final int SAS_APP_SERVER_COLUMN = 4;
    private static final int RUN_MODEL_COLUMN = 5;
    private static final int VISIBLE_COLUMNS = 5;
    private static final int HIDDEN_COLUMNS = 1;
    private static final int COLUMN_WIDTH = 200;
    private IModelListener m_lsnrModel;
    private RunModelListener m_lsnrRunModel;
    private ValidateModelListener m_lsnrValidateModel;

    public RuntimeStatusTableModel() {
        this.createColumnDefinitions();
        RunModelFactory.getInstance().addFactoryListener(new FactoryListener());
        this.m_lsnrRunModel = new RunListener();
        this.m_lsnrValidateModel = new ValidateListener();
        this.m_lsnrModel = new ModelListener();
    }

    private void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("RuntimeStatusTableModel.Column.Job.txt"), 200);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("RuntimeStatusTableModel.Column.Status.txt"), 200);
        this.m_aColumns[2] = new WsDateTableColumn(2, bundle.getString("RuntimeStatusTableModel.Column.StartTime.txt"), 200);
        this.m_aColumns[3] = new WsDateTableColumn(3, bundle.getString("RuntimeStatusTableModel.Column.EndTime.txt"), 200);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("RuntimeStatusTableModel.Column.SASAppServer.txt"), 200);
        this.m_aColumns[5] = new WsObjectTableColumn();
        ((WsDateTableColumn)this.m_aColumns[2]).setShowAsBlankDate(MISSING_DATE);
        ((WsDateTableColumn)this.m_aColumns[3]).setShowAsBlankDate(MISSING_DATE);
    }

    public int getColumnCount() {
        return 5;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() {
    }

    public void moveDataToModel() {
    }

    public void moveDataToStore() {
    }

    private void addRunModel(RunModel mdl) {
        this.insertRow(this.getRowCount() - 1, this.createRowValues(mdl));
        mdl.addListener(this.m_lsnrRunModel);
        if (mdl.getAffiliate() instanceof IJob) {
            ((IJob)mdl.getAffiliate()).getModel().addModelListener(this.m_lsnrModel);
        }
    }

    private void removeRunModel(RunModel mdl) {
        this.deleteRow(this.getRowIndexForRunModel(mdl));
        mdl.removeListener(this.m_lsnrRunModel);
        if (mdl.getAffiliate() instanceof IJob) {
            ((IJob)mdl.getAffiliate()).getModel().removeModelListener(this.m_lsnrModel);
        }
    }

    private List createRowValues(RunModel mdl) {
        SimpleObject affiliate = mdl.getAffiliate();
        WsAppServer server = mdl.getSASAppServer();
        ArrayList<Object> lValues = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        lValues.add(affiliate != null ? affiliate.getName() : "");
        lValues.add("");
        lValues.add(MISSING_DATE);
        lValues.add(MISSING_DATE);
        lValues.add(server != null ? server.getName() : "");
        lValues.add(mdl);
        return lValues;
    }

    private int getRowIndexForRunModel(RunModel mdl) {
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            if (mdl != this.getRunModel(iRow)) continue;
            return iRow;
        }
        return -1;
    }

    private int getRowIndexForJobModel(IModel mdlJob) {
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            RunModel mdlRun = this.getRunModel(iRow);
            SimpleObject affiliate = mdlRun.getAffiliate();
            if (!(affiliate instanceof IJob) || ((IJob)affiliate).getModel() != mdlJob) continue;
            return iRow;
        }
        return -1;
    }

    public RunModel getRunModel(int iRow) {
        return (RunModel)this.getValueAt(iRow, 5);
    }

    private void addValidateModel(ValidateModel mdl) {
        this.insertRow(this.getRowCount() - 1, this.createRowValues(mdl));
        mdl.addListener(this.m_lsnrValidateModel);
        if (mdl.getAffiliate() instanceof IJob) {
            ((IJob)mdl.getAffiliate()).getModel().addModelListener(this.m_lsnrModel);
        }
    }

    private void removeValidateModel(ValidateModel mdl) {
        this.deleteRow(this.getRowIndexForValidateModel(mdl));
        mdl.removeListener(this.m_lsnrValidateModel);
        if (mdl.getAffiliate() instanceof IJob) {
            ((IJob)mdl.getAffiliate()).getModel().removeModelListener(this.m_lsnrModel);
        }
    }

    private List createRowValues(ValidateModel mdl) {
        SimpleObject affiliate = mdl.getAffiliate();
        WsAppServer server = mdl.getSASAppServer();
        ArrayList<Object> lValues = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        lValues.add(affiliate != null ? affiliate.getName() : "");
        lValues.add("");
        lValues.add(MISSING_DATE);
        lValues.add(MISSING_DATE);
        lValues.add(server != null ? server.getName() : "");
        lValues.add(mdl);
        return lValues;
    }

    private int getRowIndexForValidateModel(ValidateModel mdl) {
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            if (mdl != this.getValidateModel(iRow)) continue;
            return iRow;
        }
        return -1;
    }

    public ValidateModel getValidateModel(int iRow) {
        return (ValidateModel)this.getValueAt(iRow, 5);
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "ModelController:UnknownChanges" || sType == "Object:NameChanged" && ev.getModelObject() instanceof IJob) {
                int iRow = RuntimeStatusTableModel.this.getRowIndexForJobModel(ev.getModel());
                if (iRow == -1) {
                    return;
                }
                RuntimeStatusTableModel.this.setValueAt(RuntimeStatusTableModel.this.getRunModel(iRow).getAffiliate().getName(), iRow, 0);
            }
        }
    }

    private class ValidateListener
    implements ValidateModelListener {
        private ValidateListener() {
        }

        @Override
        public void modelChanged(ValidateModelEvent ev) {
            ValidateModel mdl = (ValidateModel)ev.getSource();
            int iRow = RuntimeStatusTableModel.this.getRowIndexForValidateModel(mdl);
            if (iRow == -1) {
                return;
            }
            String sType = ev.getType();
            if (sType == "AffiliatedChanged") {
                SimpleObject affiliate = mdl.getAffiliate();
                RuntimeStatusTableModel.this.setValueAt(affiliate != null ? affiliate.getName() : "", iRow, 0);
            } else if (sType == "AppServerChanged") {
                try {
                    WsAppServer server = mdl.getSASAppServer();
                    RuntimeStatusTableModel.this.setValueAt(server != null ? server.getServerName() : "", iRow, 4);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            } else if (sType == "ValidateStateChanged") {
                String sStatus = "";
                switch (mdl.getValidateState()) {
                    case 2: {
                        sStatus = STATUS_STOPPING;
                        break;
                    }
                    case 0: {
                        return;
                    }
                }
                RuntimeStatusTableModel.this.setValueAt(sStatus, iRow, 1);
            } else if (sType == "ModelDisposed") {
                RuntimeStatusTableModel.this.removeValidateModel(mdl);
            }
        }

        @Override
        public void validateEventHappened(ValidateEvent ev) {
            ValidateModel mdl = (ValidateModel)ev.getSource();
            int iRow = RuntimeStatusTableModel.this.getRowIndexForValidateModel(mdl);
            if (iRow == -1) {
                return;
            }
            String sType = ev.getType();
            if (sType == "ValidateStarted") {
                RuntimeStatusTableModel.this.setValueAt(STATUS_RUNNING, iRow, 1);
                RuntimeStatusTableModel.this.setValueAt(new Date(ev.getTime()), iRow, 2);
                RuntimeStatusTableModel.this.setValueAt(MISSING_DATE, iRow, 3);
            } else if (sType == "ValidateStopped") {
                RuntimeStatusTableModel.this.setValueAt(STATUS_STOPPED, iRow, 1);
                RuntimeStatusTableModel.this.setValueAt(new Date(ev.getTime()), iRow, 3);
            } else if (sType == "ValidateCompleted") {
                RuntimeStatusTableModel.this.setValueAt(STATUS_COMPLETE, iRow, 1);
                RuntimeStatusTableModel.this.setValueAt(new Date(ev.getTime()), iRow, 3);
            }
        }
    }

    private class RunListener
    implements RunModelListener {
        private RunListener() {
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
            RunModel mdl = (RunModel)ev.getSource();
            int iRow = RuntimeStatusTableModel.this.getRowIndexForRunModel(mdl);
            if (iRow == -1) {
                return;
            }
            String sType = ev.getType();
            if (sType == "AffiliatedChanged") {
                SimpleObject affiliate = mdl.getAffiliate();
                RuntimeStatusTableModel.this.setValueAt(affiliate != null ? affiliate.getName() : "", iRow, 0);
            } else if (sType == "AppServerChanged") {
                try {
                    WsAppServer server = mdl.getSASAppServer();
                    RuntimeStatusTableModel.this.setValueAt(server != null ? server.getServerName() : "", iRow, 4);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            } else if (sType == "RunStateChanged") {
                String sStatus = "";
                switch (mdl.getRunState()) {
                    case 2: {
                        sStatus = STATUS_PAUSED;
                        break;
                    }
                    case 3: {
                        sStatus = STATUS_STOPPING;
                        break;
                    }
                    case 0: {
                        return;
                    }
                }
                RuntimeStatusTableModel.this.setValueAt(sStatus, iRow, 1);
            } else if (sType == "ModelDisposed") {
                RuntimeStatusTableModel.this.removeRunModel(mdl);
            }
        }

        @Override
        public void runEventHappened(RunEvent ev) {
            RunModel mdl = (RunModel)ev.getSource();
            int iRow = RuntimeStatusTableModel.this.getRowIndexForRunModel(mdl);
            if (iRow == -1) {
                return;
            }
            String sType = ev.getType();
            if (sType == "RunStarted") {
                RuntimeStatusTableModel.this.setValueAt(STATUS_RUNNING, iRow, 1);
                RuntimeStatusTableModel.this.setValueAt(new Date(ev.getTime()), iRow, 2);
                RuntimeStatusTableModel.this.setValueAt(MISSING_DATE, iRow, 3);
            } else if (sType == "RunAborted" || sType == "RunStopped") {
                RuntimeStatusTableModel.this.setValueAt(STATUS_STOPPED, iRow, 1);
                RuntimeStatusTableModel.this.setValueAt(new Date(ev.getTime()), iRow, 3);
            } else if (sType == "RunCompleted") {
                RuntimeStatusTableModel.this.setValueAt(STATUS_COMPLETE, iRow, 1);
                RuntimeStatusTableModel.this.setValueAt(new Date(ev.getTime()), iRow, 3);
            }
        }
    }

    private class FactoryListener
    implements RunModelFactoryListener {
        private FactoryListener() {
        }

        @Override
        public void runModelCreated(RunModelCreatedEvent ev) {
            RuntimeStatusTableModel.this.addRunModel(ev.getRunModel());
        }
    }
}

