/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.run;

import com.sas.wadmin.app.AppViewFactory;
import com.sas.wadmin.run.RuntimeStatusTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RuntimeStatusPanel
extends JPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(RuntimeStatusPanel.class);
    private RuntimeStatusTableModel m_mdlJobStatus;
    private WsTable m_tblJobStatus;
    private JScrollPane m_scrJobStatus;
    private WsAbstractAction m_actOpenJob;
    private WsAbstractAction m_actStopJobs;

    public RuntimeStatusPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.createActions();
        this.createTableModel();
        this.createTable();
        this.layoutComponents();
    }

    private void createTableModel() {
        this.m_mdlJobStatus = new RuntimeStatusTableModel();
    }

    private void createTable() {
        this.m_tblJobStatus = new WsTable((WsAbstractTableModel)this.m_mdlJobStatus);
        this.m_tblJobStatus.setEditable(false);
        this.m_tblJobStatus.setRowsReorderable(false);
        this.m_tblJobStatus.setColumnsReorderable(false);
        this.m_tblJobStatus.setAutoResizeMode(3);
        this.m_tblJobStatus.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_tblJobStatus.setCellSelectionEnabled(false);
        this.m_tblJobStatus.setRowSelectionAllowed(true);
        TablePopupMenuRequestListener lsnr = new TablePopupMenuRequestListener();
        this.m_tblJobStatus.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblJobStatus.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblJobStatus.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblJobStatus.getRowModel().getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.m_scrJobStatus = new JScrollPane((Component)this.m_tblJobStatus);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_scrJobStatus, "Center");
    }

    private void openJob() {
        int iRow = this.m_tblJobStatus.convertRowIndexToModel(this.m_tblJobStatus.getSelectedRow());
        AppViewFactory.getInstance().showOpenView(this.m_mdlJobStatus.getRunModel(iRow).getAffiliate());
    }

    private void stopJobs() {
        int eAnswer = MessageUtil.displayMessage((String)bundle.getString("RuntimeStatusPanel.Message.ConfirmStop.txt"), (String)bundle.getString("RuntimeStatusPanel.Message.ConfirmStop.Title.txt"), (int)1, (int)0);
        if (eAnswer != 0) {
            return;
        }
        int[] aSelectedRows = this.m_tblJobStatus.getSelectedRowsFromSelectedCells();
        this.m_tblJobStatus.convertRowIndexesToModel(aSelectedRows);
        for (int iRow = 0; iRow < aSelectedRows.length; ++iRow) {
            this.m_mdlJobStatus.getRunModel(aSelectedRows[iRow]).stop();
        }
    }

    private void createActions() {
        this.m_actOpenJob = new OpenJobAction();
        this.m_actStopJobs = new StopJobsAction();
    }

    private void updateActions() {
        int[] aSelectedRows = this.m_tblJobStatus.getSelectedRowsFromSelectedCells();
        boolean bOneRowSelected = aSelectedRows.length == 1;
        boolean bAllJobsRunning = aSelectedRows.length > 0;
        this.m_tblJobStatus.convertRowIndexesToModel(aSelectedRows);
        for (int iRow = 0; iRow < aSelectedRows.length; ++iRow) {
            if (this.m_mdlJobStatus.getRunModel(aSelectedRows[iRow]).getRunState() == 1) continue;
            bAllJobsRunning = false;
            break;
        }
        this.m_actOpenJob.setEnabled(bOneRowSelected);
        this.m_actStopJobs.setEnabled(bOneRowSelected && bAllJobsRunning);
    }

    private class TablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private TablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            RuntimeStatusPanel.this.updateActions();
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)RuntimeStatusPanel.this.m_actOpenJob));
            mnuPopup.add(new JMenuItem((Action)RuntimeStatusPanel.this.m_actStopJobs));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            RuntimeStatusPanel.this.updateActions();
        }
    }

    private class StopJobsAction
    extends WsAbstractAction {
        public StopJobsAction() {
            super(bundle, "RuntimeStatusPanel.Action.StopJobs", 256);
        }

        public void actionPerformed(ActionEvent e) {
            RuntimeStatusPanel.this.stopJobs();
        }
    }

    private class OpenJobAction
    extends WsAbstractAction {
        public OpenJobAction() {
            super(bundle, "RuntimeStatusPanel.Action.OpenJob", 256);
        }

        public void actionPerformed(ActionEvent e) {
            RuntimeStatusPanel.this.openJob();
        }
    }
}

