/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.run;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ITransform;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.run.RunResults;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.models.SimpleObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class RunModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(RunModel.class);
    public static final String AFFILIATE_CHANGED = "AffiliatedChanged";
    public static final String SAS_APP_SERVER_CHANGED = "AppServerChanged";
    public static final String CODE_SEGMENTS_CHANGED = "CodeSegmentsChanged";
    public static final String RUN_STATE_CHANGED = "RunStateChanged";
    public static final String CURRENT_CODE_SEGMENT_CHANGED = "CurrentCodeSegmentChanged";
    public static final String BREAK_POINT_ADDED = "BreakPointAdded";
    public static final String BREAK_POINT_REMOVED = "BreakPointRemoved";
    public static final String MODEL_DISPOSED = "ModelDisposed";
    public static final int INACTIVE = 0;
    public static final int RUNNING = 1;
    public static final int PAUSED = 2;
    public static final int STOPPING = 3;
    private SimpleObject m_affiliate;
    private WsAppServer m_srvr;
    private ICodeSegment[] m_aCodeSegments;
    private List m_lListeners = new ArrayList();
    private int m_eState = 0;
    private int m_iCurrentSegment;
    private boolean m_bStepMode;
    private boolean m_bHasRun;
    private boolean m_bStopParsing = false;
    private ParseSASLogThread m_thrParsing = null;
    private Object m_lock = new Object();
    private List m_lParseWork = new ArrayList();

    RunModel() {
    }

    RunModel(SimpleObject affiliate) {
        this();
        this.m_affiliate = affiliate;
    }

    public void dispose() {
        if (this.m_lListeners != null) {
            this.fireModelEvent(MODEL_DISPOSED);
        }
        this.m_affiliate = null;
        this.m_srvr = null;
        this.m_aCodeSegments = null;
        this.m_lListeners = null;
    }

    public void setAffiliate(SimpleObject affiliate) {
        if (this.m_affiliate == affiliate) {
            return;
        }
        this.m_affiliate = affiliate;
        this.fireModelEvent(AFFILIATE_CHANGED);
    }

    public SimpleObject getAffiliate() {
        return this.m_affiliate;
    }

    public void setSASAppServer(WsAppServer srvr) {
        if (this.m_srvr == srvr) {
            return;
        }
        this.m_srvr = srvr;
        this.fireModelEvent(SAS_APP_SERVER_CHANGED);
    }

    public WsAppServer getSASAppServer() {
        return this.m_srvr;
    }

    public void setCodeSegments(ICodeSegment[] aCodeSegments) {
        this.m_aCodeSegments = aCodeSegments;
        this.fireModelEvent(CODE_SEGMENTS_CHANGED);
        this.setCurrentCodeSegment(0);
    }

    public ICodeSegment[] getCodeSegments() {
        return this.m_aCodeSegments;
    }

    private void setRunState(int eState) {
        if (this.m_eState == eState) {
            return;
        }
        this.m_eState = eState;
        this.fireModelEvent(RUN_STATE_CHANGED);
    }

    public int getRunState() {
        return this.m_eState;
    }

    public void setHasRun(boolean bHasRun) {
        if (this.m_bHasRun == bHasRun) {
            return;
        }
        this.m_bHasRun = bHasRun;
    }

    public boolean getHasRun() {
        return this.m_bHasRun;
    }

    public void setCurrentCodeSegment(int iCurrentCodeSegment) {
        if (this.m_aCodeSegments == null) {
            throw new UnsupportedOperationException("There must be code segments before the current code segment can be changed");
        }
        if (iCurrentCodeSegment < 0 || iCurrentCodeSegment > this.m_aCodeSegments.length) {
            throw new IndexOutOfBoundsException("Current code segment must be between 0 and the number of code segments");
        }
        if (this.m_iCurrentSegment == iCurrentCodeSegment) {
            return;
        }
        this.m_iCurrentSegment = iCurrentCodeSegment;
        this.fireModelEvent(CURRENT_CODE_SEGMENT_CHANGED);
    }

    public int getCurrentCodeSegment() {
        return this.m_iCurrentSegment;
    }

    public void addListener(RunModelListener lsnr) {
        this.m_lListeners.add(lsnr);
    }

    public void removeListener(RunModelListener lsnr) {
        if (this.m_lListeners != null) {
            this.m_lListeners.remove(lsnr);
        }
    }

    public void run() {
        if (this.m_eState == 3) {
            throw new UnsupportedOperationException("Can not run while waiting for termination to complete");
        }
        if (this.m_eState == 1) {
            throw new UnsupportedOperationException("Can not run while waiting for run to complete");
        }
        if (this.m_srvr == null || !this.m_srvr.isSASCodeSessionOpen()) {
            throw new UnsupportedOperationException("Can not run with out a SAS application server that has an open SAS code session");
        }
        if (this.m_aCodeSegments == null || this.m_aCodeSegments.length == 0) {
            throw new UnsupportedOperationException("Can not run when there are no code segments");
        }
        this.m_bStepMode = false;
        this.setRunState(1);
        this.setHasRun(true);
        new RunSASCodeThread().start();
    }

    public void step() {
        if (this.m_eState == 3) {
            throw new UnsupportedOperationException("Can not step while waiting for termination to complete");
        }
        if (this.m_eState == 1) {
            throw new UnsupportedOperationException("Can not step while waiting for run to complete");
        }
        this.m_bStepMode = true;
        this.setRunState(1);
        new RunSASCodeThread().start();
    }

    public void restart() {
        if (this.m_eState != 2) {
            throw new UnsupportedOperationException("Can only restart when the run is paused");
        }
        this.stop();
        this.run();
    }

    public void stop() {
        if (this.m_eState == 0) {
            return;
        }
        if (this.m_eState == 1) {
            this.setRunState(3);
            this.setHasRun(false);
            this.m_srvr.kill();
            this.fireRunEvent("RunStopped");
            this.setRunState(0);
        } else {
            this.fireRunEvent("RunStopped");
            this.setHasRun(false);
            this.setRunState(0);
            this.setCurrentCodeSegment(0);
        }
    }

    private void fireRunEvent(String sEventType) {
        this.fireRunEvent(new RunEvent(this, sEventType));
    }

    private void fireSegmentStartedEvent(ICodeSegment code) {
        this.fireRunEvent(new RunEvent(this, "SegmentStarted", code));
    }

    private void fireSegmentParsingEvent(ICodeSegment code, RunResults results) {
        this.fireRunEvent(new RunEvent(this, "SegmentParsing", code, results));
    }

    private void fireSegmentCompletedEvent(ICodeSegment code, RunResults results) {
        this.fireRunEvent(new RunEvent(this, "SegmentCompleted", code, results));
    }

    private void fireRunEvent(String sEventType, ICodeSegment code, RunResults results, WsAppServerFailException ex) {
        this.fireRunEvent(new RunEvent(this, sEventType, code, results, ex));
    }

    private void fireRunEvent(RunEvent ev) {
        Workspace.getDefaultLogger().debug((Object)("RunEvent:" + ev.getType()));
        SwingUtilities.invokeLater(new FireRunEventRunnable(ev));
    }

    private void fireModelEvent(String sEventType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new FireModelEventRunnable(sEventType));
            return;
        }
        Workspace.getDefaultLogger().debug((Object)("RunModelEvent:" + sEventType));
        RunModelEvent ev = new RunModelEvent(this, sEventType);
        for (int iListener = 0; iListener < this.m_lListeners.size(); ++iListener) {
            RunModelListener lsnr = (RunModelListener)this.m_lListeners.get(iListener);
            lsnr.modelChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParseWork(RunResults results) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_lParseWork.add(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResults getParseWork() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_lParseWork.isEmpty()) {
                return null;
            }
            return (RunResults)this.m_lParseWork.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearParseWork() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_lParseWork.clear();
        }
    }

    private class RunSASCodeThread
    extends Thread {
        public RunSASCodeThread() {
            super("Run SAS Code");
        }

        @Override
        public void run() {
            if (RunModel.this.m_iCurrentSegment == 0) {
                RunModel.this.m_bStopParsing = true;
                while (RunModel.this.m_thrParsing != null && RunModel.this.m_thrParsing.isAlive()) {
                    try {
                        RunSASCodeThread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                RunModel.this.m_bStopParsing = false;
                RunModel.this.clearParseWork();
                RunModel.this.m_thrParsing = new ParseSASLogThread();
                RunModel.this.m_thrParsing.setMaxSegments(RunModel.this.m_aCodeSegments.length);
                RunModel.this.m_thrParsing.start();
                RunModel.this.fireRunEvent("RunStarted");
                try {
                    RunModel.this.m_srvr.resetServer();
                }
                catch (WsAppServerFailException ex) {
                    if (RunModel.this.m_eState != 0) {
                        RunModel.this.fireRunEvent("RunAborted", RunModel.this.m_aCodeSegments[RunModel.this.m_iCurrentSegment], null, ex);
                        RunModel.this.setRunState(0);
                    }
                    RunModel.this.setCurrentCodeSegment(0);
                }
            }
            ICodeSegment segment = null;
            RunResults results = null;
            try {
                boolean bBreakPoint = false;
                do {
                    segment = RunModel.this.m_aCodeSegments[RunModel.this.m_iCurrentSegment];
                    results = new RunResults();
                    results.setModelObject(segment.getModelObject());
                    RunModel.this.fireSegmentStartedEvent(segment);
                    results.setStartTime(System.currentTimeMillis());
                    try {
                        RunModel.this.m_srvr.submitSASCode(segment.toString(), false, false);
                    }
                    catch (WsAppServerCodeException ex) {
                        results.setStatus(2);
                    }
                    results.setStopTime(System.currentTimeMillis());
                    results.setLog(RunModel.this.m_srvr.getLog());
                    results.setOutput(RunModel.this.m_srvr.getOutput());
                    try {
                        if (segment.getModelObject() instanceof ITransform && ((ITransform)segment.getModelObject()).isValidateAvailable() && !((ITransform)segment.getModelObject()).isExplicitOn() && RunModel.this.m_srvr.isOpen()) {
                            results.setPushDown(RunModel.this.m_srvr.getMacroVariableValue("etls_sql_pushDown"));
                            results.setPushDownDBMSType(((IDataTransform)segment.getModelObject()).getDBMSExecutionTypeName());
                        } else {
                            results.setPushDown(null);
                            results.setPushDownDBMSType("SAS");
                        }
                    }
                    catch (WsAppServerFailException ex) {
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    if (!RunModel.this.m_srvr.isOpen()) {
                        RunModel.this.m_thrParsing.setMaxSegments(RunModel.this.m_iCurrentSegment + 1);
                        results.setLog(RunModel.this.m_srvr.getAbortLog());
                        results.setOutput(RunModel.this.m_srvr.getAbortList());
                        results.setStatus(4);
                        RunModel.this.m_iCurrentSegment = RunModel.this.m_aCodeSegments.length - 1;
                    }
                    boolean bLastSegment = RunModel.this.m_iCurrentSegment == RunModel.this.m_aCodeSegments.length - 1;
                    RunModel.this.addParseWork(results);
                    RunModel.this.fireSegmentParsingEvent(segment, results);
                    if (bLastSegment) {
                        return;
                    }
                    RunModel.this.setCurrentCodeSegment(RunModel.this.m_iCurrentSegment + 1);
                } while (!RunModel.this.m_bStepMode && !bBreakPoint);
                RunModel.this.setRunState(2);
            }
            catch (WsAppServerFailException ex) {
                if (RunModel.this.m_eState != 0) {
                    String sEventType;
                    String string = sEventType = RunModel.this.m_eState == 3 ? "RunStopped" : "RunAborted";
                    if (sEventType == "RunAborted" || sEventType == "RunStopped") {
                        RunModel.this.setHasRun(false);
                    }
                    RunModel.this.fireRunEvent(sEventType, segment, results, ex);
                    RunModel.this.setRunState(0);
                }
                RunModel.this.setCurrentCodeSegment(0);
            }
        }
    }

    private class ParseSASLogThread
    extends Thread {
        private int m_iParsingSegment;
        private int m_maxSegments;

        public ParseSASLogThread() {
            super("parsing SAS log");
            this.setPriority(1);
            this.m_iParsingSegment = 0;
            this.m_maxSegments = 0;
        }

        public void setMaxSegments(int maxSegments) {
            this.m_maxSegments = maxSegments;
        }

        @Override
        public void run() {
            while (!(this.m_iParsingSegment >= this.m_maxSegments || RunModel.this.m_eState != 1 && RunModel.this.m_eState != 2 || RunModel.this.m_bStopParsing)) {
                RunResults results = RunModel.this.getParseWork();
                if (results == null) {
                    try {
                        ParseSASLogThread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                results.parseLog();
                RunModel.this.fireSegmentCompletedEvent(RunModel.this.m_aCodeSegments[this.m_iParsingSegment], results);
                if (this.m_iParsingSegment == this.m_maxSegments - 1) {
                    RunModel.this.fireRunEvent("RunCompleted");
                    RunModel.this.setRunState(0);
                    RunModel.this.setCurrentCodeSegment(0);
                    continue;
                }
                ++this.m_iParsingSegment;
            }
        }
    }

    private class FireModelEventRunnable
    implements Runnable {
        private String m_sEventType;

        FireModelEventRunnable(String sEventType) {
            this.m_sEventType = sEventType;
        }

        @Override
        public void run() {
            RunModel.this.fireModelEvent(this.m_sEventType);
        }
    }

    private class FireRunEventRunnable
    implements Runnable {
        private RunEvent m_event;

        FireRunEventRunnable(RunEvent event) {
            this.m_event = event;
        }

        @Override
        public void run() {
            for (int iListener = 0; iListener < RunModel.this.m_lListeners.size(); ++iListener) {
                RunModelListener lsnr = (RunModelListener)RunModel.this.m_lListeners.get(iListener);
                lsnr.runEventHappened(this.m_event);
            }
        }
    }
}

