/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.md;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.Directory;
import com.sas.metadata.File;
import com.sas.metadata.JFJob;
import com.sas.metadata.Job;
import com.sas.metadata.MdException;
import com.sas.metadata.ServerContext;
import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.md.BaseMetadata;
import com.sas.wadmin.reports.jobdoc.md.ETLObjects;
import com.sas.wadmin.reports.jobdoc.md.TableMetadata;
import java.util.ArrayList;

public class JobMetadata
extends BaseMetadata {
    private String[] sourceTables = null;
    private String[] targetTables = null;
    private String scheduledJobUpdated = null;
    private String scheduledJob = null;
    private String servercontext = null;

    public JobMetadata(CMetadata cm) {
        super(cm.getRepositoryID(), cm.getName(), cm.getFQID(), cm.getDesc(), cm.getMetadataCreated(), cm.getMetadataUpdated());
        try {
            Job j = (Job)cm;
            JobMetadata.collectIds(j.getResponsibleParties(), this, "_setResponsiblePartyIds");
            JobMetadata.collectIds(j.getNotes(), this, "_setNoteIds");
            JobMetadata.collectIds(j.getTrees(), this, "_setTreeId");
            AssociationList list = j.getJFJobs();
            if (list != null && list.size() > 0) {
                JFJob jf = (JFJob)list.get(0);
                this.scheduledJobUpdated = jf.getMetadataUpdated();
                list = jf.getSourceCodes();
                if (list != null && list.size() > 0) {
                    File f = (File)list.get(0);
                    this.scheduledJob = f.getFileName();
                    list = f.getDirectories();
                    if (list != null && list.size() > 0) {
                        Directory d = (Directory)list.get(0);
                        this.scheduledJob = d.getDirectoryName() + System.getProperty("file.separator") + this.scheduledJob;
                    }
                }
                if ((list = jf.getComputeLocations()) != null && list.size() > 0) {
                    ServerContext sc = (ServerContext)list.get(0);
                    this.servercontext = sc.getName();
                }
            }
        }
        catch (MdException e) {
            PluginLogger.log("##### JobMetadata.<init>: error: " + PluginLogger.getStackTrace(e));
        }
    }

    public String getScheduledjob() {
        return this.scheduledJob;
    }

    public String getServercontext() {
        return this.servercontext;
    }

    public String getScheduledjobupdated() {
        return this.scheduledJobUpdated;
    }

    public ArrayList getSourcetables() {
        return this.doGetTables(this.sourceTables);
    }

    public ArrayList getTargettables() {
        return this.doGetTables(this.targetTables);
    }

    public void setSourceTable(String id) {
        if (this.sourceTables == null) {
            this.sourceTables = new String[1];
            this.sourceTables[0] = id;
            return;
        }
        String[] tmp = new String[this.sourceTables.length + 1];
        System.arraycopy(this.sourceTables, 0, tmp, 0, this.sourceTables.length);
        tmp[tmp.length - 1] = id;
        this.sourceTables = tmp;
    }

    public void setTargetTable(String id) {
        if (this.targetTables == null) {
            this.targetTables = new String[1];
            this.targetTables[0] = id;
            return;
        }
        String[] tmp = new String[this.targetTables.length + 1];
        System.arraycopy(this.targetTables, 0, tmp, 0, this.targetTables.length);
        tmp[tmp.length - 1] = id;
        this.targetTables = tmp;
    }

    private ArrayList doGetTables(String[] tablelist) {
        if (tablelist == null || tablelist.length == 0) {
            return null;
        }
        ArrayList<TableMetadata> rc = new ArrayList<TableMetadata>();
        for (int i = 0; i < tablelist.length; ++i) {
            TableMetadata tm = (TableMetadata)ETLObjects.instance().locate(TableMetadata.class, tablelist[i]);
            rc.add(tm);
        }
        return rc;
    }
}

