/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.md;

import com.sas.wadmin.reports.jobdoc.iomi.MetadataSort;
import com.sas.wadmin.reports.jobdoc.md.BaseMetadata;
import com.sas.wadmin.reports.jobdoc.md.ColumnMetadata;
import com.sas.wadmin.reports.jobdoc.md.JobMetadata;
import com.sas.wadmin.reports.jobdoc.md.LibraryMetadata;
import com.sas.wadmin.reports.jobdoc.md.LocationMetadata;
import com.sas.wadmin.reports.jobdoc.md.RepositoryMetadata;
import com.sas.wadmin.reports.jobdoc.md.TableMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ETLObjects {
    private static ETLObjects instance = null;
    private Class[] types = new Class[]{TableMetadata.class, JobMetadata.class, ColumnMetadata.class, LibraryMetadata.class, RepositoryMetadata.class};
    private ArrayList[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};

    private ETLObjects() {
    }

    public static ETLObjects instance() {
        if (instance == null) {
            instance = new ETLObjects();
        }
        return instance;
    }

    public void init() {
        for (int i = 0; this.lists != null && i < this.lists.length; ++i) {
            this.lists[i] = new ArrayList();
        }
    }

    public BaseMetadata locate(Class type, String id) {
        ArrayList list = this.findList(type);
        for (int i = 0; list != null && i < list.size(); ++i) {
            BaseMetadata bm = (BaseMetadata)list.get(i);
            if (!bm.getId().equals(id)) continue;
            return bm;
        }
        return null;
    }

    public ArrayList getAllbylocation() {
        LocationMetadata lm;
        ArrayList<LocationMetadata> all = new ArrayList<LocationMetadata>();
        all.addAll(this.getTables());
        all.addAll(this.getJobs());
        all.addAll(this.getLibraries());
        all.addAll(this.getRepositories());
        HashMap paths = new HashMap();
        for (int i = 0; i < all.size(); ++i) {
            BaseMetadata bm = (BaseMetadata)all.get(i);
            String p = bm.getTree();
            if (p == null || p.length() == 0) {
                p = "(none)";
            }
            if (!paths.containsKey(p)) {
                paths.put(p, new ArrayList());
            }
            ArrayList objs = (ArrayList)paths.get(p);
            objs.add(bm);
        }
        ArrayList alllocs = new ArrayList();
        int j = 0;
        Iterator it = paths.keySet().iterator();
        while (it.hasNext()) {
            lm = new LocationMetadata((String)it.next(), "" + j++);
            alllocs.add(lm);
        }
        alllocs = MetadataSort.instance().sortByName(alllocs);
        all.clear();
        for (int i = 0; i < alllocs.size(); ++i) {
            lm = (LocationMetadata)alllocs.get(i);
            all.add(lm);
            ArrayList list = (ArrayList)paths.get(lm.getLocation());
            all.addAll(list);
        }
        return all;
    }

    public ArrayList getAllobjects() {
        ArrayList all = new ArrayList();
        all.addAll(this.getTables());
        all.addAll(this.getColumns());
        all.addAll(this.getJobs());
        all.addAll(this.getLibraries());
        all.addAll(this.getRepositories());
        return MetadataSort.instance().sortByName(all);
    }

    public void setTables(ArrayList tables) {
        this.replaceList(TableMetadata.class, tables);
    }

    public ArrayList getTables() {
        return this.findList(TableMetadata.class);
    }

    public void setLibraries(ArrayList list) {
        this.replaceList(LibraryMetadata.class, list);
    }

    public ArrayList getLibraries() {
        return this.findList(LibraryMetadata.class);
    }

    public void setJobs(ArrayList list) {
        this.replaceList(JobMetadata.class, list);
    }

    public ArrayList getJobs() {
        return this.findList(JobMetadata.class);
    }

    public void setColumns(ArrayList list) {
        this.replaceList(ColumnMetadata.class, list);
    }

    public ArrayList getColumns() {
        return this.findList(ColumnMetadata.class);
    }

    public void setRepositories(ArrayList list) {
        this.replaceList(RepositoryMetadata.class, list);
    }

    public ArrayList getRepositories() {
        return this.findList(RepositoryMetadata.class);
    }

    public void addTable(TableMetadata tm) {
        this.add(tm);
    }

    public void addJob(JobMetadata jm) {
        this.add(jm);
    }

    public void addLibrary(LibraryMetadata lm) {
        this.add(lm);
    }

    public void addRepository(RepositoryMetadata r) {
        this.add(r);
    }

    public void addColumn(ColumnMetadata com) {
        this.add(com);
    }

    private void add(BaseMetadata bm) {
        this.findList(bm.getClass()).add(bm);
    }

    private ArrayList findList(Class type) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].getName().equals(type.getName())) continue;
            return this.lists[i];
        }
        return null;
    }

    private void replaceList(Class type, ArrayList newList) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].getName().equals(type.getName())) continue;
            this.lists[i] = newList;
            return;
        }
    }
}

