/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.iomi;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.workspace.Workspace;
import java.util.List;
import java.util.Properties;

public class IOMIConnectionProvider {
    private Properties connectionProperties = new Properties();
    private IOMI connection = null;
    private MdStore mos = null;
    private MetadataWorkspace mws = null;
    private List repos = null;
    private boolean calledFromConsole = false;
    private boolean loggingEnabled = false;
    private boolean debug = false;

    public IOMIConnectionProvider(boolean calledFromConsole) {
        this.calledFromConsole = calledFromConsole;
    }

    public void setConnectionProperties(String host, String port, String username, String password) {
        this.connectionProperties.put("host", host);
        this.connectionProperties.put("port", port);
        this.connectionProperties.put("userName", username);
        this.connectionProperties.put("password", password);
    }

    public IOMI getConnection() {
        return this.connection;
    }

    public void connect() throws Exception {
        PluginLogger.log("***** IOMIConnectionProvider.connect()");
        if (this.calledFromConsole) {
            if (this.mos == null) {
                this.mos = MdObjectFactory.createObjectStore();
                this.mws = MetadataWorkspace.getNewWorkspace();
                this.connection = this.mws.makeOMRConnection(this.connectionProperties.getProperty("host"), this.connectionProperties.getProperty("port"), this.connectionProperties.getProperty("userName"), this.connectionProperties.getProperty("password"));
                this.repos = MetadataUtil.getRepositories((IOMI)this.mws.getCMRHandle());
            }
        } else {
            this.connection = Workspace.getWorkspace().getCMRHandle();
            this.mos = MdObjectFactory.getStore();
            this.repos = MetadataUtil.getRepositories((IOMI)this.connection);
        }
        this.loggingEnabled = MdObjectFactory.getInstance().getLoggingEnabled();
        this.debug = MdObjectFactory.getInstance().getDebug();
        MdObjectFactory.getInstance().setLoggingEnabled(false);
        MdObjectFactory.getInstance().setDebug(true);
        PluginLogger.log("***** IOMIConnectionProvider.connect() successfully connected");
    }

    public void disconnect() {
        PluginLogger.log("***** IOMIConnectionProvider.disconnect()");
        if (this.calledFromConsole && this.mos != null) {
            this.mos.dispose();
            this.mws.dispose();
        }
        MdObjectFactory.getInstance().setLoggingEnabled(this.loggingEnabled);
        MdObjectFactory.getInstance().setDebug(this.debug);
    }

    public List getRepositories() {
        return this.repos;
    }

    public MdStore getObjectStore() {
        return this.mos;
    }
}

