/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc;

import com.sas.metadata.Util;
import com.sas.wadmin.reports.AbstractReport;
import com.sas.wadmin.reports.ReportingController;
import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.iomi.IOMIAccess;
import com.sas.wadmin.reports.jobdoc.iomi.IOMIConnectionProvider;
import com.sas.wadmin.reports.jobdoc.md.GlobalProperties;
import com.sas.wadmin.reports.jobdoc.parser.HTMLGenerator;
import com.sas.wadmin.reports.jobdoc.visuals.JobDocPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JobDoc
extends AbstractReport {
    private static WAdminResource bundle = new WAdminResource(JobDoc.class);
    protected ImageIcon icon = null;
    protected ImageIcon icon32 = null;
    protected String toolTip = bundle.getString("JobDoc.description.txt");
    protected String name = bundle.getString("JobDoc.Name.txt");
    protected String description = bundle.getString("JobDoc.description.txt");
    protected boolean bSuccessful = true;
    private boolean m_bUseDefaultLayout = true;
    private boolean m_bAllTables = true;
    private String m_sDefaultPath = "";

    public JobDoc() {
        this.doPrintPluginVersion();
        this.setFileName("index.html");
    }

    @Override
    public void onSelected() {
        GlobalProperties.instance().setCalledFromConsole(false);
        GlobalProperties.instance().setHostname(Workspace.getWorkspace().getServerName());
        GlobalProperties.instance().setUsername(Workspace.getWorkspace().getUsername());
        Date d = new Date();
        GlobalProperties.instance().setDate(DateFormat.getDateInstance(1).format(d));
        GlobalProperties.instance().setDatetime(DateFormat.getDateTimeInstance(1, 1).format(d));
        Util.printLogln((String)"***** JobDoc.onSelected()");
        Util.printLogln((String)"jobdoc.onselected");
        this.doOnSelected();
    }

    public Icon getLargeIcon() {
        return this.icon32;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    private void doPrintPluginVersion() {
        try {
            URL url = JobDoc.class.getClassLoader().getResource("com/sas/wadmin/reports/jobdoc/JobDoc.class");
            if (url == null) {
                return;
            }
            String s = url.getFile();
            int i = s.indexOf("file:/");
            int j = s.indexOf(33);
            s = s.substring(i += "file:/".length(), j);
            JarFile jf = new JarFile(s);
            Manifest m = jf.getManifest();
            Attributes attrs = m.getMainAttributes();
            Util.printLogln((String)"*******************************************************************************");
            Util.printLogln((String)("Plugin-Init:              " + attrs.getValue("Plugin-Init")));
            Util.printLogln((String)("Extension-Name:           " + attrs.getValue("Extension-Name")));
            Util.printLogln((String)("Implementation-Title:     " + attrs.getValue("Implementation-Title")));
            Util.printLogln((String)("Implementation-Vendor-Id: " + attrs.getValue("Implementation-Vendor-Id")));
            Util.printLogln((String)("Implementation-Version:   " + attrs.getValue("Implementation-Version")));
            Util.printLogln((String)("Implementation-Vendor:    " + attrs.getValue("Implementation-Vendor")));
            Util.printLogln((String)"*******************************************************************************");
        }
        catch (Exception e) {
            Util.printStackTrace((Throwable)e);
        }
    }

    @Override
    public String getCategory() {
        return bundle.getString("JobDoc.Category.txt");
    }

    @Override
    public String getReportingClass() {
        return "com.sas.wadmin.reports.jobdoc.JobDoc";
    }

    @Override
    public StringBuffer getSourceCode() {
        return null;
    }

    public void doOnSelected() {
        GlobalProperties.instance().setOutputdirectory(this.getOutputDirectory());
        if (this.getPath() == null || this.getPath().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("JobDoc.dlg.nopath.txt"), (int)0);
            return;
        }
        String templateDirectory = this.m_bUseDefaultLayout ? "" : "" + this.getTemplateDirectory();
        GlobalProperties.instance().setTemplatedirectory(this.m_bUseDefaultLayout ? "" : "" + this.getTemplateDirectory());
        GlobalProperties.instance().setOutputdirectory("" + this.getPath());
        Util.printLogln((String)("template directory at start: " + templateDirectory));
        Util.printLogln((String)("output directory at start: " + this.getPath()));
        this.doShowProgressBarOnSearch();
        Util.printLogln((String)"returned from running");
        ReportingController.viewReport(this.getURL());
    }

    private void doRunJobGeneration(OpRequestUI oui) {
        Util.printLogln((String)"***** JobDocDialog.doRunJobGeneration(): starting");
        boolean rc = true;
        try {
            this.doRunSearch(oui);
        }
        catch (Exception e) {
            Util.printLogln((String)("##### JobDocDialog.doRunJobGeneration(): " + PluginLogger.getStackTrace(e)));
            rc = false;
        }
        if (!rc) {
            MessageUtil.displayDetailsMessage((String)bundle.getString("JobDoc.dlg.failure.txt"), (int)0, (String)bundle.getString("JobDoc.dlg.resultstitle.txt"));
        }
        Util.printLogln((String)"***** JobDocDialog.doRunJobGeneration(): closing");
    }

    private void doRunSearch(OpRequestUI oui) {
        IOMIConnectionProvider icp = new IOMIConnectionProvider(GlobalProperties.instance().isCalledFromConsole());
        GlobalProperties.instance().setHostname(Workspace.getWorkspace().getServerName());
        GlobalProperties.instance().setTemplatedirectory(this.m_bUseDefaultLayout ? "" : "" + this.getTemplateDirectory());
        GlobalProperties.instance().setOutputdirectory("" + this.getOutputDirectory());
        GlobalProperties.instance().setIncludeall(this.m_bAllTables);
        Util.printLogln((String)("template directory at start: " + this.getTemplateDirectory()));
        Util.printLogln((String)("output directory at start: " + this.getPath()));
        IOMIAccess access = new IOMIAccess(icp);
        oui.setMessage(bundle.getString("JobDocRun.init.txt"));
        access.init();
        oui.setMessage(bundle.getString("JobDocRun.createxref.txt"));
        access.createCrossReferences();
        HTMLGenerator hg = new HTMLGenerator();
        hg.init();
        oui.setMessage(bundle.getString("JobDocRun.runningjob.txt"));
        hg.run();
        Util.printLogln((String)"returned from run");
        access.close();
    }

    private void doShowProgressBarOnSearch() {
        final OpRequestUI oui = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("JobDoc.dlg.prglabel.txt"), bundle.getString("JobDoc.dlg.prgtitle.txt"));
        oui.setProgressShownOnStatusBar(false);
        oui.setMessagePreferredSize(new Dimension(200, 50));
        oui.setDelayBeforeProgressCancelDialog(200);
        oui.execute(new Runnable(){

            @Override
            public void run() {
                JobDoc.this.doRunJobGeneration(oui);
            }
        });
    }

    private String getOutputDirectory() {
        return super.getPath();
    }

    public String getTemplateDirectory() {
        return this.m_sDefaultPath;
    }

    @Override
    public void showOptionsDialog(ReportingController controller) {
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("JobDoc.Options.Title.txt"), true);
        JobDocPanel pnlOptions = new JobDocPanel(controller);
        dialog.setMainPanel((WAPanel)pnlOptions);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            this.m_bUseDefaultLayout = pnlOptions.isDefaultLayout();
            if (pnlOptions.getTemplateDirectory() != null && pnlOptions.getTemplateDirectory().length() > 0) {
                String[] listOfFiles;
                String proposedTemplateDir = pnlOptions.getTemplateDirectory();
                File test = new File(proposedTemplateDir);
                boolean bExists = test.exists();
                if (bExists && (listOfFiles = test.list()).length == 0) {
                    bExists = false;
                }
                if (!bExists) {
                    MessageUtil.displayMessage((String)bundle.getString("JobDoc.Options.ErrorNoTemplatesDir.txt"), (int)0);
                } else {
                    this.m_sDefaultPath = pnlOptions.getTemplateDirectory();
                }
            }
            this.m_bAllTables = pnlOptions.isAllTables();
        }
        dialog.dispose();
    }

    @Override
    public boolean isFileNameFieldEditable() {
        return false;
    }

    @Override
    public boolean isLocalBrowse() {
        return true;
    }
}

