/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports;

import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRDocument;
import com.sas.services.information.metadata.PathUrl;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.plugins.ReportingInterface;
import com.sas.wadmin.reports.ReportingController;
import com.sas.wadmin.reports.ReportingView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerEvent;
import com.sas.workspace.WsAppServerEventListener;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.visuals.SASLogDialog;
import com.sas.workspace.visuals.SubmitType;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReportingPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ReportingPanel.class);
    private static final String PathNameKey = "Reporting.ReportingPanel.Path";
    private static final int PathNameMax = 8;
    private WATextArea m_txtReportResultsDesc;
    private WsTable m_tblReport;
    private ReportTableModel m_mdlReport;
    private WAComboBox m_cbShowTypes;
    private WAComboBox m_cbPath;
    private WATextField m_txtFileName;
    private JButton m_btnRunReport;
    private JButton m_btnSaveResult;
    private JButton m_btnShowOptions;
    private JButton m_btnBrowse;
    private WsAbstractAction m_actRunReport;
    private WsAbstractAction m_actSaveResult;
    private WsAbstractAction m_actShowOptions;
    private WsAbstractAction m_actBrowse;
    private boolean m_bIsLocalBrowse = false;
    private static final String SHOW_ALL = "All";
    private static final String SHOW_RECENTLY_RUN = "RecentlyRun";
    private static final String SHOW_SAVED_AS = "SavedAsDocs";
    private ReportingController m_controller = ReportingController.getInstance();
    private ReportingView m_view;
    private LogListViewer m_logView;
    private String m_lastsbip;
    private boolean m_showSingleCategory = false;
    private String m_singleCategory;
    private Root m_metadataObject;
    private PropertyChangeListener m_svrRequestChangeListener;
    private WsAppServerEventListener m_appServerEventListener;
    private static String[][] m_specialCategories = new String[][]{{bundle.getString("ReportingPanel.ShowAllCategory.txt"), "All"}, {bundle.getString("ReportingPanel.ShowRecentlyRun.txt"), "RecentlyRun"}, {bundle.getString("ReportingPanel.ShowSavedAsDoc.txt"), "SavedAsDocs"}};

    public ReportingPanel() {
        this.initialize();
    }

    public ReportingPanel(String category, Root object) {
        this.m_singleCategory = category;
        this.m_metadataObject = object;
        this.m_showSingleCategory = true;
        this.initialize();
    }

    public ReportingPanel(ReportingView view) {
        this();
        this.m_view = view;
    }

    protected void initialize() {
        this.setHelpProduct("wdb");
        this.setHelpTopic("reports_view");
        this.createActions();
        JToolBar toolBar = this.createToolBar();
        JPanel pnlResults = this.createResultsPanel();
        this.m_mdlReport = new ReportTableModel();
        this.m_tblReport = new WsTable((WsAbstractTableModel)this.m_mdlReport);
        this.m_tblReport.setToolTipText(bundle.getString("ReportingPanel.Table.tip"));
        this.m_tblReport.setRowHoldingEnabled(false);
        this.m_tblReport.setColumnsReorderable(false);
        this.m_tblReport.setColumnHidingEnabled(false);
        this.m_tblReport.setColumnHoldingEnabled(false);
        this.m_tblReport.setCellSelectionEnabled(false);
        this.m_tblReport.setRowSelectionAllowed(true);
        this.m_tblReport.setAutoResizeMode(3);
        this.m_tblReport.setSelectionMode(0);
        this.m_tblReport.setDefaultAction((Action)this.m_actRunReport);
        this.m_tblReport.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_tblReport.getRowModel().getSelectionModel().addListSelectionListener(new TableSelectionListener());
        JScrollPane scrTblReport = new JScrollPane((Component)this.m_tblReport);
        this.m_svrRequestChangeListener = new ServerRequestDataChangedListener();
        this.m_controller.getServerRequest().addPropertyChangeListener(this.m_svrRequestChangeListener);
        this.m_appServerEventListener = new AppServerEventListener();
        this.m_controller.getServerRequest().addcWsAppServerEventListener(this.m_appServerEventListener);
        this.setLayout(new GridBagLayout());
        this.add(toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(scrTblReport, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(pnlResults, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 0, 0, 0), 0, 0));
    }

    private void createActions() {
        this.m_actRunReport = new RunReportAction();
        this.m_actSaveResult = new SaveResultAction();
        this.m_actShowOptions = new ShowOptionsAction();
        this.m_actBrowse = new BrowseAction();
    }

    private JToolBar createToolBar() {
        this.m_cbShowTypes = new WAComboBox();
        this.m_cbShowTypes.setEditable(false);
        this.m_cbShowTypes.setToolTipText(bundle.getString("ReportingPanel.ShowReports.tip"));
        JLabel lblShowTypes = WsUIUtilities.createLabelForComponent((JComponent)this.m_cbShowTypes, (String)bundle.getString("ReportingPanel.ShowReports.txt"));
        lblShowTypes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.loadShowItems();
        this.m_cbShowTypes.addActionListener((ActionListener)new ShowTypeListener());
        JPanel combo = new JPanel();
        combo.setLayout(new GridBagLayout());
        combo.add((Component)lblShowTypes, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        combo.add((Component)this.m_cbShowTypes, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        JToolBar toolBar = WsUIUtilities.createToolBar();
        toolBar.add(combo);
        toolBar.addSeparator();
        this.m_btnRunReport = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRunReport);
        toolBar.add(this.m_btnRunReport);
        this.m_btnSaveResult = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actSaveResult);
        toolBar.add(this.m_btnSaveResult);
        this.m_btnShowOptions = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actShowOptions);
        toolBar.add(this.m_btnShowOptions);
        return toolBar;
    }

    private JPanel createResultsPanel() {
        this.m_txtReportResultsDesc = new WATextArea();
        this.m_txtReportResultsDesc.setText(bundle.getString("ReportingPanel.ReportResultsDesc.txt"));
        this.m_txtReportResultsDesc.setColumns(60);
        this.m_txtReportResultsDesc.setBehavior(1);
        this.m_txtReportResultsDesc.setAutosize(true);
        this.m_cbPath = new WAComboBox();
        this.m_cbPath.setEditable(true);
        this.m_cbPath.setPrototypeDisplayValue((Object)"c:\\documents and settings\\YourName\\data.txt");
        this.m_cbPath.setToolTipText(bundle.getString("ReportingPanel.DefaultLocation.tip"));
        JLabel lblPath = WsUIUtilities.createLabelForComponent((JComponent)this.m_cbPath, (String)bundle.getString("ReportingPanel.DefaultLocation.txt"));
        this.m_btnBrowse = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actBrowse);
        this.m_txtFileName = new WATextField();
        this.m_txtFileName.setEditable(true);
        this.m_txtFileName.addActionListener((ActionListener)((Object)new FileNameEditAction()));
        this.m_txtFileName.setToolTipText(bundle.getString("ReportingPanel.FileName.tip"));
        JLabel lblFileName = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtFileName, (String)bundle.getString("ReportingPanel.FileName.txt"));
        lblFileName.setIcon(bundle.getImageIcon("ReportingPanel.RequiredAsterisk.image"));
        lblFileName.setIconTextGap(0);
        JPanel pnlResults = new JPanel();
        pnlResults.setLayout(new GridBagLayout());
        pnlResults.add((Component)this.m_txtReportResultsDesc, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        pnlResults.add((Component)lblPath, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        pnlResults.add((Component)this.m_cbPath, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        pnlResults.add((Component)this.m_btnBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        pnlResults.add((Component)lblFileName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        pnlResults.add((Component)this.m_txtFileName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        pnlResults.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ReportingPanel.ReportResultsTitle.txt")));
        return pnlResults;
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlReport.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlReport.moveDataToModel();
        this.m_cbPath.loadItems(PathNameKey, 8);
        if (this.m_cbPath.getItemCount() == 0) {
            String env = System.getProperty("user.home");
            this.m_cbPath.addItem((Object)env);
            this.m_cbPath.setSelectedIndex(0);
        }
        this.updateActions();
        SwingUtilities.invokeLater(new SelectFirstRow());
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlReport.moveDataToStore();
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateActions();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actBrowse.setActive(bActive);
        this.m_actRunReport.setActive(bActive);
        this.m_actSaveResult.setActive(bActive);
        this.m_actShowOptions.setActive(bActive);
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlReport.saveDateValues();
        this.m_cbPath.saveItems(PathNameKey, 8);
        this.m_controller.getServerRequest().removePropertyChangeListener(this.m_svrRequestChangeListener);
        this.m_controller.getServerRequest().removecWsAppServerEventListener(this.m_appServerEventListener);
        this.m_controller = null;
        this.m_view = null;
        this.m_logView = null;
    }

    protected void updateActions() {
        int[] aSelectedRows = this.m_tblReport.getSelectedRowsFromSelectedCells();
        this.m_tblReport.convertRowIndexesToModel(aSelectedRows);
        boolean bEditable = this.isEditable();
        boolean bSelected = aSelectedRows.length > 0;
        boolean bOptionsAvailable = false;
        boolean bIsReportNameFieldEditable = true;
        this.m_bIsLocalBrowse = false;
        if (bSelected) {
            ReportingInterface report = (ReportingInterface)this.m_mdlReport.getValueAt(aSelectedRows[0], 5);
            bOptionsAvailable = report.hasAnOptionsDialog();
            bIsReportNameFieldEditable = report.isFileNameFieldEditable();
            this.m_bIsLocalBrowse = report.isLocalBrowse();
        }
        this.m_actShowOptions.setEnabled(bEditable && bOptionsAvailable && bSelected);
        this.m_actRunReport.setEnabled(bEditable && bSelected);
        this.m_actSaveResult.setEnabled(bEditable && bSelected);
        this.m_actBrowse.setEnabled(bEditable);
        this.m_txtFileName.setEnabled(bEditable && bIsReportNameFieldEditable);
    }

    private void loadShowItems() {
        if (!this.m_showSingleCategory) {
            this.m_cbShowTypes.addItem((Object)m_specialCategories[0][0]);
            this.m_cbShowTypes.addItem(WAComboBox.SEPARATOR);
            this.m_cbShowTypes.addItems(this.m_controller.getCategories());
        } else {
            this.m_cbShowTypes.addItem((Object)this.m_singleCategory);
        }
        this.m_cbShowTypes.addItem(WAComboBox.SEPARATOR);
        this.m_cbShowTypes.addItem((Object)m_specialCategories[1][0]);
        this.m_cbShowTypes.addItem((Object)m_specialCategories[2][0]);
    }

    private void updateViewTitle(String appendText) {
        if (this.m_view != null) {
            String title = this.m_view.getFrameTitle();
            if (appendText.length() > 0) {
                this.m_view.setFrameTitle(title + " : " + appendText);
            } else {
                this.m_view.setFrameTitle(title);
            }
        }
    }

    private void displayLocalFileSelector() {
        String sPath = (String)this.m_cbPath.getSelectedItem();
        sPath = sPath != null ? sPath.trim() : System.getProperty("user.home");
        File file = null;
        JFileChooser chooser = new JFileChooser(sPath);
        if (!this.m_txtFileName.isEnabled()) {
            chooser.setFileSelectionMode(1);
        } else {
            chooser.setFileSelectionMode(2);
        }
        chooser.setDialogTitle(bundle.getString("ReportSelectFile.txt"));
        int retValue = chooser.showOpenDialog(chooser);
        if (retValue == 0) {
            file = chooser.getSelectedFile();
            String newPath = null;
            if (file != null) {
                newPath = file.getPath();
            }
            if (newPath != null) {
                this.m_cbPath.setSelectedItem((Object)newPath);
            }
            if (file != null && this.m_txtFileName.isEnabled() && file.getName() != null) {
                this.m_txtFileName.setText(file.getName());
            }
        }
    }

    private void displayRemoteFileSelector() {
        try {
            WsServerRequest svrRequest = this.m_controller.getServerRequest();
            svrRequest.setWsAppServer(null);
            WsAppServer appServer = svrRequest.getAppServer();
            if (appServer == null) {
                return;
            }
            String strOS = appServer.getOperatingSystem();
            if (strOS.equalsIgnoreCase("OS")) {
                MessageUtil.displayMessage((String)bundle.getString("ReportingPanel.Error.UnableToBrowse.txt"), (int)0);
                return;
            }
            LinkedHashMap mapFileTypes = new LinkedHashMap();
            String sfullName = this.getPathAndFileName();
            String newPath = appServer.promptForDirectory(bundle.getString("ReportingPanel.RemoteFileSelector.Title.txt"), sfullName, mapFileTypes);
            if (newPath != null) {
                this.m_cbPath.setSelectedItem((Object)newPath);
            }
            appServer.close();
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (GenericError ge) {
            MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
        }
    }

    private String getPathAndFileName() {
        String sPath = (String)this.m_cbPath.getSelectedItem();
        sPath = sPath != null ? sPath.trim() : "";
        String sFileName = this.m_txtFileName.getText();
        sFileName = sFileName != null ? sFileName.trim() : "";
        String sfullName = sPath + sFileName;
        return sfullName;
    }

    private void submitFinished(String sJobStatus) {
        Workspace work = Workspace.getWorkspace();
        this.m_actRunReport.setEnabled(true);
        SubmitType.getInstance().setEnabled(true);
        if (sJobStatus.equals(WsServerRequest.JOBSUCCESSFUL)) {
            int[] aSelectedRows = this.m_tblReport.getSelectedRowsFromSelectedCells();
            this.m_tblReport.convertRowIndexesToModel(aSelectedRows);
            this.m_mdlReport.setValueAt(this.m_controller.getServerRequest().getPropertyDate("endtime"), aSelectedRows[0], 3);
            ReportingInterface report = (ReportingInterface)this.m_mdlReport.getValueAt(aSelectedRows[0], 5);
            ReportingController.viewReport(report.getURL());
        } else if (sJobStatus.equals(WsServerRequest.JOBERRORED)) {
            this.showSASLogDialog(bundle.getString("ReportingPanel.CodeErrors.txt"), 0);
        }
        work.clearStatusText();
        this.m_controller.getServerRequest().getAppServer().close();
    }

    public void showSASLogDialog(String message, int iMessageType) {
        int choice = MessageUtil.displayMessage((String)message, (int)iMessageType, (int)0);
        if (choice == 0) {
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("ReportingPanel.SASLog.title.txt"), true, this.m_logView);
            dlg.show();
        }
    }

    protected class SelectFirstRow
    implements Runnable {
        @Override
        public void run() {
            if (ReportingPanel.this.m_mdlReport.getRowCount() > 0) {
                ReportingPanel.this.m_tblReport.selectRow(0);
            }
        }
    }

    protected class GetLogRunnable
    implements Runnable {
        private LogListHolder m_llhLog;

        public GetLogRunnable(LogListHolder llhLog) {
            this.m_llhLog = llhLog;
        }

        @Override
        public void run() {
            if (ReportingPanel.this.m_logView != null && this.m_llhLog != null) {
                ReportingPanel.this.m_logView.append(this.m_llhLog);
            }
        }
    }

    private class SubmitFinishRunnable
    implements Runnable {
        private String m_sJobStatus;

        public SubmitFinishRunnable(String sJobStatus) {
            this.m_sJobStatus = sJobStatus;
        }

        @Override
        public void run() {
            ReportingPanel.this.submitFinished(this.m_sJobStatus);
        }
    }

    private class ShowTypeListener
    implements ActionListener {
        private ShowTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String type = (String)ReportingPanel.this.m_cbShowTypes.getSelectedItem();
            ReportingPanel.this.m_mdlReport.showReportsByType(type);
            if (ReportingPanel.this.m_mdlReport.getRowCount() > 0) {
                ReportingPanel.this.m_tblReport.addRowToSelection(0);
            }
            ReportingPanel.this.updateActions();
        }
    }

    protected class AppServerEventListener
    implements WsAppServerEventListener {
        protected AppServerEventListener() {
        }

        public void eventHappened(WsAppServerEvent evt) {
            if (evt.getEventId() == 1) {
                SwingUtilities.invokeLater(new GetLogRunnable(evt.getListText()));
            }
        }
    }

    private class ServerRequestDataChangedListener
    implements PropertyChangeListener {
        private ServerRequestDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (ReportingPanel.this.m_controller == null) {
                ReportingPanel.this.m_controller = ReportingController.getInstance();
            }
            if (e.getPropertyName().equalsIgnoreCase(WsServerRequest.DISPOSED)) {
                ReportingPanel.this.m_controller.getServerRequest().termWsServerRequest();
                return;
            }
            if (e.getPropertyName().equalsIgnoreCase("jobstatus")) {
                ReportingPanel.this.updateViewTitle(e.getNewValue().toString());
                if (e.getNewValue().equals(WsServerRequest.JOBABORTED) || e.getNewValue().equals(WsServerRequest.JOBERRORED) || e.getNewValue().equals(WsServerRequest.JOBKILLED) || e.getNewValue().equals(WsServerRequest.JOBTERMINATED) || e.getNewValue().equals(WsServerRequest.JOBSUCCESSFUL) || e.getNewValue().equals(WsServerRequest.JOBCANCELLED)) {
                    SwingUtilities.invokeLater(new SubmitFinishRunnable((String)e.getNewValue()));
                }
            }
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] aSelectedRows = ReportingPanel.this.m_tblReport.getSelectedRowsFromSelectedCells();
            if (aSelectedRows.length == 0) {
                ReportingPanel.this.updateActions();
                return;
            }
            ReportingPanel.this.m_tblReport.convertRowIndexesToModel(aSelectedRows);
            ReportingInterface report = (ReportingInterface)ReportingPanel.this.m_mdlReport.getValueAt(aSelectedRows[0], 5);
            ReportingPanel.this.m_txtFileName.setText(report.getFileName());
            ReportingPanel.this.updateActions();
        }
    }

    private class ReportTableModel
    extends WsAbstractTableModel {
        protected static final int TOTAL_COLS = 5;
        protected static final int TOTAL_HIDDEN_COLS = 1;
        protected static final int NAME_COL = 0;
        protected static final int DESC_COL = 1;
        protected static final int CATEGORY_COL = 2;
        protected static final int LAST_RUN_DATE_COL = 3;
        protected static final int LAST_SAVE_DATE_COL = 4;
        protected static final int REPORT_OBJECT_COL = 5;
        private static final String LastRunTimeKey = "LastRunTime";
        private static final String LastSavedTimeKey = "LastSavedTime";
        private final Date DateMissing = new Date(Long.MAX_VALUE);

        public ReportTableModel() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            WsStringTableColumn nameCol = new WsStringTableColumn(0, bundle.getString("ReportingPanel.NameColumn.txt"), 150);
            nameCol.setEditable(false);
            this.m_aColumns[0] = nameCol;
            WsStringTableColumn descCol = new WsStringTableColumn(1, bundle.getString("ReportingPanel.DescriptionColumn.txt"), 200);
            descCol.setEditable(false);
            this.m_aColumns[1] = descCol;
            WsStringTableColumn categoryCol = new WsStringTableColumn(2, bundle.getString("ReportingPanel.CategoryColumn.txt"), 100);
            categoryCol.setEditable(false);
            this.m_aColumns[2] = categoryCol;
            WsDateTableColumn lastRunTimeCol = new WsDateTableColumn(3, bundle.getString("ReportingPanel.LastRunDateColumn.txt"), 100);
            lastRunTimeCol.setEditable(false);
            lastRunTimeCol.setShowAsBlankDate(this.DateMissing);
            this.m_aColumns[3] = lastRunTimeCol;
            WsDateTableColumn lastSaveTimeCol = new WsDateTableColumn(4, bundle.getString("ReportingPanel.LastSaveDateColumn.txt"), 100);
            lastSaveTimeCol.setEditable(false);
            lastSaveTimeCol.setShowAsBlankDate(this.DateMissing);
            this.m_aColumns[4] = lastSaveTimeCol;
            this.m_aColumns[5] = new WsObjectTableColumn();
        }

        public int getColumnCount() {
            return 5;
        }

        public int getHiddenColumnCount() {
            return 1;
        }

        public void moveDataToModel() throws MdException, RemoteException {
            if (ReportingPanel.this.m_showSingleCategory) {
                List lReports = ReportingPanel.this.m_controller.getReportsByCategory(ReportingPanel.this.m_singleCategory);
                for (int i = 0; i < lReports.size(); ++i) {
                    ReportingInterface report = (ReportingInterface)lReports.get(i);
                    report.setDefaultMetadataObject(ReportingPanel.this.m_metadataObject);
                }
                this.showReportsByType(ReportingPanel.this.m_singleCategory);
            } else {
                this.showReportsByType(ReportingPanel.SHOW_ALL);
            }
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public void populateStore() throws MdException, RemoteException {
            if (this.isStorePopulated()) {
                return;
            }
            this.setStorePopulated(true);
        }

        public boolean validateData() {
            return true;
        }

        public void showReportsByType(String type) {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.saveDateValues();
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = 0;
            String transType = this.translateSpecialTypes(type);
            List lReports = ReportingPanel.this.m_showSingleCategory ? ReportingController.getInstance().getReportsByCategory(ReportingPanel.this.m_singleCategory) : (transType.equals(ReportingPanel.SHOW_ALL) || transType.equals(ReportingPanel.SHOW_RECENTLY_RUN) || transType.equals(ReportingPanel.SHOW_SAVED_AS) ? ReportingController.getInstance().getAllReports() : ReportingController.getInstance().getReportsByCategory(transType));
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            for (int i = 0; i < lReports.size(); ++i) {
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                ReportingInterface report = (ReportingInterface)lReports.get(i);
                String sUniqueName = report.getName().replaceAll(" ", "") + ".";
                alRow.add(report.getName());
                alRow.add(report.getDescription());
                alRow.add(report.getCategory());
                String sKey = sUniqueName + LastRunTimeKey;
                String sRunDate = appDefaults.getPropertyString(sKey).trim();
                sKey = sUniqueName + LastSavedTimeKey;
                String sSavedDate = appDefaults.getPropertyString(sKey).trim();
                Date dRunDate = this.DateMissing;
                Date dSavedDate = this.DateMissing;
                try {
                    DateFormat df = DateFormat.getDateTimeInstance(2, 2);
                    if (sRunDate.length() > 0) {
                        dRunDate = df.parse(sRunDate);
                    }
                    if (sSavedDate.length() > 0) {
                        dSavedDate = df.parse(sSavedDate);
                    }
                }
                catch (ParseException pe) {
                    Workspace.getDefaultLogger().debug((Object)pe.getLocalizedMessage());
                }
                alRow.add(dRunDate);
                alRow.add(dSavedDate);
                alRow.add(report);
                if (transType.equals(ReportingPanel.SHOW_RECENTLY_RUN) && dRunDate == this.DateMissing || transType.equals(ReportingPanel.SHOW_SAVED_AS) && dSavedDate == this.DateMissing) continue;
                this.m_lData.add(alRow);
                ++nRows;
            }
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
            this.m_nRowInstances = nRows;
        }

        public void saveDateValues() {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            DateFormat df = DateFormat.getDateTimeInstance(2, 2);
            for (int i = 0; i < this.getRowCount(); ++i) {
                Date runDate = (Date)this.getValueAt(i, 3);
                Date savedDate = (Date)this.getValueAt(i, 4);
                ReportingInterface report = (ReportingInterface)this.getValueAt(i, 5);
                String sUniqueName = report.getName().replaceAll(" ", "") + ".";
                String sKey = sUniqueName + LastRunTimeKey;
                if (!runDate.equals(this.DateMissing)) {
                    appDefaults.setPropertyString(sKey, df.format(runDate));
                }
                sKey = sUniqueName + LastSavedTimeKey;
                if (savedDate.equals(this.DateMissing)) continue;
                appDefaults.setPropertyString(sKey, df.format(savedDate));
            }
        }

        private String translateSpecialTypes(String type) {
            for (int i = 0; i < m_specialCategories.length; ++i) {
                if (!type.equals(m_specialCategories[i][0])) continue;
                return m_specialCategories[i][1];
            }
            return type;
        }
    }

    private class FileNameEditAction
    extends WsAbstractAction {
        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = ReportingPanel.this.m_tblReport.getSelectedRowsFromSelectedCells();
            if (aSelectedRows.length == 0) {
                return;
            }
            ReportingPanel.this.m_tblReport.convertRowIndexesToModel(aSelectedRows);
            ReportingInterface report = (ReportingInterface)ReportingPanel.this.m_mdlReport.getValueAt(aSelectedRows[0], 5);
            String fileName = ReportingPanel.this.m_txtFileName.getText();
            if (fileName.trim().length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ReportingPanel.MissingFileNameError.txt"));
            }
            report.setFileName(fileName.trim());
            ReportingPanel.this.m_txtFileName.setText(report.getFileName());
        }
    }

    private class BrowseAction
    extends WsAbstractAction {
        public BrowseAction() {
            super(bundle, "ReportingPanel.Action.Browse", 0);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ReportingPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                if (ReportingPanel.this.m_bIsLocalBrowse) {
                    ReportingPanel.this.displayLocalFileSelector();
                } else {
                    ReportingPanel.this.displayRemoteFileSelector();
                }
            }
            finally {
                ReportingPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class ShowOptionsAction
    extends WsAbstractAction {
        public ShowOptionsAction() {
            super(bundle, "ReportingPanel.Action.ShowOptions", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Options"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = ReportingPanel.this.m_tblReport.getSelectedRowsFromSelectedCells();
            if (aSelectedRows.length == 0) {
                return;
            }
            ReportingPanel.this.m_tblReport.convertRowIndexesToModel(aSelectedRows);
            ReportingInterface report = (ReportingInterface)ReportingPanel.this.m_mdlReport.getValueAt(aSelectedRows[0], 5);
            report.showOptionsDialog(ReportingPanel.this.m_controller);
            ReportingPanel.this.m_txtFileName.setText(report.getFileName());
        }
    }

    private class SaveResultAction
    extends WsAbstractAction {
        public SaveResultAction() {
            super(bundle, "ReportingPanel.Action.SaveResults", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:SaveAs"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = ReportingPanel.this.m_tblReport.getSelectedRowsFromSelectedCells();
            if (aSelectedRows.length == 0) {
                return;
            }
            ReportingPanel.this.m_tblReport.convertRowIndexesToModel(aSelectedRows);
            ReportingInterface report = (ReportingInterface)ReportingPanel.this.m_mdlReport.getValueAt(aSelectedRows[0], 5);
            LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
            fileTypes.put(bundle.getString("ReportingPanel.DocumentTypes.txt"), "Document");
            String startDir = null;
            int index = 0;
            if (ReportingPanel.this.m_lastsbip != null) {
                startDir = ReportingPanel.this.m_lastsbip;
            }
            MdObjectStore store = null;
            try {
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                String startFolder = null;
                if (startDir == null) {
                    try {
                        store = Workspace.getMdFactory().createObjectStore(null, "ReportingPanel:SaveResultAction:actionPerformed");
                        Tree defaultFolder = WsMetadataUtil.getDefaultFolder((MdObjectStore)store);
                        String key = defaultFolder.getFQID() + "/" + defaultFolder.getCMetadataType();
                        MetadataInterface mi = server.fetch(key, true);
                        PathUrl objectPath = mi.getPathUrl();
                        startFolder = objectPath.toString();
                    }
                    finally {
                        if (store != null) {
                            store.dispose();
                        }
                    }
                } else {
                    startFolder = startDir;
                }
                InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(startFolder, server, fileTypes, false);
                panel.getModel().setRefreshNeeded(true);
                panel.setSelectionMode(InformationServicesSelectorPanel.FILES_ONLY);
                panel.setMultiSelectionEnabled(false);
                if (Workspace.getWorkspace().isChangeManagementOn()) {
                    panel.setSaveVerificationOn(false);
                }
                panel.setFileSelections(new String[]{WsMetadataNameUtil.getUniqueNameForType((String)"Document")});
                RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog((Frame)Workspace.getWorkspace(), bundle.getString("ReportingPanel.SaveAsDialog.Title.txt"), true, 1, (BaseRemoteFileSelectorPanel)panel);
                dialog.setAllowNonExistentSelections(true);
                dialog.setVisible(true);
                if (!panel.isCancelled()) {
                    List lreturnedItems = new ArrayList();
                    lreturnedItems = panel.getReturnedInformation(true);
                    if (lreturnedItems != null && !lreturnedItems.isEmpty()) {
                        boolean fValid;
                        String path = lreturnedItems.get(0).toString();
                        PathUrl documentUrl = new PathUrl(path);
                        String folderPath = "";
                        String documentName = "";
                        index = path.lastIndexOf("/");
                        if (index != -1) {
                            folderPath = path.substring(0, index);
                            documentName = path.substring(index + 1);
                        }
                        if (fValid = WsMetadataNameUtil.isNameValid((String)documentName)) {
                            Tree tree;
                            PathUrl folderUrl = new PathUrl(folderPath);
                            folderUrl.setType("Folder");
                            FolderInterface folder = (FolderInterface)server.getObjectByPath(folderUrl);
                            MetadataInterface doc = server.getObjectByPath(documentUrl);
                            String pnlPath = (String)ReportingPanel.this.m_cbPath.getSelectedItem();
                            if (pnlPath != null && !pnlPath.trim().equals(report.getPath().trim())) {
                                report.setPath(pnlPath);
                            }
                            String fileName = ReportingPanel.this.m_txtFileName.getText();
                            report.setFileName(fileName);
                            String sDocURI = report.getURL();
                            if (doc == null) {
                                if (Workspace.getWorkspace().isChangeManagementOn()) {
                                    RepositoryInterface projectRepos = server.getRepository(server.getRepositoryName(Workspace.getWorkspace().getProjectRepository().getFQID()));
                                    doc = new OMRDocument(projectRepos, documentName, folder);
                                } else {
                                    doc = new OMRDocument(folder.getRepository(), documentName, folder);
                                }
                            }
                            Document docObject = (Document)doc.getRepositoryEntity();
                            docObject.setURI(sDocURI);
                            docObject.setDesc(report.getDescription());
                            FolderInterface projFolder = doc.getParent();
                            if (projFolder == null && (tree = (Tree)folder.getRepositoryEntity()) != null) {
                                docObject.getTrees().add((Object)tree);
                            }
                            doc.update();
                            ReportingPanel.this.m_mdlReport.setValueAt(new Date(), aSelectedRows[0], 4);
                            ReportingPanel.this.m_lastsbip = folderUrl.toString();
                            WsMetadataUtil.setDefaultFolder((String)folder.getIdentifier());
                        }
                    }
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Writing");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            }
        }
    }

    private class RunReportAction
    extends WsAbstractAction {
        public RunReportAction() {
            super(bundle, "ReportingPanel.Action.RunReport", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("RunReport"));
        }

        public void actionPerformed(ActionEvent e) {
            String sPath;
            int[] aSelectedRows = ReportingPanel.this.m_tblReport.getSelectedRowsFromSelectedCells();
            if (aSelectedRows.length == 0) {
                return;
            }
            ReportingPanel.this.m_tblReport.convertRowIndexesToModel(aSelectedRows);
            ReportingInterface report = (ReportingInterface)ReportingPanel.this.m_mdlReport.getValueAt(aSelectedRows[0], 5);
            String sFileName = ReportingPanel.this.m_txtFileName.getText();
            if (sFileName != null && sFileName.length() > 0) {
                report.setFileName(sFileName);
            }
            if ((sPath = (String)ReportingPanel.this.m_cbPath.getSelectedItem()) != null && sPath.length() > 0) {
                report.setPath(sPath);
            }
            ReportingPanel.this.m_logView = new LogListViewer(5, null, new CodeEditorDefaults());
            ReportingPanel.this.m_controller.runReport(report);
        }
    }
}

