/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.plugins.ReportingInterface;
import com.sas.wadmin.reports.impl.TableListingReport;
import com.sas.wadmin.reports.jobdoc.JobDoc;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.visuals.SubmitType;
import java.awt.Component;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class ReportingController {
    private static ReportingController INSTANCE = new ReportingController();
    private static final WAdminResource bundle = WAdminResource.getBundle(ReportingController.class);
    private List m_lReports;
    private List m_lCategories;
    private HashMap m_hmByCategory;
    private WsServerRequest m_svrRequest;
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    private ReportingController() {
        this.initialize();
    }

    private void initialize() {
        this.m_lReports = new ArrayList();
        this.m_lCategories = new ArrayList();
        this.m_hmByCategory = new HashMap();
        this.addReport(new TableListingReport());
        this.addReport(new JobDoc());
        ArrayList plugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.wadmin.plugins.ReportingInterface");
        for (int i = 0; i < plugins.size(); ++i) {
            this.addReport((ReportingInterface)plugins.get(i));
        }
        this.m_svrRequest = new WsServerRequest(null);
    }

    public static ReportingController getInstance() {
        return INSTANCE;
    }

    public List getReportsByCategory(String category) {
        ArrayList reports = (ArrayList)this.m_hmByCategory.get(category);
        if (reports == null) {
            reports = new ArrayList();
        }
        return reports;
    }

    public List getCategories() {
        return this.m_lCategories;
    }

    public List getAllReports() {
        return this.m_lReports;
    }

    public WsServerRequest getServerRequest() {
        return this.m_svrRequest;
    }

    public void setServerRequest(WsServerRequest svrRequest) {
        this.m_svrRequest = svrRequest;
    }

    public void runReport(ReportingInterface report) {
        report.onSelected();
        this.m_svrRequest.setWsAppServer(null);
        WsAppServer appServer = this.m_svrRequest.getAppServer();
        if (appServer == null) {
            MessageUtil.displayMessage((String)bundle.formatString("ReportingController.NoDefaultServer.Error.txt", (Object)report.getName()), (int)0);
            return;
        }
        StringBuffer rptCode = report.getSourceCode();
        if (rptCode != null && rptCode.length() > 0) {
            try {
                String appServerFQID = appServer.getServerContext().getFQID();
                String defaultAppServerId = this.m_svrRequest.getDefaultWsAppServerId();
                String submitType = SubmitType.getInstance().getSelectedSubmitType();
                String jobStatus = this.m_svrRequest.getPropertyString("jobstatus");
                int jsLength = jobStatus.length();
                if (this.m_svrRequest.getSubmitType() == null || jsLength == 0 || jsLength > 0 && defaultAppServerId.equals(appServerFQID)) {
                    this.m_svrRequest.setSubmitType(submitType);
                }
                Workspace.getDefaultLogger().info((Object)"----- Submitting -----");
                StringBuffer submitCode = new StringBuffer();
                SASCodeGeneration codeGen = new SASCodeGeneration();
                StringBuffer prefixCode = codeGen.getSubmitToGridPrefix((CMetadata)appServer.getServerContext(), appServer.getServerContext(), submitType);
                if (prefixCode != null) {
                    submitCode.append(prefixCode).append("\n").append(rptCode.toString()).append(codeGen.getSubmitToGridSuffix(appServer.getServerContext(), submitType)).append("\n");
                } else {
                    submitCode.append(rptCode.toString());
                }
                Workspace.getDefaultLogger().info((Object)submitCode.toString());
                Workspace.getDefaultLogger().info((Object)"----------------------");
                this.m_svrRequest.setCodeToSubmit(submitCode.toString());
                this.m_svrRequest.startCodeSubmit();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public static void viewReport(String url) {
        if (JOptionPane.showConfirmDialog((Component)Workspace.getWorkspace(), bundle.getString("ReportingController.view.txt"), bundle.getString("ReportingController.viewtitle.txt"), 0, 3) == 0) {
            boolean windows = ReportingController.isWindowsPlatform();
            String runTimeCommandFmt = null;
            runTimeCommandFmt = windows ? "rundll32 url.dll,FileProtocolHandler {0}" : "netscape -remote openURL({0})";
            MessageFormat fmt = new MessageFormat(runTimeCommandFmt);
            String runTimeCommand = fmt.format(new Object[]{url});
            try {
                Process process = Runtime.getRuntime().exec(runTimeCommand);
                if (process == null) {
                    MessageUtil.displayMessage((String)bundle.getString("ReportingController.UnableToViewReport.Error.txt"), (int)0, (int)-1);
                }
            }
            catch (IOException e) {
                MessageUtil.displayMessage((String)e.getMessage(), (String)bundle.getString("ReportingController.UnableToViewReport.Error.txt"), (int)0, (int)-1);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    private void addReport(ReportingInterface report) {
        this.m_lReports.add(report);
        String category = report.getCategory();
        if (this.m_hmByCategory.containsKey(category)) {
            ArrayList rpts = (ArrayList)this.m_hmByCategory.get(category);
            rpts.add(report);
        } else {
            this.m_lCategories.add(category);
            ArrayList<ReportingInterface> rpts = new ArrayList<ReportingInterface>();
            rpts.add(report);
            this.m_hmByCategory.put(category, rpts);
        }
    }
}

