/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.visuals;

import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.ValueItem;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class ValidatePrompts
implements ValidatePromptInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(ValidatePrompts.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection validatePrompt(PromptDefinitionInterface prompt, Locale locale) {
        ArrayList<ValidationEntry> errors;
        block12: {
            errors = new ArrayList<ValidationEntry>();
            if (prompt instanceof ValueProviderDefinitionInterface) {
                ValueProviderDefinitionInterface definition = (ValueProviderDefinitionInterface)prompt;
                ValueProviderInterface provider = definition.getValueProvider();
                try {
                    if (provider instanceof StaticValueProvider) {
                        StaticValueProvider sp = (StaticValueProvider)provider;
                        List values = (List)sp.getValues(locale);
                        for (int i = 0; i < values.size(); ++i) {
                            ValueItem valueItem = (ValueItem)values.get(i);
                            if (valueItem.getValue() != null && !"".equals(valueItem.getValue())) continue;
                            errors.add(new ValidationEntry(-1L, bundle.getString("ValidatePrompts.StaticValuesBlank.msg.txt")));
                            break block12;
                        }
                        break block12;
                    }
                    if (!(provider instanceof PromptColumnValueProvider)) break block12;
                    PromptColumnValueProvider sp = (PromptColumnValueProvider)provider;
                    UserContextInterface user = Workspace.getWorkspace().getUserContext();
                    try {
                        MetadataInterface mi = null;
                        ServerInterface server = user.getAuthServer();
                        ChildServerInterface transaction = server.newChild(true);
                        try {
                            PathUrl pathurl = PromptUtils.getURL((UserContextInterface)user, (String)sp.getTableUrl());
                            if (pathurl != null && transaction != null) {
                                mi = transaction.getObjectByPath(pathurl);
                            }
                            if (mi == null) {
                                errors.add(new ValidationEntry(-1L, bundle.formatString("ValidatePrompts.TableNotValid.msg.txt", (Object)sp.getTableUrl())));
                            }
                        }
                        finally {
                            transaction.destroy();
                        }
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    }
                }
                catch (ValueProviderException exc) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)exc);
                }
            }
        }
        return errors;
    }
}

