/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.visuals;

import com.sas.datatypes.DataTypeInterface;
import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.prompts.impl.DISPromptLogFactory;
import com.sas.etl.models.prompts.impl.PromptDataProvider;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.visuals.swing.designtime.GetRootPromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.MainPromptPanel;
import com.sas.prompts.visuals.swing.designtime.PromptTypesProviderInterface;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.UserInfoCleanupInterface;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.services.ServiceException;
import com.sas.services.util.Names;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.visuals.Config;
import com.sas.swing.visuals.ConfigPanelInterface;
import com.sas.util.UserInfo;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.wadmin.prompts.model.PromptTypesProvider;
import com.sas.wadmin.prompts.visuals.ConfigStateValidator;
import com.sas.wadmin.prompts.visuals.PromptXMLDialog;
import com.sas.wadmin.prompts.visuals.ValidatePrompts;
import com.sas.wadmin.visuals.MacroOptionsTemplatesPanel;
import com.sas.wadmin.visuals.ParametersSelectorPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PromptDesignTimePanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(PromptDesignTimePanel.class);
    protected MainPromptPanel m_pnlPrompt;
    protected boolean m_showImportParameters = false;
    protected boolean m_showImportExportXML = false;
    protected boolean m_bDontDeletePromptWasRemoved = false;
    protected boolean m_bGeneratedTransform = false;
    private JPanel m_pnlButtons;
    protected JButton m_butImportParameters;
    protected JButton m_butExportPromptXML;
    protected JButton m_butImportPromptXML;
    protected WsAbstractAction m_actImportParameters;
    protected WsAbstractAction m_actExportPromptXML;
    protected WsAbstractAction m_actImportPromptXML;
    private Object m_owner;
    protected PromptDataProvider m_dataProvider;
    protected PromptGroupInterface m_promptGroup;
    private PropertyChangeListener m_promptChangeListener;
    private ValidatePromptInterface m_promptValidator;
    private static final ConfigPanelInterface CONFIG_VALIDATOR = new ConfigStateValidator();
    public static final Config.Element DIS_COLUMN_PROMPT_TYPE_ELEMENT = new Config.Element(CONFIG_VALIDATOR, PromptUtils.COLUMN_PROMPT_ID, 18);
    public static final Config.Element BOOLEAN_YES_NO_ELEMENT = new Config.Element(CONFIG_VALIDATOR, PromptUtils.BOOLEAN_YES_NO_PROMPT_ID, 18);
    public static final Config.Element BOOLEAN_TRUE_FALSE_ELEMENT = new Config.Element(CONFIG_VALIDATOR, PromptUtils.BOOLEAN_TRUE_FALSE_PROMPT_ID, 18);
    private static final String HELP_PRODUCT = "wdb";
    private IModel m_model;
    private boolean m_bLocalModel = true;

    public PromptDesignTimePanel(PromptGroupInterface promptGroup, boolean allowImportParameters, Object owner, boolean showImportExport, boolean generatedTransform) {
        this.setPromptGroup(promptGroup);
        this.m_showImportParameters = allowImportParameters;
        this.m_showImportExportXML = showImportExport;
        this.m_bGeneratedTransform = generatedTransform;
        this.m_promptValidator = this.createPromptValidator();
        this.setOwner(owner);
        try {
            this.m_dataProvider = this.createDataProvider();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (String)"Accessing", (int)0);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        this.initialize();
        this.createListeners();
    }

    protected void createListeners() {
        this.m_promptChangeListener = new cPromptPanelPropertyChangeListener();
        this.m_pnlPrompt.addPropertyChangeListener(this.m_promptChangeListener);
    }

    protected PropertyChangeListener getPromptPanelListener() {
        return this.m_promptChangeListener;
    }

    protected void setOwner(Object owner) {
        this.m_owner = owner;
    }

    protected Object getOwner() {
        return this.m_owner;
    }

    private Root getMetadata() {
        Object obj = this.getOwner();
        if (obj instanceof Root) {
            return (Root)obj;
        }
        return null;
    }

    protected void initialize() {
        this.m_pnlPrompt = this.createPromptPanel();
        this.m_pnlPrompt.setNameValidator((ValidatePromptNameInterface)new cPromptNameValidator((GetRootPromptGroupInterface)this.m_pnlPrompt));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlPrompt, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.createActions();
        if (this.m_showImportParameters || this.m_showImportExportXML) {
            this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
            JPanel pnlLeft = new JPanel((LayoutManager)new WsButtonsLayout());
            this.m_pnlButtons.add((Component)pnlLeft, "West");
            if (this.m_showImportParameters) {
                this.m_butImportParameters = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actImportParameters);
                pnlLeft.add(this.m_butImportParameters);
            }
            if (this.m_showImportExportXML) {
                this.m_butImportPromptXML = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actImportPromptXML);
                this.m_butExportPromptXML = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actExportPromptXML);
                pnlLeft.add(this.m_butImportPromptXML);
                pnlLeft.add(this.m_butExportPromptXML);
            }
            this.add(this.m_pnlButtons, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
    }

    protected void createActions() {
        this.m_actImportParameters = this.createImportAction();
        this.m_actExportPromptXML = this.createExportXMLAction();
        this.m_actImportPromptXML = this.createImportXMLAction();
    }

    protected WsAbstractAction createExportXMLAction() {
        return new cExportPromptXMLAction();
    }

    protected WsAbstractAction createImportXMLAction() {
        return new cImportPromptXMLAction();
    }

    protected WsAbstractAction createImportAction() {
        return new cImportPromptsAction();
    }

    protected PromptDataProvider createDataProvider() throws RemoteException, MdException, ServiceException, ServerConnectionException {
        this.createModel();
        return new PromptDataProvider(this.m_model);
    }

    protected void createModel() {
        this.m_bLocalModel = true;
        this.m_model = new BaseModel();
    }

    public void setModel(IModel model) {
        this.disposeModel();
        this.m_bLocalModel = false;
        this.m_model = model;
        if (this.m_dataProvider != null) {
            this.m_dataProvider.setModel(model);
        }
    }

    protected void disposeModel() {
        if (this.m_bLocalModel && this.m_model != null) {
            this.m_model.dispose();
            this.m_model = null;
        }
    }

    protected PromptTypesProviderInterface createPromptTypesProvider(PropertiesCommunicator pc, boolean generatedTransform) {
        return new PromptTypesProvider(pc, generatedTransform);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        PromptGroupInterface rootPromptGroup = this.getPromptGroup();
        PromptDefinitionInterface dontDeleteOutputsPrompt = rootPromptGroup.getPromptDefinition("ADMIN.DONTDELETEOUTPUTS", false);
        if (dontDeleteOutputsPrompt != null) {
            rootPromptGroup.removePromptDefinition(dontDeleteOutputsPrompt);
            this.m_pnlPrompt.setRootPromptGroup(rootPromptGroup);
            this.m_bDontDeletePromptWasRemoved = true;
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_bDontDeletePromptWasRemoved) {
            this.getPromptGroup().addPromptDefinition((PromptDefinitionInterface)MacroOptionsTemplatesPanel.createDontDeleteOutputsPrompt());
            this.m_bDontDeletePromptWasRemoved = false;
        }
        this.setDataChanged(false);
    }

    public boolean validateData() {
        PromptGroupInterface grp = this.getPromptGroup();
        StringBuffer conflicts = PromptUtils.getDuplicateMacroNameList((PromptGroupInterface)grp);
        if (conflicts != null && conflicts.length() > 0) {
            MessageUtil.displayDetailsMessage((String)bundle.getString("PromptDesignTimePanel.ConflictingMacroName.txt"), (String)bundle.getString("Common.Error.txt"), (int)0, (String)conflicts.toString());
            return false;
        }
        List definitions = grp.getPromptDefinitions(true);
        int defsize = definitions.size();
        for (int i = 0; i < defsize; ++i) {
            PromptDefinitionInterface def = (PromptDefinitionInterface)definitions.get(i);
            Collection errors = def.validateDefinition(Locale.getDefault());
            if (!errors.isEmpty()) {
                MessageUtil.displayDetailsMessage((String)bundle.formatString("PromptDesignTimePanel.DefinitionNotValid.msg.txt", (Object)def.getPromptName()), (String)errors.toArray()[0].toString());
                return false;
            }
            errors = this.m_promptValidator.validatePrompt(def, Locale.getDefault());
            if (errors.isEmpty()) continue;
            MessageUtil.displayDetailsMessage((String)bundle.formatString("PromptDesignTimePanel.DefinitionNotValid.msg.txt", (Object)def.getPromptName()), (String)errors.toArray()[0].toString());
            return false;
        }
        return true;
    }

    protected MainPromptPanel createPromptPanel() {
        MainPromptPanel panel = null;
        panel = this.m_promptGroup == null ? new MainPromptPanel() : new MainPromptPanel(this.m_promptGroup);
        panel.setLocationSelectorEnabled(true);
        panel.setSharedButtonsVisible(false);
        PropertiesCommunicator propertiesCommunicator = panel.getPropertiesCommunicator();
        propertiesCommunicator.setLoggerFactory((LoggerFactoryInterface)DISPromptLogFactory.getInstance());
        propertiesCommunicator.setUserInfoCleanup((UserInfoCleanupInterface)new cUserInfoCleanup());
        propertiesCommunicator.setPromptValidator(this.m_promptValidator);
        propertiesCommunicator.setDataProvider((PromptDataProviderInterface)this.m_dataProvider);
        propertiesCommunicator.setPromptTypesProvider(this.createPromptTypesProvider(propertiesCommunicator, this.m_bGeneratedTransform));
        propertiesCommunicator.setUserContext(UtilPlatformServices.getUserContext());
        Config config = new Config();
        config.setHelpProduct(DIS_COLUMN_PROMPT_TYPE_ELEMENT, HELP_PRODUCT);
        config.setHelpProduct(BOOLEAN_TRUE_FALSE_ELEMENT, HELP_PRODUCT);
        config.setHelpProduct(BOOLEAN_YES_NO_ELEMENT, HELP_PRODUCT);
        config.setHelpID(DIS_COLUMN_PROMPT_TYPE_ELEMENT, "prompt_data_source_col");
        config.setHelpID(BOOLEAN_TRUE_FALSE_ELEMENT, "prompt_boolean_true");
        config.setHelpID(BOOLEAN_YES_NO_ELEMENT, "prompt_boolean_yes");
        propertiesCommunicator.setConfig(config);
        propertiesCommunicator.setDefaultHelpKeys(this.getHelpKeys());
        propertiesCommunicator.setConfigStateElements(this.getConfigStateElements());
        panel.setUserContext(UtilPlatformServices.getUserContext());
        return panel;
    }

    private Map getHelpKeys() {
        HashMap<Config.Element, String> configMap = new HashMap<Config.Element, String>();
        configMap.put(DIS_COLUMN_PROMPT_TYPE_ELEMENT, "prompt_data_source_col");
        configMap.put(BOOLEAN_TRUE_FALSE_ELEMENT, "prompt_boolean_true");
        configMap.put(BOOLEAN_YES_NO_ELEMENT, "prompt_boolean_yes");
        return configMap;
    }

    private Map getConfigStateElements() {
        HashMap<String, Config.Element> configMap = new HashMap<String, Config.Element>();
        configMap.put(PromptUtils.COLUMN_PROMPT_ID, DIS_COLUMN_PROMPT_TYPE_ELEMENT);
        configMap.put(PromptUtils.BOOLEAN_TRUE_FALSE_PROMPT_ID, BOOLEAN_TRUE_FALSE_ELEMENT);
        configMap.put(PromptUtils.BOOLEAN_YES_NO_PROMPT_ID, BOOLEAN_YES_NO_ELEMENT);
        return configMap;
    }

    protected ValidatePromptInterface createPromptValidator() {
        return new ValidatePrompts();
    }

    protected PropertyChangeListener createPromptPropertyChangeListener() {
        return new cPromptPanelPropertyChangeListener();
    }

    protected ValidatePromptNameInterface createPromptNameValidator() {
        return new cPromptNameValidator((GetRootPromptGroupInterface)this.m_pnlPrompt);
    }

    public PromptGroupInterface getPromptGroup() {
        return this.m_pnlPrompt.getRootPromptGroup();
    }

    public void setPromptGroup(PromptGroupInterface promptGroup) {
        if (promptGroup != null) {
            this.m_pnlPrompt.setRootPromptGroup(promptGroup);
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_pnlPrompt.setEnabled(editable);
        this.m_actImportPromptXML.setEnabled(editable);
        this.m_actImportParameters.setEnabled(editable);
    }

    public void saveSettingsAndCleanUp() {
        this.disposeModel();
        super.saveSettingsAndCleanUp();
        this.m_pnlPrompt.removePropertyChangeListener(this.m_promptChangeListener);
        if (this.m_dataProvider != null) {
            try {
                this.m_dataProvider.close();
            }
            catch (ServerConnectionException serverConnectionException) {
                // empty catch block
            }
        }
    }

    private class cUserInfoCleanup
    implements UserInfoCleanupInterface {
        public void cleanupUserInfo(MutablePromptDefinitionInterface prompt, int reason) {
            UserInfo info;
            List keys;
            if (prompt.getUserInfo() != null && (keys = (info = (UserInfo)prompt.getUserInfo()).getKeys()) != null) {
                int size = keys.size();
                for (int i = 0; i < size; ++i) {
                    prompt.removeUserInfo((String)keys.get(i));
                }
            }
        }
    }

    protected class cPromptPanelPropertyChangeListener
    implements PropertyChangeListener {
        protected cPromptPanelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (PromptDesignTimePanel.this.isListeningForChanges() && (ev.getPropertyName().equals("addOperation") || ev.getPropertyName().equals("deleteOperation") || ev.getPropertyName().equals("moveOperation") || ev.getPropertyName().equals("editOperation") || ev.getPropertyName().equals("shareOperation"))) {
                PromptDesignTimePanel.this.setDataChanged(true);
            }
        }
    }

    protected class cImportPromptXMLAction
    extends WsAbstractAction {
        public cImportPromptXMLAction() {
            super(bundle, "PromptDesignTimePanel.ImportPromptXML");
        }

        public void actionPerformed(ActionEvent e) {
            PromptXMLDialog exportDialog = new PromptXMLDialog(false);
            exportDialog.show();
            PromptGroupInterface pGroup = exportDialog.getPromptGroup();
            if (pGroup != null) {
                PromptDesignTimePanel.this.setPromptGroup(pGroup);
                PromptDesignTimePanel.this.setDataChanged(true);
            }
        }
    }

    protected class cExportPromptXMLAction
    extends WsAbstractAction {
        public cExportPromptXMLAction() {
            super(bundle, "PromptDesignTimePanel.ExportPromptXML");
        }

        public void actionPerformed(ActionEvent e) {
            PromptXMLDialog exportDialog = new PromptXMLDialog(true);
            exportDialog.setPromptGroup(PromptDesignTimePanel.this.m_pnlPrompt.getRootPromptGroup());
            exportDialog.show();
        }
    }

    private class cImportPromptsAction
    extends WsAbstractAction {
        public cImportPromptsAction() {
            super(bundle, "PromptDesignTimePanel.ImportParameters");
        }

        public void actionPerformed(ActionEvent e) {
            Root root = PromptDesignTimePanel.this.getMetadata();
            if (root == null || !(root instanceof Job)) {
                return;
            }
            Job job = (Job)root;
            String name = "";
            try {
                name = job.getName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            WAStandardDialog importDialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.formatString("PromptDesignTimePanel.ImportDialog.Title.txt", (Object)name), true);
            ParametersSelectorPanel parmPanel = new ParametersSelectorPanel(job);
            importDialog.setMainPanel((WAPanel)parmPanel);
            importDialog.show();
            List selList = parmPanel.getSelectedObjects();
            PromptGroup promptGroup = (PromptGroup)PromptDesignTimePanel.this.m_pnlPrompt.getRootPromptGroup();
            if (selList != null) {
                ArrayList<PromptDefinitionInterface> duplicates = new ArrayList<PromptDefinitionInterface>();
                int selSize = selList.size();
                for (int i = 0; i < selSize; ++i) {
                    PromptDefinitionInterface sel = (PromptDefinitionInterface)selList.get(i);
                    if (promptGroup.getPromptDefinition(sel.getPromptName(), true) == null) continue;
                    duplicates.add(sel);
                }
                if (!duplicates.isEmpty()) {
                    MessageUtil.displayListMessage((String)bundle.getString("PromptDesignTimePanel.Duplicates.Warning.txt"), duplicates, (int)2);
                } else {
                    promptGroup.addPromptDefinitions(selList);
                    PromptDesignTimePanel.this.m_pnlPrompt.setRootPromptGroup((PromptGroupInterface)promptGroup);
                }
            }
        }
    }

    protected class cPromptNameValidator
    implements ValidatePromptNameInterface {
        private GetRootPromptGroupInterface m_mainPromptPanel;

        public cPromptNameValidator(GetRootPromptGroupInterface mainPromptPanel) {
            this.m_mainPromptPanel = mainPromptPanel;
        }

        public Collection validatePromptName(int mode, PromptDefinitionInterface prompt, PromptGroupInterface promptGroup) {
            ArrayList<ValidationEntry> errors = new ArrayList<ValidationEntry>();
            String incomingPromptsName = prompt.getPromptName();
            try {
                Names.validateSASVariableName((String)incomingPromptsName, (boolean)true);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                errors.add(new ValidationEntry(-1L, e.getMessage()));
                return errors;
            }
            DataTypeInterface dti = prompt.getPromptDataType();
            int len = dti.getEstimatedMaxMacroVariableNameLength(incomingPromptsName);
            if (len > 32) {
                String text = bundle.formatString("PromptDesignTimePanel.LengthError.txt", (Object)incomingPromptsName, (Object)new Integer(32));
                errors.add(new ValidationEntry(-1L, text));
                return errors;
            }
            PromptGroupInterface rootGroup = this.m_mainPromptPanel.getRootPromptGroup();
            List visiblePrompts = PromptUtil.getPromptsVisibleFromGroup((PromptGroupInterface)rootGroup, (PromptGroupInterface)promptGroup);
            Map errorMap = PromptUtil.getConflictingPromptsBasedOnMacroVariableName((Collection)visiblePrompts, (PromptDefinitionInterface)prompt, (boolean)true, (mode == 2 || mode == 3 ? 1 : 0) != 0);
            if (!errorMap.isEmpty()) {
                errors.add(new ValidationEntry(-1L, bundle.formatString("PromptDesignTimePanel.DuplicatePromptName.txt", (Object)prompt.getPromptName())));
                return errors;
            }
            return errors;
        }
    }
}

