/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.conversion;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.wadmin.prompts.conversion.EntityObjectHandler;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EntityStringHandler
extends EntityObjectHandler {
    protected int m_stringLengthMin;
    protected int m_stringLengthMax;
    protected List m_txtTranslatedValues;
    protected List m_txtUntranslatedValues;
    private static WAdminResource bundle = WAdminResource.getBundle(EntityStringHandler.class);

    public EntityStringHandler(MdFactory factory, AttributeDescriptorInterface attributeDescriptor) throws MdException, RemoteException {
        super(factory, attributeDescriptor, "String");
        this.setupHandler();
    }

    @Override
    protected void setupHandler() {
        super.setupHandler();
        this.m_txtTranslatedValues = new ArrayList();
        this.m_txtUntranslatedValues = new ArrayList();
        this.m_stringLengthMin = -1;
        this.m_stringLengthMax = -1;
        if (this.m_docConfig != null && this.m_docConfig.getElementsByTagName("String").getLength() != 0) {
            Node enumNode;
            String tokenList;
            Node node = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "EntryEditable");
            this.m_fIsEntryEditable = MacroPluginUtilities.getValueForNode(node).equals("1");
            NamedNodeMap rangeNodeMap = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "StringLengthRange").getAttributes();
            String strLength = rangeNodeMap.getNamedItem("min").getNodeValue();
            if (strLength != null && strLength.length() > 0) {
                this.m_stringLengthMin = Integer.parseInt(strLength);
            }
            if ((strLength = rangeNodeMap.getNamedItem("max").getNodeValue()) != null && strLength.length() > 0) {
                this.m_stringLengthMax = Integer.parseInt(strLength);
            }
            if ((tokenList = MacroPluginUtilities.getValueForNode(enumNode = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "EnumeratedValues"))).length() > 0) {
                String[] tokens = tokenList.split("\\n");
                for (int i = 0; i < tokens.length; ++i) {
                    this.m_txtTranslatedValues.add(tokens[i].trim());
                }
            }
        }
    }

    public int getMinLength() {
        return this.m_stringLengthMin;
    }

    public int getMaxLength() {
        return this.m_stringLengthMax;
    }

    @Override
    public List getValidValues() {
        return this.m_txtTranslatedValues;
    }

    @Override
    public String validateInputValue(Object inputValue) {
        String strError = super.validateInputValue(inputValue);
        if (strError == null) {
            if (this.m_stringLengthMin != -1 && inputValue.toString().length() < this.m_stringLengthMin) {
                strError = bundle.getString("MacroUserOptionsTable.StringOptionValueMinimum.Error.txt");
            } else if (this.m_stringLengthMax != -1 && inputValue.toString().length() > this.m_stringLengthMax) {
                strError = bundle.getString("MacroUserOptionsTable.StringOptionValueMaximum.Error.txt");
            }
            if (!(this.fIsEntryEditable() || this.m_txtTranslatedValues.isEmpty() || this.m_txtTranslatedValues.contains(inputValue))) {
                strError = bundle.formatString("MacroUserOptionsTable.ValidValueNotFound.Error.txt", (Object)inputValue.toString());
            }
        }
        return strError;
    }

    public String getUntranslatedValue(String translatedValue) {
        int ind = this.m_txtTranslatedValues.indexOf(translatedValue);
        if (ind > -1) {
            return this.m_txtUntranslatedValues.get(ind).toString();
        }
        return translatedValue;
    }

    public String getTranslatedValue(String untranslatedValue) {
        int ind = this.m_txtUntranslatedValues.indexOf(untranslatedValue);
        if (ind > -1) {
            return this.m_txtTranslatedValues.get(ind).toString();
        }
        return untranslatedValue;
    }

    @Override
    public String getDefaultValue() {
        String def;
        String transDefault = def = super.getDefaultValue();
        if (def != null && def.length() > 0) {
            transDefault = this.getTranslatedValue(def);
        }
        return transDefault;
    }
}

