/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.conversion;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.prompts.conversion.EntityBooleanHandler;
import com.sas.wadmin.prompts.conversion.EntityDecimalHandler;
import com.sas.wadmin.prompts.conversion.EntityObjectHandler;
import com.sas.wadmin.prompts.conversion.EntityYesNoHandler;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;

public class EntityMetadataHandler
extends EntityObjectHandler {
    private String m_metadataType;
    private String m_defaultRepositoryId;

    public EntityMetadataHandler(MdFactory factory, String defaultRepositoryId, AttributeDescriptorInterface attributeDescriptor, String metadataType) throws MdException, RemoteException {
        super(factory, attributeDescriptor, null);
        this.m_defaultRepositoryId = defaultRepositoryId;
        this.m_metadataType = metadataType;
        this.setupHandler();
    }

    private String getDefaultRepositoryId() {
        return this.m_defaultRepositoryId;
    }

    public String getMetadataType() {
        return this.m_metadataType;
    }

    public void setMetadataType(String metadataType) {
        this.m_metadataType = metadataType;
    }

    @Override
    public List getValidValues() {
        return null;
    }

    public CMetadata getDefaultMetadataObject(MdObjectStore store) {
        try {
            Object defaultObject = EntityMetadataHandler.getEntityDefaultValueObject(this.m_defaultRepositoryId, this, store);
            if (defaultObject instanceof CMetadata) {
                return (CMetadata)defaultObject;
            }
            return null;
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public static Object getEntityDefaultValueObject(String defaultRepositoryId, EntityObjectHandler objectHandler, MdObjectStore store) throws MdException, RemoteException {
        Object value = "";
        String defaultValue = objectHandler.getDefaultValue();
        if (defaultValue != null && defaultValue.length() > 0 && objectHandler instanceof EntityMetadataHandler) {
            PhysicalTable defaultObject = null;
            EntityMetadataHandler mHandler = (EntityMetadataHandler)objectHandler;
            if (mHandler.getMetadataType().equals("PhysicalTable")) {
                defaultObject = MacroPluginUtilities.findTable(defaultRepositoryId, defaultValue.split("\\."), store);
            } else if (mHandler.getMetadataType().equals("SASLibrary")) {
                defaultObject = MacroPluginUtilities.findLibrary(defaultRepositoryId, defaultValue, store);
            }
            if (defaultObject != null) {
                value = defaultObject;
            }
        } else if (defaultValue != null && defaultValue.length() > 0 && objectHandler instanceof EntityDecimalHandler) {
            try {
                value = new Double(NumberFormat.getNumberInstance().parse(defaultValue).doubleValue());
            }
            catch (ParseException parseException) {}
        } else if (defaultValue != null && objectHandler instanceof EntityYesNoHandler) {
            value = ((EntityYesNoHandler)objectHandler).getTranslatedValue(defaultValue);
        } else if (objectHandler instanceof EntityBooleanHandler) {
            value = ((EntityBooleanHandler)objectHandler).getTranslatedValue(defaultValue);
        } else if (defaultValue != null) {
            value = defaultValue;
        }
        return value;
    }
}

