/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.conversion;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.wadmin.prompts.conversion.EntityObjectHandler;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EntityDecimalHandler
extends EntityObjectHandler {
    private Double m_minValue;
    private Double m_maxValue;
    private int m_maxDecimalPlaces;
    private static WAdminResource bundle = WAdminResource.getBundle(EntityDecimalHandler.class);

    public EntityDecimalHandler(MdFactory factory, AttributeDescriptorInterface attributeDescriptor) throws MdException, RemoteException {
        super(factory, attributeDescriptor, "Float");
    }

    @Override
    protected void setupHandler() {
        String maxDecimals;
        super.setupHandler();
        NamedNodeMap rangeNodeMap = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "NumericRange").getAttributes();
        String strLength = rangeNodeMap.getNamedItem("min").getNodeValue();
        this.m_minValue = strLength != null && strLength.length() > 0 ? new Double(strLength) : new Double(-1.7976931348623157E308);
        strLength = rangeNodeMap.getNamedItem("max").getNodeValue();
        this.m_maxValue = strLength != null && strLength.length() > 0 ? new Double(strLength) : new Double(Double.MAX_VALUE);
        this.m_maxDecimalPlaces = -1;
        Node decimalPlcNode = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "LimitDecimalPlaces");
        if (decimalPlcNode != null && (maxDecimals = MacroPluginUtilities.getValueForNode(decimalPlcNode)) != null && maxDecimals.length() > 0) {
            this.m_maxDecimalPlaces = Integer.parseInt(maxDecimals);
        }
    }

    @Override
    public List getValidValues() {
        return null;
    }

    public double getMinimumValue() {
        return this.m_minValue;
    }

    public double getMaximumValue() {
        return this.m_maxValue;
    }

    public int getMaximumDecimalPlaces() {
        return this.m_maxDecimalPlaces;
    }

    @Override
    public String validateInputValue(Object inputValue) {
        String strInputValue;
        String strValid = super.validateInputValue(inputValue);
        if (strValid == null && (strInputValue = inputValue.toString()).length() > 0) {
            Double inValue = null;
            try {
                inValue = new Double(strInputValue);
            }
            catch (NumberFormatException exc) {
                inValue = null;
            }
            DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance();
            df.setMaximumFractionDigits(Integer.MAX_VALUE);
            df.setGroupingUsed(false);
            if (inValue != null) {
                if (inValue.compareTo(this.m_minValue) < 0) {
                    strValid = bundle.formatString("MacroUserOptionsTable.OptionMinimum.msg.txt", (Object)"{0}", (Object)df.format(this.m_minValue));
                }
                if (inValue.compareTo(this.m_maxValue) > 0) {
                    strValid = bundle.formatString("MacroUserOptionsTable.OptionMaximum.msg.txt", (Object)"{0}", (Object)df.format(this.m_maxValue));
                }
            } else {
                strValid = "NaN";
            }
        }
        return strValid;
    }
}

