/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.conversion;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.Entity;
import com.sas.entities.EntityInterface;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.persist.EntityConverter;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.etl.models.job.IGeneratedTransformDefinition;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.entities.MdOMAEntityUtility;
import com.sas.models.FileLocation;
import com.sas.models.SASLibraryLocation;
import com.sas.models.datasources.BaseDataSource;
import com.sas.prompts.definitions.DataSourceColumnDefinition;
import com.sas.prompts.definitions.DataSourceDefinition;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.OutputFileDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinition;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.wadmin.pfd.PFDMetadataParsing;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.prompts.conversion.EntityColumnHandler;
import com.sas.wadmin.prompts.conversion.EntityDecimalHandler;
import com.sas.wadmin.prompts.conversion.EntityFileHandler;
import com.sas.wadmin.prompts.conversion.EntityIntegerHandler;
import com.sas.wadmin.prompts.conversion.EntityLookupHandler;
import com.sas.wadmin.prompts.conversion.EntityMetadataHandler;
import com.sas.wadmin.prompts.conversion.EntityStringHandler;
import com.sas.wadmin.prompts.model.DefaultLogicalServer;
import com.sas.wadmin.visuals.MacroOptionsTemplatesPanel;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DISEntityConverter
extends EntityConverter {
    private static final String PARAMETERS_ENTITY_CONTAINER_NAME = "Parameters";
    private Root m_metaObject = null;
    private EntityInterface m_entity = null;
    private MdObjectStore m_store = null;
    private Property m_entityProperty = null;
    private List m_deleteObjects = null;
    private static final WAdminResource bundle = WAdminResource.getBundle(DISEntityConverter.class);
    private boolean m_bDontDeleteOutputsFound = false;
    public static final String GUID_CORRELATIONS_REPORT = "6da3c6a8-0a1a-0b30-0082-e4f3bf2404ca";
    public static final String GUID_DISTRIBUTION_REPORT = "6da3ca13-0a1a-0b30-0082-e4f3d278309e";
    public static final String GUID_SUMMARY_STATISTICS_REPORT = "6da3c7f0-0a1a-0b30-0082-e4f3167822ec";
    public static final String GUID_FREQUENCY_REPORT = "6da3c7a2-0a1a-0b30-0082-e4f3768cee0b";
    private static final String GUID_CORRELATIONS = "6da3c715-0a1a-0b30-0082-e4f38cca6909";
    private static final String GUID_DISTRIBUTION = "6da3ca32-0a1a-0b30-0082-e4f362a1580f";
    private static final String GUID_SUMMARY_STATISTICS = "6da3c80f-0a1a-0b30-0082-e4f378676645";
    private static final String GUID_FREQUENCY = "6da3c7d1-0a1a-0b30-0082-e4f38fdf70b8";
    public static final String OLD_PUBLISH_QUEUE = "6da3c8fa-0a1a-0b30-0082-e4f3f27a69c0";
    public static final String OLD_REMOVE_CLUSTER = "bc68ee4c-0a17-0c86-00cf-e04915e867ce";
    public static final String OLD_CREATE_CLUSTER = "bc5ac953-0a17-0c86-018e-18a359caad3e";
    public static final String OLD_LIST_CLUSTER = "bc64bec3-0a17-0c86-00cf-e0499e662a78";
    private static final String NEW_PUBLISH_QUEUE = "1c98d152-0a17-0c2a-014a-e2c14c1f69d2";
    private static final String NEW_REMOVE_CLUSTER = "9028bb90-0a17-0c86-0073-1e909a21dcde";
    private static final String NEW_CREATE_CLUSTER = "901f5002-0a17-0c86-0073-1e90e63b81f8";
    private static final String NEW_LIST_CLUSTER = "9024248b-0a17-0c86-0073-1e90cf0a0b3d";
    private UserContextInterface m_userContext;

    public DISEntityConverter(MdObjectStore store, EntityInterface entity, Root metaObject, UserContextInterface userContext) {
        this.m_metaObject = metaObject;
        this.m_store = store;
        this.m_userContext = userContext;
        this.m_deleteObjects = new ArrayList();
        if (entity == null) {
            try {
                this.m_entity = this.getEntityToConvert(this.m_deleteObjects);
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else {
            this.m_entity = entity;
        }
    }

    public DISEntityConverter(MdObjectStore store, Root metaObject, UserContextInterface userContext) {
        this(store, null, metaObject, userContext);
    }

    public EntityInterface getEntity() {
        return this.m_entity;
    }

    public PromptGroupInterface convert2Prompt() throws MdException, RemoteException, BackingStoreException {
        return this.convert2Prompt(true, false);
    }

    public PromptGroupInterface convert2Prompt(boolean prompt, boolean save) throws MdException, RemoteException, BackingStoreException {
        boolean oldStyleTransform = DISEntityConverter.isOldStyleTypeGeneratedTransform(this.m_metaObject);
        if (!(this.m_metaObject instanceof Job || this.m_metaObject instanceof TransformationStep || oldStyleTransform || this.m_entity != null)) {
            return null;
        }
        if (prompt) {
            int answer = MessageUtil.displayMessage((String)"Do you want to save the modified object?", (int)3, (int)0);
            save = answer == 0;
        }
        PromptGroupInterface pGroup = null;
        String promptRootName = bundle.getString("DISEntityConverter.RootGroup.ParametersName.txt");
        String promptDescName = bundle.getString("DISEntityConverter.RootGroup.ParametersDesc.txt");
        boolean createSubGroup = false;
        if (this.m_metaObject instanceof Job) {
            Job job = (Job)this.m_metaObject;
            AssociationList activities = job.getJobActivities();
            int aSize = activities.size();
            for (int j = 0; j < aSize; ++j) {
                TransformationActivity act = (TransformationActivity)activities.get(j);
                AssociationList steps = act.getSteps();
                int size = steps.size();
                for (int i = 0; i < size; ++i) {
                    TransformationStep step = (TransformationStep)steps.get(i);
                    DISEntityConverter conv = new DISEntityConverter(this.m_store, (Root)step, this.m_userContext);
                    conv.convert2Prompt(false, save);
                }
            }
        } else if (this.m_metaObject instanceof TransformationStep) {
            String newGuid;
            TransformationStep step = (TransformationStep)this.m_metaObject;
            String guid = MacroPluginUtilities.getTransformationStepClassName(step);
            if (guid != null && !guid.equals(newGuid = this.getNewGuid(guid))) {
                DISEntityConverter.updateTransformationStepClassName(step, newGuid);
                guid = newGuid;
            }
            boolean isOldStyleStep = DISEntityConverter.isOldStyleTypeGeneratedTransformFromTransformationStep(step);
            if (DISEntityConverter.isEntityTypeTransform(this.m_metaObject, guid) || isOldStyleStep) {
                step.setTransformRole("TransformationStep2");
                if (isOldStyleStep && !step.getTransformations().isEmpty()) {
                    int i;
                    boolean hasInput = false;
                    boolean hasOutput = false;
                    ArrayList<AssociationProperty> sourceProps = new ArrayList<AssociationProperty>();
                    ArrayList<AssociationProperty> targetProps = new ArrayList<AssociationProperty>();
                    int numIn = 0;
                    int numOut = 0;
                    Root root = step.getUsingPrototype();
                    if (root instanceof Prototype) {
                        AssociationList protoProps = ((Prototype)root).getPrototypeProperties();
                        int size = protoProps.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            Root p = (Root)protoProps.get(i2);
                            if (!(p instanceof AssociationProperty)) continue;
                            AssociationProperty a = (AssociationProperty)p;
                            if (a.getMetadataType().equals("INPUT") && "".equals(a.getPartnerName())) {
                                a.setPartnerName("_INPUT" + numIn + ":");
                                hasInput = true;
                                sourceProps.add(a);
                                ++numIn;
                                continue;
                            }
                            if (!a.getMetadataType().equals("OUTPUT") || !"".equals(a.getPartnerName())) continue;
                            a.setPartnerName("_OUTPUT" + numOut + ":");
                            hasOutput = true;
                            targetProps.add(a);
                            ++numOut;
                        }
                    }
                    ClassifierMap cMap = (ClassifierMap)step.getTransformations().get(0);
                    if (!hasOutput && !cMap.getClassifierTargets().isEmpty()) {
                        this.m_store.removeObjectsFromStore((List)cMap.getClassifierTargets());
                    } else if (hasOutput && !cMap.getClassifierTargets().isEmpty()) {
                        for (i = 0; i < targetProps.size(); ++i) {
                            AssociationProperty a = (AssociationProperty)targetProps.get(i);
                            a.getUsingPrototypes().add(cMap.getClassifierTargets().get(i));
                        }
                    }
                    if (!hasInput && !cMap.getClassifierSources().isEmpty()) {
                        this.m_store.removeObjectsFromStore((List)cMap.getClassifierSources());
                    } else if (hasInput && !cMap.getClassifierSources().isEmpty()) {
                        for (i = 0; i < sourceProps.size(); ++i) {
                            AssociationProperty a = (AssociationProperty)sourceProps.get(i);
                            a.getUsingPrototypes().add(cMap.getClassifierSources().get(i));
                        }
                    }
                }
            }
            AssociationList stepSets = step.getPropertySets();
            block5: for (int l = 0; l < stepSets.size(); ++l) {
                PropertySet tSet = (PropertySet)stepSets.get(l);
                if (!tSet.getSetRole().equals("OPTIONS")) continue;
                AssociationList props = tSet.getProperties();
                for (int z = 0; z < props.size(); ++z) {
                    Property p = (Property)props.get(z);
                    if (!p.getPropertyName().equals("SYSLAST")) continue;
                    if (p.getDefaultValue().equalsIgnoreCase("YES")) {
                        p.setDefaultValue("YES");
                    } else {
                        p.setDefaultValue("NO");
                    }
                    p.setSQLType(12);
                    break block5;
                }
                break;
            }
            AssociationList trans = step.getTransformations();
            int tSize = trans.size();
            block7: for (int k = 0; k < tSize; ++k) {
                if (!(trans.get(k) instanceof ClassifierMap)) continue;
                ClassifierMap tMap = (ClassifierMap)trans.get(k);
                AssociationList pSets = tMap.getPropertySets();
                for (int l = 0; l < pSets.size(); ++l) {
                    PropertySet tSet = (PropertySet)pSets.get(l);
                    if (!tSet.getSetRole().equals("MACROOPTIONS")) continue;
                    PropertySet newSet = (PropertySet)this.m_store.getFactory().createComplexMetadataObject(this.m_store, tSet.getName(), "PropertySet", tMap.getRepositoryID());
                    newSet.setOwningObject(this.m_metaObject);
                    ArrayList props = new ArrayList(tSet.getProperties());
                    for (int z = 0; z < props.size(); ++z) {
                        Property p = (Property)props.get(z);
                        p.setAssociatedObject((Root)newSet);
                    }
                    MdStoreUtil.copyObjectAttributes((CMetadata)tSet, (CMetadata)newSet, (int)1);
                    this.m_deleteObjects.add(tSet);
                    continue block7;
                }
            }
        } else if (this.m_metaObject == null || this.m_metaObject instanceof Prototype) {
            String name = bundle.getString("DISEntityConverter.Options.txt");
            if (this.m_metaObject != null) {
                name = this.m_metaObject.getName();
            }
            promptRootName = name;
            promptDescName = bundle.formatString("DISEntityConverter.TransformationOptionDesc.txt", (Object)name);
            createSubGroup = true;
            if (this.m_metaObject != null) {
                Prototype proto = (Prototype)this.m_metaObject;
                MacroPluginUtilities.updatePrototypeVersion(proto, true);
                String guid = MacroPluginUtilities.getGuid(proto);
                guid = this.getNewGuid(guid);
                MacroPluginUtilities.setNewGuid(proto, guid);
                if (guid == null || guid.length() == 0) {
                    proto.setPublicType("");
                    proto.setMetadataType("");
                    proto.setUsageVersion(0.0);
                    proto.getTrees().clear();
                } else if ("".equals(proto.getPublicType())) {
                    proto.setPublicType("GeneratedTransform");
                    proto.setUsageVersion(IGeneratedTransformDefinition.CURRENT_VERSION.encode());
                }
            } else {
                createSubGroup = false;
            }
        }
        if (this.m_entity != null) {
            PromptGroup subGroup = (PromptGroup)this.newPromptGroup((RemoteEntityInterface)this.m_entity, null);
            subGroup.setPromptGroupHidden(false);
            if (this.m_metaObject != null) {
                subGroup.setPromptGroupLabel(bundle.getString("DISEntityConverter.Options.txt"), Locale.getDefault());
                subGroup.setPromptGroupDescription(bundle.getString("DISEntityConverter.Options.txt"), Locale.getDefault());
            }
            pGroup = this.createPromptGroup(promptRootName, promptDescName);
            if (createSubGroup) {
                pGroup.addPromptSubgroup((PromptGroupInterface)subGroup);
            } else {
                pGroup.addPromptDefinitions(subGroup.getPromptDefinitions(true));
            }
            if (this.m_bDontDeleteOutputsFound) {
                this.removeDeleteOutputsPrompts(pGroup);
                pGroup.addPromptDefinition((PromptDefinitionInterface)MacroOptionsTemplatesPanel.createDontDeleteOutputsPrompt());
            }
        } else if (oldStyleTransform && ((Prototype)this.m_metaObject).getMetadataType().length() > 0) {
            MacroPlugin macro = new MacroPlugin((CMetadata)this.m_metaObject, MacroPluginUtilities.getGetXML((Prototype)this.m_metaObject), GeneratedTransformationUtilities.getProcessTreePath((Root)this.m_metaObject));
            this.updateTransformationTemplate(macro);
            PromptGroup subGroup = (PromptGroup)this.createPromptGroupFromOldTransform(macro);
            subGroup.setPromptGroupHidden(false);
            subGroup.setPromptGroupLabel(bundle.getString("DISEntityConverter.Options.txt"), Locale.getDefault());
            subGroup.setPromptGroupDescription(bundle.getString("DISEntityConverter.Options.txt"), Locale.getDefault());
            pGroup = this.createPromptGroup(promptRootName, promptDescName);
            pGroup.addPromptSubgroup((PromptGroupInterface)subGroup);
        }
        if (save && pGroup != null && !pGroup.getPromptDefinitions(true).isEmpty()) {
            PromptUtils.savePromptGroupToMetadataObject((UserContextInterface)this.m_userContext, (String)this.m_metaObject.getRepositoryID(), (PromptGroupInterface)pGroup, (Root)this.m_metaObject);
            if (this.m_entityProperty != null) {
                MdOMAEntityUtility.removeEntityPropertyObjectFromOMR((Property)this.m_entityProperty);
            }
        }
        if (this.m_store != null) {
            this.m_store.removeObjectsFromStore(this.m_deleteObjects);
        }
        if (save && this.m_store != null) {
            this.m_store.updatedMetadataAll();
        }
        return pGroup;
    }

    public static void updateTransformationStepClassName(TransformationStep step, String newGuid) throws RemoteException, MdException {
        AssociationList properties = step.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Property prop = (Property)properties.get(i);
            if (!prop.getPropertyName().equals("Class")) continue;
            prop.setDefaultValue(newGuid);
            break;
        }
    }

    private String getNewGuid(String guid) {
        if (GUID_CORRELATIONS_REPORT.equals(guid)) {
            return GUID_CORRELATIONS;
        }
        if (GUID_DISTRIBUTION_REPORT.equals(guid)) {
            return GUID_DISTRIBUTION;
        }
        if (GUID_SUMMARY_STATISTICS_REPORT.equals(guid)) {
            return GUID_SUMMARY_STATISTICS;
        }
        if (GUID_FREQUENCY_REPORT.equals(guid)) {
            return GUID_FREQUENCY;
        }
        if (OLD_CREATE_CLUSTER.equals(guid)) {
            return NEW_CREATE_CLUSTER;
        }
        if (OLD_LIST_CLUSTER.equals(guid)) {
            return NEW_LIST_CLUSTER;
        }
        if (OLD_PUBLISH_QUEUE.equals(guid)) {
            return NEW_PUBLISH_QUEUE;
        }
        if (OLD_REMOVE_CLUSTER.equals(guid)) {
            return NEW_REMOVE_CLUSTER;
        }
        return guid;
    }

    private void removeDeleteOutputsPrompts(PromptGroupInterface group) {
        List subs = group.getPromptSubgroups(true);
        for (int i = 0; i < subs.size(); ++i) {
            PromptGroupInterface g = (PromptGroupInterface)subs.get(i);
            List defs = g.getPromptDefinitions(false);
            for (int j = 0; j < defs.size(); ++j) {
                PromptDefinitionInterface delDef = (PromptDefinitionInterface)defs.get(j);
                if (!"ADMIN.DONTDELETEOUTPUTS".equals(delDef.getPromptName())) continue;
                g.removePromptDefinition(delDef);
            }
        }
    }

    private void updateTransformationTemplate(MacroPlugin macro) throws MdException, RemoteException {
        String ts;
        int startTS;
        CMetadata meta = macro.getPrototype();
        Prototype p = null;
        p = meta instanceof Prototype ? (Prototype)meta : (Prototype)this.m_store.getFactory().createComplexMetadataObject(this.m_store, meta.getName(), meta.getCMetadataType(), meta.getFQID());
        String xml = macro.getXML();
        if (xml != null && (startTS = xml.indexOf(ts = "<TransformationStep")) > -1) {
            int endTS = xml.indexOf(">") + 1;
            String tsAttrs = xml.substring(startTS, endTS);
            int tRoleStart = tsAttrs.indexOf("TransformRole=\"");
            if (tRoleStart > -1) {
                int n = tsAttrs.indexOf("\"", tRoleStart);
            } else {
                String newTS = tsAttrs.replaceAll(">", " TransformRole=\"TransformationStep2\">");
                xml = xml.replaceFirst(tsAttrs, newTS);
            }
            MacroPluginUtilities.setGetXML(p, xml);
        }
    }

    public PromptDefinitionInterface newPromptDefinition(AttributeDescriptorInterface ad, LoggerFactoryInterface factory, String promptDefinitionIDPrefix) {
        PromptDefinitionInterface pd = super.newPromptDefinition(ad, factory, promptDefinitionIDPrefix);
        if (pd instanceof MutableSupportedSpecialValuesInterface) {
            SupportedSpecialValues sp = new SupportedSpecialValues();
            ((MutableSupportedSpecialValuesInterface)pd).setSupportedSpecialValues(sp);
        }
        return pd;
    }

    private PromptGroupInterface createPromptGroup(String name, String desc) {
        PromptGroup pGroup = new PromptGroup();
        pGroup.setPromptGroupLabel(name, Locale.getDefault());
        pGroup.setPromptGroupDescription(desc, Locale.getDefault());
        return pGroup;
    }

    protected PromptGroupInterface createPromptGroupFromOldTransform(TransformInterface transform) throws MdException, RemoteException {
        PromptGroup newGroup = (PromptGroup)PromptUtils.createPromptGroup();
        newGroup.setPromptGroupHidden(false);
        MdObjectStore store = this.m_store.getFactory().createObjectStore(null, "Old Transform conversion store");
        String transformXMLString = transform.getXML();
        Document doc = this.m_store.getFactory().getOMIUtil().parseXML(transformXMLString);
        Node firstNode = doc.getFirstChild();
        TransformationStep cmStep = (TransformationStep)this.m_store.getFactory().createComplexMetadataObject(store, null, transform.getName(), "TransformationStep", this.m_metaObject.getRepositoryID());
        cmStep = (TransformationStep)PFDMetadataParsing.populateNewObjects((CMetadata)cmStep, firstNode.getAttributes(), firstNode.getChildNodes(), this.m_metaObject.getRepositoryID(), new ArrayList(), new ArrayList());
        AssociationList cms = cmStep.getTransformations();
        if (!cms.isEmpty() && cms.get(0) instanceof ClassifierMap) {
            ClassifierMap map = (ClassifierMap)cms.get(0);
            AssociationList psets = map.getPropertySets();
            for (int i = 0; i < psets.size(); ++i) {
                PropertySet temp = (PropertySet)psets.get(i);
                if (!temp.getSetRole().equals("MACROOPTIONS")) continue;
                AssociationList props = temp.getProperties();
                for (int j = 0; j < props.size(); ++j) {
                    TextDefinition newDef = null;
                    Property prop = (Property)props.get(j);
                    if (prop.getPropertyRole().indexOf("INPUTS") == -1 && prop.getPropertyRole().indexOf("OUTPUTS") == -1) {
                        TextDefinition newText = newDef = new TextDefinition(prop.getPropertyName());
                        String defaultValue = prop.getDefaultValue();
                        if (defaultValue != null && defaultValue.length() > 0) {
                            newText.setDefaultValue((Object)defaultValue);
                        }
                    } else {
                        newDef = this.createDataSourceColumnDefinition(prop.getPropertyRole().indexOf("SQL") >= 0, prop.getPropertyRole().indexOf("OUTPUTS") == -1);
                        DataSourceColumnDefinition dsc = (DataSourceColumnDefinition)newDef;
                        dsc.setAllowMultipleDataSources(true);
                        dsc.setMaximumValueCount(Integer.MAX_VALUE);
                    }
                    newDef.setPromptName(prop.getPropertyName());
                    newDef.setPromptLabel(prop.getName(), Locale.US);
                    newDef.setPromptDescription(prop.getDesc(), Locale.US);
                    newGroup.addPromptDefinition((PromptDefinitionInterface)newDef);
                }
            }
        }
        if (store != null) {
            store.dispose();
            store = null;
        }
        return newGroup;
    }

    private String getFullRepositoryId(Root meta) throws RemoteException {
        return "A0000001." + meta.getRepositoryID();
    }

    protected PromptDefinitionInterface createPromptDefinition(AttributeDescriptorInterface ad, ParsedConfigurationXMLObject parsedObj, CommonLoggerInterface logger) {
        SASLibraryDefinition retVal;
        block63: {
            String sqlTypeString;
            retVal = null;
            String attrName = ad.getName();
            if (attrName != null && attrName.indexOf("OPTION.") == 0 && attrName.length() > "OPTION.".length()) {
                attrName = attrName.substring("OPTION.".length());
            }
            if (attrName != null) {
                attrName = attrName.trim();
            }
            ad.setName(attrName);
            if ("ADMIN.DONTDELETEOUTPUTS".equals(attrName)) {
                this.m_bDontDeleteOutputsFound = true;
            }
            if ((sqlTypeString = ad.getType().getName()).equals("Library")) {
                SASLibraryDefinition sL = retVal = new SASLibraryDefinition();
                sL.setRequired(ad.isRequired());
                try {
                    MetadataInterface mInterface;
                    PathUrl t;
                    EntityMetadataHandler mH = new EntityMetadataHandler(this.m_store.getFactory(), this.getFullRepositoryId(this.m_metaObject), ad, "SASLibrary");
                    CMetadata meta = mH.getDefaultMetadataObject(this.m_store);
                    if (meta != null && (t = (mInterface = UtilPlatformServices.getSmartObject((String)meta.getFQID(), (String)meta.getCMetadataType())).getPathUrl()) != null) {
                        String url = t.getAbsolutePath();
                        SASLibraryLocation libLocation = new SASLibraryLocation(url, meta.getName());
                        sL.setDefaultValue((Object)libLocation);
                    }
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (ServiceException exc) {
                    Workspace.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                ad.setDefaultValueHasBeenSet(false);
            } else if (sqlTypeString.equals("Table")) {
                retVal = new DataSourceDefinition();
                try {
                    DataSourceDefinition dDef = (DataSourceDefinition)retVal;
                    dDef.setAllowedDataSourceTypes(1L);
                    EntityMetadataHandler mh = new EntityMetadataHandler(this.m_store.getFactory(), this.getFullRepositoryId(this.m_metaObject), ad, "PhysicalTable");
                    CMetadata meta = mh.getDefaultMetadataObject(this.m_store);
                    if (meta != null) {
                        BaseDataSource bds = new BaseDataSource();
                        try {
                            MetadataInterface mInterface = UtilPlatformServices.getSmartObject((String)meta.getFQID(), (String)meta.getCMetadataType());
                            PathUrl t = mInterface.getPathUrl();
                            if (t != null) {
                                String url = t.getAbsolutePath();
                                bds.setDataSourceLocation(url);
                                bds.setDataSourceType(1L);
                                dDef.setDefaultValue((Object)bds);
                            }
                        }
                        catch (RemoteException exc) {
                            Workspace.handleRemoteException((RemoteException)exc);
                        }
                        catch (ServiceException exc) {
                            Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                        }
                    }
                    ad.setDefaultValueHasBeenSet(false);
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else if (sqlTypeString.equals("Column")) {
                try {
                    EntityColumnHandler ch = new EntityColumnHandler(this.m_store.getFactory(), ad);
                    boolean isSource = ch.getSelectTable() == 0;
                    boolean isEmitSQL = ch.getEmitSQL() == 1;
                    DataSourceColumnDefinition dDef = this.createDataSourceColumnDefinition(isEmitSQL, isSource);
                    int type = ch.getColumnType();
                    if (type == 2) {
                        dDef.setAllowedColumnTypes(1L);
                    } else if (type == 1) {
                        dDef.setAllowedColumnTypes(30L);
                    } else {
                        dDef.setAllowedColumnTypes(-1L);
                    }
                    dDef.setAllowedDataSourceTypes(1L);
                    if (ch.getLimitColumns() == 1) {
                        dDef.addUserInfo("LimitColumns", "Yes");
                        dDef.setMinimumValueCount(ch.getMinimumColumns());
                        dDef.setMaximumValueCount(ch.getMaximumColumns());
                    } else {
                        dDef.setMaximumValueCount(Integer.MAX_VALUE);
                    }
                    dDef.setAllowMultipleDataSources(true);
                    retVal = dDef;
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                ad.setDefaultValueHasBeenSet(false);
            } else if (sqlTypeString.equals("Float")) {
                retVal = new DoubleDefinition();
                try {
                    EntityDecimalHandler decHandler = new EntityDecimalHandler(this.m_store.getFactory(), ad);
                    DoubleDefinition dDef = (DoubleDefinition)retVal;
                    dDef.setAllowUserValues(false);
                    dDef.setDefaultValue((Object)decHandler.getDefaultValue());
                    dDef.setMaximum(decHandler.getMaximumValue());
                    dDef.setMinimum(decHandler.getMinimumValue());
                    dDef.setMaximumDecimalPlaces(decHandler.getMaximumDecimalPlaces());
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                ad.setDefaultValueHasBeenSet(false);
            } else if (sqlTypeString.equals("Integer")) {
                retVal = new IntegerDefinition();
                try {
                    EntityIntegerHandler intHandler = new EntityIntegerHandler(this.m_store.getFactory(), ad);
                    IntegerDefinition iDef = (IntegerDefinition)retVal;
                    iDef.setAllowUserValues(false);
                    iDef.setDefaultValue((Object)intHandler.getDefaultValue());
                    iDef.setMaximum(intHandler.getMaximumValue());
                    iDef.setMinimum(intHandler.getMinimumValue());
                    ad.setDefaultValueHasBeenSet(false);
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else if (sqlTypeString.equals("File")) {
                retVal = new OutputFileDefinition();
                OutputFileDefinition dDef = (OutputFileDefinition)retVal;
                try {
                    EntityFileHandler fileHandler = new EntityFileHandler(this.m_store.getFactory(), ad);
                    dDef.setRequired(ad.isRequired());
                    DefaultLogicalServer lServer = new DefaultLogicalServer();
                    dDef.setLogicalServerName(lServer.getName());
                    String defaultValue = fileHandler.getDefaultValue();
                    if (defaultValue != null && defaultValue.length() > 0) {
                        FileLocation fileLoc = new FileLocation(lServer.getName(), defaultValue, fileHandler.isDirectory());
                        dDef.setDefaultValue((Object)fileLoc);
                    }
                    if (fileHandler.isDirectory()) {
                        dDef.setFileSelectionMode(2);
                    } else {
                        dDef.setFileSelectionMode(1);
                    }
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                ad.setDefaultValueHasBeenSet(false);
            } else if (sqlTypeString.equals("Lookup")) {
                try {
                    EntityLookupHandler lkpHandler = new EntityLookupHandler(this.getFullRepositoryId(this.m_metaObject), this.m_store.getFactory(), ad, this.m_store);
                    Column column = lkpHandler.getColumnObject();
                    column = (Column)this.m_store.getFactory().getOMIUtil().getMetadataAllDepths((CMetadata)column, null, null, "", 264, true);
                    if (column == null || WsColumnMetadataUtil.isColumnTypeCharacter((Column)column)) {
                        retVal = new TextDefinition();
                        TextDefinition txtDef = (TextDefinition)retVal;
                        txtDef.setAllowUserValues(false);
                        break block63;
                    }
                    retVal = new DoubleDefinition();
                    DoubleDefinition dblDef = (DoubleDefinition)retVal;
                    dblDef.setAllowUserValues(false);
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else if (sqlTypeString.equals("Boolean Yes/No")) {
                retVal = PromptUtils.createBooleanDefinition(null, (boolean)false);
            } else if (sqlTypeString.equals("Boolean True/False")) {
                retVal = PromptUtils.createBooleanDefinition(null, (boolean)true);
            } else {
                retVal = new TextDefinition();
                TextDefinition tDef = (TextDefinition)retVal;
                try {
                    EntityStringHandler strHandle = new EntityStringHandler(this.m_store.getFactory(), ad);
                    tDef.setAllowUserValues(strHandle.fIsEntryEditable());
                    tDef.setAllowMultipleLines(false);
                    tDef.setMaximumLength(strHandle.getMaxLength());
                    tDef.setMinimumLength(strHandle.getMinLength());
                    tDef.setSelectionOrdered(true);
                    String defaultValue = strHandle.getDefaultValue();
                    if (defaultValue != null && defaultValue.length() > 0) {
                        tDef.setDefaultValue((Object)strHandle.getDefaultValue());
                    }
                    ad.setDefaultValueHasBeenSet(false);
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return retVal;
    }

    private DataSourceColumnDefinition createDataSourceColumnDefinition(boolean emitSQL, boolean useSources) {
        DataSourceColumnDefinition retVal = new DataSourceColumnDefinition();
        UserInfo userMap = new UserInfo();
        if (useSources) {
            userMap.put("TableSelect", "Sources");
        } else {
            userMap.put("TableSelect", "Targets");
        }
        if (emitSQL) {
            userMap.put("EmitSQL", "Yes");
        } else {
            userMap.put("EmitSQL", "No");
        }
        retVal.setUserInfo((UserInfoInterface)userMap);
        retVal.setSelectionOrdered(true);
        retVal.setAllowMultipleDataSources(true);
        return retVal;
    }

    protected ValueProviderInterface createValueProvider(PromptDefinitionInterface newPrompt, AttributeDescriptorInterface ad, ParsedConfigurationXMLObject parsedObject, CommonLoggerInterface logger) {
        String sqlTypeString = ad.getType().getName();
        ValueProviderInterface vP = null;
        if (sqlTypeString.equals("String")) {
            try {
                EntityStringHandler strHandle = new EntityStringHandler(this.m_store.getFactory(), ad);
                List tValues = strHandle.getValidValues();
                if (tValues != null && !tValues.isEmpty()) {
                    ArrayList<ValueItem> valueList = new ArrayList<ValueItem>();
                    int size = tValues.size();
                    for (int i = 0; i < size; ++i) {
                        String label;
                        String value = label = tValues.get(i).toString();
                        ValueItem vItem = new ValueItem((Object)label, (Object)value);
                        valueList.add(vItem);
                    }
                    StaticValueProvider sp = new StaticValueProvider(valueList, Locale.getDefault());
                    sp.setValuesAsLabel(true);
                    vP = sp;
                }
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else if (sqlTypeString.equals("Boolean Yes/No")) {
            vP = PromptUtils.getValueProviderForBooleanDefinition((boolean)false);
        } else if (sqlTypeString.equals("Boolean True/False")) {
            vP = PromptUtils.getValueProviderForBooleanDefinition((boolean)true);
        } else if (sqlTypeString.equals("Lookup")) {
            try {
                EntityLookupHandler lkpHandler = new EntityLookupHandler(this.getFullRepositoryId(this.m_metaObject), this.m_store.getFactory(), ad, this.m_store);
                Column column = lkpHandler.getColumnObject();
                PromptColumnValueProvider colPvd = new PromptColumnValueProvider();
                if (column != null) {
                    DataTable table = column.getTable();
                    MetadataInterface tableInterface = UtilPlatformServices.getSmartObject((String)table.getFQID(), (String)table.getCMetadataType());
                    PathUrl t = tableInterface.getPathUrl();
                    colPvd.setTableUrl(t.getAbsolutePath());
                    ColumnInfo valueColumn = new ColumnInfo(column.getName());
                    ColumnInfo labelColumn = new ColumnInfo(column.getName());
                    colPvd.setValueColumn(valueColumn);
                    colPvd.setLabelColumn(labelColumn);
                }
                colPvd.setDistinct(true);
                colPvd.setUseValueAsLabel(true);
                colPvd.setFormatLabels(false);
                colPvd.setFormatValues(false);
                int max = lkpHandler.getMaximumObservations();
                if (max > -1) {
                    colPvd.setThreshold(max);
                }
                vP = colPvd;
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (ServiceException exc) {
                Workspace.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
            }
        }
        return vP;
    }

    protected ParsedConfigurationXMLObject getParsedConfigurationXMLObject(AttributeDescriptorInterface ad) {
        ParsedConfigurationXMLObject parsedObj = new ParsedConfigurationXMLObject();
        return parsedObj;
    }

    private String getTSStringfromPrototype(MacroPlugin macro, MdObjectStore store) throws MdException, RemoteException {
        return "";
    }

    protected Entity getEntityToConvert(List objectsToDelete) throws MdException, RemoteException {
        Property entityContainer = this.getEntityContainer(objectsToDelete);
        Entity entity = null;
        if (entityContainer != null) {
            entity = new Entity();
            objectsToDelete.add(entityContainer);
            this.m_entityProperty = (Property)this.m_store.getFactory().getOMIUtil().getMetadataAllDepths((CMetadata)entityContainer, null, null, "<TEMPLATES>   <Property Id=\"\" Name=\"\">      <ExternalIdentities/>      <UsingPrototype/>      <Customizers/>      <PrimaryPropertyGroup/>      <OwningType/>      <Properties/>      <LocalizedAttributes/>      <StoredConfiguration/>      <Editors/>      <Resources/>      <Properties/>   </Property></TEMPLATES>", 268, true);
            MdOMAEntityUtility.populateEntityFromOMRProperty((RemoteEntityInterface)entity, (Property)this.m_entityProperty);
        }
        return entity;
    }

    private Property getEntityContainer(List objectsToDelete) throws MdException, RemoteException {
        Root link;
        Root mdObject = this.m_metaObject;
        if (this.m_metaObject instanceof TransformationStep && !((TransformationStep)this.m_metaObject).getTransformations().isEmpty() && ((TransformationStep)this.m_metaObject).getTransformations().get(0) instanceof Job) {
            this.m_metaObject = mdObject = (Job)((TransformationStep)this.m_metaObject).getTransformations().get(0);
        }
        if ((link = this.getEntityLink(mdObject)) != null) {
            objectsToDelete.add(link);
            return DISEntityConverter.getEntityContainerFromPrototype(link);
        }
        return null;
    }

    private Root getEntityLink(Root mdObject) throws MdException, RemoteException {
        PropertySet entityLink;
        block7: {
            entityLink = null;
            if (mdObject == null) break block7;
            if (mdObject instanceof Job) {
                Job mdJob = (Job)mdObject;
                for (int i = 0; i < mdJob.getSourceTransformations().size(); ++i) {
                    AbstractTransformation mdAbstractTransformation = (AbstractTransformation)mdJob.getSourceTransformations().get(i);
                    if (!(mdAbstractTransformation instanceof ClassifierMap) || !mdAbstractTransformation.getTransformRole().equals(PARAMETERS_ENTITY_CONTAINER_NAME)) continue;
                    entityLink = mdAbstractTransformation;
                    mdJob.getSourceTransformations().remove((Object)mdAbstractTransformation);
                    break;
                }
            } else if (mdObject instanceof Prototype) {
                AssociationList alPropertySets = mdObject.getPropertySets();
                for (int j = 0; j < alPropertySets.size(); ++j) {
                    PropertySet set = (PropertySet)alPropertySets.get(j);
                    if (!set.getName().equalsIgnoreCase("EntitySet") && !set.getName().equalsIgnoreCase(PARAMETERS_ENTITY_CONTAINER_NAME)) continue;
                    entityLink = set;
                }
            } else {
                for (int i = 0; i < mdObject.getPropertySets().size(); ++i) {
                    PropertySet pSet = (PropertySet)this.m_metaObject.getPropertySets().get(i);
                    if (!pSet.getSetRole().equals(PARAMETERS_ENTITY_CONTAINER_NAME)) continue;
                    entityLink = pSet;
                    break;
                }
            }
        }
        return entityLink;
    }

    public static Property getEntityContainerFromPrototype(Root proto) throws MdException, RemoteException {
        AssociationList alPropertySets = proto.getPropertySets();
        AssociationList alProperties = null;
        for (int j = 0; j < alPropertySets.size(); ++j) {
            PropertySet set = (PropertySet)alPropertySets.get(j);
            if (!set.getName().equalsIgnoreCase("EntitySet") && !set.getName().equalsIgnoreCase(PARAMETERS_ENTITY_CONTAINER_NAME)) continue;
            alProperties = set.getProperties();
        }
        if (proto instanceof ClassifierMap) {
            AssociationList alCMProperties = proto.getProperties();
            for (int i = 0; i < alCMProperties.size(); ++i) {
                Property prop = (Property)alCMProperties.get(i);
                if (!prop.getDefaultValue().equals("com.sas.entities.RemoteEntityInterface") && !prop.getName().equalsIgnoreCase("Entity")) continue;
                return prop;
            }
        } else if (proto instanceof PropertySet) {
            alProperties = ((PropertySet)proto).getProperties();
        }
        if (alProperties == null) {
            return null;
        }
        for (int i = 0; i < alProperties.size(); ++i) {
            Property p = (Property)alProperties.get(i);
            if (!p.getDefaultValue().equals("com.sas.entities.RemoteEntityInterface") && !p.getName().equalsIgnoreCase("Entity")) continue;
            return p;
        }
        return null;
    }

    public static boolean isEntityTypeTransform(Root metaObject, String guid) {
        if (metaObject == null || guid == null) {
            return false;
        }
        try {
            UUID test = UUID.fromString(guid);
            if (metaObject instanceof TransformationStep && ((TransformationStep)metaObject).getTransformRole().indexOf("Entity") > -1) {
                return true;
            }
            Property property = DISEntityConverter.getEntityContainerFromPrototype(metaObject);
            return property != null;
        }
        catch (IllegalArgumentException test) {
        }
        catch (MdException ex) {
            Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }

    public static boolean isOldStyleTypeGeneratedTransformFromTransformationStep(TransformationStep step) throws MdException, RemoteException {
        if (step == null) {
            return false;
        }
        if (step.getTransformRole().indexOf("Entity") > -1) {
            return false;
        }
        if ("".equals(step.getTransformRole())) {
            for (int i = 0; i < step.getProperties().size(); ++i) {
                Property prop = (Property)step.getProperties().get(i);
                if (!prop.getPropertyName().equalsIgnoreCase("CLASS") && !prop.getName().equalsIgnoreCase("CLASS") || !prop.getPropertyRole().equalsIgnoreCase("ESMACRO")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOldStyleTypeGeneratedTransform(Root metaObject) {
        if (metaObject == null) {
            return false;
        }
        try {
            if (metaObject instanceof Prototype && ((Prototype)metaObject).getMetadataType().equalsIgnoreCase("TransformationStep2")) {
                Property property = DISEntityConverter.getEntityContainerFromPrototype(metaObject);
                return property == null && metaObject.getPrompts().isEmpty();
            }
        }
        catch (MdException ex) {
            Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }
}

