/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDTransformComputeNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.workspace.PluginUtil;
import com.sas.workspace.Workspace;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;

public class WAPFDTransformComputeNodeModel
extends WAPFDTransformNodeModel {
    public WAPFDTransformComputeNodeModel(PFDPanel parentPanel, CMetadata object) {
        super(parentPanel, object);
    }

    public WAPFDTransformComputeNodeModel(PFDPanel parentPanel) {
        super(parentPanel, null);
    }

    @Override
    public void addNode(MdObjectStore newStore, TransformInterface transformBeingDropped) throws PFDException, MdException, RemoteException {
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        TransformationStep temporaryTS = (TransformationStep)WAPFDTransformComputeNodeModel.makeDropObject(this.m_activeJob, newStore, transformBeingDropped, inputs, outputs);
        if (temporaryTS == null) {
            throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTCREATETRANFORM.txt");
        }
        this.m_objectID = temporaryTS.getFQID();
        TransformationActivity taoldstore = (TransformationActivity)((Job)this.m_activeJob).getJobActivities(false).elementAt(0);
        TransformationActivity ta = (TransformationActivity)Workspace.getMdFactory().createComplexMetadataObject(newStore, (CMetadata)taoldstore);
        temporaryTS.getActivities(false).add((Object)ta);
        this.m_viewNode = new WAPFDTransformComputeNode(new Point(0, 0), (ImageIcon)transformBeingDropped.getIcon(), temporaryTS.getName(), this, this.m_parentPanel);
        this.m_viewNode.addNode();
    }

    @Override
    public void addNode(CMetadata step, String sName) throws PFDException, MdException, RemoteException {
        this.m_viewNode = new WAPFDTransformComputeNode(new Point(0, 0), this.getIcon(step), sName, this, this.m_parentPanel);
        this.m_viewNode.addNode();
    }

    @Override
    public void addNode(CMetadata step) throws PFDException, MdException, RemoteException {
        this.m_viewNode = new WAPFDTransformComputeNode(new Point(0, 0), this.getIcon(step), step.getName(), this, this.m_parentPanel);
        this.m_viewNode.addNode();
    }

    @Override
    public Classifier findOutputClassifierOnThisStepToMapTo(MdObjectStore store, TransformationStep thisStep) throws MdException, RemoteException {
        if (thisStep.getTransformations().size() > 0 && !(thisStep.getTransformations().get(0) instanceof Job)) {
            return super.findOutputClassifierOnThisStepToMapTo(store, thisStep);
        }
        TransformationStep nextStep = this.findPreviousDataStep(thisStep);
        if (nextStep == null) {
            return null;
        }
        WAPFDTransformNodeModel nodeModel = (WAPFDTransformNodeModel)this.m_parentPanel.getNodeModel(nextStep.getFQID());
        if (nodeModel == null) {
            return this.findEmptyExistingClassifier(nextStep);
        }
        return nodeModel.findOutputClassifierOnThisStepToMapTo(store, nextStep);
    }

    @Override
    public void connectNodeMetadata(MdObjectStore newStore, WAPFDNodeInterface fromNode, WAPFDNodeInterface toNode, ArrayList thisNodesCMsThatWereDisconnectedFrom) throws MdException, RemoteException, PFDException {
        CMetadata fromNodeObject = fromNode.getWAPFDNodeModel().getMetadataObject(newStore);
        CMetadata toNodeObject = toNode.getWAPFDNodeModel().getMetadataObject(newStore);
        ArrayList targetCMsToMapTo = null;
        TransformationStep thisStep = (TransformationStep)toNodeObject;
        if (thisStep.getTransformations().size() > 0) {
            super.connectNodeMetadata(newStore, fromNode, toNode, thisNodesCMsThatWereDisconnectedFrom);
            return;
        }
        ArrayList nextTSList = new ArrayList();
        targetCMsToMapTo = this.findInputCMsOnThisStepToMapTo(thisStep, nextTSList);
        TransformationStep nextStep = null;
        if (nextTSList.size() > 0) {
            nextStep = (TransformationStep)nextTSList.get(0);
        }
        if (!(fromNodeObject instanceof Classifier)) {
            WAPFDTransformNodeModel prevNodeModel;
            this.hookupSP(newStore, (TransformationStep)fromNodeObject, (TransformationStep)toNodeObject);
            TransformationStep prevDataStep = (TransformationStep)fromNodeObject;
            Classifier fromNodeClassifier = null;
            if (thisStep.getTransformRole().equalsIgnoreCase("SASReturnCodeCheck") && (prevDataStep = this.findPreviousDataStep(thisStep)) != null && (fromNodeClassifier = (prevNodeModel = (WAPFDTransformNodeModel)this.m_parentPanel.getNodeModel(prevDataStep.getFQID())).findOutputClassifierOnThisStepToMapTo(newStore, prevDataStep)) == null) {
                throw new PFDException("PFDEXCEPTION.NOSPACEONTRANSFORM.txt");
            }
            if (fromNodeClassifier != null && nextStep != null) {
                this.connectNodeMetadata(newStore, prevDataStep, nextStep, targetCMsToMapTo, fromNodeClassifier);
            }
        }
    }

    @Override
    protected int getNumFullExistingClassifiers(TransformationStep thisStep) throws MdException, RemoteException {
        int numClassifiers;
        if (thisStep.getTransformations().size() == 0) {
            return this.getNumFullOutputs(thisStep);
        }
        int numOutputs = this.getNumFullOutputs(thisStep);
        if (numOutputs > (numClassifiers = super.getNumFullExistingClassifiers(thisStep))) {
            return numOutputs;
        }
        return numClassifiers;
    }

    protected ArrayList findInputCMsOnThisStepToMapTo(TransformationStep thisStep, ArrayList nextTSList) throws MdException, RemoteException {
        ArrayList inputCMsToMapTo = new ArrayList();
        TransformationStep nextStep = this.findNextDataStep(thisStep);
        if (nextStep == null) {
            return inputCMsToMapTo;
        }
        inputCMsToMapTo = this.findInputCMsOnThisStepToMapTo(nextStep);
        nextTSList.add(nextStep);
        return inputCMsToMapTo;
    }

    @Override
    protected int getNumFullInputs(TransformationStep thisStep) throws MdException, RemoteException {
        if (thisStep.getTransformations().isEmpty()) {
            return thisStep.getSuccessorDependencies(false).size();
        }
        return super.getNumFullInputs(thisStep);
    }

    protected int getNumFullOutputs(TransformationStep thisStep) throws MdException, RemoteException {
        return thisStep.getPredecessorDependencies(false).size();
    }

    @Override
    protected void cleanupThisNode(TransformationStep thisStep, ArrayList thisNodesCMsThatWereDisconnectedFrom) throws MdException, RemoteException, PFDException {
        if (thisStep.getTransformations().size() == 0) {
            return;
        }
        super.cleanupThisNode(thisStep, thisNodesCMsThatWereDisconnectedFrom);
    }

    @Override
    public boolean fNodeHasSpace(MdObjectStore newStore, int iTypeToLookFor) throws MdException, RemoteException {
        TransformationStep step = (TransformationStep)this.getMetadataObject(newStore);
        if (step.getTransformations().size() > 0) {
            return super.fNodeHasSpace(newStore, iTypeToLookFor);
        }
        if (iTypeToLookFor == 0) {
            if (this.getMaxTemplates(step, "INPUT") == 0) {
                return true;
            }
            return step.getSuccessorDependencies(false).size() < this.getMaxTemplates(step, "INPUT");
        }
        if (step.getPredecessorDependencies(false).size() < this.getMaxTemplates(step, "OUTPUT")) {
            return true;
        }
        return this.getMaxTemplates(step, "OUTPUT") == 0;
    }

    @Override
    public void deleteFromOtherNode(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        TransformationStep stepToRemove = (TransformationStep)this.getMetadataObject();
        if (stepToRemove.getTransformations().size() > 0) {
            super.deleteFromOtherNode(affectedObjects);
            return;
        }
        TransformInterface transformPlugin = this.getTransformFromStep(stepToRemove);
        if (transformPlugin == null) {
            Workspace.getDefaultLogger().info((Object)"Cant find transform plugin");
            this.m_parentPanel.clearSelections();
            return;
        }
        String strRemoveXML = transformPlugin.getRemoveXML();
        if (strRemoveXML == null) {
            strRemoveXML = "<TransformationStep><Prototype><PrototypeProperties/></Prototype></UsingPrototype><SourceCode/><SuccessorDependencies/><PredecessorDependencies/><Properties><Property><OwningType/></Property></Properties><Transformations><ClassifierMap><FeatureMaps/><ClassifierTargets><WorkTable><Columns/></WorkTable></ClassifierTargets></ClassifierMap></Transformations></TransformationStep>";
        }
        this.m_parentPanel.removeNode(stepToRemove.getFQID());
        stepToRemove.getViewList().remove(this.m_parentPanel.getOwningView());
        PluginUtil.doRemoveFromChildStore((MdObjectStore)((MdObjectStore)this.m_activeJob.getObjectStore()), (String)strRemoveXML, (CMetadata)stepToRemove);
        Vector inputLinks = this.m_viewNode.getInputLinks();
        for (int i = 0; i < inputLinks.size(); ++i) {
            WAPFDLink inputLink = (WAPFDLink)inputLinks.elementAt(i);
            WAPFDNode returningFromNode = inputLink.doDeleteInputLink(affectedObjects);
            if (returningFromNode == null) continue;
            returningFromNode.deleteFromOtherNode(affectedObjects);
            returningFromNode = null;
        }
        Vector outputLinks = this.m_viewNode.getOutputLinks();
        for (int i = 0; i < outputLinks.size(); ++i) {
            WAPFDLink outputLink = (WAPFDLink)outputLinks.elementAt(i);
            WAPFDNode returningFromNode = outputLink.doDeleteOutputLink(affectedObjects);
            if (returningFromNode == null) continue;
            returningFromNode.deleteFromOtherNode(affectedObjects);
            if (returningFromNode.getMetadataObject() instanceof TransformationStep && !((TransformationStep)returningFromNode.getMetadataObject()).getTransformations().isEmpty()) {
                ((WAPFDTransformNodeModel)returningFromNode.getWAPFDNodeModel()).updateTemplateVisual((TransformationStep)returningFromNode.getWAPFDNodeModel().getMetadataObject());
            }
            returningFromNode = null;
        }
        this.m_viewNode.deleteNode();
    }

    public WAPFDNode deleteFromBeforeOtherNode(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        TransformationStep stepToRemove = (TransformationStep)this.getMetadataObject();
        TransformInterface transformPlugin = this.getTransformFromStep(stepToRemove);
        if (transformPlugin == null) {
            Workspace.getDefaultLogger().info((Object)"Cant find transform plugin");
            this.m_parentPanel.clearSelections();
            return null;
        }
        String strRemoveXML = transformPlugin.getRemoveXML();
        if (strRemoveXML == null) {
            strRemoveXML = "<TransformationStep><Prototype><PrototypeProperties/></Prototype></UsingPrototype><SourceCode/><SuccessorDependencies/><PredecessorDependencies/><Properties><Property><OwningType/></Property></Properties><Transformations><ClassifierMap><FeatureMaps/><ClassifierTargets><WorkTable><Columns/></WorkTable></ClassifierTargets></ClassifierMap></Transformations></TransformationStep>";
        }
        this.m_parentPanel.removeNode(stepToRemove.getFQID());
        stepToRemove.getViewList().remove(this.m_parentPanel.getOwningView());
        PluginUtil.doRemoveFromChildStore((MdObjectStore)((MdObjectStore)this.m_activeJob.getObjectStore()), (String)strRemoveXML, (CMetadata)stepToRemove);
        Vector inputLinks = this.m_viewNode.getInputLinks();
        WAPFDNode returningFromNode = null;
        for (int i = 0; i < inputLinks.size(); ++i) {
            WAPFDLink inputLink = (WAPFDLink)inputLinks.elementAt(i);
            returningFromNode = inputLink.doDeleteInputLink(affectedObjects);
        }
        Vector outputLinks = this.m_viewNode.getOutputLinks();
        for (int i = 0; i < outputLinks.size(); ++i) {
            WAPFDLink outputLink = (WAPFDLink)outputLinks.elementAt(i);
            outputLink.doDeleteOutputLink(affectedObjects);
        }
        this.m_viewNode.deleteNode();
        return returningFromNode;
    }
}

