/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDShapeNode;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDTemplateNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNode;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.SASSplitter;
import com.sas.workspace.Workspace;
import java.awt.Dimension;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;

public class WAPFDTemplateNode
extends PFDShapeNode
implements WAPFDNodeInterface,
WAPFDPrimitiveInterface {
    PFDPanel m_parentPanel = null;
    WAPFDNodeModel m_nodeModel = null;
    CMetadata m_activeJob = null;

    public WAPFDTemplateNode(Point loc, Dimension size, String s, WAPFDTemplateNodeModel nodeModel, PFDPanel parentPanel) {
        super(loc, size, s);
        this.m_nodeModel = nodeModel;
        this.m_parentPanel = parentPanel;
        this.m_activeJob = parentPanel.getActiveJob();
        this.getDrawable().getBrush().setStyle(0);
        this.getDrawable().getPen().setStyle(2);
        if (this.getLabel() != null) {
            this.getLabel().setMultiline(true);
        }
        this.getPort("east").setSelectable(false);
        this.getPort("west").setSelectable(false);
        this.getPort("north").setSelectable(false);
        this.getPort("south").setSelectable(false);
        this.m_parentPanel.getModel().addPrimitive((PFDPrimitive)this);
    }

    @Override
    public void addNode() {
    }

    @Override
    public WAPFDNodeModel getWAPFDNodeModel() {
        return this.m_nodeModel;
    }

    public CMetadata getMetadataObject() {
        return this.m_nodeModel.getMetadataObject();
    }

    @Override
    public void delete(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        this.delete(affectedObjects, false);
    }

    public void delete(ArrayList affectedObjects, boolean bNoDeleteWorkTable) throws MdException, RemoteException, PFDException {
        WAPFDTemplateNodeModel Model;
        TransformationStep step;
        Vector inputLinks = this.getInputLinks();
        boolean bIsOutput = false;
        if (inputLinks.size() > 0) {
            bIsOutput = true;
            WAPFDLink inputLink = (WAPFDLink)inputLinks.elementAt(0);
            WAPFDNodeInterface workFromNode = inputLink.getWAFromNode();
            if (workFromNode instanceof WAPFDWorkTableNode) {
                WAPFDNodeInterface fromNode;
                WAPFDLink workInputLink = null;
                Vector workInputLinks = workFromNode.getInputLinks();
                if (workInputLinks != null && !workInputLinks.isEmpty() && (fromNode = (workInputLink = (WAPFDLink)workInputLinks.elementAt(0)).getWAFromNode()) instanceof WAPFDNode && !bNoDeleteWorkTable) {
                    TransformationStep step2 = (TransformationStep)fromNode.getWAPFDNodeModel().getMetadataObject();
                    WAPFDTransformNodeModel fromModel = (WAPFDTransformNodeModel)fromNode.getWAPFDNodeModel();
                    boolean bFound = false;
                    TransformInterface transInterface = fromModel.getTransformFromStep(step2);
                    Prototype prototype = null;
                    if (transInterface instanceof MacroPlugin) {
                        prototype = MacroPluginUtilities.getPrototypeForStep(step2);
                    }
                    if (transInterface instanceof MacroPlugin && ((WAPFDTemplateNodeModel)this.getWAPFDNodeModel()).fCanDeleteOutputTemplate() || transInterface instanceof SASSplitter && step2.getTransformations().size() > 2) {
                        fromModel.deleteWorkTableNodeAndLink((WorkTable)workFromNode.getWAPFDNodeModel().getMetadataObject(), affectedObjects);
                        AssociationList stepTransformations = step2.getTransformations(false);
                        for (int iTable = 0; iTable < stepTransformations.size(); ++iTable) {
                            ClassifierMap oMap = (ClassifierMap)stepTransformations.get(iTable);
                            for (int p = 0; p < oMap.getClassifierTargets(false).size(); ++p) {
                                DataTable oTable = (DataTable)oMap.getClassifierTargets(false).get(p);
                                if (oTable == null || !(oTable instanceof WorkTable) || !oTable.getFQID().equalsIgnoreCase(workFromNode.getWAPFDNodeModel().getMetadataObject().getFQID())) continue;
                                affectedObjects.add(oTable);
                                ((MdObjectStore)step2.getObjectStore()).removeObjectFromStore((CMetadata)oTable, "<WorkTable><Indexes/><PropertySets><SetProperties/><Properties/></PropertySets><Columns><Column><PropertySets><SetProperties/><Properties/></PropertySets></Column></Columns></WorkTable>");
                                if (step2.getTransformRole().equalsIgnoreCase("SASSplitter") && stepTransformations.size() > 2) {
                                    ((MdObjectStore)step2.getObjectStore()).removeObjectFromStore((CMetadata)oMap, "<ClassifierMap/>");
                                }
                                bFound = true;
                                break;
                            }
                            if (bFound) break;
                        }
                    }
                }
            }
        }
        this.m_parentPanel.removeNode(this);
        this.m_parentPanel.getModel().removePrimitive((PFDPrimitive)this);
        if (bIsOutput && (step = (Model = (WAPFDTemplateNodeModel)this.getWAPFDNodeModel()).getAssociatedStep()) != null) {
            WAPFDTransformNodeModel transformModel = (WAPFDTransformNodeModel)this.m_parentPanel.getNodeModel(step.getFQID());
            transformModel.cleanupThisEntityNodeOutputs(step);
        }
        this.dispose();
    }

    @Override
    public void deleteNode() {
        this.m_parentPanel.removeNode(this);
        this.m_parentPanel.getModel().removePrimitive((PFDPrimitive)this);
        this.dispose();
    }

    @Override
    public PFDPort getPort(String portLoc) {
        return super.getPort(portLoc);
    }

    public void replaceTemplateNode(WAPFDNode newNode) {
        this.m_parentPanel.forceFlowDirectionChange();
        Vector east_ins = null;
        Vector west_ins = null;
        Vector east_outs = null;
        Vector west_outs = null;
        if (PFDPanel.getLayoutDirection() == 2 || PFDPanel.getLayoutDirection() == 0) {
            east_ins = this.getPort("east").getToLinks();
            east_outs = this.getPort("east").getFromLinks();
            west_ins = this.getPort("west").getToLinks();
            west_outs = this.getPort("west").getFromLinks();
            this.redirectLinks(east_ins, newNode.getPort("east"), true, newNode);
            this.redirectLinks(east_outs, newNode.getPort("east"), false, newNode);
            this.redirectLinks(west_ins, newNode.getPort("west"), true, newNode);
            this.redirectLinks(west_outs, newNode.getPort("west"), false, newNode);
        } else {
            east_ins = this.getPort("north").getToLinks();
            east_outs = this.getPort("north").getFromLinks();
            west_ins = this.getPort("south").getToLinks();
            west_outs = this.getPort("south").getFromLinks();
            this.redirectLinks(east_ins, newNode.getPort("north"), true, newNode);
            this.redirectLinks(east_outs, newNode.getPort("north"), false, newNode);
            this.redirectLinks(west_ins, newNode.getPort("south"), true, newNode);
            this.redirectLinks(west_outs, newNode.getPort("south"), false, newNode);
        }
        this.m_parentPanel.clearSelections();
        try {
            this.m_parentPanel.removeNode(this.getMetadataObject().getFQID());
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.dispose();
    }

    public void dispose() {
        this.m_parentPanel.getModel().removePrimitive((PFDPrimitive)this);
        this.m_nodeModel.removeNode();
        if (this.m_nodeModel != null) {
            CMetadata object = this.m_nodeModel.getMetadataObject();
            try {
                if (object != null) {
                    this.m_parentPanel.removeNode(object.getFQID());
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        this.m_nodeModel = null;
        this.m_parentPanel = null;
        this.m_activeJob = null;
        this.removeAllPrimitives();
    }

    protected void redirectLinks(Vector links, PFDPort port, boolean in, WAPFDNode newnode) {
        for (int i = 0; i < links.size(); ++i) {
            PFDLink link = (PFDLink)links.elementAt(i);
            if (in) {
                link.setToPort(port);
                ((WAPFDLink)link).setToNode(newnode);
            } else {
                link.setFromPort(port);
                ((WAPFDLink)link).setFromNode(newnode);
            }
            link.getPen().setStyle(1);
        }
    }

    @Override
    public void getPortsFromNode(Vector ins, Vector outs) {
        if (PFDPanel.getLayoutDirection() == 2) {
            outs = this.getPort("west").getFromLinks();
            ins = this.getPort("east").getToLinks();
        } else if (PFDPanel.getLayoutDirection() == 0) {
            ins = this.getPort("west").getFromLinks();
            outs = this.getPort("east").getToLinks();
        } else if (PFDPanel.getLayoutDirection() == 3) {
            ins = this.getPort("south").getFromLinks();
            outs = this.getPort("north").getToLinks();
        } else {
            outs = this.getPort("south").getFromLinks();
            ins = this.getPort("north").getToLinks();
        }
    }

    public boolean fIsInputTemplate() {
        return this.getOutputLinks().size() > 0;
    }

    public boolean fIsOutputTemplate() {
        return this.getInputLinks().size() > 0;
    }

    @Override
    public boolean fCanShowPopup() {
        return false;
    }

    @Override
    public boolean fCanViewStepCode() {
        return false;
    }

    @Override
    public boolean fCanViewData() {
        return false;
    }

    @Override
    public boolean fCanViewFile() {
        return false;
    }

    @Override
    public boolean fCanShowImpact() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanShowReverseImpact() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanAddInputTemplate() {
        return false;
    }

    @Override
    public boolean fCanAddOutputTemplate() {
        return false;
    }

    @Override
    public boolean fCanDelete() throws MdException, RemoteException {
        if (this.fIsInputTemplate()) {
            return ((WAPFDTemplateNodeModel)this.getWAPFDNodeModel()).fCanDeleteInputTemplate();
        }
        return ((WAPFDTemplateNodeModel)this.getWAPFDNodeModel()).fCanDeleteOutputTemplate();
    }

    @Override
    public boolean fCanShowProperties() {
        return false;
    }

    @Override
    public boolean fCanMakeOutput() {
        return false;
    }

    @Override
    public boolean fCanViewJob() {
        return false;
    }

    @Override
    public void showProperties() throws MdException, RemoteException {
    }

    @Override
    public void disconnectFromNode(WAPFDNodeInterface fromNode, ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
    }

    @Override
    public Vector getOutputLinks() {
        Vector outputs = null;
        outputs = PFDPanel.getLayoutDirection() == 2 ? this.getPort("west").getFromLinks() : (PFDPanel.getLayoutDirection() == 0 ? this.getPort("east").getFromLinks() : (PFDPanel.getLayoutDirection() == 3 ? this.getPort("north").getFromLinks() : this.getPort("south").getFromLinks()));
        return outputs;
    }

    @Override
    public Vector getInputLinks() {
        Vector inputs = null;
        inputs = PFDPanel.getLayoutDirection() == 2 ? this.getPort("east").getToLinks() : (PFDPanel.getLayoutDirection() == 0 ? this.getPort("west").getToLinks() : (PFDPanel.getLayoutDirection() == 3 ? this.getPort("south").getToLinks() : this.getPort("north").getToLinks()));
        return inputs;
    }

    @Override
    public void viewData() {
    }

    @Override
    public void viewFile() {
    }

    @Override
    public void showImpactAnalysis(boolean bForward) {
    }

    @Override
    public void showReverseImpactAnslysis(boolean bForward) {
    }
}

