/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsButtonsLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;

public class PFDZoomDialog
extends WAStandardDialog {
    private static final WAdminResource bundle = WAdminResource.getBundle(PFDZoomDialog.class);
    private static final int TOTAL_WIDTH = 250;
    private static final int TOTAL_HEIGHT = 80;
    private double m_dCurrentZoomRatio;
    private JLabel m_lblCurrent;
    private JLabel m_lblCustom;
    private JLabel m_lblCurrentZoom;
    private WATextField m_txtCustomZoom;
    private WAPanel m_pnlMain;

    public PFDZoomDialog(double currentRatio) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("pfd.zoom.custom.prompt.title"), true);
        this.m_dCurrentZoomRatio = currentRatio;
    }

    protected void initialize() {
        this.setSize(250, 80);
        this.setResizable(false);
        this.m_lblCurrent = new JLabel(bundle.getString("pfd.zoom.custom.currentlabel"));
        this.m_lblCustom = new JLabel(bundle.getString("pfd.zoom.custom.customlabel"));
        int zoomPercentage = (int)(this.m_dCurrentZoomRatio * 100.0);
        String s = Integer.toString(zoomPercentage) + "%";
        this.m_lblCurrentZoom = new JLabel(s);
        this.m_txtCustomZoom = new WATextField(s, 6);
        this.m_lblCustom.setDisplayedMnemonic(bundle.getString("pfd.zoom.custom.customlabel.mnem").charAt(0));
        this.m_lblCustom.setLabelFor((Component)this.m_txtCustomZoom);
        this.m_pnlButtons = new WAPanel();
        this.m_pnlMain = new WAPanel();
        this.m_pnlMain.setPreferredSize(new Dimension(250, 80));
        this.setMainPanel(this.m_pnlMain);
        super.initialize();
    }

    protected void layoutWidgets() {
        this.m_pnlButtons.setLayout((LayoutManager)new WsButtonsLayout());
        WAPanel cp = this.m_pnlMain;
        cp.setLayout(new GridBagLayout());
        cp.add((Component)this.m_lblCurrent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        cp.add((Component)this.m_lblCustom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        cp.add((Component)this.m_lblCurrentZoom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        cp.add((Component)this.m_txtCustomZoom, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        super.layoutWidgets();
    }

    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout((LayoutManager)new WsButtonsLayout());
        if (!this.isEditable()) {
            this.m_pnlButtons.add(this.m_btnCancel);
        } else {
            this.m_pnlButtons.add(this.m_btnOk);
        }
        if (this.isEditable()) {
            this.m_pnlButtons.add(this.m_btnCancel);
        }
        if (!this.isModal() && this.isEditable()) {
            this.m_pnlButtons.add(this.m_btnApply);
        }
        if (this.isEditable()) {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnOk);
        } else {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnCancel);
        }
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }

    public String getCustomZoomText() {
        return this.m_txtCustomZoom.getText();
    }

    protected boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    protected boolean validateData() {
        return true;
    }
}

