/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Join;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreIDChangeListener;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.pfd.PFDChangeListener;
import com.sas.wadmin.pfd.PFDCodegenEditorPropertyTab;
import com.sas.wadmin.pfd.PFDDnDAdapter;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDStepEditorOMAView;
import com.sas.wadmin.pfd.PFDUtil;
import com.sas.wadmin.pfd.PFDZoomDialog;
import com.sas.wadmin.pfd.ProcessDetailEventListener;
import com.sas.wadmin.pfd.ProcessEventListener;
import com.sas.wadmin.pfd.WAPFDExternalTableNode;
import com.sas.wadmin.pfd.WAPFDInformationNode;
import com.sas.wadmin.pfd.WAPFDJobNode;
import com.sas.wadmin.pfd.WAPFDJobNodeModel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDSASLibraryNode;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTableNodeModel;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTransformComputeNode;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNode;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNode;
import com.sas.wadmin.pfd.WAPFDWorkTableNodeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.FileWriter;
import com.sas.wadmin.visuals.InnerJobView;
import com.sas.wadmin.visuals.JobTreeNode;
import com.sas.wadmin.visuals.JobView;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.TableStatisticsView;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.wadmin.visuals.WAJobSpecificView;
import com.sas.wadmin.visuals.WAPFDEditorOMAView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.plugins.TreeNodeInterface;
import com.sas.workspace.visuals.SubmitType;
import com.sas.workspace.visuals.WsEditorOMAView;
import com.sas.workspace.visuals.WsFileChooser;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class PFDPanel
extends PFDView {
    protected Point myDefaultLocation = new Point(80, 80);
    protected PFDDnDAdapter m_DnDadapter = null;
    protected EventListenerList m_listenerList = new EventListenerList();
    protected EventListenerList m_detaillistenerList = new EventListenerList();
    protected CMetadata m_activeJob = null;
    protected Workspace m_workspace = Workspace.getWorkspace();
    protected WorkspaceFile m_defaultsFile = this.m_workspace.getAppDefaultsFile();
    protected boolean m_fFirstInstance = false;
    protected WAJobSpecificView m_jobBuilder = null;
    private static final String IMAGE_FILENAME_SUFFIX = ".png";
    private static WAdminResource bundle = WAdminResource.getBundle(PFDPanel.class);
    public static final int CANVAS = 0;
    public static final int NODE = 1;
    public static final int LINK = 2;
    public static final String ALLTYPES = "ALL";
    public static final String PERCENT_SIGN = "%";
    public static final int FLAGNEVERBEENSET = -1;
    public static final int ISREADWRITE = 1;
    public static final int ISREADONLY = 2;
    protected WsAbstractAction m_actViewData;
    protected WsAbstractAction m_actViewFile;
    protected WsAbstractAction m_actPFDMenu;
    protected WsAbstractAction m_actPopupMenu;
    protected WsAbstractAction m_actSubmit;
    protected WsAbstractAction m_actTerminate;
    protected WsAbstractAction m_actKill;
    protected WsAbstractAction m_actPageSetup;
    protected WsAbstractAction m_actPrint;
    protected WsAbstractAction m_actPrinttogif;
    protected WsAbstractAction m_actViewCode;
    protected WsAbstractAction m_actViewStepCode;
    protected WsAbstractAction m_actSave;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actProperties;
    protected WsAbstractAction m_actUseSavedSource;
    protected WsAbstractAction m_actMakeOutput;
    protected WsAbstractAction m_actZoomout;
    protected WsAbstractAction m_actZoomin;
    protected WsAbstractAction m_actZoomCustom;
    protected WsAbstractAction m_actZoomToFit;
    protected WsAbstractAction m_actZoom25;
    protected WsAbstractAction m_actZoom50;
    protected WsAbstractAction m_actZoom75;
    protected WsAbstractAction m_actZoom100;
    protected WsAbstractAction m_actZoom200;
    protected WsAbstractToggleAction m_actLayoutLeft;
    protected WsAbstractToggleAction m_actLayoutRight;
    protected WsAbstractToggleAction m_actLayoutUp;
    protected WsAbstractToggleAction m_actLayoutDown;
    protected WsAbstractAction m_actViewJob;
    protected WsAbstractAction m_actGenerate;
    protected WsAbstractAction m_actPropogate;
    protected WsAbstractToggleAction m_actAutomap;
    protected WsAbstractAction m_actAddInputTemplate;
    protected WsAbstractAction m_actAddOutputTemplate;
    protected WsAbstractAction m_actViewTableStatistics;
    protected WsAbstractToggleAction m_actCreateWebStream;
    protected WsAbstractToggleAction m_actCreateMemberType;
    protected WsAbstractAction m_actImpact;
    protected WsAbstractAction m_actReverseImpact;
    protected JCheckBoxMenuItem m_cbAutomapMenuItem;
    protected JCheckBoxMenuItem m_cbCreateWebStreamMenuItem;
    protected JCheckBoxMenuItem m_cbCreateMemberTypeMenuItem;
    protected PFDCodegenEditorPropertyTab m_tabEditor;
    protected boolean m_enableOnBeforeDeleteEvent = true;
    protected PFDViewListener m_lsnrAppDefaults;
    protected MdStoreIDChangeListener m_lsnrMDStoreIDChange = null;
    protected PFDChangeListener m_lsnrPFDChangeListener = null;
    protected MouseListener m_lsnrMouseListener;
    protected KeyListener m_lsnrKeyListener;
    protected boolean m_fInitializeFromNewObjectWizard = false;
    protected static int m_layoutDirection = -1;
    protected boolean m_bIsPFDMenuVisible = false;
    protected double m_dZoomRatio = 1.0;
    protected boolean m_bIgnoreCustomZoom = false;
    protected static boolean m_bNeedToConstructButtons = true;
    protected WAPropertyTab m_parentPanel = null;
    protected ArrayList m_outputTables = null;
    protected InnerJobView m_innerJobView;
    protected WorkspaceOMAView m_view;
    protected static int m_numPFDs = 0;
    protected static Vector m_vecPFDs = new Vector();
    protected static int layoutDirection;
    protected Vector m_vecZoomActions = new Vector();
    private List m_lPFDLinks;
    protected String m_sTransformationStepFQID;
    protected Hashtable m_nodeModelLookup = new Hashtable();
    protected String m_sGIFFileName = null;
    public static final String LAYOUT_DIRECTION_RIGHT = "Right";
    public static final String LAYOUT_DIRECTION_DOWN = "Down";
    public static final String LAYOUT_DIRECTION_LEFT = "Left";
    public static final String LAYOUT_DIRECTION_UP = "Up";
    public static final int LAYOUT_DIRECTION_RIGHT_CODE = 0;
    public static final int LAYOUT_DIRECTION_DOWN_CODE = 1;
    public static final int LAYOUT_DIRECTION_LEFT_CODE = 2;
    public static final int LAYOUT_DIRECTION_UP_CODE = 3;
    public final double ZOOM_INCREMENT = 0.1;
    public static final double ZOOM_MIN_RATIO = 0.1;
    public static final double ZOOM_MAX_RATIO = 5.0;
    public static final int ZOOM_MIN_PERCENTAGE = 10;
    public static final int ZOOM_MAX_PERCENTAGE = 500;
    public static final String ID_ZOOM_OUT = "zoomout";
    public static final String ID_ZOOM_IN = "zoomin";
    public static final double CANCEL_ZOOM = -1.0;
    public static final int ZOOM_TO_FIT_INDEX = 5;
    public static final int CUSTOM_ZOOM_INDEX = 6;
    protected boolean m_fNeedZoomToFit = false;
    public static final String TOOLLOCATION_ROTATE = "rotate";
    public static final String TOOLLOCATION_ZOOM = "zoom";
    protected static final int BOX_WIDTH = 100;
    protected static final int BOX_HEIGHT = 21;
    protected static final int POPUP_CANVAS = 1;
    protected static final int POPUP_LINK = 2;
    protected static final int POPUP_NODE = 3;
    protected static final int POPUP_NOPOPUP = -1;
    protected static final int POPUP_MULTIPLESELECT = 4;
    protected int m_iJobPropertiesReadOnlyState = -1;
    protected int m_iCMReadOnlyState = -1;
    protected MdStore m_jobStore = null;
    protected static final String DEFAULT_REMOVE_TEMPLATE = "<TransformationStep><Prototype><PrototypeProperties/></Prototype></UsingPrototype><SourceCode/><SuccessorDependencies/><PredecessorDependencies/><Properties><Property><OwningType/></Property></Properties><Transformations><ClassifierMap><FeatureMaps/><ClassifierTargets><WorkTable><Columns/></WorkTable></ClassifierTargets></ClassifierMap></Transformations></TransformationStep>";
    protected cChildFramesManager m_mgrChildFrames;

    public PFDPanel(CMetadata metadata) {
        this(metadata, null);
    }

    public PFDPanel(CMetadata metadata, ArrayList list, MdStore jobStore) {
        if (jobStore != null) {
            this.m_jobStore = jobStore;
        }
        if (m_layoutDirection == -1) {
            m_layoutDirection = this.m_defaultsFile.getPropertyInt("PFDFrame.LayoutDirection", 0);
        }
        try {
            MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
            this.createListeners(store);
            ++m_numPFDs;
            m_vecPFDs.add(this);
            this.setKeyboardEnabled(false);
            this.setPopupMenuEnabled(false);
            this.setOpaque(true);
            ArrayList transforms = TransformManager.getInstance().getProcessEventListenerTransforms();
            for (ChangeListener object : transforms) {
                this.addProcessEventListener((ProcessEventListener)object);
            }
            transforms = TransformManager.getInstance().getProcessDetailEventListenerTransforms();
            for (ChangeListener object : transforms) {
                this.addProcessDetailEventListener((ProcessDetailEventListener)object);
            }
            this.m_mgrChildFrames = this.createChildFramesManager();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public PFDPanel() {
    }

    public PFDPanel(CMetadata metadata, ArrayList outputTables) {
        this.m_outputTables = outputTables;
        if (outputTables != null) {
            this.m_fInitializeFromNewObjectWizard = true;
        }
        this.m_activeJob = metadata;
        if (Workspace.getWorkspace().isObjectEditable(this.m_activeJob)) {
            this.m_DnDadapter = new PFDDnDAdapter(this);
        }
        if (m_layoutDirection == -1) {
            m_layoutDirection = this.m_defaultsFile.getPropertyInt("PFDFrame.LayoutDirection", 0);
        }
        try {
            MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
            this.createListeners(store);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        ++m_numPFDs;
        m_vecPFDs.add(this);
        this.setKeyboardEnabled(false);
        this.setPopupMenuEnabled(false);
        this.setOpaque(true);
        ArrayList transforms = TransformManager.getInstance().getProcessEventListenerTransforms();
        for (ChangeListener object : transforms) {
            this.addProcessEventListener((ProcessEventListener)object);
        }
        transforms = TransformManager.getInstance().getProcessDetailEventListenerTransforms();
        for (ChangeListener object : transforms) {
            this.addProcessDetailEventListener((ProcessDetailEventListener)object);
        }
        this.m_mgrChildFrames = this.createChildFramesManager();
    }

    protected void createListeners(MdObjectStore store) {
        this.m_lsnrAppDefaults = this.createPFDViewListener();
        this.m_lsnrMouseListener = this.createMouseListener();
        this.m_lsnrKeyListener = this.createKeyListener();
        this.addPFDViewListener(this.m_lsnrAppDefaults);
        this.addMouseListener(this.m_lsnrMouseListener);
        this.addKeyListener(this.m_lsnrKeyListener);
        this.createStoreListeners(store);
    }

    protected void createStoreListeners(MdObjectStore store) {
        this.m_lsnrMDStoreIDChange = this.createMdStoreIDChangeListener();
        this.m_lsnrPFDChangeListener = new PFDChangeListener(store, this);
        try {
            store.addVetoableChangeListener((VetoableChangeListener)this.m_lsnrPFDChangeListener);
            store.addMdStoreIDChangeListener(this.m_lsnrMDStoreIDChange);
            store.addMdStoreListener((MdStoreListener)this.m_lsnrMDStoreIDChange);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void removeListeners() {
        this.removePFDViewListener(this.m_lsnrAppDefaults);
        this.removeMouseListener(this.m_lsnrMouseListener);
        this.removeKeyListener(this.m_lsnrKeyListener);
        this.removeStoreListeners();
        this.m_lsnrAppDefaults = null;
        this.m_lsnrMouseListener = null;
        this.m_lsnrKeyListener = null;
        this.m_listenerList = null;
        this.m_detaillistenerList = null;
    }

    protected void removeStoreListeners() {
        try {
            MdObjectStore store = (MdObjectStore)this.m_activeJob.getObjectStore();
            store.removeMdStoreIDChangeListener(this.m_lsnrMDStoreIDChange);
            store.removeVetoableChangeListener((VetoableChangeListener)this.m_lsnrPFDChangeListener);
            store.removeMdStoreListener((MdStoreListener)this.m_lsnrMDStoreIDChange);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_lsnrMDStoreIDChange = null;
        this.m_lsnrPFDChangeListener = null;
        this.m_lsnrMDStoreIDChange = null;
    }

    public void initialize() {
        this.createActions();
        this.updateActions(true);
        this.getActionMap().put("delete", (Action)this.m_actDelete);
        this.getActionMap().put("showPopup", (Action)this.m_actPopupMenu);
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getInputMap().put(KeyStroke.getKeyStroke(121, 1), "showPopup");
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_actProperties.setActive(bActive);
        this.m_actPFDMenu.setActive(bActive);
        this.m_actSubmit.setActive(bActive);
        SubmitType.getInstance().setActive(bActive);
        this.m_actTerminate.setActive(bActive);
        this.m_actKill.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actPageSetup.setActive(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actMakeOutput.setActive(bActive);
        this.m_actPrinttogif.setActive(bActive);
        this.m_actViewCode.setActive(bActive);
        this.m_actViewStepCode.setActive(bActive);
        this.m_actViewData.setActive(bActive);
        this.m_actViewFile.setActive(bActive);
        this.m_actViewTableStatistics.setActive(bActive);
        this.m_actSave.setActive(bActive);
        this.m_actZoomout.setActive(bActive);
        this.m_actZoomin.setActive(bActive);
        this.m_actZoomCustom.setActive(bActive);
        this.m_actZoomToFit.setActive(bActive);
        this.m_actZoom25.setActive(bActive);
        this.m_actZoom50.setActive(bActive);
        this.m_actZoom75.setActive(bActive);
        this.m_actZoom100.setActive(bActive);
        this.m_actZoom200.setActive(bActive);
        this.m_actLayoutLeft.setActive(bActive);
        this.m_actLayoutRight.setActive(bActive);
        this.m_actLayoutUp.setActive(bActive);
        this.m_actLayoutDown.setActive(bActive);
        this.m_actGenerate.setActive(bActive);
        this.m_actPropogate.setActive(bActive);
        this.m_actAutomap.setActive(bActive);
        this.m_actAddInputTemplate.setActive(bActive);
        this.m_actAddOutputTemplate.setActive(bActive);
        this.m_actCreateWebStream.setActive(bActive);
        this.m_actCreateMemberType.setActive(bActive);
        this.m_actImpact.setActive(bActive);
        this.m_actReverseImpact.setActive(bActive);
        this.updateActions(bActive);
        if (bActive) {
            int i = this.getLayoutDirection();
            if (i == 0) {
                this.m_actLayoutRight.setSelected(true);
            } else if (i == 2) {
                this.m_actLayoutLeft.setSelected(true);
            } else if (i == 3) {
                this.m_actLayoutUp.setSelected(true);
            } else if (i == 1) {
                this.m_actLayoutDown.setSelected(true);
            }
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_jobBuilder = new WAJobSpecificView(this.m_activeJob, this);
        this.m_jobBuilder.getPFDMetadata((Job)this.m_activeJob);
    }

    public void showTSProperties(String sTransformationStepFQID) {
        block16: {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            WAPFDNodeModel nodeModel = this.getNodeModel(sTransformationStepFQID);
            if (nodeModel == null) {
                return;
            }
            WAPFDNodeInterface thisnode = nodeModel.getViewNode();
            if (thisnode == null) {
                return;
            }
            MdObjectStore newStore = null;
            if (!(thisnode instanceof WAPFDNode)) {
                return;
            }
            WAPFDNode node = (WAPFDNode)thisnode;
            CMetadata iObj = node.getMetadataObject();
            try {
                newStore = Workspace.getMdFactory().createObjectStore(this.m_activeJob.getObjectStore());
                newStore.setIsGotToServerForMetadata(false);
                CMetadata newObject = Workspace.getMdFactory().createComplexMetadataObject(newStore, null, iObj);
                if (iObj instanceof Join) {
                    this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.query.wa.", (String)"JoinView").getFrame());
                    break block16;
                }
                if (iObj instanceof TransformationStep) {
                    String classname = null;
                    try {
                        AssociationList properties = ((TransformationStep)iObj).getProperties();
                        for (int i = 0; i < properties.size(); ++i) {
                            Property prop = (Property)properties.get(i);
                            if (!prop.getPropertyName().equals("Class")) continue;
                            classname = prop.getDefaultValue();
                            break;
                        }
                    }
                    catch (Exception ex) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                    }
                    TransformInterface transformInterface = TransformManager.getInstance().getTransform(classname);
                    if (transformInterface == null) {
                        this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.TransformationStepView", (ClassLoader)newObject.getClass().getClassLoader()).getFrame());
                    } else {
                        TransformationStep step;
                        if (!(transformInterface instanceof MacroPlugin) || MacroPluginUtilities.isGeneratedTransform((Root)(step = (TransformationStep)iObj))) {
                            // empty if block
                        }
                        this.m_mgrChildFrames.add(transformInterface.displayProperties(newObject));
                    }
                    break block16;
                }
                if (iObj instanceof Classifier || iObj instanceof Document) {
                    boolean fFound = false;
                    ArrayList plugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.workspace.plugins.TreeNodeInterface");
                    for (int i = 0; i < plugins.size(); ++i) {
                        TreeNodeInterface treeNode = (TreeNodeInterface)plugins.get(i);
                        if (!iObj.getCMetadataType().equals(treeNode.getCMetadataType())) continue;
                        this.m_mgrChildFrames.add((JInternalFrame)treeNode.getDataTreeNode(newObject).onProperties().getFrame());
                        fFound = true;
                        newStore.dispose();
                        break;
                    }
                    if (!fFound) {
                        this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.", (String)"View").getFrame());
                    }
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (!this.m_fFirstInstance) {
            int direction = PFDPanel.getLayoutDirection();
            PFDPanel.setLayoutDirection(0);
            this.getModel().disableChangeUpdate();
            TransformationActivity ta = null;
            if (((Job)this.m_activeJob).getJobActivities(false).size() == 0) {
                ta = (TransformationActivity)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_activeJob.getObjectStore(), null, bundle.getString("PFDFrame.NewTA"), "TransformationActivity", this.m_activeJob.getRepositoryID(), null);
                ta.getJobs().add((Object)this.m_activeJob);
            }
            this.m_fFirstInstance = true;
            this.setHoldDisplay(true);
            if (!this.m_fInitializeFromNewObjectWizard) {
                this.m_jobBuilder.buildView();
            } else {
                this.buildViewFromTables();
            }
            this.getModel().enableChangeUpdate();
            PFDPanel.updateAllPreferredColors();
            this.buildRenderables();
            this.updateZoom();
            this.setHoldDisplay(false);
            PFDPanel.setLayoutDirection(direction);
        }
        if (this.m_fNeedZoomToFit) {
            this.zoomToFit();
        }
        if (this.m_jobBuilder.getError() == WAJobSpecificView.ERROR_LOADERTARGETEMPTY) {
            MessageUtil.displayMessage((String)bundle.getString("PFDPanel.Error.LoaderTargetEmpty.txt"), (String)bundle.getString("PFDPanel.StartupErrorMessage.txt"), (int)2);
        }
        if (this.m_sTransformationStepFQID != null && this.m_sTransformationStepFQID.length() > 0) {
            this.showTSProperties(this.m_sTransformationStepFQID);
            this.m_sTransformationStepFQID = null;
        }
    }

    protected void buildViewFromTables() {
        if (this.m_outputTables != null && this.m_outputTables.size() > 0) {
            this.m_parentPanel.setDataChanged(true);
            try {
                for (int i = 0; i < this.m_outputTables.size(); ++i) {
                    CMetadata tabletemp = (CMetadata)this.m_outputTables.get(i);
                    DataTable table = (DataTable)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_activeJob.getObjectStore(), tabletemp);
                    try {
                        table.getColumns();
                        WAPFDTableNodeModel newNodeModel = new WAPFDTableNodeModel(this, (CMetadata)table);
                        newNodeModel.addNode((MdObjectStore)this.m_activeJob.getObjectStore(), (CMetadata)table);
                        ArrayList list = new ArrayList();
                        newNodeModel.handleLocation((MdObjectStore)this.m_activeJob.getObjectStore(), null, list);
                        continue;
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                        continue;
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void setTransformationStepFQID(String sFQIDForTS) {
        this.m_sTransformationStepFQID = sFQIDForTS;
    }

    public void doPFDLayout() {
        this.doPFDLayout(PFDPanel.getLayoutDirection());
    }

    public void doPFDLayout(int direction) {
        LayeredLayoutStrategy pfdLayout = (LayeredLayoutStrategy)this.getPFDLayout();
        if (pfdLayout == null) {
            pfdLayout = PFDPanel.createDefaultLayoutStrategy();
            this.setPFDLayout((LayoutStrategyInterface)pfdLayout);
        } else if (direction == 2 || direction == 0) {
            pfdLayout.setReferenceNodeSize(130, 60);
        } else {
            pfdLayout.setReferenceNodeSize(150, 40);
        }
        pfdLayout.setFlowDirection(this.getLayoutDirectionString(direction));
        this.doPFDLayout(true);
        this.forceFlowDirectionChange(direction);
    }

    public void forceFlowDirectionChange(int direction) {
        this.getModel().disableChangeUpdate();
        this.getModel().setFlowDirection(this.getLayoutDirectionString((direction + 1) % 4));
        this.getModel().setFlowDirection(this.getLayoutDirectionString(direction));
        this.getModel().enableChangeUpdate();
    }

    public void forceFlowDirectionChange() {
        this.forceFlowDirectionChange(PFDPanel.getLayoutDirection());
    }

    protected static LayeredLayoutStrategy createDefaultLayoutStrategy() {
        LayeredLayoutStrategy lls = new LayeredLayoutStrategy();
        lls.setReferenceNodeSize(150, 40);
        lls.setBetweenLayerSpace(20);
        lls.setWithinLayerSpace(60);
        return lls;
    }

    protected void updateZoom() {
        int index = this.m_defaultsFile.getPropertyInt("PFDFrame.DefaultZoomIndex", 1);
        if (index == 6) {
            int percentage = this.m_defaultsFile.getPropertyInt("pfd.zoom.custompercent", 100);
            double ratio = (double)percentage / 100.0;
            this.zoom(ratio);
            this.setZoomRatio(ratio);
        } else if (index == 5) {
            this.m_fNeedZoomToFit = true;
        } else {
            ((WsAbstractAction)this.m_vecZoomActions.get(index)).actionPerformed(null);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        MdObjectStore jobStore = (MdObjectStore)this.m_activeJob.getObjectStore();
        Map mapIDs = jobStore.getDetailObjectMap();
        Iterator iterIDs = mapIDs.keySet().iterator();
        ArrayList<Root> lObjects = new ArrayList<Root>();
        while (iterIDs.hasNext()) {
            Root oObject = (Root)mapIDs.get(iterIDs.next());
            if (!oObject.isNewObject() || !oObject.getCMetadataType().equalsIgnoreCase("PropertySet") || !((PropertySet)oObject).getOwningObjects().isEmpty()) continue;
            lObjects.add(oObject);
        }
        if (!lObjects.isEmpty()) {
            for (Root oObject : lObjects) {
                jobStore.removeElementFromStore((CMetadata)oObject);
            }
        }
    }

    public void saveSettingsAndCleanUp() {
        this.cleanupViews();
        if (this.m_lPFDLinks != null) {
            for (int i = 0; i < this.m_lPFDLinks.size(); ++i) {
                WAPFDLink link = (WAPFDLink)this.m_lPFDLinks.get(i);
                link.dispose();
            }
            this.m_lPFDLinks = null;
        }
        this.removeListeners();
        --m_numPFDs;
        m_vecPFDs.remove((Object)this);
        this.setPFDLayout(null);
        this.m_activeJob = null;
        this.myDefaultLocation = null;
        if (this.m_DnDadapter != null) {
            this.m_DnDadapter.dispose();
        }
        this.m_DnDadapter = null;
        if (this.m_mgrChildFrames != null) {
            this.m_mgrChildFrames.clear();
        }
        this.m_mgrChildFrames = null;
        this.m_jobBuilder = null;
        this.m_tabEditor.saveSettingsAndCleanUp();
        try {
            if (this.m_jobStore != null) {
                this.m_jobStore.dispose();
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void addChildFrame(JInternalFrame frmChild) {
        this.m_mgrChildFrames.add(frmChild);
    }

    public void addLink(WAPFDLink link) {
        if (this.m_lPFDLinks == null) {
            this.m_lPFDLinks = new ArrayList();
        }
        this.m_lPFDLinks.add(link);
    }

    public void removeLink(WAPFDLink link) {
        if (this.m_lPFDLinks != null) {
            this.m_lPFDLinks.remove(link);
        }
    }

    public void setActiveJob(CMetadata job) {
        this.m_activeJob = job;
    }

    public CMetadata getActiveJob() {
        return this.m_activeJob;
    }

    public PFDDnDAdapter getDNDAdapter() {
        return this.m_DnDadapter;
    }

    public void setEditorTab(PFDCodegenEditorPropertyTab tabEditor) {
        this.m_tabEditor = tabEditor;
    }

    public void setParentPanel(WAPropertyTab parentPanel) {
        this.m_parentPanel = parentPanel;
    }

    public void setOwningView(WorkspaceOMAView view) {
        this.m_view = view;
    }

    public void setInnerJobView(InnerJobView view) {
        this.m_innerJobView = view;
    }

    public InnerJobView getInnerJobView() {
        return this.m_innerJobView;
    }

    public WorkspaceOMAView getOwningView() {
        return this.m_view;
    }

    public void setDataChanged(boolean bDataChanged) {
    }

    public String getHelpTopic() {
        return "process_editor";
    }

    public String getHelpProduct() {
        return "wdb";
    }

    public static int getDefaultZoomIndex() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt("PFDFrame.DefaultZoomIndex", 1);
    }

    public static void setDefaultZoomIndex(int i) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt("PFDFrame.DefaultZoomIndex", i);
    }

    public static double getDefaultZoomRatio() {
        double dRatio;
        String ratio = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("PFDFrame.DefaultZoomRatio", "1.0");
        try {
            dRatio = Float.parseFloat(ratio);
            dRatio *= 100.0;
        }
        catch (NumberFormatException nfe) {
            dRatio = Float.parseFloat("1.0");
            dRatio *= 100.0;
        }
        return dRatio;
    }

    public static void setDefaultZoomRatio(double ratio) {
        double dRatio = ratio;
        String value = String.valueOf(dRatio /= 100.0);
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("PFDFrame.DefaultZoomRatio", value);
    }

    public static int getPFDCount() {
        return m_numPFDs;
    }

    public static void displayPFDErrorMessage(String key) {
        Workspace.getWorkspace().setStatusText(bundle.getString(key));
    }

    public void addProcessEventListener(ProcessEventListener l) {
        this.m_listenerList.add(ProcessEventListener.class, l);
    }

    public void removeProcessEventListener(ProcessEventListener l) {
        this.m_listenerList.remove(ProcessEventListener.class, l);
    }

    public void addProcessDetailEventListener(ProcessDetailEventListener l) {
        this.m_detaillistenerList.add(ProcessDetailEventListener.class, l);
    }

    public void removeProcessDetailEventListener(ProcessDetailEventListener l) {
        this.m_detaillistenerList.remove(ProcessDetailEventListener.class, l);
    }

    protected PFDViewListener createPFDViewListener() {
        return new cPFDViewListener();
    }

    protected MdStoreIDChangeListener createMdStoreIDChangeListener() {
        return new cMdStoreIDChangeListener();
    }

    protected PFDChangeListener createPFDChangeListener(MdObjectStore store) {
        return new cPFDChangeListener(store, this);
    }

    protected MouseListener createMouseListener() {
        return new cMouseListener();
    }

    protected KeyListener createKeyListener() {
        return new cKeyListener();
    }

    public void handlePopupEvent(MouseEvent e) throws MdException, RemoteException {
        int iCanShowPopup = -1;
        PFDPrimitive object = null;
        if (this.getSelectionList().getNumPrimitives() == 0) {
            iCanShowPopup = 1;
        } else if (this.getSelectionList().getNumPrimitives() == 1) {
            object = this.getSelectedPrimitives()[0];
            iCanShowPopup = object instanceof WAPFDLink ? 2 : 3;
        } else if (this.getSelectionList().getNumPrimitives() > 1) {
            iCanShowPopup = 4;
        } else {
            return;
        }
        this.updateActions(true);
        if (e.isPopupTrigger() && iCanShowPopup > -1) {
            switch (iCanShowPopup) {
                case 1: {
                    this.showCanvasPopupMenu(e);
                    break;
                }
                case 2: {
                    this.showLinkPopupMenu(e);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    this.showNodePopupMenu((WAPFDPrimitiveInterface)object, e);
                }
            }
        }
    }

    public void showNodePopupMenu(WAPFDPrimitiveInterface object, MouseEvent e) throws MdException, RemoteException {
        boolean fState;
        JPopupMenu menuPopup = new JPopupMenu();
        menuPopup.add(new JMenuItem((Action)this.m_actProperties));
        menuPopup.add(new JSeparator());
        menuPopup.add(new JMenuItem((Action)this.m_actViewStepCode));
        menuPopup.add(new JMenuItem((Action)this.m_actViewData));
        if (object instanceof WAPFDTableNode && !(object instanceof WAPFDExternalTableNode) && !(object instanceof WAPFDWorkTableNode) && !(object instanceof WAPFDInformationNode)) {
            CMetadata metaObject = ((WAPFDTableNode)object).getWAPFDNodeModel().getMetadataObject();
            if (!metaObject.getCMetadataType().equalsIgnoreCase("Cube")) {
                if (metaObject.getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
                    menuPopup.add(new JMenuItem((Action)this.m_actViewTableStatistics));
                }
                this.m_cbCreateWebStreamMenuItem = new JCheckBoxMenuItem((Action)this.m_actCreateWebStream);
                menuPopup.add(this.m_cbCreateWebStreamMenuItem);
                fState = PFDUtil.isWebServiceStream((DataTable)((WAPFDTableNode)object).getMetadataObject());
                this.m_actCreateWebStream.setSelected(fState);
                this.m_cbCreateWebStreamMenuItem.setSelected(fState);
                WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
                if (menusupport != null) {
                    menusupport.getMenuBar().setSelectedItemsState("createwebstream", fState);
                }
            }
        } else if (object instanceof WAPFDWorkTableNode) {
            this.m_cbCreateMemberTypeMenuItem = new JCheckBoxMenuItem((Action)this.m_actCreateMemberType);
            menuPopup.add(this.m_cbCreateMemberTypeMenuItem);
            PhysicalTable table = (PhysicalTable)((WAPFDTableNode)object).getMetadataObject();
            fState = PFDUtil.isTableView(table);
            this.m_actCreateMemberType.setSelected(fState);
            this.m_cbCreateMemberTypeMenuItem.setSelected(fState);
            WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
            if (menusupport != null) {
                menusupport.getMenuBar().setSelectedItemsState("membertype", fState);
            }
        }
        if (object instanceof WAPFDExternalTableNode) {
            menuPopup.add(new JMenuItem((Action)this.m_actViewFile));
        }
        menuPopup.add(new JMenuItem((Action)this.m_actViewJob));
        menuPopup.add(new JMenuItem((Action)this.m_actMakeOutput));
        if (object instanceof WAPFDTransformNode && !(object instanceof WAPFDJobNode) && !(object instanceof WAPFDTransformComputeNode)) {
            this.m_cbAutomapMenuItem = new JCheckBoxMenuItem((Action)this.m_actAutomap);
            menuPopup.add(this.m_cbAutomapMenuItem);
            boolean fState2 = ((WAPFDTransformNode)object).isAutomapEnabled();
            this.m_actAutomap.setSelected(((WAPFDTransformNode)object).isAutomapEnabled());
            this.m_cbAutomapMenuItem.setSelected(fState2);
            WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
            if (menusupport != null) {
                menusupport.getMenuBar().setSelectedItemsState("automap", fState2);
            }
        }
        menuPopup.add(new JMenuItem((Action)this.m_actImpact));
        menuPopup.add(new JMenuItem((Action)this.m_actReverseImpact));
        menuPopup.add(new JSeparator());
        menuPopup.add(new JMenuItem((Action)this.m_actAddInputTemplate));
        menuPopup.add(new JMenuItem((Action)this.m_actAddOutputTemplate));
        menuPopup.add(new JMenuItem((Action)this.m_actDelete));
        menuPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void showLinkPopupMenu(MouseEvent e) {
        JPopupMenu menuPopup = new JPopupMenu();
        menuPopup.add(new JMenuItem((Action)this.m_actDelete));
        menuPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void showMultipleSelectPopupMenu(MouseEvent e) {
        JPopupMenu menuPopup = new JPopupMenu();
        menuPopup.add(new JMenuItem((Action)this.m_actDelete));
        menuPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void showCanvasPopupMenu(MouseEvent e) {
        JPopupMenu menuPopup = new JPopupMenu();
        menuPopup.add(new JMenuItem((Action)this.m_actProperties));
        menuPopup.add(new JSeparator());
        menuPopup.add(new JMenuItem((Action)this.m_actSubmit));
        menuPopup.add(new JMenuItem((Action)this.m_actTerminate));
        menuPopup.add(new JMenuItem((Action)this.m_actKill));
        menuPopup.add(new JMenuItem((Action)this.m_actViewCode));
        menuPopup.add(new JMenuItem((Action)this.m_actSave));
        menuPopup.add(new JMenuItem((Action)this.m_actPrinttogif));
        menuPopup.add(new JMenuItem((Action)this.m_actGenerate));
        menuPopup.add(new JMenuItem((Action)this.m_actPropogate));
        menuPopup.add(new JSeparator());
        JMenu menuZoom = new JMenu(bundle.getString("pfd.zoom.txt"));
        menuZoom.setMnemonic(bundle.getString("pfd.zoom.mnem").charAt(0));
        menuZoom.setIcon(bundle.getImageIcon("Common.EmptyIcon.image"));
        menuZoom.add(new JMenuItem((Action)this.m_actZoomout));
        menuZoom.add(new JMenuItem((Action)this.m_actZoomin));
        menuZoom.add(new JMenuItem((Action)this.m_actZoomCustom));
        menuZoom.add(new JMenuItem((Action)this.m_actZoomToFit));
        menuZoom.add(new JMenuItem((Action)this.m_actZoom25));
        menuZoom.add(new JMenuItem((Action)this.m_actZoom50));
        menuZoom.add(new JMenuItem((Action)this.m_actZoom75));
        menuZoom.add(new JMenuItem((Action)this.m_actZoom100));
        menuZoom.add(new JMenuItem((Action)this.m_actZoom200));
        menuPopup.add(menuZoom);
        menuPopup.add(new JSeparator());
        JMenu menuLayout = new JMenu(bundle.getString("pfd.layout.txt"));
        menuLayout.setMnemonic(bundle.getString("pfd.layout.mnem").charAt(0));
        menuLayout.setIcon(bundle.getImageIcon("Common.EmptyIcon.image"));
        JCheckBoxMenuItem menuRight = new JCheckBoxMenuItem((Action)this.m_actLayoutRight);
        JCheckBoxMenuItem menuLeft = new JCheckBoxMenuItem((Action)this.m_actLayoutLeft);
        JCheckBoxMenuItem menuUp = new JCheckBoxMenuItem((Action)this.m_actLayoutUp);
        JCheckBoxMenuItem menuDown = new JCheckBoxMenuItem((Action)this.m_actLayoutDown);
        menuLayout.add(menuRight);
        menuLayout.add(menuDown);
        menuLayout.add(menuLeft);
        menuLayout.add(menuUp);
        int i = this.getLayoutDirection();
        menuRight.setState(false);
        menuLeft.setState(false);
        menuUp.setState(false);
        menuDown.setState(false);
        if (i == 0) {
            menuRight.setState(true);
        } else if (i == 2) {
            menuLeft.setState(true);
        } else if (i == 3) {
            menuUp.setState(true);
        } else if (i == 1) {
            menuDown.setState(true);
        }
        menuPopup.add(menuLayout);
        menuPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    public Hashtable getNodeModelLookup() {
        return this.m_nodeModelLookup;
    }

    public void cleanupViews() {
        if (this.m_nodeModelLookup == null) {
            return;
        }
        for (WAPFDNodeModel returningModel : this.m_nodeModelLookup.values()) {
            CMetadata object = returningModel.getMetadataObject();
            if (object == null) continue;
            try {
                ArrayList list = object.getViewList();
                if (list.size() == 0) continue;
                list.remove(this.m_view);
                if (!list.contains((Object)this.m_innerJobView)) continue;
                list.remove((Object)this.m_innerJobView);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void cleanupViews(MdStore store) {
        if (this.m_nodeModelLookup == null) {
            return;
        }
        for (WAPFDNodeModel returningModel : this.m_nodeModelLookup.values()) {
            CMetadata object = returningModel.getMetadataObject((MdObjectStore)store);
            if (object == null) continue;
            try {
                ArrayList list = object.getViewList();
                if (list.size() == 0) continue;
                list.remove(this.m_view);
                if (!list.contains((Object)this.m_innerJobView)) continue;
                list.remove((Object)this.m_innerJobView);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public WAPFDNodeModel getNodeModel(String metadataID) {
        return (WAPFDNodeModel)this.m_nodeModelLookup.get(metadataID);
    }

    public WAPFDNodeModel addNodeModelToHashmap(String id, WAPFDNodeModel nodeModel) {
        WAPFDNodeModel returningModel = (WAPFDNodeModel)this.m_nodeModelLookup.get(id);
        if (returningModel == null) {
            Workspace.getDefaultLogger().debug((Object)("PFDPANEL:  Creating new node in hashmap: " + id));
        }
        this.m_nodeModelLookup.put(id, nodeModel);
        returningModel = nodeModel;
        return returningModel;
    }

    public boolean isNodeModelAlreadyAdded(CMetadata metadata) {
        try {
            String sParentID;
            String id = metadata.getFQID();
            if (this.m_nodeModelLookup.containsKey(id)) {
                return true;
            }
            if ((metadata.getCMetadataType().equalsIgnoreCase("PhysicalTable") || metadata.getCMetadataType().equalsIgnoreCase("ExternalTable") || metadata.getCMetadataType().equalsIgnoreCase("SASLibrary") || metadata.getCMetadataType().equalsIgnoreCase("Job")) && (sParentID = ProjectUtil.getParentRepositoryID((Root)((Root)metadata))) != null && this.m_nodeModelLookup.containsKey(sParentID)) {
                return true;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }

    public void removeNode(WAPFDNodeInterface node) {
        WAPFDNodeModel nodeModel = node.getWAPFDNodeModel();
        CMetadata object = nodeModel.getMetadataObject();
        if (object == null) {
            return;
        }
        try {
            Workspace.getDefaultLogger().debug((Object)("Removing " + object.getFQID()));
            if (!this.m_nodeModelLookup.containsKey(object.getFQID())) {
                Workspace.getDefaultLogger().debug((Object)"Couldnt remove");
                return;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getDefaultLogger().debug((Object)"Removed node");
        if (nodeModel instanceof WAPFDJobNodeModel) {
            try {
                Job job = (Job)((TransformationStep)object).getTransformations().get(0);
                job.getViewList().remove((Object)this.m_innerJobView);
                this.m_nodeModelLookup.remove(job.getFQID());
                String sCOId = ProjectUtil.getParentRepositoryID((Root)job);
                if (sCOId != null) {
                    this.m_nodeModelLookup.remove(sCOId);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        try {
            this.m_nodeModelLookup.remove(object.getFQID());
            String sCOId = ProjectUtil.getParentRepositoryID((Root)((Root)object));
            if (sCOId != null) {
                this.m_nodeModelLookup.remove(sCOId);
            }
            object.getViewList().remove(this.m_view);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void removeNode(String strFQID) {
        if (!this.m_nodeModelLookup.containsKey(strFQID)) {
            Workspace.getDefaultLogger().debug((Object)"Couldnt remove");
            return;
        }
        Workspace.getDefaultLogger().debug((Object)"Removed node");
        this.m_nodeModelLookup.remove(strFQID);
    }

    public void fireOnDeleteEvent(ChangeEvent e, CMetadata object) {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProcessEventListener.class) continue;
            ((ProcessEventListener)listeners[i + 1]).onDelete(e, object);
        }
    }

    public void fireOnBeforeDeleteEvent(ChangeEvent e) {
        if (this.m_enableOnBeforeDeleteEvent) {
            Object[] listeners = this.m_detaillistenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ProcessDetailEventListener.class) continue;
                ((ProcessDetailEventListener)listeners[i + 1]).onBeforeDelete(e);
            }
        }
    }

    public void fireOnAddEvent(ChangeEvent e) {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProcessEventListener.class) continue;
            ((ProcessEventListener)listeners[i + 1]).onAdd(e);
        }
    }

    public boolean closeAllChildFrames() {
        return this.m_mgrChildFrames.closeAll();
    }

    protected cChildFramesManager createChildFramesManager() {
        return new cChildFramesManager();
    }

    public static void setLayoutDirection(int iDirection) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt("PFDFrame.LayoutDirection", iDirection);
        for (int i = 0; i < m_vecPFDs.size(); ++i) {
            PFDPanel panel = (PFDPanel)((Object)m_vecPFDs.get(i));
            LayeredLayoutStrategy lls = (LayeredLayoutStrategy)panel.getPFDLayout();
            String strDirection = panel.getLayoutDirectionString();
            if (lls == null) {
                lls = PFDPanel.createDefaultLayoutStrategy();
                lls.setNodePositionHonored(true);
                panel.setPFDLayout((LayoutStrategyInterface)lls);
            } else if (iDirection == 2 || iDirection == 0) {
                lls.setReferenceNodeSize(130, 60);
            } else {
                lls.setReferenceNodeSize(150, 40);
            }
            lls.setFlowDirection(strDirection);
            panel.getModel().disableChangeUpdate();
            panel.getModel().setFlowDirection(panel.getLayoutDirectionString((iDirection + 1) % 4));
            panel.getModel().setFlowDirection(panel.getLayoutDirectionString());
            panel.getModel().enableChangeUpdate();
            panel.updateView();
        }
    }

    public static int getLayoutDirection() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt("PFDFrame.LayoutDirection", 0);
    }

    protected String getLayoutDirectionString() {
        return this.getLayoutDirectionString(PFDPanel.getLayoutDirection());
    }

    protected String getLayoutDirectionString(int iDirection) {
        switch (iDirection) {
            case 0: {
                return LAYOUT_DIRECTION_RIGHT;
            }
            case 1: {
                return LAYOUT_DIRECTION_DOWN;
            }
            case 2: {
                return LAYOUT_DIRECTION_LEFT;
            }
            case 3: {
                return LAYOUT_DIRECTION_UP;
            }
        }
        return "";
    }

    public void updateView() {
        this.doPFDLayout();
        PFDPanel.updateAllPreferredColors();
        this.repaint();
    }

    public static void updateAllPreferredColors() {
    }

    public void setEditable(boolean bEditable) {
    }

    protected void writeMetadata() {
        try {
            if (this.m_activeJob instanceof Root) {
                WsMetadataUtil.updateModifiedByFor((Root)((Root)this.m_activeJob));
            }
            String str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
            String str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title");
            String str3 = bundle.getString("WriteMetadataProgressIndicator.Msg.Cancel.txt");
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2, str3);
            request.setDelayBeforeProgressCancelDialog(200);
            Runnable runWrite = new Runnable(){

                @Override
                public void run() {
                    PFDPanel.this.doThreadedWrite();
                }
            };
            request.execute(runWrite);
            Workspace.getDefaultLogger().debug((Object)"Finished waiting on write");
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().error((Object)("Error encountered while writing data" + ge.getMessage()));
        }
    }

    public void doThreadedWrite() {
        Workspace.getDefaultLogger().debug((Object)"Starting write");
        try {
            this.m_activeJob.updateMetadataAll();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getDefaultLogger().debug((Object)"Finished write");
    }

    protected void createActions() {
        this.m_actViewData = this.createViewDataAction();
        this.m_actViewFile = this.createViewFileAction();
        this.m_actPFDMenu = this.createPFDMenuAction();
        this.m_actPopupMenu = this.createPopupMenuAction();
        this.m_actPrint = this.createPrintAction();
        this.m_actPrinttogif = this.createPrinttogifAction();
        this.m_actProperties = this.createPropertiesAction();
        this.m_actViewJob = this.createViewJobAction();
        this.m_actImpact = this.createImpactAnalysisAction();
        this.m_actReverseImpact = this.createReverseImpactAnalysisAction();
    }

    protected void updateActions(boolean bActive) {
        try {
            if (this.m_actSubmit.isEnabled()) {
                SubmitType.getInstance().setEnabled(true);
                this.m_actTerminate.setEnabled(false);
                this.m_actKill.setEnabled(false);
            }
            if (!bActive) {
                this.m_actProperties.setEnabled(bActive);
                this.m_actViewStepCode.setEnabled(bActive);
                this.m_actMakeOutput.setEnabled(bActive);
                this.m_actViewData.setEnabled(bActive);
                this.m_actViewFile.setEnabled(bActive);
                this.m_actViewTableStatistics.setEnabled(bActive);
                this.m_actViewJob.setEnabled(false);
                this.m_actDelete.setEnabled(bActive);
                this.m_actGenerate.setEnabled(bActive);
                this.m_actPropogate.setEnabled(bActive);
                this.m_actImpact.setEnabled(bActive);
                this.m_actReverseImpact.setEnabled(bActive);
                this.m_actAddInputTemplate.setEnabled(bActive);
                this.m_actAddOutputTemplate.setEnabled(bActive);
                this.m_actAutomap.setEnabled(bActive);
                this.m_actCreateWebStream.setEnabled(bActive);
                this.m_actCreateMemberType.setEnabled(bActive);
            } else if (this.getSelectionList().getNumPrimitives() == 0) {
                this.m_actProperties.setEnabled(true);
                this.m_actViewStepCode.setEnabled(false);
                this.m_actMakeOutput.setEnabled(false);
                this.m_actViewData.setEnabled(false);
                this.m_actViewFile.setEnabled(false);
                this.m_actViewTableStatistics.setEnabled(false);
                this.m_actViewJob.setEnabled(false);
                this.m_actDelete.setEnabled(false);
                this.m_actGenerate.setEnabled(true);
                this.m_actImpact.setEnabled(false);
                this.m_actReverseImpact.setEnabled(false);
                this.m_actAddInputTemplate.setEnabled(false);
                this.m_actAddOutputTemplate.setEnabled(false);
                this.m_actAutomap.setEnabled(false);
                this.m_actCreateWebStream.setEnabled(false);
                this.m_actCreateMemberType.setEnabled(false);
                if (this.m_mgrChildFrames.m_alChildFrames.size() == 0) {
                    this.m_actPropogate.setEnabled(true);
                } else {
                    this.m_actPropogate.setEnabled(false);
                }
            } else if (this.isJobPropertiesReadOnlyJob() || this.isCMReadOnlyJob()) {
                PFDPrimitive primitive = this.getSelectedPrimitives()[0];
                WAPFDPrimitiveInterface object = (WAPFDPrimitiveInterface)primitive;
                this.m_actMakeOutput.setEnabled(false);
                this.m_actViewJob.setEnabled(false);
                this.m_actDelete.setEnabled(false);
                this.m_actGenerate.setEnabled(true);
                this.m_actPropogate.setEnabled(false);
                this.m_actProperties.setEnabled(object.fCanShowProperties());
                this.m_actAddInputTemplate.setEnabled(false);
                this.m_actAddOutputTemplate.setEnabled(false);
                this.m_actViewStepCode.setEnabled(object.fCanViewStepCode());
                this.m_actViewData.setEnabled(object.fCanViewData());
                this.m_actViewFile.setEnabled(object.fCanViewFile());
                this.m_actImpact.setEnabled(object.fCanShowImpact());
                this.m_actReverseImpact.setEnabled(object.fCanShowReverseImpact());
                this.m_actAutomap.setEnabled(false);
                this.m_actCreateWebStream.setEnabled(false);
                this.m_actCreateMemberType.setEnabled(false);
                if (primitive instanceof WAPFDTableNode) {
                    CMetadata metaObject = ((WAPFDTableNode)primitive).getWAPFDNodeModel().getMetadataObject();
                    if (metaObject.getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
                        this.m_actViewTableStatistics.setEnabled(true);
                    }
                } else {
                    this.m_actViewTableStatistics.setEnabled(false);
                }
            } else if (this.getSelectionList().getNumPrimitives() == 1) {
                PFDPrimitive primitive = this.getSelectedPrimitives()[0];
                WAPFDPrimitiveInterface object = (WAPFDPrimitiveInterface)primitive;
                this.m_actProperties.setEnabled(object.fCanShowProperties());
                this.m_actViewStepCode.setEnabled(object.fCanViewStepCode());
                this.m_actMakeOutput.setEnabled(object.fCanMakeOutput());
                if (this.m_actSubmit.isEnabled()) {
                    SubmitType.getInstance().setEnabled(true);
                    this.m_actTerminate.setEnabled(false);
                    this.m_actKill.setEnabled(false);
                }
                this.m_actViewData.setEnabled(object.fCanViewData());
                this.m_actViewFile.setEnabled(object.fCanViewFile());
                this.m_actViewJob.setEnabled(object.fCanViewJob());
                boolean canDelete = object.fCanDelete();
                if (canDelete) {
                    String role;
                    WAPFDLink link;
                    WAPFDNodeInterface fromNode;
                    if (object instanceof WAPFDTransformNode && !((WAPFDNode)object).getWAPFDNodeModel().getMetadataObject().getViewList().isEmpty()) {
                        canDelete = false;
                    }
                    if (object instanceof WAPFDLink && (fromNode = (link = (WAPFDLink)object).getWAFromNode()) instanceof WAPFDTransformNode && ((role = ((TransformationStep)((WAPFDTransformNode)fromNode).getWAPFDNodeModel().getMetadataObject()).getTransformRole()).equalsIgnoreCase("SASJob") || role.equalsIgnoreCase("Loop"))) {
                        canDelete = false;
                    }
                }
                this.m_actDelete.setEnabled(canDelete);
                this.m_actGenerate.setEnabled(true);
                this.m_actPropogate.setEnabled(true);
                this.m_actImpact.setEnabled(object.fCanShowImpact());
                this.m_actReverseImpact.setEnabled(object.fCanShowReverseImpact());
                this.m_actAddInputTemplate.setEnabled(object.fCanAddInputTemplate());
                this.m_actAddOutputTemplate.setEnabled(object.fCanAddOutputTemplate());
                WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
                if (menusupport != null) {
                    if (object instanceof WAPFDTransformNode) {
                        menusupport.getMenuBar().setSelectedItemsState("automap", ((WAPFDTransformNode)object).isAutomapEnabled());
                        this.m_actAutomap.setEnabled(true);
                    } else {
                        this.m_actAutomap.setEnabled(false);
                        menusupport.getMenuBar().setSelectedItemsState("automap", false);
                    }
                }
                if (primitive instanceof WAPFDTableNode) {
                    CMetadata metaObject = ((WAPFDTableNode)primitive).getWAPFDNodeModel().getMetadataObject();
                    if (metaObject.getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
                        this.m_actViewTableStatistics.setEnabled(true);
                        if (Workspace.getWorkspace().isObjectEditable(metaObject)) {
                            this.m_actCreateWebStream.setEnabled(true);
                        } else {
                            this.m_actCreateWebStream.setEnabled(false);
                        }
                    } else if (metaObject instanceof WorkTable) {
                        if (Workspace.getWorkspace().isObjectEditable(metaObject)) {
                            this.m_actCreateMemberType.setEnabled(true);
                        } else {
                            this.m_actCreateMemberType.setEnabled(false);
                        }
                    } else {
                        this.m_actViewTableStatistics.setEnabled(false);
                        this.m_actCreateWebStream.setEnabled(false);
                        this.m_actCreateMemberType.setEnabled(false);
                    }
                } else {
                    this.m_actViewTableStatistics.setEnabled(false);
                    this.m_actCreateWebStream.setEnabled(false);
                    this.m_actCreateMemberType.setEnabled(false);
                }
            } else if (this.getSelectionList().getNumPrimitives() > 1) {
                this.m_actProperties.setEnabled(false);
                this.m_actViewStepCode.setEnabled(false);
                this.m_actMakeOutput.setEnabled(false);
                this.m_actViewData.setEnabled(false);
                this.m_actViewFile.setEnabled(false);
                this.m_actViewTableStatistics.setEnabled(false);
                this.m_actViewJob.setEnabled(false);
                this.m_actDelete.setEnabled(false);
                this.m_actGenerate.setEnabled(false);
                this.m_actPropogate.setEnabled(false);
                this.m_actImpact.setEnabled(false);
                this.m_actReverseImpact.setEnabled(false);
                this.m_actAddInputTemplate.setEnabled(false);
                this.m_actAddOutputTemplate.setEnabled(false);
                this.m_actAutomap.setEnabled(false);
                this.m_actCreateWebStream.setEnabled(false);
                this.m_actCreateMemberType.setEnabled(false);
            } else {
                this.m_actProperties.setEnabled(false);
                this.m_actViewStepCode.setEnabled(false);
                this.m_actMakeOutput.setEnabled(false);
                this.m_actViewData.setEnabled(false);
                this.m_actViewFile.setEnabled(false);
                this.m_actViewTableStatistics.setEnabled(false);
                this.m_actViewJob.setEnabled(false);
                this.m_actDelete.setEnabled(false);
                this.m_actGenerate.setEnabled(false);
                this.m_actPropogate.setEnabled(false);
                this.m_actImpact.setEnabled(false);
                this.m_actReverseImpact.setEnabled(false);
                this.m_actAddInputTemplate.setEnabled(false);
                this.m_actAddOutputTemplate.setEnabled(false);
                this.m_actAutomap.setEnabled(false);
                this.m_actCreateWebStream.setEnabled(false);
                this.m_actCreateMemberType.setEnabled(false);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (PFDException ex2) {
            PFDPanel.displayPFDErrorMessage(ex2.getMessage());
        }
    }

    protected WsAbstractAction createViewDataAction() {
        return new cViewDataAction();
    }

    protected WsAbstractAction createViewFileAction() {
        return new cViewFileAction();
    }

    protected WsAbstractAction createViewTableStatisticsAction() {
        return new cViewTableStatisticsAction();
    }

    protected WsAbstractAction createImpactAnalysisAction() {
        return new cImpactAnalysisAction();
    }

    protected WsAbstractAction createReverseImpactAnalysisAction() {
        return new cReverseImpactAnalysisAction();
    }

    protected WsAbstractAction createPFDMenuAction() {
        return new cPFDMenuAction();
    }

    protected WsAbstractAction createPopupMenuAction() {
        return new cPopupMenuAction();
    }

    protected WsAbstractAction createSubmitAction() {
        return new cSubmitAction();
    }

    protected WsAbstractAction createTerminateAction() {
        return new cTerminateAction();
    }

    protected WsAbstractAction createKillAction() {
        return new cKillAction();
    }

    protected WsAbstractAction createPageSetupAction() {
        return new cPageSetupAction();
    }

    protected WsAbstractAction createPrintAction() {
        return new cPrintAction();
    }

    protected WsAbstractAction createPrinttogifAction() {
        return new cPrinttogifAction();
    }

    protected WsAbstractAction createViewCodeAction() {
        return new cViewCodeAction();
    }

    protected WsAbstractAction createViewStepCodeAction() {
        return new cViewStepCodeAction();
    }

    protected WsAbstractAction createSaveAction() {
        return new cSaveAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createPropertiesAction() {
        return new cPropertiesAction();
    }

    protected WsAbstractAction createUseSavedSourceAction() {
        return new cUseSavedSourceAction();
    }

    protected WsAbstractAction createMakeOutputAction() {
        return new cMakeOutputAction();
    }

    protected WsAbstractAction createZoomoutAction() {
        return new cZoomoutAction();
    }

    protected WsAbstractAction createZoominAction() {
        return new cZoominAction();
    }

    protected WsAbstractAction createZoomCustomAction() {
        return new cZoomCustomAction();
    }

    protected WsAbstractAction createZoomToFitAction() {
        return new cZoomToFitAction();
    }

    protected WsAbstractAction createZoom25Action() {
        return new cZoom25Action();
    }

    protected WsAbstractAction createZoom50Action() {
        return new cZoom50Action();
    }

    protected WsAbstractAction createZoom75Action() {
        return new cZoom75Action();
    }

    protected WsAbstractAction createZoom100Action() {
        return new cZoom100Action();
    }

    protected WsAbstractAction createZoom200Action() {
        return new cZoom200Action();
    }

    protected WsAbstractToggleAction createLayoutLeftAction() {
        return new cLayoutLeftAction();
    }

    protected WsAbstractToggleAction createLayoutRightAction() {
        return new cLayoutRightAction();
    }

    protected WsAbstractToggleAction createLayoutUpAction() {
        return new cLayoutUpAction();
    }

    protected WsAbstractToggleAction createLayoutDownAction() {
        return new cLayoutDownAction();
    }

    protected WsAbstractAction createViewJobAction() {
        return new cViewJobAction();
    }

    protected WsAbstractAction createGenerateAction() {
        return new cGenerateAction();
    }

    protected WsAbstractAction createPropogateAction() {
        return new cPropogateAction();
    }

    protected WsAbstractAction createAddInputTemplateAction() {
        return new cAddInputTemplateAction();
    }

    protected WsAbstractAction createAddOutputTemplateAction() {
        return new cAddOutputTemplateAction();
    }

    protected WsAbstractToggleAction createAutomapAction() {
        return new cAutomapAction();
    }

    protected WsAbstractToggleAction createWebStreamAction() {
        return new cCreateWebStreamAction();
    }

    protected WsAbstractToggleAction createMemberTypeAction() {
        return new cMemberTypeAction();
    }

    public void pfdDeleteObjects(List objects, boolean fShowPromptDialog) throws MdException, RemoteException, PFDException {
        if (fShowPromptDialog) {
            String strTitle = bundle.getString("PFDFrame.ConfirmRemoveDialog.Title.txt");
            StringBuffer strMessage = new StringBuffer();
            strMessage.append(bundle.getString("PFDFrame.ConfirmRemove.txt"));
            ArrayList<String> titles = new ArrayList<String>();
            for (int i = 0; i < objects.size(); ++i) {
                Object object = objects.get(i);
                if (object instanceof PFDPrimitive) {
                    PFDPrimitive primitive = (PFDPrimitive)object;
                    String label = null;
                    if (primitive instanceof WAPFDNode) {
                        label = ((WAPFDNode)primitive).getLabel().getText();
                        WAPFDNodeModel nodeModel = ((WAPFDNode)primitive).getWAPFDNodeModel();
                        CMetadata metaObject = nodeModel.getMetadataObject();
                        if (metaObject instanceof TransformationStep) {
                            TransformationStep step = (TransformationStep)metaObject;
                            if (step.getTransformRole().indexOf("Loader") > -1) {
                                TransformInterface transformInterface = nodeModel.getTransformFromStep(step);
                                if (transformInterface instanceof FileWriter) {
                                    strMessage.append("\n\n");
                                    strMessage.append(bundle.getString("PFDFrame.WriterDeleteMessage.txt"));
                                } else {
                                    strMessage.append("\n\n");
                                    strMessage.append(bundle.getString("PFDFrame.LoaderDeleteMessage.txt"));
                                }
                            } else if (step.getTransformRole().indexOf("FileReader") > -1) {
                                strMessage.append("\n\n");
                                strMessage.append(bundle.getString("PFDFrame.ReaderDeleteMessage.txt"));
                            } else if (step.getTransformRole().indexOf("Contents") > -1) {
                                strMessage.append("\n\n");
                                strMessage.append(bundle.getString("PFDFrame.ContentsDeleteMessage.txt"));
                            } else if (step.getTransformRole().indexOf("QueueReader") > -1 || step.getTransformRole().indexOf("IBMWSQWriter") > -1 || step.getTransformRole().indexOf("QueueWriter") > -1) {
                                strMessage.append("\n\n");
                                strMessage.append(bundle.getString("PFDFrame.QueueNodeDeleteMessage.txt"));
                            }
                        }
                    } else if (primitive instanceof WAPFDTemplateNode) {
                        label = ((WAPFDTemplateNode)primitive).getLabel().getText();
                    } else {
                        String fromNodeName = null;
                        String toNodeName = null;
                        WAPFDNodeInterface fromNodeInterface = ((WAPFDLink)primitive).getWAFromNode();
                        fromNodeName = fromNodeInterface instanceof WAPFDTemplateNode ? ((WAPFDTemplateNode)fromNodeInterface).getLabel().getText() : ((WAPFDNode)fromNodeInterface).getLabel().getText();
                        WAPFDNodeInterface toNodeInterface = ((WAPFDLink)primitive).getWAToNode();
                        toNodeName = toNodeInterface instanceof WAPFDTemplateNode ? ((WAPFDTemplateNode)toNodeInterface).getLabel().getText() : ((WAPFDNode)toNodeInterface).getLabel().getText();
                        label = bundle.formatString("PFDPanel.deletelink.txt", (Object)fromNodeName, (Object)toNodeName);
                        if (fromNodeInterface instanceof WAPFDNode && toNodeInterface instanceof WAPFDNode) {
                            TransformationStep step;
                            WAPFDNodeModel fromNodeModel = ((WAPFDNode)fromNodeInterface).getWAPFDNodeModel();
                            CMetadata fromNodeObject = fromNodeModel.getMetadataObject();
                            WAPFDNodeModel toNodeModel = ((WAPFDNode)toNodeInterface).getWAPFDNodeModel();
                            CMetadata toNodeObject = toNodeModel.getMetadataObject();
                            if (fromNodeObject instanceof TransformationStep && toNodeObject instanceof PhysicalTable) {
                                strMessage.append("\n\n");
                                strMessage.append(bundle.getString("PFDFrame.TransformTableLinkDeleteMessage.txt"));
                            } else if (fromNodeObject instanceof PhysicalTable && toNodeObject instanceof TransformationStep) {
                                strMessage.append("\n\n");
                                strMessage.append(bundle.getString("PFDFrame.TransformTableLinkDeleteMessage.txt"));
                            } else if (fromNodeObject instanceof TransformationStep && toNodeObject instanceof ExternalTable) {
                                step = (TransformationStep)fromNodeObject;
                                if (step.getTransformRole().indexOf("Loader") > -1) {
                                    strMessage.append("\n\n");
                                    strMessage.append(bundle.getString("PFDFrame.WriterLinkDeleteMessage.txt"));
                                }
                            } else if (fromNodeObject instanceof ExternalTable && toNodeObject instanceof TransformationStep) {
                                step = (TransformationStep)toNodeObject;
                                if (step.getTransformRole().indexOf("FileReader") > -1) {
                                    strMessage.append("\n\n");
                                    strMessage.append(bundle.getString("PFDFrame.ReaderLinkDeleteMessage.txt"));
                                }
                            } else if (fromNodeObject instanceof SASLibrary && toNodeObject instanceof TransformationStep) {
                                step = (TransformationStep)toNodeObject;
                                if (step.getTransformRole().indexOf("FileReader") > -1) {
                                    strMessage.append("\n\n");
                                    strMessage.append(bundle.getString("PFDFrame.ReaderLinkDeleteMessage.txt"));
                                }
                            } else if (fromNodeObject instanceof Transformation && toNodeObject instanceof TransformationStep && (step = (TransformationStep)toNodeObject).getTransformRole().indexOf("QueueReader") > -1) {
                                strMessage.append("\n\n");
                                strMessage.append(bundle.getString("PFDFrame.QueueLinkDeleteMessage.txt"));
                            }
                        }
                    }
                    titles.add(label);
                    continue;
                }
                CMetadata metaObject = (CMetadata)object;
                titles.add(metaObject.getName());
            }
            int iChoice = MessageUtil.displayListMessage((String)strMessage.toString(), titles, (String)strTitle, (int)2, (int)2);
            if (iChoice != 0) {
                return;
            }
        }
        for (int i = 0; i < objects.size(); ++i) {
            WAPFDNodeInterface node;
            String objectID;
            WAPFDNodeModel nodeModel;
            Object object = objects.get(i);
            if (object instanceof PFDPrimitive) {
                this.pfdDeleteObject((PFDPrimitive)object, false);
                continue;
            }
            if (!(object instanceof CMetadata) || (nodeModel = (WAPFDNodeModel)this.m_nodeModelLookup.get(objectID = ((CMetadata)object).getFQID())) == null || !((node = nodeModel.getViewNode()) instanceof WAPFDNode)) continue;
            this.pfdDeleteObject((PFDPrimitive)node, false);
        }
    }

    public void pfdDeleteObject(PFDPrimitive primitive, boolean fShowPromptDialog) throws MdException, RemoteException, PFDException {
        if (fShowPromptDialog) {
            int iChoice;
            String strMessage;
            String strTitle;
            ArrayList<String> list = new ArrayList<String>();
            if (primitive instanceof WAPFDNode) {
                list.add(((WAPFDNode)primitive).getLabel().getText());
            }
            if (primitive instanceof WAPFDTransformLoaderNode) {
                strTitle = bundle.getString("PFDFrame.ConfirmRemoveDialog.Title.txt");
                strMessage = bundle.getString("PFDFrame.ConfirmRemove.txt");
                iChoice = MessageUtil.displayListMessage((String)strMessage, list, (String)strTitle, (int)2, (int)2);
                if (iChoice != 0) {
                    return;
                }
            } else {
                strTitle = bundle.getString("PFDFrame.ConfirmRemoveDialog.Title.txt");
                strMessage = bundle.getString("PFDFrame.ConfirmRemove.txt");
                iChoice = MessageUtil.displayListMessage((String)strMessage, list, (String)strTitle, (int)2, (int)2);
                if (iChoice != 0) {
                    return;
                }
            }
        }
        this.m_parentPanel.setDataChanged(true);
        this.m_tabEditor.setGenerateCode(true);
        ArrayList<Object> affectedObjects = new ArrayList<Object>();
        WAPFDPrimitiveInterface interfaceObject = (WAPFDPrimitiveInterface)primitive;
        if (!(interfaceObject instanceof WAPFDTemplateNode)) {
            if (interfaceObject instanceof WAPFDNode) {
                WAPFDNodeModel nodeModel = ((WAPFDNode)interfaceObject).getWAPFDNodeModel();
                CMetadata object = nodeModel.getMetadataObject();
                if (object instanceof TransformationStep) {
                    List workNodes = ((WAPFDTransformNodeModel)nodeModel).getWorkTableNodes();
                    for (int iNode = 0; iNode < workNodes.size(); ++iNode) {
                        WAPFDWorkTableNode workNode = (WAPFDWorkTableNode)workNodes.get(iNode);
                        WAPFDWorkTableNodeModel workModel = (WAPFDWorkTableNodeModel)workNode.getWAPFDNodeModel();
                        affectedObjects.add(workModel.getMetadataObject());
                    }
                }
                affectedObjects.add(object);
            } else if (interfaceObject instanceof WAPFDLink) {
                WAPFDLink link = (WAPFDLink)interfaceObject;
                WAPFDNodeInterface linkFromNode = link.getWAFromNode();
                WAPFDNodeInterface linkToNode = link.getWAToNode();
                if (linkFromNode instanceof WAPFDNode && linkToNode instanceof WAPFDNode) {
                    WAPFDNodeModel fromModel = ((WAPFDNode)linkFromNode).getWAPFDNodeModel();
                    WAPFDNodeModel toModel = ((WAPFDNode)linkToNode).getWAPFDNodeModel();
                    CMetadata fromObject = fromModel.getMetadataObject();
                    CMetadata toObject = toModel.getMetadataObject();
                    boolean fFound = false;
                    if (fromObject instanceof TransformationStep) {
                        TransformationStep fromStep = (TransformationStep)fromObject;
                        for (int k = 0; k < fromStep.getTransformations(false).size(); ++k) {
                            ClassifierMap map = (ClassifierMap)fromStep.getTransformations(false).elementAt(k);
                            DataTable table = (DataTable)map.getClassifierTargets(false).elementAt(0);
                            for (int j = 0; j < table.getSourceClassifierMaps(false).size(); ++j) {
                                ClassifierMap innermap = (ClassifierMap)table.getSourceClassifierMaps(false).get(j);
                                TransformationStep step = (TransformationStep)innermap.getSteps(false).elementAt(0);
                                if (!step.getFQID().equals(toObject.getFQID())) continue;
                                fFound = true;
                                affectedObjects.add(table);
                                break;
                            }
                            if (fFound) break;
                        }
                    }
                    if (fFound) {
                        affectedObjects.add(toObject);
                    }
                }
            }
        }
        if (affectedObjects.size() > 0) {
            this.fireOnBeforeDeleteEvent(new ChangeEvent(affectedObjects));
        }
        affectedObjects = new ArrayList();
        ((WAPFDPrimitiveInterface)primitive).delete(affectedObjects);
        if (affectedObjects.size() > 0) {
            this.fireOnDeleteEvent(new ChangeEvent(affectedObjects), null);
        }
        this.clearSelections();
        this.updateView();
        this.updateActions(true);
    }

    protected void handlePropertiesAction() {
        this.handlePropertiesAction(false);
    }

    protected void handlePropertiesAction(boolean fFromDoubleClick) {
        block33: {
            try {
                MdObjectStore newStore = null;
                if (this.getSelectedPrimitives().length > 0) {
                    CMetadata detailObject;
                    WAPFDPrimitiveInterface primitive = (WAPFDPrimitiveInterface)this.getSelectedPrimitives()[0];
                    if (!(primitive instanceof WAPFDNode)) {
                        return;
                    }
                    WAPFDNode node = (WAPFDNode)primitive;
                    CMetadata iObj = detailObject = node.getMetadataObject();
                    if (node instanceof WAPFDTableNode && !(detailObject instanceof WorkTable)) {
                        if (detailObject.isNewObject() && !detailObject.getCMetadataType().equalsIgnoreCase("WorkTable")) {
                            MessageUtil.displayMessage((String)bundle.getString("PFDPanel.TableNotSaved.Information.msg.txt"), (String)bundle.getString("PFDPanel.TableNotSaved.Information.title.txt"), (int)1);
                            return;
                        }
                        newStore = Workspace.getMdFactory().createObjectStore();
                    } else {
                        newStore = Workspace.getMdFactory().createObjectStore(this.m_activeJob.getObjectStore());
                        newStore.setIsGotToServerForMetadata(false);
                    }
                    if (detailObject instanceof Column) {
                        try {
                            iObj = ((Column)detailObject).getTable();
                        }
                        catch (MdException ex) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException((RemoteException)re);
                        }
                    }
                    CMetadata newObject = Workspace.getMdFactory().createComplexMetadataObject(newStore, null, iObj);
                    if (iObj instanceof Join) {
                        this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.query.wa.", (String)"JoinView").getFrame());
                    }
                    if (iObj instanceof Transformation) {
                        this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.", (String)"QueueView").getFrame());
                        break block33;
                    }
                    if (node instanceof WAPFDSASLibraryNode) {
                        newStore.setIsGotToServerForMetadata(true);
                        this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.", (String)"View").getFrame());
                        break block33;
                    }
                    if (iObj instanceof TransformationStep && ((TransformationStep)iObj).getTransformations(false) != null && ((TransformationStep)iObj).getTransformations(false).size() > 0 && ((TransformationStep)iObj).getTransformations(false).get(0) instanceof Job) {
                        if (newStore != null) {
                            newStore.dispose();
                        }
                        Job job = (Job)((TransformationStep)iObj).getTransformations(false).get(0);
                        if (fFromDoubleClick) {
                            WsOMAView view = WsViewFactory.findExistingView((CMetadata)job, (String)WAPFDEditorOMAView.class.getName());
                            if (view != null) {
                                WsViewFactory.showExistingView((WsOMAView)view);
                                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                            } else {
                                JobTreeNode.showNewProcessView((CMetadata)job, "inner job store");
                            }
                        } else {
                            WsOMAView view = WsViewFactory.findExistingView((CMetadata)job, (String)JobView.class.getName());
                            if (view != null) {
                                WsViewFactory.showExistingView((WsOMAView)view);
                                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                            } else {
                                newStore = Workspace.getMdFactory().createObjectStore(null, "inner job store");
                                newStore.setIsGotToServerForMetadata(true);
                                newObject = Workspace.getMdFactory().createComplexMetadataObject(newStore, null, job.getName(), job.getCMetadataType(), job.getFQID());
                                this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.", (String)"View").getFrame());
                            }
                        }
                        break block33;
                    }
                    if (iObj instanceof TransformationStep) {
                        String classname = null;
                        try {
                            AssociationList properties = ((TransformationStep)iObj).getProperties();
                            for (int i = 0; i < properties.size(); ++i) {
                                Property prop = (Property)properties.get(i);
                                if (!prop.getPropertyName().equals("Class")) continue;
                                classname = prop.getDefaultValue();
                                break;
                            }
                        }
                        catch (Exception ex) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                        }
                        TransformInterface transformInterface = TransformManager.getInstance().getTransform(classname);
                        if (transformInterface == null) {
                            this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.TransformationStepView", (ClassLoader)newObject.getClass().getClassLoader()).getFrame());
                        } else {
                            TransformationStep step;
                            if (!(transformInterface instanceof MacroPlugin) || MacroPluginUtilities.isGeneratedTransform((Root)(step = (TransformationStep)iObj))) {
                                // empty if block
                            }
                            this.m_mgrChildFrames.add(transformInterface.displayProperties(newObject));
                        }
                        break block33;
                    }
                    if (iObj instanceof Classifier || iObj instanceof Document) {
                        boolean fFound = false;
                        ArrayList plugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.workspace.plugins.TreeNodeInterface");
                        for (int i = 0; i < plugins.size(); ++i) {
                            TreeNodeInterface treeNode = (TreeNodeInterface)plugins.get(i);
                            if (!iObj.getCMetadataType().equals(treeNode.getCMetadataType())) continue;
                            this.m_mgrChildFrames.add((JInternalFrame)treeNode.getDataTreeNode(newObject).onProperties().getFrame());
                            fFound = true;
                            newStore.dispose();
                            break;
                        }
                        if (!fFound) {
                            this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.", (String)"View").getFrame());
                        }
                    }
                    break block33;
                }
                newStore = Workspace.getMdFactory().createObjectStore(this.m_activeJob.getObjectStore());
                newStore.setIsGotToServerForMetadata(false);
                CMetadata newObject = Workspace.getMdFactory().createComplexMetadataObject(newStore, this.m_activeJob.getObjectStore(), this.m_activeJob.getName(), this.m_activeJob.getCMetadataType(), this.m_activeJob.getId());
                this.m_mgrChildFrames.add((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.", (String)"View").getFrame());
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void mapAllOutputs() {
        try {
            TransformationActivity act = (TransformationActivity)((Job)this.m_activeJob).getJobActivities(false).elementAt(0);
            for (int i = 0; i < act.getTransformationTargets(false).size(); ++i) {
                Classifier classifier = (Classifier)act.getTransformationTargets(false).get(i);
                if (!(classifier instanceof DataTable)) continue;
                MappingUtil.doAutomaticMappings((DataTable)classifier);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void zoomIn() {
        double newScale = this.scaleToFit ? this.getFitScale() + 0.1 : this.getScale() + 0.1;
        this.m_actZoomin.setEnabled(newScale < 5.0);
        this.m_actZoomout.setEnabled(true);
        if (newScale > 5.0) {
            newScale = 5.0;
        }
        this.setScale(newScale);
        this.setZoomRatio(newScale);
        this.setScaleToFit(false);
    }

    protected void zoomOut() {
        double newScale = this.scaleToFit ? this.getFitScale() - 0.1 : this.getScale() - 0.1;
        this.m_actZoomout.setEnabled(newScale > 0.1);
        this.m_actZoomin.setEnabled(true);
        if (newScale < 0.1) {
            newScale = 0.1;
        }
        this.setScale(newScale);
        this.setZoomRatio(newScale);
        this.setScaleToFit(false);
    }

    void zoom(double percentage) {
        double newScale = percentage;
        if (newScale <= 0.1) {
            newScale = 0.1;
            this.m_actZoomout.setEnabled(true);
            this.m_actZoomin.setEnabled(false);
        } else if (newScale >= 5.0) {
            newScale = 5.0;
            this.m_actZoomout.setEnabled(false);
            this.m_actZoomin.setEnabled(true);
        } else {
            this.m_actZoomout.setEnabled(true);
            this.m_actZoomin.setEnabled(true);
        }
        this.setScaleToFit(false);
        this.setScale(newScale);
        this.setZoomRatio(newScale);
    }

    protected void zoomToFit() {
        this.zoom(this.getFitScale());
    }

    public double getZoomRatio() {
        return this.m_dZoomRatio;
    }

    public void setZoomRatio(double ratio) {
        this.m_dZoomRatio = ratio;
    }

    public double showCustomZoomDialog() {
        double ratio;
        PFDZoomDialog pzd = new PFDZoomDialog(this.getZoomRatio());
        pzd.show();
        if (pzd.getReturnValue() == 2) {
            return -1.0;
        }
        String s = pzd.getCustomZoomText();
        if (s.length() == 0) {
            return -1.0;
        }
        if (s.endsWith(PERCENT_SIGN)) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            ratio = Float.parseFloat(s);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog((Component)this.m_workspace, bundle.getString("pfd.zoom.custom.error.txt"), bundle.getString("pfd.zoom.custom.error.title"), 0);
            return this.showCustomZoomDialog();
        }
        if ((ratio /= 100.0) < 0.1 || ratio > 5.0) {
            JOptionPane.showMessageDialog((Component)this.m_workspace, bundle.getString("pfd.zoom.custom.error.txt"), bundle.getString("pfd.zoom.custom.error.title"), 0);
            return this.showCustomZoomDialog();
        }
        long i = Math.round(ratio *= 100.0);
        ratio = (double)i / 100.0;
        return ratio;
    }

    public boolean isCMReadOnlyJob() {
        this.m_iCMReadOnlyState = 1;
        try {
            if (Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_ON) {
                String projectReposID = Workspace.getWorkspace().getProjectRepository().getFQID();
                String lowerHalf = projectReposID.substring(9, 17);
                this.m_iCMReadOnlyState = this.m_activeJob.getFQID().indexOf(lowerHalf) == -1 ? 2 : 1;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this.m_iCMReadOnlyState == 2;
    }

    public boolean isJobPropertiesReadOnlyJob() throws MdException, RemoteException {
        this.m_iJobPropertiesReadOnlyState = 1;
        if (((Job)this.m_activeJob).getProperties(false).size() > 0) {
            AssociationList properties = ((Job)this.m_activeJob).getProperties(false);
            for (int i = 0; i < properties.size(); ++i) {
                Property prop = (Property)properties.elementAt(i);
                if (!prop.getName().equalsIgnoreCase("EDITABLE") || !prop.getDefaultValue().equals("0")) continue;
                this.m_iJobPropertiesReadOnlyState = 2;
            }
        }
        return this.m_iJobPropertiesReadOnlyState == 2;
    }

    protected void enableOnBeforeDeleteEvent(boolean fState) {
        this.m_enableOnBeforeDeleteEvent = fState;
    }

    public boolean getStateOfOnBeforeDeleteEventEnabledFlag() {
        return this.m_enableOnBeforeDeleteEvent;
    }

    protected class cAutomapAction
    extends WsAbstractToggleAction {
        public cAutomapAction() {
            super(bundle, "PFDPanel.Automap", 545);
            this.setMenuSupportId("automap");
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDTransformNode transform = (WAPFDTransformNode)PFDPanel.this.getSelectedPrimitives()[0];
            try {
                boolean state = transform.isAutomapEnabled();
                transform.setAutomapEnabled(!state);
                PFDPanel.this.m_actAutomap.setSelected(!state);
                if (PFDPanel.this.m_cbAutomapMenuItem != null) {
                    PFDPanel.this.m_cbAutomapMenuItem.setState(!state);
                }
                WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
                if (PFDPanel.this.m_cbAutomapMenuItem != null && menusupport != null) {
                    menusupport.getMenuBar().setSelectedItemsState("automap", PFDPanel.this.m_cbAutomapMenuItem.getState());
                }
                PFDPanel.this.updateActions(true);
                PFDPanel.this.m_parentPanel.setDataChanged(true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (PFDException ex2) {
                PFDPanel.displayPFDErrorMessage(ex2.getMessage());
            }
        }
    }

    protected class cPropogateAction
    extends WsAbstractAction {
        public cPropogateAction() {
            super(bundle, "PFDPanel.Propogate", true);
            this.setMenuSupportId("propogate");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int val;
            if (PFDPanel.this.m_mgrChildFrames.m_alChildFrames.size() == 0 && (val = MessageUtil.displayMessage((String)bundle.getString("PFDPropogateMessage.txt"), (int)2, (int)0)) == 0) {
                PFDPanel.this.setDataChanged(true);
                PFDPanel.this.mapAllOutputs();
                MessageUtil.displayMessage((String)bundle.getString("PFDPropogateMessage.Complete.txt"), (int)1);
            }
        }
    }

    protected class cGenerateAction
    extends WsAbstractAction {
        public cGenerateAction() {
            super(bundle, "PFDPanel.Generate", true);
            this.setMenuSupportId("generate");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.m_tabEditor.setGenerateCode(true);
            PFDPanel.this.m_tabEditor.setFromGenerateAction(true);
            PFDPanel.this.m_tabEditor.generateCode(false, false);
            PFDPanel.this.m_tabEditor.setDataChanged(false);
            ((WAPFDEditorOMAView)PFDPanel.this.m_view).showEditorTab();
        }
    }

    protected class cViewJobAction
    extends WsAbstractAction {
        public cViewJobAction() {
            super(bundle, "PFDPanel.ViewJob");
            this.setMenuSupportId("viewjob");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPrimitive primitive = PFDPanel.this.getSelectedPrimitives()[0];
            if (primitive instanceof WAPFDJobNode) {
                TransformationStep step = (TransformationStep)((WAPFDJobNode)primitive).getWAPFDNodeModel().getMetadataObject();
                try {
                    Job job = (Job)step.getTransformations(false).get(0);
                    WsEditorOMAView view = (WsEditorOMAView)WsViewFactory.findExistingView((CMetadata)job, (String)WAPFDEditorOMAView.class.getName());
                    if (view != null) {
                        WsViewFactory.showExistingView((WsOMAView)view);
                        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        JobTreeNode.showNewProcessView((CMetadata)job);
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    protected class cLayoutDownAction
    extends WsAbstractToggleAction {
        public cLayoutDownAction() {
            super(bundle, "PFDPanel.LayoutDown", 544);
            this.setMenuSupportId("layoutdown");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.setLayoutDirection(1);
            PFDPanel.this.m_actLayoutDown.setSelected(true);
        }
    }

    protected class cLayoutUpAction
    extends WsAbstractToggleAction {
        public cLayoutUpAction() {
            super(bundle, "PFDPanel.LayoutUp", 544);
            this.setMenuSupportId("layoutup");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.setLayoutDirection(3);
            PFDPanel.this.m_actLayoutUp.setSelected(true);
        }
    }

    protected class cLayoutRightAction
    extends WsAbstractToggleAction {
        public cLayoutRightAction() {
            super(bundle, "PFDPanel.LayoutRight", 544);
            this.setMenuSupportId("layoutright");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.setLayoutDirection(0);
            PFDPanel.this.m_actLayoutRight.setSelected(true);
        }
    }

    protected class cLayoutLeftAction
    extends WsAbstractToggleAction {
        public cLayoutLeftAction() {
            super(bundle, "PFDPanel.LayoutLeft", 544);
            this.setMenuSupportId("layoutleft");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.setLayoutDirection(2);
            PFDPanel.this.m_actLayoutLeft.setSelected(true);
        }
    }

    protected class cZoom200Action
    extends WsAbstractAction {
        public cZoom200Action() {
            super(bundle, "PFDPanel.Zoom200");
            this.setMenuSupportId("zoom200");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.zoom(2.0);
            PFDPanel.this.m_dZoomRatio = 2.0;
        }
    }

    protected class cZoom100Action
    extends WsAbstractAction {
        public cZoom100Action() {
            super(bundle, "PFDPanel.Zoom100");
            this.setMenuSupportId("zoom100");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.zoom(1.0);
            PFDPanel.this.m_dZoomRatio = 1.0;
        }
    }

    protected class cZoom75Action
    extends WsAbstractAction {
        public cZoom75Action() {
            super(bundle, "PFDPanel.Zoom75");
            this.setMenuSupportId("zoom75");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.zoom(0.75);
            PFDPanel.this.m_dZoomRatio = 0.75;
        }
    }

    protected class cZoom50Action
    extends WsAbstractAction {
        public cZoom50Action() {
            super(bundle, "PFDPanel.Zoom50");
            this.setMenuSupportId("zoom50");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.zoom(0.5);
            PFDPanel.this.m_dZoomRatio = 0.5;
        }
    }

    protected class cZoom25Action
    extends WsAbstractAction {
        public cZoom25Action() {
            super(bundle, "PFDPanel.Zoom25");
            this.setMenuSupportId("zoom25");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.zoom(0.25);
            PFDPanel.this.m_dZoomRatio = 0.25;
        }
    }

    protected class cZoomToFitAction
    extends WsAbstractAction {
        public cZoomToFitAction() {
            super(bundle, "PFDPanel.ZoomToFit");
            this.setMenuSupportId("zoomtofit");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.zoomToFit();
            PFDPanel.this.m_dZoomRatio = PFDPanel.this.getFitScale();
        }
    }

    protected class cZoomCustomAction
    extends WsAbstractAction {
        public cZoomCustomAction() {
            super(bundle, "PFDPanel.ZoomCustom");
            this.setMenuSupportId("zoomcustom");
        }

        public void actionPerformed(ActionEvent e) {
            double ratio = PFDPanel.this.showCustomZoomDialog();
            if (ratio != -1.0) {
                PFDPanel.this.zoom(ratio);
                PFDPanel.this.m_dZoomRatio = ratio;
            }
        }
    }

    protected class cZoominAction
    extends WsAbstractAction {
        public cZoominAction() {
            super(bundle, "PFDPanel.ZoomIn", true);
            this.setMenuSupportId(PFDPanel.ID_ZOOM_IN);
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.zoomIn();
            PFDPanel.this.m_dZoomRatio = PFDPanel.this.getScale();
        }
    }

    protected class cZoomoutAction
    extends WsAbstractAction {
        public cZoomoutAction() {
            super(bundle, "PFDPanel.ZoomOut", true);
            this.setMenuSupportId(PFDPanel.ID_ZOOM_OUT);
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.zoomOut();
            PFDPanel.this.m_dZoomRatio = PFDPanel.this.getScale();
        }
    }

    protected class cMakeOutputAction
    extends WsAbstractAction {
        public cMakeOutputAction() {
            super(bundle, "PFDPanel.MakeOutput");
            this.setMenuSupportId("makeoutput");
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDTableNode table = (WAPFDTableNode)PFDPanel.this.getSelectedPrimitives()[0];
            try {
                table.makeOutput();
                PFDPanel.this.m_parentPanel.setDataChanged(true);
                PFDPanel.this.m_tabEditor.setGenerateCode(true);
                PFDPanel.this.updateView();
                PFDPanel.this.updateActions(true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (PFDException ex2) {
                PFDPanel.displayPFDErrorMessage(ex2.getMessage());
            }
        }
    }

    protected class cUseSavedSourceAction
    extends WsAbstractAction {
        public cUseSavedSourceAction() {
            super(bundle, "PFDPanel.UseSavedSource");
            this.setMenuSupportId("usesavedsource");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cPropertiesAction
    extends WsAbstractAction {
        public cPropertiesAction() {
            super(bundle, "PFDPanel.Properties", true);
            this.setMenuSupportId("properties");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.handlePropertiesAction();
        }
    }

    protected class cCreateWebStreamAction
    extends WsAbstractToggleAction {
        public cCreateWebStreamAction() {
            super(bundle, "PFDPanel.CreateWebStream", 545);
            this.setMenuSupportId("createwebstream");
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDTableNode tableNode = (WAPFDTableNode)PFDPanel.this.getSelectedPrimitives()[0];
            DataTable table = (DataTable)tableNode.getMetadataObject();
            try {
                boolean state = PFDUtil.isWebServiceStream(table);
                PFDPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                PFDUtil.manageWebServiceStream(!state, table, bundle);
                PFDPanel.this.setCursor(Cursor.getDefaultCursor());
                PFDPanel.this.m_actCreateWebStream.setSelected(!state);
                PFDPanel.this.m_cbCreateWebStreamMenuItem.setState(!state);
                WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
                if (menusupport != null) {
                    menusupport.getMenuBar().setSelectedItemsState("createwebstream", PFDPanel.this.m_cbCreateWebStreamMenuItem.getState());
                }
                PFDPanel.this.updateActions(true);
                PFDPanel.this.m_parentPanel.setDataChanged(true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (PFDException ex2) {
                PFDPanel.displayPFDErrorMessage(ex2.getMessage());
            }
        }
    }

    protected class cAddOutputTemplateAction
    extends WsAbstractAction {
        public cAddOutputTemplateAction() {
            super(bundle, "PFDPanel.AddOutputTemplate");
            this.setMenuSupportId("addoutput");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPrimitive primitive = PFDPanel.this.getSelectedPrimitives()[0];
            WAPFDPrimitiveInterface interfaceObject = (WAPFDPrimitiveInterface)primitive;
            if (interfaceObject instanceof WAPFDNode) {
                WAPFDNode node = (WAPFDNode)interfaceObject;
                WAPFDTransformNodeModel nodeModel = (WAPFDTransformNodeModel)node.getWAPFDNodeModel();
                try {
                    TransformationStep step = (TransformationStep)node.getMetadataObject();
                    if (nodeModel.fCanAddTemplate(step, 1)) {
                        nodeModel.addTemplate(step, 1);
                        PFDPanel.this.m_parentPanel.setDataChanged(true);
                        PFDPanel.this.m_tabEditor.setGenerateCode(true);
                        PFDPanel.this.updateView();
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    protected class cAddInputTemplateAction
    extends WsAbstractAction {
        public cAddInputTemplateAction() {
            super(bundle, "PFDPanel.AddInputTemplate");
            this.setMenuSupportId("addinput");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPrimitive primitive = PFDPanel.this.getSelectedPrimitives()[0];
            WAPFDPrimitiveInterface interfaceObject = (WAPFDPrimitiveInterface)primitive;
            if (interfaceObject instanceof WAPFDNode) {
                WAPFDNode node = (WAPFDNode)interfaceObject;
                WAPFDTransformNodeModel nodeModel = (WAPFDTransformNodeModel)node.getWAPFDNodeModel();
                try {
                    TransformationStep step = (TransformationStep)node.getMetadataObject();
                    if (nodeModel.fCanAddTemplate(step, 0)) {
                        nodeModel.addTemplate(step, 0);
                        PFDPanel.this.m_parentPanel.setDataChanged(true);
                        PFDPanel.this.m_tabEditor.setGenerateCode(true);
                        PFDPanel.this.updateView();
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "PFDPanel.Delete", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPrimitive[] primitives = PFDPanel.this.getSelectedPrimitives();
            ArrayList<PFDPrimitive> list = new ArrayList<PFDPrimitive>();
            for (int i = 0; i < primitives.length; ++i) {
                list.add(primitives[i]);
            }
            try {
                PFDPanel.this.pfdDeleteObjects(list, true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (PFDException ex2) {
                PFDPanel.displayPFDErrorMessage(ex2.getMessage());
            }
        }
    }

    protected class cSaveAction
    extends WsAbstractAction {
        public cSaveAction() {
            super(bundle, "PFDPanel.Save", true);
            this.setMenuSupportId("save");
        }

        public void actionPerformed(ActionEvent e) {
            int iRC;
            if (Workspace.getWorkspace().isServerStatusCheckEnabled() && ((iRC = Workspace.getWorkspace().checkMetadataServerStatus(true)) == Workspace.SERVERSTATUS_ERROR || iRC == Workspace.SERVERSTATUS_PAUSED)) {
                return;
            }
            PFDPanel.this.writeMetadata();
            PFDPanel.this.m_parentPanel.setDataChanged(false);
        }
    }

    protected class cViewStepCodeAction
    extends WsAbstractAction {
        public cViewStepCodeAction() {
            super(bundle, "PFDPanel.ViewStepCode");
            this.setMenuSupportId("viewstepcode");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                WAPFDNode selectedNode = (WAPFDNode)PFDPanel.this.getSelectedPrimitives()[0];
                TransformationStep oTS = (TransformationStep)selectedNode.getMetadataObject();
                WsViewFactory.attachViewToFrame(null, (WorkspaceOMAView)new PFDStepEditorOMAView(oTS), (WAPropertyFrame)new WASplittablePropertyFrame());
            }
            catch (NullPointerException npe) {
                JOptionPane.showMessageDialog((Component)PFDPanel.this.m_workspace, bundle.getString("pfd.nostepselected.error"), bundle.getString("pfd.nostepselected.title"), 0);
            }
        }
    }

    protected class cViewCodeAction
    extends WsAbstractAction {
        public cViewCodeAction() {
            super(bundle, "PFDPanel.ViewCode");
            this.setMenuSupportId("viewcode");
        }

        public void actionPerformed(ActionEvent e) {
            ((WAPFDEditorOMAView)PFDPanel.this.m_view).showEditorTab();
        }
    }

    protected class cMemberTypeAction
    extends WsAbstractToggleAction {
        public cMemberTypeAction() {
            super(bundle, "PFDPanel.MemberType", 545);
            this.setMenuSupportId("membertype");
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDTableNode tableNode = (WAPFDTableNode)PFDPanel.this.getSelectedPrimitives()[0];
            PhysicalTable table = (PhysicalTable)tableNode.getMetadataObject();
            try {
                ImageIcon icon;
                PFDPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                WAPFDNodeModel tableNodeModel = tableNode.getWAPFDNodeModel();
                PFDPanel.this.m_parentPanel.setDataChanged(true);
                PFDPanel.this.m_tabEditor.setGenerateCode(true);
                PFDPanel.this.setCursor(Cursor.getDefaultCursor());
                boolean isView = PFDUtil.isTableView(table);
                isView = !isView;
                PFDPanel.this.m_actCreateMemberType.setSelected(isView);
                PFDPanel.this.m_cbCreateMemberTypeMenuItem.setState(isView);
                if (!isView) {
                    table.setMemberType("DATA");
                    icon = WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)false);
                    if (icon != null) {
                        PFDUtil.updateNodeIcon((WAPFDNode)tableNodeModel.getViewNode(), icon);
                    }
                } else {
                    table.setMemberType("VIEW");
                    icon = bundle.getImageIcon("DataSetView.image");
                    if (icon != null) {
                        PFDUtil.updateNodeIcon((WAPFDNode)tableNodeModel.getViewNode(), icon);
                    }
                }
                WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
                if (menusupport != null) {
                    menusupport.getMenuBar().setSelectedItemsState("membertype", PFDPanel.this.m_cbCreateMemberTypeMenuItem.getState());
                }
                PFDPanel.this.updateActions(true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (PFDException ex2) {
                PFDPanel.displayPFDErrorMessage(ex2.getMessage());
            }
        }
    }

    protected class cPrinttogifAction
    extends WsAbstractAction {
        public cPrinttogifAction() {
            super(bundle, "PFDPanel.Printtogif");
            this.setMenuSupportId("printtogif");
        }

        public void actionPerformed(ActionEvent e) {
            String sFileName;
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            String sDefaultPath = appDefaults.getPropertyString("PFDPanel.SaveToGif.DefaultDirectory", "");
            WsFileChooser dlg = new WsFileChooser(sDefaultPath);
            dlg.setFileSelectionMode(0);
            dlg.setMultiSelectionEnabled(false);
            dlg.setDialogTitle(bundle.getString("PFDPanel.SaveToImageDialog.Title.txt"));
            if (PFDPanel.this.m_sGIFFileName == null) {
                PFDPanel.this.m_sGIFFileName = bundle.getString("PFDPanel.Untitled.txt");
            }
            if (!(sFileName = PFDPanel.this.m_sGIFFileName).endsWith(PFDPanel.IMAGE_FILENAME_SUFFIX)) {
                sFileName = sFileName + PFDPanel.IMAGE_FILENAME_SUFFIX;
            }
            dlg.setSelectedFile(new File(sFileName));
            if (dlg.showSaveDialog((Component)Workspace.getWorkspace()) == 0) {
                File file = dlg.getSelectedFile();
                PFDPanel.this.saveModelToPng(file);
                appDefaults.setPropertyString("PFDPanel.SaveToGif.DefaultDirectory", dlg.getCurrentDirectory().getPath());
                PFDPanel.this.m_sGIFFileName = file.getName();
            }
        }
    }

    protected class cPrintAction
    extends WsAbstractAction {
        public cPrintAction() {
            super(bundle, "PFDPanel.Print", true);
            this.setMenuSupportId("print");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.setPrintMode(0);
            PrinterJob printJob = PrinterJob.getPrinterJob();
            if (!Workspace.getWorkspace().isPrinterConnected(printJob)) {
                return;
            }
            printJob.setPrintable((Printable)((Object)PFDPanel.this), PFDPanel.this.getPageFormat());
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (Exception ex) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                }
            }
            PFDPanel.this.repaint();
        }
    }

    protected class cPageSetupAction
    extends WsAbstractAction {
        public cPageSetupAction() {
            this.setMenuSupportId("pagesetup");
        }

        public void actionPerformed(ActionEvent e) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            if (!Workspace.getWorkspace().isPrinterConnected(printJob)) {
                return;
            }
            PFDPanel.this.setPageFormat(printJob.pageDialog(PFDPanel.this.getPageFormat()));
            PFDPanel.this.setPrintMode(0);
        }
    }

    protected class cKillAction
    extends WsAbstractAction {
        public cKillAction() {
            super(bundle, "PFDPanel.Kill", true);
            this.setMenuSupportId("killjob");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("PFDCodegenEditorPropertyTab.ConfirmKillMessage.txt"), (String)bundle.getString("PFDCodegenEditorPropertyTab.ConfirmKillTitle.txt"), (int)1, (int)0);
            if (eAnswer == 1) {
                return;
            }
            PFDPanel.this.m_tabEditor.killAppServer();
        }
    }

    protected class cTerminateAction
    extends WsAbstractAction {
        public cTerminateAction() {
            super(bundle, "PFDPanel.Terminate", true);
            this.setMenuSupportId("terminatejob");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("PFDCodegenEditorPropertyTab.ConfirmCancelMessage.txt"), (String)bundle.getString("PFDCodegenEditorPropertyTab.ConfirmCancelTitle.txt"), (int)1, (int)0);
            if (eAnswer == 1) {
                return;
            }
            PFDPanel.this.m_tabEditor.terminateRunningCode();
        }
    }

    protected class cSubmitAction
    extends WsAbstractAction {
        public cSubmitAction() {
            super(bundle, "PFDPanel.Submit", true);
            this.setMenuSupportId("submit");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PFDPanel.this.m_tabEditor.submitCode();
        }
    }

    protected class cPopupMenuAction
    extends WsAbstractAction {
        protected cPopupMenuAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int x = 0;
            int y = 0;
            if (PFDPanel.this.getSelectionList().getNumPrimitives() != 0) {
                x = PFDPanel.this.getSelectionList().getLastPrimitive().getX();
                y = PFDPanel.this.getSelectionList().getLastPrimitive().getY();
            }
            MouseEvent me = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), 0, x, y, 0, true);
            try {
                PFDPanel.this.handlePopupEvent(me);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected class cPFDMenuAction
    extends WsAbstractAction {
        public cPFDMenuAction() {
            super(bundle, "PFDPanel.Menu");
            this.setMenuSupportId("pfdmenu");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cReverseImpactAnalysisAction
    extends WsAbstractAction {
        public cReverseImpactAnalysisAction() {
            super(bundle, "PFDPanel.ReverseImpactAnalysis");
            this.setMenuSupportId("reverseimpactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDPrimitiveInterface prim = (WAPFDPrimitiveInterface)PFDPanel.this.getSelectedPrimitives()[0];
            prim.showImpactAnalysis(false);
        }
    }

    protected class cImpactAnalysisAction
    extends WsAbstractAction {
        public cImpactAnalysisAction() {
            super(bundle, "PFDPanel.ImpactAnalysis");
            this.setMenuSupportId("impactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDPrimitiveInterface prim = (WAPFDPrimitiveInterface)PFDPanel.this.getSelectedPrimitives()[0];
            prim.showImpactAnalysis(true);
        }
    }

    protected class cViewTableStatisticsAction
    extends WsAbstractAction {
        public cViewTableStatisticsAction() {
            super(bundle, "PFDPanel.ViewStatistics");
            this.setMenuSupportId("viewtablestatistics");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDNode selectedNode = (WAPFDNode)PFDPanel.this.getSelectedPrimitives()[0];
            CMetadata oTable = selectedNode.getMetadataObject();
            WsViewFactory.showView((CMetadata)oTable, TableStatisticsView.class);
        }
    }

    protected class cViewFileAction
    extends WsAbstractAction {
        public cViewFileAction() {
            super(bundle, "PFDPanel.ViewFile");
            this.setMenuSupportId("viewfile");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDPrimitiveInterface prim = (WAPFDPrimitiveInterface)PFDPanel.this.getSelectedPrimitives()[0];
            prim.viewFile();
        }
    }

    protected class cViewDataAction
    extends WsAbstractAction {
        public cViewDataAction() {
            super(bundle, "PFDPanel.ViewData");
            this.setMenuSupportId("viewdata");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            WAPFDPrimitiveInterface prim = (WAPFDPrimitiveInterface)PFDPanel.this.getSelectedPrimitives()[0];
            prim.viewData();
        }
    }

    protected class cChildFramesManager {
        protected ArrayList m_alChildFrames = new ArrayList();
        protected InternalFrameListener m_lsnrChildFrame = this.createChildFrameListener();

        protected InternalFrameListener createChildFrameListener() {
            return new cChildFrameListener();
        }

        public void add(JInternalFrame frmChild) {
            if (this.m_alChildFrames.indexOf(frmChild) == -1) {
                frmChild.addInternalFrameListener(this.m_lsnrChildFrame);
                this.m_alChildFrames.add(frmChild);
            }
        }

        public void remove(JInternalFrame frmChild) {
            frmChild.removeInternalFrameListener(this.m_lsnrChildFrame);
            if (this.m_alChildFrames != null) {
                this.m_alChildFrames.remove(frmChild);
            }
            if (this.m_alChildFrames != null && this.m_alChildFrames.size() == 0 && PFDPanel.this.getSelectionList().getNumPrimitives() == 0) {
                PFDPanel.this.m_actPropogate.setEnabled(true);
            }
        }

        public void clear() {
            this.m_alChildFrames.clear();
            this.m_alChildFrames = null;
        }

        public boolean closeAll() {
            while (this.m_alChildFrames.size() > 0) {
                try {
                    ((WAInternalFrame)this.m_alChildFrames.get(0)).setClosed(true);
                }
                catch (PropertyVetoException e) {
                    return false;
                }
            }
            return true;
        }

        protected class cChildFrameListener
        extends InternalFrameAdapter {
            protected cChildFrameListener() {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                cChildFramesManager.this.remove(e.getInternalFrame());
            }
        }
    }

    protected class cPFDViewListener
    implements PFDViewListener {
        protected cPFDViewListener() {
        }

        public void viewChanged(PFDViewEvent e) {
            try {
                if (e.getType() == 2) {
                    if (PFDPanel.this.isJobPropertiesReadOnlyJob() || PFDPanel.this.isCMReadOnlyJob()) {
                        return;
                    }
                    if (PFDPanel.this.getSelectedPrimitives().length > 1) {
                        return;
                    }
                    if (PFDPanel.this.getSelectedPrimitives().length == 0) {
                        return;
                    }
                    PFDPrimitive[] primitives = PFDPanel.this.getSelectedPrimitives();
                    PFDPrimitive selectedPrimitive = primitives[0];
                    if (selectedPrimitive instanceof WAPFDTemplateNode) {
                        return;
                    }
                    if (selectedPrimitive instanceof WAPFDLink) {
                        return;
                    }
                    WAPFDNode selectedNode = (WAPFDNode)selectedPrimitive;
                    Rectangle rect = selectedNode.getIcon().getBBox();
                    Point centerptOfDropObject = new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
                    PFDPrimitive dropPrimitive = null;
                    PFDModel pfdmodel = PFDPanel.this.getModel();
                    for (int i = 0; i < pfdmodel.getNumPrimitives(); ++i) {
                        PFDPrimitive p = pfdmodel.getPrimitive(i);
                        if (p == selectedNode || !p.isVisible() || !p.contains(centerptOfDropObject.x, centerptOfDropObject.y)) continue;
                        dropPrimitive = p;
                        break;
                    }
                    if (!(dropPrimitive instanceof WAPFDNodeInterface)) {
                        return;
                    }
                    selectedNode.checkReconnectLocation(dropPrimitive);
                    if (selectedNode instanceof WAPFDTransformNode) {
                        TransformInterface inter = ((WAPFDTransformNodeModel)selectedNode.getWAPFDNodeModel()).getInterfaceClass();
                        WAPFDTransformNode.isValidLocation((MdObjectStore)PFDPanel.this.m_activeJob.getObjectStore(), dropPrimitive, inter);
                    }
                    ArrayList affectedObjects = new ArrayList();
                    selectedNode.handleLocation((MdObjectStore)PFDPanel.this.m_activeJob.getObjectStore(), dropPrimitive, affectedObjects);
                    PFDPanel.this.m_parentPanel.setDataChanged(true);
                    PFDPanel.this.m_tabEditor.setGenerateCode(true);
                    PFDPanel.this.updateView();
                    if (affectedObjects.size() > 0) {
                        PFDPanel.this.fireOnAddEvent(new ChangeEvent(affectedObjects));
                    }
                }
            }
            catch (PFDException ex3) {
                PFDPanel.displayPFDErrorMessage(ex3.getMessage());
            }
            catch (MdException ex2) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex2, (String)"Reading");
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex2);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected class cKeyListener
    implements KeyListener {
        protected cKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }

    protected class cMouseListener
    extends MouseAdapter {
        protected cMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PFDPanel.this.requestFocusInWindow();
            if (e.isPopupTrigger()) {
                try {
                    PFDPanel.this.handlePopupEvent(e);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 2) {
                PFDPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                PFDPanel.this.handlePropertiesAction(true);
                PFDPanel.this.setCursor(Cursor.getDefaultCursor());
            } else if (e.isPopupTrigger()) {
                try {
                    PFDPanel.this.handlePopupEvent(e);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else {
                PFDPanel.this.updateActions(true);
            }
        }
    }

    protected class cMdStoreIDChangeListener
    implements MdStoreIDChangeListener {
        protected cMdStoreIDChangeListener() {
        }

        public void MdObjectsAdded(MdEvent e, List items) {
        }

        public void MdObjectsRemoved(MdEvent e, List items) {
        }

        public void MdObjectsModified(MdEvent e, List items) {
            PFDPanel.this.m_parentPanel.setDataChanged(true);
            PFDPanel.this.m_tabEditor.setGenerateCode(true);
            for (String objectId : items) {
                if (PFDPanel.this.m_activeJob == null) {
                    return;
                }
                try {
                    CMetadata updatedObject = ((MdObjectStore)PFDPanel.this.m_activeJob.getObjectStore()).getObject(objectId, true);
                    if (updatedObject == null) continue;
                    if (updatedObject instanceof Job && updatedObject.getFQID().equals(PFDPanel.this.m_activeJob.getFQID())) {
                        PFDPanel.this.m_view.updateFrameTitle();
                        continue;
                    }
                    WAPFDNodeModel nodeModel = PFDPanel.this.getNodeModel(updatedObject.getFQID());
                    if (nodeModel == null) continue;
                    try {
                        ClassifierMap cMap;
                        if (updatedObject instanceof TransformationStep && ((TransformationStep)updatedObject).getTransformRole().equalsIgnoreCase("SQL") && (cMap = (ClassifierMap)((TransformationStep)updatedObject).getTransformations(false).get(0)).getClassifierTargets(false).size() > 0) {
                            AssociationList lTargets = cMap.getClassifierTargets(false);
                            for (int i = 0; i < lTargets.size(); ++i) {
                                ImageIcon icon;
                                DataTable table = (DataTable)cMap.getClassifierTargets(false).get(0);
                                if (!(table instanceof WorkTable)) continue;
                                boolean isView = PFDUtil.isTableView((PhysicalTable)table);
                                isView = !isView;
                                WAPFDNodeModel tableNodeModel = null;
                                tableNodeModel = PFDPanel.this.getNodeModel(table.getFQID());
                                if (!isView) {
                                    ((PhysicalTable)table).setMemberType("DATA");
                                    icon = WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)false);
                                    if (icon == null || tableNodeModel == null) continue;
                                    PFDUtil.updateNodeIcon((WAPFDNode)tableNodeModel.getViewNode(), icon);
                                    continue;
                                }
                                ((PhysicalTable)table).setMemberType("VIEW");
                                icon = bundle.getImageIcon("DataSetView.image");
                                if (icon == null || tableNodeModel == null) continue;
                                PFDUtil.updateNodeIcon((WAPFDNode)tableNodeModel.getViewNode(), icon);
                            }
                        }
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    if (nodeModel.getViewNode() instanceof WAPFDTemplateNode) continue;
                    WAPFDNode node = (WAPFDNode)nodeModel.getViewNode();
                    if (!(node instanceof WAPFDWorkTableNode)) {
                        if (nodeModel != null && node.getLabel() != null && !node.getLabel().getText().equals(updatedObject.getName())) {
                            node.getLabel().setText(updatedObject.getName());
                        }
                    } else if (node.getLabel() != null) {
                        node.getLabel().setText(updatedObject.getName() + "- " + ((WorkTable)updatedObject).getSASTableName());
                    }
                    if (nodeModel instanceof WAPFDTransformNodeModel && updatedObject instanceof TransformationStep && !MacroPluginUtilities.isGeneratedTransform((Root)((TransformationStep)updatedObject))) continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }

        public void MdStoreIDChange(MdEvent e, List idsOld, List idsNew) {
            for (int i = 0; i < idsOld.size(); ++i) {
                String oldID = (String)idsOld.get(i);
                String newID = (String)idsNew.get(i);
                WAPFDNodeModel nodeModel = (WAPFDNodeModel)PFDPanel.this.m_nodeModelLookup.get(oldID);
                if (nodeModel == null) continue;
                nodeModel.updateIDs(oldID, newID);
                PFDPanel.this.m_nodeModelLookup.remove(oldID);
                PFDPanel.this.m_nodeModelLookup.put(newID, nodeModel);
            }
        }
    }

    protected class cPFDChangeListener
    extends PFDChangeListener {
        public cPFDChangeListener(MdObjectStore store, PFDPanel panel) {
            super(store, panel);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            super.vetoableChange(e);
        }
    }
}

