/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.codegen.CodegenRequest;
import com.sas.editor.LogListHolder;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.wadmin.visuals.WAPFDEditorOMAView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsJobSubmissionManager;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.visuals.SubmitType;
import com.sas.workspace.visuals.WsEditorOMAView;
import com.sas.workspace.visuals.WsEditorPropertyTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.SwingUtilities;

public class PFDCodegenEditorPropertyTab
extends WsEditorPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(PFDCodegenEditorPropertyTab.class);
    protected Job m_oJob;
    protected TransformationStep m_oTS;
    protected boolean m_bGenerateCode;
    private boolean m_bFromGenerateAction;
    protected boolean m_codegenFailed = false;
    protected CodegenRequest m_CodegenRequest;
    protected PFDPanel m_PFDPanel;
    protected PropertyChangeListener m_lstnrServerRequest;
    private boolean m_bAppServerCreateStarted;

    public PFDCodegenEditorPropertyTab(Job oJob) {
        this.m_oJob = oJob;
        if (this.m_oJob != null) {
            try {
                this.m_WsServerRequest = WsJobSubmissionManager.getInstance().getWsServerRequest(this.m_oJob.getFQID());
                if (this.m_WsServerRequest == null) {
                    this.m_WsServerRequest = WsJobSubmissionManager.getInstance().makeWsServerRequest((CMetadata)this.m_oJob);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        this.m_bGenerateCode = true;
        this.m_lstnrServerRequest = this.createServerRequestDataChangedListener();
        this.m_WsServerRequest.addPropertyChangeListener(this.m_lstnrServerRequest);
        this.m_lstnrWsAppServerEvent = this.createWsAppServerEventListener();
        this.m_WsServerRequest.addcWsAppServerEventListener(this.m_lstnrWsAppServerEvent);
        this.createActions();
        this.updateActions();
    }

    public PFDCodegenEditorPropertyTab(TransformationStep oTS) {
        this.m_oTS = oTS;
        if (this.m_oTS != null) {
            this.m_WsServerRequest = new WsServerRequest((CMetadata)this.m_oTS);
        }
        this.m_bGenerateCode = true;
        this.createActions();
        this.updateActions();
    }

    public void moveDataToView() throws MdException, RemoteException {
        String defaultWsAppServerId = WsAppServer.getDefaultAppServerFQID();
        if (!this.m_bFromGenerateAction) {
            if (defaultWsAppServerId != "" && this.m_WsAppServer != null && !defaultWsAppServerId.equals(this.m_WsAppServer.getServerContext().getId())) {
                this.setGenerateCode(true);
            }
        } else {
            this.setFromGenerateAction(false);
        }
        if (this.m_bGenerateCode) {
            this.generateCode(false, true);
        }
    }

    public boolean canClose() {
        if (this.m_WsServerRequest != null && (this.m_WsServerRequest.getPropertyString("jobstatus").equals(WsServerRequest.JOBCANCELINPROGRESS) || this.m_WsServerRequest.getPropertyString("jobstatus").equals(WsServerRequest.JOBRUNNING))) {
            String sMessage = null;
            String sTitle = null;
            try {
                sTitle = this.m_oJob != null ? this.m_oJob.getName() + ": " + bundle.getString("PFDCodegenEditorPropertyTab.CanNotCloseTitle.txt") : bundle.getString("PFDCodegenEditorPropertyTab.CanNotCloseTitle.txt");
                sMessage = this.m_WsServerRequest.getPropertyString("jobstatus").equals(WsServerRequest.JOBCANCELINPROGRESS) ? bundle.getString("PFDCodegenEditorPropertyTab.CanNotCloseCancellingMessage.txt") : bundle.getString("PFDCodegenEditorPropertyTab.CanNotCloseRunningMessage.txt");
                MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)1, (int)-1);
                return false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return true;
    }

    public void setGenerateCode(boolean bGenerateCode) {
        this.m_bGenerateCode = bGenerateCode;
    }

    public void setFromGenerateAction(boolean bGenerateAction) {
        this.m_bFromGenerateAction = bGenerateAction;
    }

    public boolean willGenerateCode() {
        return this.m_bGenerateCode;
    }

    public boolean generationFailed() {
        return this.m_codegenFailed;
    }

    public int generateCode(boolean submitPending, boolean promptUser) {
        int status;
        block22: {
            if (this.m_WsServerRequest != null && this.m_WsServerRequest.getPropertyString("jobstatus").equalsIgnoreCase(WsServerRequest.JOBRUNNING)) {
                return 2;
            }
            status = 0;
            if (this.m_WsAppServer == null) {
                this.createServers();
            } else {
                String defaultWsAppServerId = this.m_WsServerRequest.getDefaultWsAppServerId();
                try {
                    if (defaultWsAppServerId == "" || defaultWsAppServerId.equals(this.m_WsAppServer.getServerContext().getId()) && !this.getAppServerRefreshed()) break block22;
                    this.setAppServerRefreshed(false);
                    int eAnswer = MessageUtil.displayMessage((String)bundle.getString("PFDCodegenEditorPropertyTab.ChangeAppServerMessage.txt"), (String)bundle.getString("PFDCodegenEditorPropertyTab.ChangeAppServerTitle.txt"), (int)1, (int)0);
                    if (eAnswer != 0) break block22;
                    try {
                        this.m_view.updateTitleWithDefaultAppServerChanges();
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    this.refreshAppServer();
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        if (this.m_oJob != null) {
            this.m_CodegenRequest = new CodegenRequest((CMetadata)this.m_oJob, this.m_WsAppServer, 1, true, (ParametersInterface)new ParametersModel());
        } else if (this.m_oTS != null) {
            this.m_CodegenRequest = new CodegenRequest((CMetadata)this.m_oTS, this.m_WsAppServer, 0, true, (ParametersInterface)new ParametersModel());
        } else {
            return 2;
        }
        if (this.hasDataChanged() && promptUser) {
            status = this.shouldRegenerate(submitPending);
            if (status != 0) {
                return status;
            }
            status = this.promptedSave();
            if (status == 2) {
                return status;
            }
        }
        this.setListeningForChanges(false);
        this.m_cmpEditor.setText("");
        OpRequestUI cgOpRequestUI = new OpRequestUI((Component)((Object)this), bundle.getString("PFDCodegenEditorPropertyTab.GeneratingCode.txt"), this.getName());
        cgOpRequestUI.setDelayBeforeProgressCancelDialog(300);
        cgOpRequestUI.setProgressShownOnStatusBar(false);
        cgOpRequestUI.execute(this.createCodegenRunnable());
        if (this.m_CodegenRequest != null) {
            this.m_txtEditor.setText(this.m_CodegenRequest.getSource());
        }
        this.m_txtEditor.setCaretPosition(0);
        this.setGenerateCode(false);
        if (submitPending) {
            this.m_view.setListenForDefaultAppServerChanges(false);
            this.setListenForDefaultAppServerChanges(false);
        }
        this.setDataChanged(false);
        this.setListeningForChanges(true);
        this.m_codegenFailed = false;
        if (this.m_CodegenRequest != null) {
            boolean bl = this.m_codegenFailed = this.m_CodegenRequest.getRC() == -1;
        }
        if (this.m_codegenFailed) {
            String sTitle = null;
            try {
                sTitle = this.m_oJob != null ? this.m_oJob.getName() + ": " + bundle.getString("PFDCodegenEditorPropertyTab.CodegenError.title.txt") : bundle.getString("PFDCodegenEditorPropertyTab.CodegenError.title.txt");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            MessageUtil.displayMessage((String)this.m_CodegenRequest.getErrorMessage(), (String)sTitle, (int)0, (int)-1);
            this.m_CodegenRequest.cleanupCodeGen();
            this.m_CodegenRequest = null;
            return 2;
        }
        if (this.m_CodegenRequest != null) {
            this.m_CodegenRequest.cleanupCodeGen();
        }
        this.m_CodegenRequest = null;
        return 0;
    }

    public void submitCode() {
        block18: {
            boolean success = true;
            if (this.willGenerateCode() || this.generationFailed() && !this.hasDataChanged()) {
                boolean bl = success = this.generateCode(true, true) != 2;
            }
            if (!success) {
                return;
            }
            String defaultWsAppServerId = this.m_WsServerRequest.getDefaultWsAppServerId();
            String sSelectedSubmitType = SubmitType.getInstance().getSelectedSubmitType();
            try {
                if (this.m_WsServerRequest.getSubmitType() == null || this.m_WsServerRequest.getPropertyString("jobstatus").length() == 0 || this.m_WsServerRequest.getPropertyString("jobstatus").length() > 0 && defaultWsAppServerId.equals(this.m_WsAppServer.getServerContext().getId())) {
                    this.m_WsServerRequest.setSubmitType(sSelectedSubmitType);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (this.m_WsAppServer == null) {
                this.createServers();
            } else {
                try {
                    int eAnswer;
                    if (defaultWsAppServerId == "" || defaultWsAppServerId.equals(this.m_WsAppServer.getServerContext().getId()) || (eAnswer = MessageUtil.displayMessage((String)bundle.getString("PFDCodegenEditorPropertyTab.ChangeAppServerMessage.txt"), (String)bundle.getString("PFDCodegenEditorPropertyTab.ChangeAppServerTitle.txt"), (int)1, (int)0)) != 0) break block18;
                    try {
                        this.m_view.updateTitleWithDefaultAppServerChanges();
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    this.refreshAppServer();
                    if (!this.m_WsServerRequest.getSubmitType().equalsIgnoreCase(sSelectedSubmitType)) {
                        this.m_WsServerRequest.setSubmitType(sSelectedSubmitType);
                    }
                    this.generateCode(true, true);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        if (this.m_WsAppServer == null) {
            return;
        }
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        if (defaultsFile.getPropertyBoolean("Workspace.ClearLogBeforeSubmit", false)) {
            if (this.m_tabLog != null && this.m_view.isLogTabPresent()) {
                this.m_tabLog.clear();
            }
            if (this.m_tabOutput != null && this.m_view.isOutputTabPresent()) {
                this.m_tabOutput.clear();
            }
        }
        if (this.m_SASCodeGeneration == null) {
            this.m_SASCodeGeneration = new SASCodeGeneration();
        }
        this.submitCodeToAppServer(this.getSASCode());
    }

    protected boolean submitCodeToAppServer(String sSASCode) {
        Workspace.getDefaultLogger().info((Object)"----- Submitting -----");
        String sSelectedSubmitType = this.m_WsServerRequest.getSubmitType();
        StringBuffer sbGridCode = new StringBuffer();
        try {
            StringBuffer prefixCode = this.m_SASCodeGeneration.getSubmitToGridPrefix((CMetadata)this.m_oJob, this.m_WsAppServer.getServerContext(), sSelectedSubmitType);
            if (prefixCode != null) {
                sbGridCode.append(prefixCode);
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (sbGridCode.length() > 0) {
            sbGridCode.append("\n").append(sSASCode).append("\n").append(this.m_SASCodeGeneration.getSubmitToGridSuffix(this.m_WsAppServer.getServerContext(), sSelectedSubmitType));
            Workspace.getDefaultLogger().info((Object)sbGridCode.toString());
            Workspace.getDefaultLogger().info((Object)"----------------------");
            this.m_WsServerRequest.setCodeToSubmit(sbGridCode.toString());
        } else {
            Workspace.getDefaultLogger().info((Object)sSASCode);
            Workspace.getDefaultLogger().info((Object)"----------------------");
            this.m_WsServerRequest.setCodeToSubmit(sSASCode);
        }
        this.m_WsServerRequest.setWsAppServer(this.m_WsAppServer);
        this.m_actSubmit.setEnabled(false);
        SubmitType.getInstance().setEnabled(false);
        this.setSubmitActionActive(false);
        this.m_actTerminate.setEnabled(true);
        this.m_actKill.setEnabled(true);
        WsEditorOMAView view = this.getOwningView();
        if (view instanceof WAPFDEditorOMAView) {
            WAPFDEditorOMAView pfdView = (WAPFDEditorOMAView)view;
            this.m_PFDPanel = pfdView.getPFDPanel();
            if (this.m_PFDPanel != null) {
                this.m_PFDPanel.m_actSubmit.setEnabled(false);
                SubmitType.getInstance().setEnabled(false);
                this.m_PFDPanel.m_actTerminate.setEnabled(true);
                this.m_PFDPanel.m_actKill.setEnabled(true);
            }
        }
        this.m_WsServerRequest.startCodeSubmit();
        return true;
    }

    protected void createServers() {
        try {
            if (this.m_WsAppServer == null) {
                if (this.m_WsServerRequest == null) {
                    this.m_WsServerRequest = WsJobSubmissionManager.getInstance().getWsServerRequest(this.m_oJob.getFQID());
                    if (this.m_oJob != null) {
                        this.m_WsServerRequest = WsJobSubmissionManager.getInstance().makeWsServerRequest((CMetadata)this.m_oJob);
                        this.m_WsServerRequest.addPropertyChangeListener(this.createServerRequestDataChangedListener());
                    } else if (this.m_oTS != null) {
                        this.m_WsServerRequest = new WsServerRequest((CMetadata)this.m_oTS);
                    }
                }
                this.m_bAppServerCreateStarted = true;
                this.m_WsAppServer = this.m_WsServerRequest.getAppServer();
                this.m_bAppServerCreateStarted = false;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void refreshAppServer() {
        if (!this.m_bAppServerCreateStarted) {
            if (this.m_WsAppServer != null) {
                this.m_WsAppServer = null;
            }
            this.m_WsAppServer = this.m_WsServerRequest.refreshWsAppServer();
            String lastStatus = this.m_view.getLastAppServerStatus();
            if (this.isVisible() && (this.m_bGenerateCode || lastStatus == null || lastStatus.equalsIgnoreCase(""))) {
                this.generateCode(false, true);
            } else {
                this.setGenerateCode(true);
            }
            try {
                this.m_view.updateTitleWithDefaultAppServerChanges();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_WsServerRequest != null) {
            if (this.m_oJob != null) {
                WsJobSubmissionManager.getInstance().clearServerRequest(this.m_WsServerRequest.getMetadataFQID());
            } else {
                this.m_WsServerRequest.termWsServerRequest();
            }
            this.m_WsServerRequest = null;
            this.m_WsAppServer = null;
        }
        super.saveSettingsAndCleanUp();
    }

    protected void submitFinished(String sJobStatus) {
        Workspace work;
        block14: {
            String sTitle;
            work = Workspace.getWorkspace();
            this.m_actSubmit.setEnabled(true);
            SubmitType.getInstance().setEnabled(true);
            this.setSubmitActionActive(true);
            this.m_actTerminate.setEnabled(false);
            this.m_actKill.setEnabled(false);
            if (this.m_PFDPanel != null) {
                this.m_PFDPanel.m_actSubmit.setEnabled(true);
                SubmitType.getInstance().setEnabled(true);
                this.m_PFDPanel.m_actTerminate.setEnabled(false);
                this.m_PFDPanel.m_actKill.setEnabled(false);
            }
            if (!sJobStatus.equals(WsServerRequest.JOBCANCELLED) && this.m_WsServerRequest.getPropertyInt("status") != 0) {
                String sError = bundle.getString("PFDCodegenEditorPropertyTab.Msg.SubFail.txt") + " " + this.m_WsServerRequest.getMessage();
                Workspace.getDefaultLogger().warn((Object)sError);
                work.setStatusText(sError);
                work.getMessagesWindow().addMessage(sError);
                sTitle = "";
                try {
                    if (this.m_oJob != null) {
                        sTitle = this.m_oJob.getName() + ": " + bundle.getString("Common.Error.txt");
                        MessageUtil.displayMessage((String)sError, (String)sTitle, (int)0);
                    } else {
                        MessageUtil.displayMessage((String)sError, (int)0);
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            try {
                LogListHolder hldrOutput;
                LogListHolder hldrLog;
                if (this.m_tabLog != null && this.m_view.isLogTabPresent() && (hldrLog = this.m_WsServerRequest.getLogText()) != null) {
                    this.m_tabLog.appendText(hldrLog);
                }
                if (this.m_tabOutput != null && this.m_view.isOutputTabPresent() && (hldrOutput = this.m_WsServerRequest.getOutputText()) != null) {
                    this.m_tabOutput.appendText(hldrOutput);
                }
            }
            catch (WsAppServerFailException e) {
                if (this.m_WsAppServer.isKilled()) break block14;
                sTitle = "";
                try {
                    if (this.m_oJob != null) {
                        sTitle = this.m_oJob.getName() + ": " + bundle.getString("Common.Error.txt");
                        MessageUtil.displayMessage((String)e.getMessage(), (String)sTitle, (int)0);
                    } else {
                        MessageUtil.displayMessage((String)e.getMessage(), (int)0);
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        work.clearStatusText();
    }

    public void terminateRunningCode() {
        try {
            WsJobSubmissionManager.getInstance().termWsServerRequestCode(this.m_oJob.getFQID());
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void killAppServer() {
        try {
            WsJobSubmissionManager.getInstance().killAppServer(this.m_oJob.getFQID());
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected Runnable createCodegenRunnable() {
        return new cCodegenRunnable();
    }

    public String getTabTypeName() {
        return bundle.getString("PFDCodegenEditorPropertyTab.ViewName.txt");
    }

    protected void createActions() {
        super.createActions();
    }

    protected void updateActions() {
        super.updateActions();
        if (this.m_actSubmit.isEnabled()) {
            SubmitType.getInstance().setEnabled(true);
            this.m_actTerminate.setEnabled(false);
            this.m_actKill.setEnabled(false);
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        if (this.isSubmitActionVisible()) {
            this.m_actTerminate.setActive(bActive);
            this.m_actKill.setActive(bActive);
            if (this.m_actSubmit.isEnabled()) {
                SubmitType.getInstance().setEnabled(true);
                this.m_actTerminate.setEnabled(false);
                this.m_actKill.setEnabled(false);
            }
        }
    }

    protected WsAbstractAction createKillAction() {
        return new cKillAction();
    }

    protected WsAbstractAction createTerminateAction() {
        return new cTerminateAction();
    }

    public int shouldRegenerate(boolean submitPending) {
        try {
            return MessageUtil.displayMessage((String)bundle.formatString("PFDCodegenEditorPropertyTab.RegenerateCode.txt", (Object)(this.m_oJob != null ? this.m_oJob.getName() : this.m_oTS.getName())), (String)this.getName(), (int)1, (int)(submitPending ? 1 : 0));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return -1;
        }
    }

    public PropertyChangeListener createDataChangedListener() {
        return new cDataChangedListener();
    }

    public PropertyChangeListener createServerRequestDataChangedListener() {
        return new cServerRequestDataChangedListener();
    }

    protected class cServerRequestDataChangedListener
    implements PropertyChangeListener {
        protected cServerRequestDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equalsIgnoreCase(WsServerRequest.DISPOSED)) {
                PFDCodegenEditorPropertyTab.this.m_WsServerRequest = null;
                PFDCodegenEditorPropertyTab.this.m_WsAppServer = null;
                return;
            }
            if (e.getPropertyName().equalsIgnoreCase("jobstatus")) {
                try {
                    String sAppServerName = null;
                    if (PFDCodegenEditorPropertyTab.this.m_WsServerRequest != null) {
                        sAppServerName = PFDCodegenEditorPropertyTab.this.m_WsServerRequest.getWsAppServerName();
                    }
                    if (sAppServerName == null) {
                        sAppServerName = "";
                    }
                    PFDCodegenEditorPropertyTab.this.m_view.updateTitleWithStatusChanges(e.getNewValue().toString(), PFDCodegenEditorPropertyTab.this.m_oJob.getName(), sAppServerName);
                    if (e.getNewValue().equals(WsServerRequest.JOBABORTED) || e.getNewValue().equals(WsServerRequest.JOBERRORED) || e.getNewValue().equals(WsServerRequest.JOBKILLED) || e.getNewValue().equals(WsServerRequest.JOBTERMINATED) || e.getNewValue().equals(WsServerRequest.JOBSUCCESSFUL) || e.getNewValue().equals(WsServerRequest.JOBCANCELLED)) {
                        SwingUtilities.invokeLater(new cSubmitFinishRunnable((String)e.getNewValue()));
                    }
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    protected class cDataChangedListener
    implements PropertyChangeListener {
        protected cDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equalsIgnoreCase("DataChanged")) {
                PFDCodegenEditorPropertyTab.this.setGenerateCode(true);
            }
        }
    }

    protected class cKillAction
    extends WsAbstractAction {
        public cKillAction() {
            super(bundle, "PFDPanel.Kill", true);
            this.setMenuSupportId("killjob");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("PFDCodegenEditorPropertyTab.ConfirmKillMessage.txt"), (String)bundle.getString("PFDCodegenEditorPropertyTab.ConfirmKillTitle.txt"), (int)1, (int)0);
            if (eAnswer == 1) {
                return;
            }
            if (!PFDCodegenEditorPropertyTab.this.m_WsAppServer.isKilled()) {
                PFDCodegenEditorPropertyTab.this.killAppServer();
            }
        }
    }

    protected class cTerminateAction
    extends WsAbstractAction {
        public cTerminateAction() {
            super(bundle, "PFDPanel.Terminate", true);
            this.setMenuSupportId("terminatejob");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("PFDCodegenEditorPropertyTab.ConfirmCancelMessage.txt"), (String)bundle.getString("PFDCodegenEditorPropertyTab.ConfirmCancelTitle.txt"), (int)1, (int)0);
            if (eAnswer == 1) {
                return;
            }
            PFDCodegenEditorPropertyTab.this.terminateRunningCode();
        }
    }

    protected class cSubmitFinishRunnable
    implements Runnable {
        private String m_sJobStatus;

        public cSubmitFinishRunnable(String sJobStatus) {
            this.m_sJobStatus = sJobStatus;
        }

        @Override
        public void run() {
            PFDCodegenEditorPropertyTab.this.submitFinished(this.m_sJobStatus);
        }
    }

    protected class cCodegenRunnable
    implements Runnable {
        protected cCodegenRunnable() {
        }

        @Override
        public void run() {
            PFDCodegenEditorPropertyTab.this.m_CodegenRequest.doCodegen();
        }
    }
}

