/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Variable;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.PFDDnDAdapter;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.plugins.StopAutomaticMappingInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformUnionInterface;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class MappingUtil {
    private static boolean m_stopAutoMapping = false;
    private static DataTable m_oMiningTargetTable;

    public static boolean isAutoMapEnabled(TransformationStep object) throws MdException, RemoteException {
        AssociationList sets = object.getPropertySets();
        for (int i = 0; i < sets.size(); ++i) {
            PropertySet set = (PropertySet)sets.get(i);
            if (!set.getName().equalsIgnoreCase("AUTOMAP")) continue;
            AssociationList extensions = set.getExtensions();
            if (extensions.size() == 0) {
                return true;
            }
            Extension extension = (Extension)set.getExtensions().get(0);
            return !extension.getValue().equalsIgnoreCase("off");
        }
        return true;
    }

    public static void quickMap(CMetadata inputObject, CMetadata outputObject) throws MdException, RemoteException {
        if (((DataTable)outputObject).getTargetClassifierMaps(false).size() == 0) {
            return;
        }
        ClassifierMap map = (ClassifierMap)((DataTable)outputObject).getTargetClassifierMaps(false).get(0);
        if (map.getSteps(false).size() == 0) {
            return;
        }
        TransformationStep step = (TransformationStep)map.getSteps(false).get(0);
        if (!MappingUtil.isAutoMapEnabled(step)) {
            return;
        }
        TransformInterface transformInterface = WAPFDTransformNodeModel.getInterfaceClass(step);
        if (!(transformInterface instanceof TransformUnionInterface)) {
            ArrayList unmappedTargetColumns = MappingUtil.findUnmappedTargets((DataTable)outputObject);
            block0: for (int i = 0; i < unmappedTargetColumns.size(); ++i) {
                Column targetColumn = (Column)unmappedTargetColumns.get(i);
                AssociationList inputColumns = ((DataTable)inputObject).getColumns(false);
                for (int j = 0; j < inputColumns.size(); ++j) {
                    Column sourceColumn = (Column)inputColumns.get(j);
                    if (sourceColumn == null || !targetColumn.getSASColumnName().equalsIgnoreCase(sourceColumn.getSASColumnName()) || !targetColumn.getSASColumnType().equalsIgnoreCase(sourceColumn.getSASColumnType()) || targetColumn.getSASColumnLength() < sourceColumn.getSASColumnLength()) continue;
                    MappingUtil.addFeatureMap(sourceColumn, targetColumn, (DataTable)outputObject);
                    continue block0;
                }
            }
        } else {
            AssociationList targetColumns = ((DataTable)outputObject).getColumns(false);
            AssociationList sourceColumns = ((DataTable)inputObject).getColumns(false);
            block2: for (int i = 0; i < targetColumns.size(); ++i) {
                Column targetColumn = (Column)targetColumns.get(i);
                for (int j = 0; j < sourceColumns.size(); ++j) {
                    Column sourceColumn = (Column)sourceColumns.get(j);
                    if (!targetColumn.getSASColumnName().equalsIgnoreCase(sourceColumn.getSASColumnName()) || !targetColumn.getSASColumnType().equalsIgnoreCase(sourceColumn.getSASColumnType()) || targetColumn.getSASColumnLength() < sourceColumn.getSASColumnLength()) continue;
                    if (targetColumn.getTargetFeatureMaps(false).size() > 0) {
                        FeatureMap featureMap = (FeatureMap)targetColumn.getTargetFeatureMaps(false).get(0);
                        featureMap.getFeatureSources(false).add((Object)sourceColumn);
                        featureMap.setTransformRole("MANYTOONE");
                        continue block2;
                    }
                    MappingUtil.addFeatureMap(sourceColumn, targetColumn, (DataTable)outputObject);
                    continue block2;
                }
            }
        }
    }

    public static void quickMap(DataTable inputObject, DataTable outputObject, ClassifierMap oCM) throws MdException, RemoteException {
        if (oCM.getSteps(false).isEmpty()) {
            return;
        }
        TransformationStep step = (TransformationStep)oCM.getSteps().get(0);
        if (!MappingUtil.isAutoMapEnabled(step)) {
            return;
        }
        ArrayList unmappedTargetColumns = MappingUtil.findUnmappedTargets(outputObject);
        block0: for (int i = 0; i < unmappedTargetColumns.size(); ++i) {
            Column targetColumn = (Column)unmappedTargetColumns.get(i);
            AssociationList inputColumns = inputObject.getColumns(false);
            for (int j = 0; j < inputColumns.size(); ++j) {
                Column sourceColumn = (Column)inputColumns.get(j);
                if (!targetColumn.getSASColumnName().equalsIgnoreCase(sourceColumn.getSASColumnName()) || !targetColumn.getSASColumnType().equalsIgnoreCase(sourceColumn.getSASColumnType()) || targetColumn.getSASColumnLength() < sourceColumn.getSASColumnLength()) continue;
                MappingUtil.addFeatureMap(sourceColumn, targetColumn, oCM);
                continue block0;
            }
        }
    }

    public static void quickMapForSQL(DataTable inputObject, DataTable outputObject, ClassifierMap oCM) throws MdException, RemoteException {
        ArrayList unmappedTargetColumns = MappingUtil.findUnmappedTargetsForSQL(outputObject, oCM);
        block0: for (int i = 0; i < unmappedTargetColumns.size(); ++i) {
            Column targetColumn = (Column)unmappedTargetColumns.get(i);
            AssociationList inputColumns = inputObject.getColumns(false);
            for (int j = 0; j < inputColumns.size(); ++j) {
                Column sourceColumn = (Column)inputColumns.get(j);
                if (!targetColumn.getSASColumnName().equalsIgnoreCase(sourceColumn.getSASColumnName()) || !targetColumn.getSASColumnType().equalsIgnoreCase(sourceColumn.getSASColumnType()) || targetColumn.getSASColumnLength() < sourceColumn.getSASColumnLength()) continue;
                MappingUtil.addFeatureMap(sourceColumn, targetColumn, oCM);
                continue block0;
            }
        }
    }

    protected static void addFeatureMap(Column inputObject, Column outputObject, ClassifierMap oCM) throws MdException, RemoteException {
        String reposFQID = Workspace.getWorkspace().getDefaultRepositoryId();
        FeatureMap featureMap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)oCM.getObjectStore(), null, "newmap", "FeatureMap", reposFQID);
        oCM.getFeatureMaps().add((Object)featureMap);
        featureMap.getFeatureSources().add((Object)inputObject);
        featureMap.getFeatureTargets().add((Object)outputObject);
        featureMap.setTransformRole("ONETOONE");
    }

    protected static void addFeatureMap(Column inputObject, Column outputObject, DataTable outputTable) {
        try {
            String reposFQID = Workspace.getWorkspace().getDefaultRepository().getFQID().substring(9);
            FeatureMap featureMap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)outputTable.getObjectStore(), null, "newmap", "FeatureMap", reposFQID);
            ClassifierMap map = (ClassifierMap)outputTable.getTargetClassifierMaps(false).get(0);
            map.getFeatureMaps().add((Object)featureMap);
            featureMap.getFeatureSources().add((Object)inputObject);
            featureMap.getFeatureTargets().add((Object)outputObject);
            featureMap.setTransformRole("ONETOONE");
            outputTable.addElementToChangeList((CMetadata)featureMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList findUnmappedTargets(DataTable targettable) {
        ArrayList<Object> unmappedColumns = new ArrayList<Object>();
        try {
            if (targettable.getTargetClassifierMaps(false).size() == 0) {
                return unmappedColumns;
            }
            ClassifierMap map = (ClassifierMap)targettable.getTargetClassifierMaps(false).get(0);
            String mapOfTransformID = map.getFQID();
            AssociationList columns = targettable.getColumns(false);
            for (int i = 0; i < columns.size(); ++i) {
                Column col = (Column)columns.get(i);
                boolean isFound = false;
                AssociationList alTargetFMs = col.getTargetFeatureMaps(false);
                for (int j = 0; j < alTargetFMs.size(); ++j) {
                    ClassifierMap mapOfFeature;
                    FeatureMap fm = (FeatureMap)alTargetFMs.get(j);
                    String role = fm.getTransformRole();
                    if (!role.equalsIgnoreCase("ONETOONE") && !role.equalsIgnoreCase("DERIVED") || fm.getAssociatedClassifierMaps().size() <= 0 || !(mapOfFeature = (ClassifierMap)fm.getAssociatedClassifierMaps().get(0)).getFQID().equalsIgnoreCase(mapOfTransformID)) continue;
                    isFound = true;
                    break;
                }
                if (isFound || col.getName().compareToIgnoreCase("_LOADTM") == 0) continue;
                unmappedColumns.add(columns.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unmappedColumns;
    }

    public static ArrayList findUnmappedTargetsForSQL(DataTable targettable, ClassifierMap map) {
        ArrayList<Object> unmappedColumns = new ArrayList<Object>();
        try {
            String mapOfTransformID = map.getFQID();
            AssociationList columns = targettable.getColumns(false);
            for (int i = 0; i < columns.size(); ++i) {
                Column col = (Column)columns.get(i);
                boolean isFound = false;
                AssociationList alTargetFMs = col.getTargetFeatureMaps(false);
                for (int j = 0; j < alTargetFMs.size(); ++j) {
                    ClassifierMap mapOfFeature;
                    FeatureMap fm = (FeatureMap)alTargetFMs.get(j);
                    String role = fm.getTransformRole();
                    if (!role.equalsIgnoreCase("ONETOONE") && !role.equalsIgnoreCase("DERIVED") || fm.getAssociatedClassifierMaps().size() <= 0 || !(mapOfFeature = (ClassifierMap)fm.getAssociatedClassifierMaps().get(0)).getFQID().equalsIgnoreCase(mapOfTransformID)) continue;
                    isFound = true;
                    break;
                }
                if (isFound || col.getName().compareToIgnoreCase("_LOADTM") == 0) continue;
                unmappedColumns.add(columns.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unmappedColumns;
    }

    public static void createColumnMappings(DataTable input, DataTable output) throws MdException, RemoteException {
        MappingUtil.buildCols(input, output);
        MappingUtil.quickMap((CMetadata)input, (CMetadata)output);
    }

    public static void createColumnMappings(DataTable input, DataTable output, ClassifierMap map) throws MdException, RemoteException {
        MappingUtil.buildCols(input, output);
        MappingUtil.quickMapForSQL(input, output, map);
    }

    public static void createColumnMappings(DataTable input, DataTable output, boolean bool) throws MdException, RemoteException {
        HashMap newCols = MappingUtil.buildCols(input, output);
        AssociationList maps = output.getSourceClassifierMaps(false);
        if (MappingUtil.isTerminated(output)) {
            ClassifierMap previousMap = (ClassifierMap)input.getSourceClassifierMaps(false).get(0);
            for (int i = 0; i < maps.size(); ++i) {
                ClassifierMap existingMap = (ClassifierMap)maps.get(i);
                MappingUtil.remapUsingSourceColumns(existingMap, newCols, previousMap, false);
            }
            MappingUtil.quickMap((CMetadata)input, (CMetadata)output);
        }
    }

    public static void rebuildFeatureMapsOnDelete(TransformationStep stepToRemove) throws MdException, RemoteException {
        MappingUtil.rebuildFeatureMapsOnDelete(stepToRemove, null, null);
    }

    public static void rebuildFeatureMapsOnDelete(TransformationStep stepToRemove, TransformationStep nextStep, TransformationStep nextStepAfterDataStep) throws MdException, RemoteException {
        AssociationList lSPs = stepToRemove.getPredecessorDependencies(false);
        if (lSPs.size() == 0 && nextStep instanceof SyncStep && nextStepAfterDataStep != null) {
            AssociationList lTargCMs = nextStepAfterDataStep.getTransformations(false);
            for (int k = 0; k < lTargCMs.size(); ++k) {
                if (!(lTargCMs.get(k) instanceof ClassifierMap)) continue;
                ClassifierMap iTargCM = (ClassifierMap)lTargCMs.get(k);
                AssociationList lRemCMs = stepToRemove.getTransformations(false);
                for (int l = 0; l < lRemCMs.size(); ++l) {
                    ClassifierMap iRemCM = (ClassifierMap)lRemCMs.get(l);
                    AssociationList lInputTabs = iRemCM.getClassifierSources(false);
                    for (int m = 0; m < lInputTabs.size(); ++m) {
                        DataTable iInputTable = (DataTable)lInputTabs.get(m);
                        HashMap<String, Column> newCols = new HashMap<String, Column>();
                        for (int ii = 0; ii < iInputTable.getColumns(false).size(); ++ii) {
                            Column iCol = (Column)iInputTable.getColumns(false).get(ii);
                            newCols.put(iCol.getSASColumnName(), iCol);
                        }
                        MappingUtil.remapUsingSourceColumns(iTargCM, newCols, iRemCM, true);
                    }
                }
            }
        } else {
            for (int i = 0; i < lSPs.size(); ++i) {
                StepPrecedence iSP = (StepPrecedence)lSPs.get(i);
                AssociationList lTargSteps = iSP.getSuccessors(false);
                for (int j = 0; j < lTargSteps.size(); ++j) {
                    TransformationStep targetStep = (TransformationStep)lTargSteps.get(j);
                    AssociationList lTargCMs = targetStep.getTransformations(false);
                    for (int k = 0; k < lTargCMs.size(); ++k) {
                        if (!(lTargCMs.get(k) instanceof ClassifierMap)) continue;
                        ClassifierMap iTargCM = (ClassifierMap)lTargCMs.get(k);
                        AssociationList lRemCMs = stepToRemove.getTransformations(false);
                        for (int l = 0; l < lRemCMs.size(); ++l) {
                            ClassifierMap iRemCM = (ClassifierMap)lRemCMs.get(l);
                            AssociationList lInputTabs = iRemCM.getClassifierSources(false);
                            for (int m = 0; m < lInputTabs.size(); ++m) {
                                DataTable iInputTable = (DataTable)lInputTabs.get(m);
                                HashMap<String, Column> newCols = new HashMap<String, Column>();
                                for (int ii = 0; ii < iInputTable.getColumns(false).size(); ++ii) {
                                    Column iCol = (Column)iInputTable.getColumns(false).get(ii);
                                    newCols.put(iCol.getSASColumnName(), iCol);
                                }
                                MappingUtil.remapUsingSourceColumns(iTargCM, newCols, iRemCM, true);
                            }
                        }
                    }
                }
            }
        }
    }

    private static void remapUsingSourceColumns(ClassifierMap existingMap, HashMap newCols, ClassifierMap oldMap, boolean onDelete) throws MdException, RemoteException {
        AssociationList lOrderBys;
        Column iNewCol;
        String name;
        boolean fMultipleInputs = false;
        if (existingMap.getClassifierSources(false).size() > 1) {
            fMultipleInputs = true;
        }
        AssociationList FMs = existingMap.getFeatureMaps(false);
        for (int i = 0; i < FMs.size(); ++i) {
            FeatureMap FM = (FeatureMap)FMs.get(i);
            AssociationList srcs = FM.getFeatureSources(false);
            for (int k = 0; k < srcs.size(); ++k) {
                Column iOldCol = (Column)srcs.get(k);
                if (fMultipleInputs && !MappingUtil.columnAffected(iOldCol, oldMap, onDelete)) continue;
                name = iOldCol.getSASColumnName();
                iNewCol = null;
                if (newCols != null && newCols.size() > 0) {
                    iNewCol = (Column)newCols.get(name);
                }
                if (iNewCol == null) continue;
                FM.getFeatureSources(false).remove(k);
                FM.getFeatureSources(false).add(k, (Object)iNewCol);
            }
            AssociationList subVars = FM.getSubstitutionVariables(false);
            for (int k = 0; k < subVars.size(); ++k) {
                String name2;
                Column iNewCol2;
                Variable iVar = (Variable)subVars.get(k);
                Column iOldCol = (Column)iVar.getAssociatedObjects(false).get(0);
                if (fMultipleInputs && !MappingUtil.columnAffected(iOldCol, oldMap, onDelete) || (iNewCol2 = (Column)newCols.get(name2 = iOldCol.getSASColumnName())) == null) continue;
                iVar.getAssociatedObjects(false).remove(0);
                iVar.getAssociatedObjects(false).add(0, (Object)iNewCol2);
            }
        }
        if (existingMap instanceof Select && (lOrderBys = ((Select)existingMap).getOrderByForSelects(false)).size() > 0) {
            OrderByClause iOrderBy = (OrderByClause)lOrderBys.get(0);
            AssociationList lOrderByCols = iOrderBy.getColumns(false);
            for (int i = 0; i < lOrderByCols.size(); ++i) {
                Column iOldCol = (Column)lOrderByCols.get(i);
                if (fMultipleInputs && !MappingUtil.columnAffected(iOldCol, oldMap, onDelete) || (iNewCol = (Column)newCols.get(name = iOldCol.getSASColumnName())) == null) continue;
                iOrderBy.getColumns(false).remove(i);
                iOrderBy.getColumns(false).add(i, (Object)iNewCol);
            }
        }
        AssociationList lSubVars = existingMap.getSubstitutionVariables(false);
        for (int i = 0; i < lSubVars.size(); ++i) {
            Variable iVar = (Variable)lSubVars.get(i);
            Object iObj = iVar.getAssociatedObjects(false).size() == 0 ? iVar.getMarker() : iVar.getAssociatedObjects(false).get(0);
            if (!(iObj instanceof Column)) continue;
            Column iOldCol = (Column)iObj;
            if (fMultipleInputs && !MappingUtil.columnAffected(iOldCol, oldMap, onDelete) || (iNewCol = (Column)newCols.get(name = iOldCol.getSASColumnName())) == null) continue;
            iVar.getAssociatedObjects(false).remove(0);
            iVar.getAssociatedObjects(false).add(0, (Object)iNewCol);
        }
    }

    private static boolean columnAffected(Column iCol, ClassifierMap iMap, boolean onDelete) throws MdException, RemoteException {
        if (iCol == null || iMap == null) {
            return false;
        }
        if (!onDelete) {
            AssociationList lTabs = iMap.getClassifierSources(false);
            for (int i = 0; i < lTabs.size(); ++i) {
                DataTable iTab = (DataTable)lTabs.get(i);
                AssociationList lCols = iTab.getColumns(false);
                for (int j = 0; j < lCols.size(); ++j) {
                    if (!iCol.getId().equals(((Column)lCols.get(j)).getId())) continue;
                    return true;
                }
            }
        } else {
            AssociationList lTabs = iMap.getClassifierTargets(false);
            for (int i = 0; i < lTabs.size(); ++i) {
                DataTable iTab = (DataTable)lTabs.get(i);
                AssociationList lCols = iTab.getColumns(false);
                for (int j = 0; j < lCols.size(); ++j) {
                    if (!iCol.getId().equals(((Column)lCols.get(j)).getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static HashMap buildCols(DataTable input, DataTable output) throws MdException, RemoteException {
        HashMap newCols = new HashMap();
        if (output instanceof WorkTable) {
            if (MappingUtil.isTerminated(output)) {
                TransformationStep step;
                ClassifierMap map = (ClassifierMap)output.getTargetClassifierMaps(false).get(0);
                if (!map.getSteps().isEmpty() && !MappingUtil.isAutoMapEnabled(step = (TransformationStep)map.getSteps().get(0))) {
                    return newCols;
                }
                newCols = MappingUtil.makeCols(output, input);
            }
        } else if (output instanceof QueryTable) {
            newCols = MappingUtil.makeCols(output, input);
        }
        return newCols;
    }

    private static HashMap makeCols(DataTable tableToBuildColsFor, DataTable tableToBuildColsFrom) throws MdException, RemoteException {
        HashMap<String, Column> newCols = new HashMap<String, Column>();
        AssociationList cols = new Vector();
        if (tableToBuildColsFor != null && tableToBuildColsFrom != null) {
            AssociationList lFromCols = tableToBuildColsFrom.getColumns(false);
            if (lFromCols.size() <= 0) {
                return null;
            }
            AssociationList lToCols = tableToBuildColsFor.getColumns(false);
            if (lFromCols.size() > 0) {
                for (int i = 0; i < lFromCols.size(); ++i) {
                    boolean found = false;
                    Column iCol = (Column)lFromCols.get(i);
                    String iName = iCol.getSASColumnName();
                    for (int j = 0; j < lToCols.size(); ++j) {
                        Column oCol = (Column)lToCols.get(j);
                        String oName = oCol.getSASColumnName();
                        if (iName.compareToIgnoreCase(oName) != 0) continue;
                        found = true;
                        break;
                    }
                    for (int k = 0; k < cols.size(); ++k) {
                        Column selCol = (Column)cols.get(k);
                        String sName = selCol.getSASColumnName();
                        if (iName.compareToIgnoreCase(sName) != 0) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    cols.add(iCol);
                }
            } else {
                cols = lFromCols;
            }
        }
        for (int i = 0; i < cols.size(); ++i) {
            Column iCol = (Column)cols.get(i);
            if (iCol.getName().compareToIgnoreCase("_LOADTM") == 0) continue;
            Column iNewCol = (Column)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)tableToBuildColsFor.getObjectStore(), null, "Column" + i, "Column", tableToBuildColsFor.getRepositoryID());
            MdStoreUtil.copyObjectAttributes((CMetadata)iCol, (CMetadata)iNewCol, (int)1);
            tableToBuildColsFor.getColumns(false).add((Object)iNewCol);
            newCols.put(iNewCol.getSASColumnName(), iNewCol);
        }
        return newCols;
    }

    private static boolean stopAutoMapping(ClassifierMap map) throws MdException, RemoteException {
        m_stopAutoMapping = false;
        TransformationStep oStep = null;
        if (map.getSteps(false).isEmpty()) {
            return true;
        }
        oStep = (TransformationStep)map.getSteps(false).get(0);
        TransformInterface transformInterface = WAPFDTransformNodeModel.getInterfaceClass(oStep);
        if (!(transformInterface instanceof StopAutomaticMappingInterface)) {
            return false;
        }
        AssociationList alTargetTables = map.getClassifierTargets();
        if (!alTargetTables.isEmpty()) {
            m_oMiningTargetTable = (DataTable)alTargetTables.get(0);
        }
        AssociationList alSourceSpecifications = map.getSourceSpecifications(false);
        int nMiningResults = alSourceSpecifications.size();
        for (int iMiningResult = 0; iMiningResult < nMiningResults; ++iMiningResult) {
            Root oRoot = (Root)alSourceSpecifications.get(iMiningResult);
            if (!(oRoot instanceof MiningResult)) continue;
            return false;
        }
        return true;
    }

    public static void doAutomaticMappings(DataTable dropTable) throws MdException, RemoteException {
        Vector vSrcs = new Vector();
        MappingUtil.sourceTerminals(dropTable, vSrcs);
        for (int i = 0; i < vSrcs.size(); ++i) {
            MappingUtil.performMapping((DataTable)vSrcs.get(i));
        }
        Vector vTargs = new Vector();
        MappingUtil.targetTerminals(dropTable, vTargs);
        if (vTargs.size() > 0) {
            MappingUtil.performMapping(dropTable);
        }
    }

    private static void sourceTerminals(DataTable iTab, Vector ret) throws MdException, RemoteException {
        try {
            Vector temp = MappingUtil.getSources(iTab);
            for (int i = 0; i < temp.size(); ++i) {
                DataTable tab = (DataTable)temp.get(i);
                if (tab instanceof WorkTable && !((ClassifierMap)((WorkTable)tab).getSourceClassifierMaps(false).get(0)).getTransformRole().equals("Contents")) {
                    MappingUtil.sourceTerminals(tab, ret);
                    continue;
                }
                ret.add(tab);
            }
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void targetTerminals(DataTable iTab, Vector ret) throws MdException, RemoteException {
        try {
            Vector temp = MappingUtil.getTargets(iTab);
            for (int i = 0; i < temp.size(); ++i) {
                DataTable tab = (DataTable)temp.get(i);
                if (tab instanceof WorkTable) {
                    MappingUtil.targetTerminals(tab, ret);
                    continue;
                }
                ret.add(tab);
            }
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sourceCopyTerminals(DataTable iTab, Vector ret) throws MdException, RemoteException {
        try {
            Vector temp = MappingUtil.getSources(iTab);
            for (int i = 0; i < temp.size(); ++i) {
                DataTable tab = (DataTable)temp.get(i);
                if (tab instanceof WorkTable) {
                    MappingUtil.sourceCopyTerminals(tab, ret);
                    continue;
                }
                ret.add(tab);
            }
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void targetCopyTerminals(DataTable iTab, Vector ret) throws MdException, RemoteException {
        try {
            Vector temp = MappingUtil.getTargets(iTab);
            for (int i = 0; i < temp.size(); ++i) {
                DataTable tab = (DataTable)temp.get(i);
                if (tab instanceof WorkTable) {
                    MappingUtil.targetCopyTerminals(tab, ret);
                    continue;
                }
                ret.add(tab);
            }
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isTerminated(DataTable iTab) throws MdException, RemoteException {
        if (iTab == null) {
            return false;
        }
        Vector tTabs = new Vector();
        Vector sTabs = new Vector();
        MappingUtil.targetTerminals(iTab, tTabs);
        MappingUtil.sourceTerminals(iTab, sTabs);
        return tTabs.size() > 0 && sTabs.size() > 0;
    }

    public static boolean isCopyTerminated(DataTable iTab) throws MdException, RemoteException {
        if (iTab == null) {
            return false;
        }
        Vector tTabs = new Vector();
        Vector sTabs = new Vector();
        MappingUtil.targetCopyTerminals(iTab, tTabs);
        MappingUtil.sourceCopyTerminals(iTab, sTabs);
        return tTabs.size() > 0 && sTabs.size() > 0;
    }

    public static void performMapping(DataTable iSrc) throws MdException, RemoteException {
        Vector vTargs = MappingUtil.getTargets(iSrc);
        if (!m_stopAutoMapping) {
            for (int i = 0; i < vTargs.size(); ++i) {
                DataTable iTarg = (DataTable)vTargs.get(i);
                if (!iTarg.equals(m_oMiningTargetTable)) {
                    MappingUtil.createColumnMappings(iSrc, iTarg);
                }
                if (PFDDnDAdapter.validateDropObject((CMetadata)iTarg)) continue;
                MappingUtil.performMapping(iTarg);
            }
        }
    }

    private static Vector getSources(DataTable iTab) throws MdException, RemoteException {
        Vector<Object> ret = new Vector<Object>();
        AssociationList lCMs = iTab.getTargetClassifierMaps(false);
        for (int i = 0; i < lCMs.size(); ++i) {
            ClassifierMap cm = (ClassifierMap)lCMs.get(i);
            if (cm.getSteps(false).isEmpty()) continue;
            m_stopAutoMapping = MappingUtil.stopAutoMapping(cm);
            AssociationList sources = cm.getClassifierSources(false);
            for (int j = 0; j < sources.size(); ++j) {
                ret.add(sources.get(j));
            }
        }
        return ret;
    }

    private static Vector getTargets(DataTable iTab) throws MdException, RemoteException {
        Vector<Object> ret = new Vector<Object>();
        AssociationList lCMs = iTab.getSourceClassifierMaps(false);
        for (int i = 0; i < lCMs.size(); ++i) {
            ClassifierMap cm = (ClassifierMap)lCMs.get(i);
            if (cm.getSteps(false).isEmpty()) continue;
            m_stopAutoMapping = MappingUtil.stopAutoMapping(cm);
            AssociationList sources = cm.getClassifierTargets(false);
            for (int j = 0; j < sources.size(); ++j) {
                ret.add(sources.get(j));
            }
        }
        return ret;
    }

    public static void setAutomapEnabled(TransformationStep step, boolean fState) throws MdException, RemoteException {
        AssociationList sets = step.getPropertySets();
        MdObjectStore store = (MdObjectStore)step.getObjectStore();
        CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
        String reposID = repos.getFQID().substring(9, 17);
        PropertySet set = null;
        boolean foundSet = false;
        for (int i = 0; i < sets.size(); ++i) {
            set = (PropertySet)sets.get(i);
            if (!set.getName().equalsIgnoreCase("AUTOMAP")) continue;
            foundSet = true;
            break;
        }
        if (!foundSet) {
            set = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, null, "AUTOMAP", "PropertySet", reposID, null);
            step.getPropertySets().add((Object)set);
        }
        AssociationList extensions = set.getExtensions();
        Extension extension = null;
        if (extensions.size() == 0) {
            extension = (Extension)Workspace.getMdFactory().createComplexMetadataObject(store, null, "AUTOMAP", "Extension", reposID, null);
            set.getExtensions().add((Object)extension);
        } else {
            extension = (Extension)set.getExtensions().get(0);
        }
        if (!fState) {
            extension.setValue("off");
        } else {
            extension.setValue("on");
        }
    }
}

