/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFilter;
import java.rmi.RemoteException;

public class OSNodeFilter
implements WsNodeFilter {
    public static final int ALL_COLUMNS = 0;
    public static final int NUMERIC_COLUMNS = 1;
    public static final int CHARACTER_COLUMNS = 2;
    private String[] m_saTypesToShow = new String[0];
    private int m_eShowColumnType;

    public void setTypesToShow(String[] saTypes) {
        this.m_saTypesToShow = saTypes;
    }

    public String[] getTypesToShow() {
        return this.m_saTypesToShow;
    }

    public void addTypeToShow(String sType) {
        if (this.m_saTypesToShow == null) {
            this.m_saTypesToShow = new String[]{sType};
            return;
        }
        int nTypes = this.m_saTypesToShow.length + 1;
        String[] saTypes = new String[nTypes];
        System.arraycopy(this.m_saTypesToShow, 0, saTypes, 0, nTypes);
        this.m_saTypesToShow = saTypes;
        this.m_saTypesToShow[nTypes - 1] = sType;
    }

    public boolean isTypeShown(String sType) {
        if (this.m_saTypesToShow == null) {
            return true;
        }
        for (int iType = 0; iType < this.m_saTypesToShow.length; ++iType) {
            if (!this.m_saTypesToShow[iType].equals(sType)) continue;
            return true;
        }
        return false;
    }

    public void setColumnTypeToShow(int eType) {
        this.m_eShowColumnType = eType;
    }

    public int getColumnTypeToShow() {
        return this.m_eShowColumnType;
    }

    public boolean accept(Root mdo, WsTreeNode nodeParent) {
        try {
            String sType = mdo.getCMetadataType();
            if (sType.equals("Environment") || sType.equals("Root") || sType.equals("Tree")) {
                return true;
            }
            if (sType.equals("Column")) {
                return this.m_eShowColumnType == 0 || this.m_eShowColumnType == 1 && WsColumnMetadataUtil.isColumnTypeNumeric((Column)((Column)mdo)) || this.m_eShowColumnType == 2 && WsColumnMetadataUtil.isColumnTypeCharacter((Column)((Column)mdo));
            }
            return this.isTypeShown(sType);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }
}

