/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.DataTable;
import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.SasFormatUtil;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import com.sas.wadmin.model.WAdminDataSourceTable;
import com.sas.wadmin.model.WAdminSqlLogic;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.Serializable;
import java.rmi.RemoteException;

public class WAdminDataSource
extends DataSource
implements Serializable {
    protected DataSourceContainerList m_tables = new DataSourceContainerList();
    protected transient SqlProperties m_properties = new SqlProperties((DataSource)this);
    protected static QueryResource bundle = new QueryResource(WAdminDataSource.class);
    private static WAdminResource waBundle = WAdminResource.getBundle(WAdminDataSource.class);

    public WAdminDataSource() throws QueryException {
        super(new MessageHandler());
    }

    public void close() {
        this.m_tables = null;
        this.m_properties = null;
    }

    public void initialize() {
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public DataSourceContainer getParent() {
        return null;
    }

    public String getName() {
        return waBundle.getString("WAdminDataSource.name.txt");
    }

    public SqlLogic getSqlLogic(Query query) {
        return new WAdminSqlLogic(query, this.m_passwordList);
    }

    public SqlProperties getProperties() {
        return this.m_properties;
    }

    public void execute(String executeStr) {
    }

    public DataSourceTable getTable(String strQualifiedTableName) {
        DataSourceContainerList tableList = this.getItems();
        for (int index = 0; index < tableList.size(); ++index) {
            String strQualifiedName = tableList.elementAt(index).getQualifiedName();
            if (!(strQualifiedName = strQualifiedName.substring(strQualifiedName.indexOf("(") + 1, strQualifiedName.indexOf(")"))).equals(strQualifiedTableName)) continue;
            return (DataSourceTable)tableList.elementAt(index);
        }
        return null;
    }

    public DataSourceColumn getColumn(String strQualifiedColumnName) {
        String separatorString = this.getProperties().getCatalogSeparator();
        int pos = strQualifiedColumnName.lastIndexOf(separatorString);
        if (pos == -1) {
            return null;
        }
        DataSourceTable table = this.getTable(strQualifiedColumnName.substring(0, pos));
        if (table == null) {
            return null;
        }
        String strColumnName = strQualifiedColumnName.substring(pos + 1);
        DataSourceColumnList columnList = table.getColumns();
        for (int index = 0; index < columnList.size(); ++index) {
            DataSourceColumn column = columnList.elementAt(index);
            if (!column.getName().equals(strColumnName)) continue;
            return column;
        }
        return null;
    }

    public int getItemCount() {
        return this.m_tables.size();
    }

    public String[] getItemNames() {
        String[] names = new String[this.m_tables.size()];
        for (int index = 0; index < this.m_tables.size(); ++index) {
            WAdminDataSourceTable table = (WAdminDataSourceTable)this.m_tables.elementAt(index);
            names[index] = table.getName();
        }
        return names;
    }

    public DataSourceContainerList getItems() {
        return this.m_tables;
    }

    public void addTable(DataTable wTable) {
        try {
            WAdminDataSourceTable table = this._tableForName(wTable.getFQID());
            if (table != null) {
                this.m_messages.addError(bundle.messageString("Message.DataSource.tableExists.fmt.txt", (Object)wTable.getName()));
                return;
            }
            this.m_tables.addElement((DataSourceContainer)new WAdminDataSourceTable(this, wTable));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static int mapSasToSqlType(String strType, String strFormat) {
        int retType = 0;
        retType = strType.equalsIgnoreCase("N") ? SasFormatUtil.getNumericSqlType((String)strFormat) : (strType.equalsIgnoreCase("C") ? 1 : 1111);
        return retType;
    }

    protected WAdminDataSourceTable _tableForName(String qualifiedName) {
        for (int index = 0; index < this.m_tables.size(); ++index) {
            WAdminDataSourceTable table = (WAdminDataSourceTable)this.m_tables.elementAt(index);
            if (!qualifiedName.equals(table.getQualifiedName())) continue;
            return table;
        }
        return null;
    }
}

