/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;

public class WAExtAttrTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(WAExtAttrTableModel.class);
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int DESCR_COLUMN = 2;
    public static final int EXTENSION_COLUMN = 3;
    protected static final int NAME_WIDTH = 100;
    protected static final int VALUE_WIDTH = 100;
    protected static final int DESCR_WIDTH = 200;
    protected static final int TOTAL_COLS = 3;
    protected static final int TOTAL_HIDDEN_COLS = 1;
    protected Root m_oData;
    protected int[] m_aRowMappings;

    public WAExtAttrTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("WAExtAttrTableModel.Name.txt"), 100, 60);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("WAExtAttrTableModel.Value.txt"), 100, 256);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("WAExtAttrTableModel.Description.txt"), 200, 200);
        this.m_aColumns[3] = new WsMetadataTableColumn();
    }

    public void setMetadataObject(Root oData) {
        this.m_oData = oData;
    }

    public Root getMetadataObject() {
        return this.m_oData;
    }

    public void setRowMappings(int[] aRowMappings) {
        this.m_aRowMappings = aRowMappings;
    }

    public int[] getRowMappings() {
        return this.m_aRowMappings;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() throws MdException, RemoteException {
        Vector<String> lAssociations = new Vector<String>();
        lAssociations.add("Extensions");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oData, null, lAssociations, null, 8, true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        AssociationList alExtensions = this.m_oData.getExtensions();
        nRows = alExtensions.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            Extension oExtension = (Extension)alExtensions.get(iRow);
            ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add(oExtension.getName());
            alRow.add(oExtension.getValue());
            alRow.add(oExtension.getDesc());
            alRow.add((String)oExtension);
            this.m_lData.add(alRow);
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        Extension oExtension;
        int iExtension;
        AssociationList alExtensions = this.m_oData.getExtensions(false);
        int nExtensions = alExtensions.size();
        ArrayList alOldExtensions = new ArrayList(nExtensions);
        alOldExtensions.addAll(alExtensions);
        alExtensions.removeAllElements();
        int nRows = this.m_lData.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            iExtension = this.m_aRowMappings != null ? this.m_aRowMappings[iRow] : iRow;
            String sName = (String)this.getValueAt(iExtension, 0);
            oExtension = (Extension)this.getValueAt(iExtension, 3);
            if (oExtension == null) {
                oExtension = (Extension)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_oData.getObjectStore(), sName, "Extension", this.m_oData.getRepositoryID());
                this.setValueAt(oExtension, iExtension, 3);
            } else if (!oExtension.getName().equals(sName)) {
                oExtension.setName(sName);
            }
            String sValue = (String)this.getValueAt(iExtension, 1);
            if (!oExtension.getValue().equals(sValue)) {
                oExtension.setValue(sValue);
            }
            String sDescr = (String)this.getValueAt(iExtension, 2);
            if (!oExtension.getDesc().equals(sDescr)) {
                oExtension.setDesc(sDescr);
            }
            alExtensions.add((Object)oExtension);
            if (!alOldExtensions.contains(oExtension)) continue;
            alOldExtensions.remove(oExtension);
        }
        MdObjectStore store = (MdObjectStore)this.m_oData.getObjectStore();
        nExtensions = alOldExtensions.size();
        for (iExtension = 0; iExtension < nExtensions; ++iExtension) {
            oExtension = (Extension)alOldExtensions.get(iExtension);
            store.deleteObject((CMetadata)oExtension);
        }
    }
}

