/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

public class TransformationTargetColumnsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TransformationTargetColumnsTableModel.class);
    private static final boolean g_bGotoServer = true;
    public static final int COLUMNNAME_COLUMN = 0;
    public static final int EXPRESSION_COLUMN = 1;
    public static final int COLUMNDESCR_COLUMN = 2;
    public static final int TABLENAME_COLUMN = 3;
    public static final int TABLEDESCR_COLUMN = 4;
    public static final int GROUPBY_COLUMN = 5;
    public static final int MAPPINGTYPE_COLUMN = 6;
    public static final int TYPE_COLUMN = 7;
    public static final int LENGTH_COLUMN = 8;
    public static final int INFORMAT_COLUMN = 9;
    public static final int FORMAT_COLUMN = 10;
    public static final int COLUMN_COLUMN = 11;
    public static final int FEATUREMAP_COLUMN = 12;
    public static final int NULLABLE_COLUMN = 13;
    public static final int TABLENAME_WIDTH = 100;
    public static final int TABLEDESCR_WIDTH = 110;
    public static final int COLUMNNAME_WIDTH = 100;
    public static final int EXPRESSION_WIDTH = 75;
    public static final int COLUMNDESCR_WIDTH = 110;
    public static final int GROUPBY_WIDTH = 75;
    public static final int MAPPINGTYPE_WIDTH = 85;
    public static final int TYPE_WIDTH = 75;
    public static final int LENGTH_WIDTH = 50;
    private static final int INFORMAT_WIDTH = 75;
    private static final int FORMAT_WIDTH = 75;
    public static final int UNMAPPED_MAPPING = 0;
    public static final int ONETOONE_MAPPING = 1;
    public static final int DERIVED_MAPPING = 2;
    public static final int MANYTOONE_MAPPING = 3;
    public static final int UNKNOWN_MAPPING = 4;
    protected static final int VISIBLE_COLUMNS = 11;
    protected static final int HIDDEN_COLUMNS = 3;
    protected TransformationStep m_oTS;
    protected List m_lDataTables;
    protected List m_lSourceDataTables;
    protected List m_lFeatureMaps;
    protected int[] m_aRowMappings;
    protected static String[] g_saMappingTypes = new String[]{bundle.getString("CommonTableModel.None.txt"), bundle.getString("CommonTableModel.OneToOne.txt"), bundle.getString("CommonTableModel.Derived.txt"), bundle.getString("CommonTableModel.ManyToOne.txt"), bundle.getString("CommonTableModel.Unknown.txt")};
    protected boolean m_bTableProvided = false;

    public TransformationTargetColumnsTableModel() {
        this.createColumnDefinitions();
        this.m_lDataTables = new ArrayList();
        this.m_lSourceDataTables = new ArrayList();
    }

    protected void createColumnDefinitions() {
        String[] saTypes = WsColumnMetadataUtil.getViewTypes();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new cColumnNameTableColumn(0, bundle.getString("TransformationTargetColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("TransformationTargetColumnsTableModel.Expression.txt"), 75);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("TransformationTargetColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[3] = new cTableNameTableColumn(3, bundle.getString("TransformationTargetColumnsTableModel.Table.txt"), 100);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("TransformationTargetColumnsTableModel.TableDescr.txt"), 110);
        this.m_aColumns[5] = new WsBooleanTableColumn(5, bundle.getString("TransformationTargetColumnsTableModel.GroupBy.txt"), 75, false);
        this.m_aColumns[6] = new WsStringTableColumn(6, bundle.getString("TransformationTargetColumnsTableModel.MappingType.txt"), 85, TransformationTargetColumnsTableModel.getViewMappingTypeString(0));
        this.m_aColumns[7] = new WsEnumeratedTableColumn(7, bundle.getString("TransformationTargetColumnsTableModel.Type.txt"), 75, saTypes);
        this.m_aColumns[8] = new WsIntegerTableColumn(8, bundle.getString("TransformationTargetColumnsTableModel.Length.txt"), 50, 8, 1, Short.MAX_VALUE);
        this.m_aColumns[9] = this.createInformatsTableColumn();
        this.m_aColumns[10] = this.createFormatsTableColumn();
        this.m_aColumns[11] = new WsMetadataTableColumn();
        this.m_aColumns[12] = new WsMetadataTableColumn();
        this.m_aColumns[13] = new WsBooleanTableColumn(13, bundle.getString("TransformationTargetColumnsTableModel.IsNullable.txt"), 75, true);
        this.m_aColumns[4].setEditable(false);
        this.m_aColumns[6].setEditable(false);
    }

    protected WsAbstractTableColumn createInformatsTableColumn() {
        return new cInformatsTableColumn();
    }

    protected WsAbstractTableColumn createFormatsTableColumn() {
        return new cFormatsTableColumn();
    }

    public void setTransformationStep(TransformationStep oTS) {
        this.m_oTS = oTS;
    }

    public TransformationStep getTransformationStep() {
        return this.m_oTS;
    }

    public void setTable(DataTable oTable) {
        this.m_lDataTables.clear();
        if (oTable != null) {
            this.m_lDataTables.add(oTable);
        }
        this.m_bTableProvided = true;
    }

    public void setTables(List lTables) {
        this.m_lDataTables.clear();
        this.m_lDataTables.addAll(lTables);
        this.m_bTableProvided = true;
    }

    public void setSourceTable(DataTable oSourceTable) {
        this.m_lSourceDataTables.clear();
        this.m_lSourceDataTables.add(oSourceTable);
    }

    public void setSourceTables(List lSourceTables) {
        this.m_lSourceDataTables.clear();
        this.m_lSourceDataTables.addAll(lSourceTables);
    }

    public void setFeatureMapsList(List lFeatureMaps) {
        this.m_lFeatureMaps = lFeatureMaps;
    }

    public void setRowMappings(int[] aRowMappings) {
        this.m_aRowMappings = aRowMappings;
    }

    public int[] getRowMappings() {
        return this.m_aRowMappings;
    }

    public List getDataTables() {
        return this.m_lDataTables;
    }

    public static String getViewMappingTypeString(int eMappingType) {
        return g_saMappingTypes[eMappingType];
    }

    public static int getMappingTypeEnum(FeatureMap oFM) {
        try {
            if (oFM == null) {
                return 0;
            }
            String sRole = oFM.getTransformRole();
            if (sRole.equalsIgnoreCase("ONETOONE")) {
                return 1;
            }
            if (sRole.equalsIgnoreCase("DERIVED")) {
                return 2;
            }
            if (sRole.equalsIgnoreCase("MANYTOONE")) {
                return 3;
            }
            return 4;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return 4;
        }
    }

    public static String getViewMappingTypeString(FeatureMap oFM) {
        try {
            int eType = TransformationTargetColumnsTableModel.getMappingTypeEnum(oFM);
            if (eType != 4) {
                return TransformationTargetColumnsTableModel.getViewMappingTypeString(eType);
            }
            String sRole = oFM.getTransformRole();
            if (sRole.length() != 0) {
                return sRole;
            }
            return TransformationTargetColumnsTableModel.getViewMappingTypeString(eType);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public int getColumnCount() {
        return 11;
    }

    public int getHiddenColumnCount() {
        return 3;
    }

    public int getDefaultEditColumnIndex() {
        return 0;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        String sNone = WsColumnMetadataUtil.NONE;
        this.clear();
        if (!this.m_bTableProvided) {
            this.m_lDataTables.clear();
            AssociationList alCMs = this.m_oTS.getTransformations();
            int nCMs = alCMs.size();
            for (int iCM = 0; iCM < nCMs; ++iCM) {
                ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
                AssociationList alFMs = oCM.getFeatureMaps();
                boolean bUsesQuotes = false;
                AssociationList alSources = oCM.getClassifierSources();
                int nSources = alSources.size();
                for (int iSource = 0; iSource < nSources; ++iSource) {
                    Root oSource = (Root)alSources.get(iSource);
                    if (!(oSource instanceof DataTable) || !DBMSNamesPropertyHandler.needQuotes((DataTable)((DataTable)oSource))) continue;
                    bUsesQuotes = true;
                    break;
                }
                AssociationList alTargets = oCM.getClassifierTargets();
                int nTargets = alTargets.size();
                for (int iTarget = 0; iTarget < nTargets; ++iTarget) {
                    DataTable oTarget = (DataTable)alTargets.get(iTarget);
                    if (this.m_lDataTables.contains(oTarget)) continue;
                    this.m_lDataTables.add(oTarget);
                    AssociationList alColumns = oTarget.getColumns();
                    int nColumns = alColumns.size();
                    for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                        Column oColumn = (Column)alColumns.get(iColumn);
                        String sName = TransformationTargetColumnsTableModel.getDataTableDisplayName(oTarget);
                        FeatureMap oFM = this.findFeatureMapForColumn(alFMs, oColumn);
                        String sExpression = "";
                        int eMappingType = 0;
                        if (oFM != null) {
                            String sTransformRole = oFM.getTransformRole();
                            if (sTransformRole.equalsIgnoreCase("ONETOONE")) {
                                if (oFM.getFeatureSources().size() == 0) {
                                    oFM = null;
                                } else {
                                    eMappingType = 1;
                                }
                            } else if (sTransformRole.equalsIgnoreCase("Derived")) {
                                eMappingType = 2;
                                TextStore oExpression = (TextStore)oFM.getSourceCode();
                                if (oExpression != null) {
                                    sExpression = ExpressionParser.detokenizeString((String)oExpression.getStoredText(), (AbstractTransformation)oFM, (boolean)bUsesQuotes);
                                }
                            } else if (sTransformRole.equalsIgnoreCase("MANYTOONE")) {
                                eMappingType = 3;
                            } else if (sTransformRole.equalsIgnoreCase("UNMAPPED")) {
                                eMappingType = 0;
                            }
                        }
                        String sInformat = oColumn.getSASInformat();
                        String sFormat = oColumn.getSASFormat();
                        ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                        alRow.add(oColumn.getSASColumnName());
                        alRow.add(sExpression);
                        alRow.add(oColumn.getDesc());
                        alRow.add(sName);
                        alRow.add(oTarget.getDesc());
                        alRow.add(new Boolean(false));
                        alRow.add(TransformationTargetColumnsTableModel.getViewMappingTypeString(eMappingType));
                        alRow.add(WsColumnMetadataUtil.getColumnViewTypeString((Column)oColumn));
                        alRow.add(new Integer(oColumn.getSASColumnLength()));
                        alRow.add(sInformat.length() == 0 ? sNone : sInformat);
                        alRow.add(sFormat.length() == 0 ? sNone : sFormat);
                        alRow.add(oColumn);
                        alRow.add(oFM);
                        alRow.add(new Boolean(oColumn.getIsNullable() == 1));
                        this.m_lData.add(alRow);
                    }
                }
            }
        } else {
            boolean bUsesQuotes = false;
            for (int iSource = 0; iSource < this.m_lSourceDataTables.size(); ++iSource) {
                DataTable oSource = (DataTable)this.m_lSourceDataTables.get(iSource);
                if (!DBMSNamesPropertyHandler.needQuotes((DataTable)oSource)) continue;
                bUsesQuotes = true;
                break;
            }
            for (int iTarget = 0; iTarget < this.m_lDataTables.size(); ++iTarget) {
                DataTable oTarget = (DataTable)this.m_lDataTables.get(iTarget);
                AssociationList alColumns = oTarget.getColumns();
                int nColumns = alColumns.size();
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    Column oColumn = (Column)alColumns.get(iColumn);
                    String sName = TransformationTargetColumnsTableModel.getDataTableDisplayName(oTarget);
                    FeatureMap oFM = this.findFeatureMapForColumn((AssociationList)this.m_lFeatureMaps, oColumn);
                    String sExpression = "";
                    int eMappingType = 0;
                    if (oFM != null) {
                        String sTransformRole = oFM.getTransformRole();
                        if (sTransformRole.equalsIgnoreCase("ONETOONE")) {
                            if (oFM.getFeatureSources().size() == 0) {
                                oFM = null;
                            } else {
                                eMappingType = 1;
                            }
                        } else if (sTransformRole.equalsIgnoreCase("Derived")) {
                            eMappingType = 2;
                            TextStore oExpression = (TextStore)oFM.getSourceCode();
                            if (oExpression != null) {
                                sExpression = ExpressionParser.detokenizeString((String)oExpression.getStoredText(), (AbstractTransformation)oFM, (boolean)bUsesQuotes);
                            }
                        } else {
                            eMappingType = sTransformRole.equalsIgnoreCase("MANYTOONE") ? 3 : (sTransformRole.equalsIgnoreCase("UNMAPPED") ? 0 : -1);
                        }
                    }
                    String sInformat = oColumn.getSASInformat();
                    String sFormat = oColumn.getSASFormat();
                    String sMappingType = eMappingType == -1 ? oFM.getTransformRole() : TransformationTargetColumnsTableModel.getViewMappingTypeString(eMappingType);
                    ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                    alRow.add(oColumn.getSASColumnName());
                    alRow.add(sExpression);
                    alRow.add(oColumn.getDesc());
                    alRow.add(sName);
                    alRow.add(oTarget.getDesc());
                    alRow.add(new Boolean(false));
                    alRow.add(sMappingType);
                    alRow.add(WsColumnMetadataUtil.getColumnViewTypeString((Column)oColumn));
                    alRow.add(new Integer(oColumn.getSASColumnLength()));
                    alRow.add(sInformat.length() == 0 ? sNone : sInformat);
                    alRow.add(sFormat.length() == 0 ? sNone : sFormat);
                    alRow.add(oColumn);
                    alRow.add(oFM);
                    alRow.add(new Boolean(oColumn.getIsNullable() == 1));
                    this.m_lData.add(alRow);
                }
            }
        }
        int nDataTables = this.m_lDataTables.size();
        String[] saDataTables = new String[nDataTables];
        for (int iDataTable = 0; iDataTable < nDataTables; ++iDataTable) {
            DataTable oDataTable = (DataTable)this.m_lDataTables.get(iDataTable);
            saDataTables[iDataTable] = TransformationTargetColumnsTableModel.getDataTableDisplayName(oDataTable);
        }
        WsEnumeratedTableColumn colTableName = (WsEnumeratedTableColumn)this.m_aColumns[3];
        if (nDataTables > 0) {
            colTableName.setPossibleValues(saDataTables);
            DataTable oDataTable = (DataTable)this.m_lDataTables.get(0);
            WsStringTableColumn colTableDescr = (WsStringTableColumn)this.m_aColumns[4];
            colTableDescr.setDefaultValue(oDataTable.getDesc());
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        int iDataTable;
        int nDataTables = this.m_lDataTables.size();
        AssociationList[] aColumnsAssociationLists = new AssociationList[nDataTables];
        ArrayList lOldColumns = new ArrayList();
        for (iDataTable = 0; iDataTable < nDataTables; ++iDataTable) {
            DataTable oDataTable = (DataTable)this.m_lDataTables.get(iDataTable);
            aColumnsAssociationLists[iDataTable] = oDataTable.getColumns(false);
            lOldColumns.addAll(aColumnsAssociationLists[iDataTable]);
            aColumnsAssociationLists[iDataTable].removeAllElements();
        }
        MdObjectStore store = (MdObjectStore)this.m_oTS.getObjectStore();
        int nRows = this.m_lData.size();
        block1: for (int iRow = 0; iRow < nRows; ++iRow) {
            int iColumn = this.m_aRowMappings != null ? this.m_aRowMappings[iRow] : iRow;
            Column oColumn = this.updateColumn(iColumn);
            if (oColumn == null) continue;
            String sDataTable = (String)this.getValueAt(iColumn, 3);
            for (iDataTable = 0; iDataTable < nDataTables; ++iDataTable) {
                DataTable oDataTable = (DataTable)this.m_lDataTables.get(iDataTable);
                if (!TransformationTargetColumnsTableModel.getDataTableDisplayName(oDataTable).equals(sDataTable)) continue;
                aColumnsAssociationLists[iDataTable].add((Object)oColumn);
                if (!lOldColumns.contains(oColumn)) continue block1;
                lOldColumns.remove(oColumn);
                continue block1;
            }
        }
        int nColumns = lOldColumns.size();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            Column oColumn = (Column)lOldColumns.get(iColumn);
            store.removeObjectFromStore((CMetadata)oColumn, "<Column><Extensions/><SourceFeatureMaps/><TargetFeatureMaps/><PropertySets><SetProperties/><Properties/></PropertySets></Column>");
        }
    }

    private Column createColumn(int rowIndex) {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            String name = (String)this.getValueAt(rowIndex, 0);
            Column oColumn = (Column)factory.createComplexMetadataObject((MdObjectStore)this.m_oTS.getObjectStore(), name, "Column", this.m_oTS.getRepositoryID());
            oColumn.setSASColumnName(name);
            oColumn.setPublicType("Column");
            oColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            oColumn.setIsNullable(1);
            this.setValueAt(oColumn, rowIndex, 11);
            return oColumn;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public Column updateColumn(int iColumn) {
        try {
            Boolean isNullable;
            String sFormat;
            String sInformat;
            String sName;
            String sNone = WsColumnMetadataUtil.NONE;
            Column oColumn = (Column)this.getValueAt(iColumn, 11);
            if (oColumn == null) {
                oColumn = this.createColumn(iColumn);
            }
            if (!(sName = (String)this.getValueAt(iColumn, 0)).equals(oColumn.getSASColumnName())) {
                oColumn.setSASColumnName(sName);
                oColumn.setName(sName);
            }
            String sDescription = (String)this.getValueAt(iColumn, 2);
            if (!oColumn.getDesc().equals(sDescription)) {
                oColumn.setDesc(sDescription);
            }
            String sViewType = (String)this.getValueAt(iColumn, 7);
            WsColumnMetadataUtil.updateType((Column)oColumn, (String)sViewType);
            Integer iLength = (Integer)this.getValueAt(iColumn, 8);
            if (iLength.intValue() != oColumn.getSASColumnLength()) {
                oColumn.setSASColumnLength(iLength.intValue());
            }
            if ((sInformat = (String)this.getValueAt(iColumn, 9)).equalsIgnoreCase(sNone)) {
                sInformat = "";
            }
            if (!oColumn.getSASInformat().equals(sInformat)) {
                oColumn.setSASInformat(sInformat);
            }
            if ((sFormat = (String)this.getValueAt(iColumn, 10)).equalsIgnoreCase(sNone)) {
                sFormat = "";
            }
            if (!oColumn.getSASFormat().equals(sFormat)) {
                oColumn.setSASFormat(sFormat);
            }
            if ((isNullable = (Boolean)this.getValueAt(iColumn, 13)).booleanValue()) {
                oColumn.setIsNullable(1);
            } else {
                oColumn.setIsNullable(0);
            }
            return oColumn;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public List createRowValuesFromColumn(Column oNewColumn, String sSelectedTable) {
        try {
            List lRowValues = this.createDefaultRowValues();
            String sNone = WsColumnMetadataUtil.NONE;
            String sInformat = oNewColumn.getSASInformat();
            String sFormat = oNewColumn.getSASFormat();
            lRowValues.set(0, oNewColumn.getSASColumnName());
            lRowValues.set(2, oNewColumn.getDesc());
            lRowValues.set(7, WsColumnMetadataUtil.getColumnViewTypeString((Column)oNewColumn));
            lRowValues.set(8, new Integer(oNewColumn.getSASColumnLength()));
            lRowValues.set(3, sSelectedTable);
            lRowValues.set(9, sInformat.length() == 0 ? sNone : sInformat);
            lRowValues.set(10, sFormat.length() == 0 ? sNone : sFormat);
            lRowValues.set(13, new Boolean(oNewColumn.getIsNullable() == 1));
            return lRowValues;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public List getRowValuesForColumn(Column oColumn, DataTable oTable) {
        try {
            String sNone = WsColumnMetadataUtil.NONE;
            String sType = WsColumnMetadataUtil.getColumnViewTypeString((Column)oColumn);
            String sTableName = TransformationTargetColumnsTableModel.getDataTableDisplayName(oTable);
            String sInformat = oColumn.getSASInformat();
            String sFormat = oColumn.getSASFormat();
            Boolean isNullable = new Boolean(oColumn.getIsNullable() == 1);
            ArrayList<Object> lRowValues = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
            lRowValues.add(oColumn.getSASColumnName());
            lRowValues.add("");
            lRowValues.add(oColumn.getDesc());
            lRowValues.add(sTableName);
            lRowValues.add(oTable.getDesc());
            lRowValues.add(false);
            lRowValues.add(TransformationTargetColumnsTableModel.getViewMappingTypeString(0));
            lRowValues.add(sType);
            lRowValues.add(new Integer(oColumn.getSASColumnLength()));
            lRowValues.add(sInformat.length() == 0 ? sNone : sInformat);
            lRowValues.add(sFormat.length() == 0 ? sNone : sFormat);
            lRowValues.add(null);
            lRowValues.add(null);
            lRowValues.add(isNullable);
            return lRowValues;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    protected DataTable getDataTableForName(String sDataTable) {
        int nDataTables = this.m_lDataTables.size();
        if (nDataTables == 1) {
            return (DataTable)this.m_lDataTables.get(0);
        }
        for (int iDataTable = 0; iDataTable < nDataTables; ++iDataTable) {
            DataTable oDataTable = (DataTable)this.m_lDataTables.get(iDataTable);
            if (!TransformationTargetColumnsTableModel.getDataTableDisplayName(oDataTable).equals(sDataTable)) continue;
            return oDataTable;
        }
        return null;
    }

    public FeatureMap findFeatureMapForColumn(AssociationList alFMs, Column oColumn) throws MdException, RemoteException {
        if (alFMs != null) {
            int nFMs = alFMs.size();
            for (int iFM = 0; iFM < nFMs; ++iFM) {
                AssociationList alFeatureTargets;
                FeatureMap oFM = (FeatureMap)alFMs.get(iFM);
                if (oFM.getIsUserDefined() != 0 || !(alFeatureTargets = oFM.getFeatureTargets()).contains((Object)oColumn)) continue;
                return oFM;
            }
        }
        return null;
    }

    public static String getDataTableDisplayName(DataTable oDataTable) {
        try {
            if (oDataTable instanceof PhysicalTable) {
                return ((PhysicalTable)oDataTable).getSASTableName();
            }
            return oDataTable.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public boolean validateColumnNameUniqueness(String sTestTable, String sTestColumn, int iTestRow) {
        boolean bCaseSensitive = false;
        try {
            bCaseSensitive = DBMSNamesPropertyHandler.needQuotes((DataTable)this.getDataTableForName(sTestTable));
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            boolean bEquals;
            if (iRow == iTestRow) continue;
            String sColumnName = (String)this.getValueAt(iRow, 0);
            String sTableName = (String)this.getValueAt(iRow, 3);
            boolean bl = bCaseSensitive ? sTestColumn.equals(sColumnName) && sTestTable.equals(sTableName) : (bEquals = sTestColumn.equalsIgnoreCase(sColumnName) && sTestTable.equalsIgnoreCase(sTableName));
            if (!bEquals) continue;
            return false;
        }
        return true;
    }

    public boolean validateColumnUniqueness(String sTestTable, Column sTestColumn, int iTestRow) {
        try {
            boolean bCaseSensitive = false;
            try {
                bCaseSensitive = DBMSNamesPropertyHandler.needQuotes((DataTable)this.getDataTableForName(sTestTable));
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            int nRows = this.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                boolean bEquals;
                if (iRow == iTestRow) continue;
                String sTestName = sTestColumn.getSASColumnName();
                String sColumnName = (String)this.getValueAt(iRow, 0);
                String sTableName = (String)this.getValueAt(iRow, 3);
                boolean bl = bCaseSensitive ? sTestName.equals(sColumnName) && sTestTable.equals(sTableName) : (bEquals = sTestName.equalsIgnoreCase(sColumnName) && sTestTable.equalsIgnoreCase(sTableName));
                if (!bEquals) continue;
                return false;
            }
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    protected class cColumnNameTableColumn
    extends WsUniqueNameTableColumn {
        public cColumnNameTableColumn(int iModelIndex, String sName, int cxWidth, int nMaximum) {
            super((WsAbstractTableModel)TransformationTargetColumnsTableModel.this, iModelIndex, sName, cxWidth, nMaximum);
        }

        protected boolean validateNameUniqueness(String sTestName, int iTestRow) {
            String sTestTable = iTestRow == -1 ? ((WsEnumeratedTableColumn)this.m_mdlTable.getColumn(3)).getDefaultValue() : (String)this.m_mdlTable.getValueAt(iTestRow, 3);
            return TransformationTargetColumnsTableModel.this.validateColumnNameUniqueness(sTestTable, sTestName, iTestRow);
        }
    }

    public class cTableNameTableColumn
    extends WsEnumeratedTableColumn {
        public cTableNameTableColumn(int iModelIndex, String sName, int cxWidth) {
            super(iModelIndex, sName, cxWidth);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            String sColumn = (String)TransformationTargetColumnsTableModel.this.getValueAt(iRow, 0);
            if (TransformationTargetColumnsTableModel.this.validateColumnNameUniqueness((String)oValue, sColumn, iRow)) {
                return true;
            }
            String sMessage = bundle.formatString("TransformationTargetColumnsTableModel.DuplicateColumnError.fmt", (Object)sColumn, oValue);
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return false;
        }
    }

    protected class cFormatsTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public cFormatsTableColumn() {
            super(10, bundle.getString("TransformationTargetColumnsTableModel.Format.txt"), 75, WsColumnMetadataUtil.NONE);
            this.setEditorEditable(true);
        }

        public void populate(JTable tbl, int row, int col) {
            String sType = (String)TransformationTargetColumnsTableModel.this.getValueAt(row = ((WsTable)tbl).convertRowIndexToModel(row), 7);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterFormats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericFormats());
            }
        }
    }

    protected class cInformatsTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public cInformatsTableColumn() {
            super(9, bundle.getString("TransformationTargetColumnsTableModel.Informat.txt"), 75, WsColumnMetadataUtil.NONE);
            this.setEditorEditable(true);
        }

        public void populate(JTable tbl, int row, int col) {
            String sType = (String)TransformationTargetColumnsTableModel.this.getValueAt(row = ((WsTable)tbl).convertRowIndexToModel(row), 7);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterInformats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericInformats());
            }
        }
    }
}

