/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.ColumnsTableModel2;
import com.sas.wadmin.model.IndexTreeNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IndexTreeModel2
extends DefaultTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(IndexTreeModel2.class);
    protected PhysicalTable m_oTable;
    protected ColumnsTableModel2 m_mdlColumns;
    protected int m_nIndexNodes;

    public IndexTreeModel2() {
        super(null);
    }

    public void setMetadataTable(PhysicalTable oTable) {
        this.m_oTable = oTable;
    }

    public PhysicalTable getMetadataTable() {
        return this.m_oTable;
    }

    public void setColumnsTableModel(ColumnsTableModel2 mdlColumns) {
        this.m_mdlColumns = mdlColumns;
    }

    public ColumnsTableModel2 getColumnsTableModel() {
        return this.m_mdlColumns;
    }

    public boolean isIndexNameUnique(String sName, IndexTreeNode nodeIndexToSkip) {
        IndexTreeNode nodeRoot = (IndexTreeNode)this.getRoot();
        int nIndexes = nodeRoot.getChildCount();
        for (int iIndex = 0; iIndex < nIndexes; ++iIndex) {
            TreeNode nodeIndex = nodeRoot.getChildAt(iIndex);
            if (nodeIndex == nodeIndexToSkip || !nodeIndex.toString().equals(sName)) continue;
            return false;
        }
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.setRoot(this.createRootNode());
        AssociationList alIndexes = this.m_oTable.getIndexes(false);
        int nIndexes = alIndexes.size();
        for (int iIndex = 0; iIndex < nIndexes; ++iIndex) {
            Index oIndex = (Index)alIndexes.get(iIndex);
            IndexTreeNode nodeIndex = this.createIndexNode(oIndex);
            AssociationList alColumns = oIndex.getColumns();
            int nColumns = alColumns.size();
            for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                Column oColumn = (Column)alColumns.get(iColumn);
                IndexTreeNode nodeColumn = this.createColumnNode(oColumn);
                if (nodeColumn == null) continue;
                this.insertNodeInto(nodeColumn, nodeIndex, iColumn);
            }
            this.insertNodeInto(nodeIndex, (IndexTreeNode)this.getRoot(), iIndex);
        }
        this.m_nIndexNodes = nIndexes;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        AssociationList alIndexes = this.m_oTable.getIndexes(false);
        ArrayList alOldIndexes = new ArrayList(alIndexes);
        alIndexes.removeAllElements();
        IndexTreeNode nodeRoot = (IndexTreeNode)this.getRoot();
        int nIndexes = nodeRoot.getChildCount();
        for (int iIndex = 0; iIndex < nIndexes; ++iIndex) {
            int eClustered;
            IndexTreeNode nodeIndex = (IndexTreeNode)nodeRoot.getChildAt(iIndex);
            Index oIndex = nodeIndex.getIndex();
            if (oIndex == null) {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                oIndex = (Index)factory.createComplexMetadataObject((MdObjectStore)this.m_oTable.getObjectStore(), nodeIndex.getName(), "Index", this.m_oTable.getRepositoryID());
                oIndex.setIndexName(nodeIndex.getName());
            } else {
                alOldIndexes.remove(oIndex);
            }
            String sIndex = nodeIndex.getName();
            if (!oIndex.getName().equals(sIndex)) {
                oIndex.setName(sIndex);
                oIndex.setIndexName(sIndex);
            }
            AssociationList alIndexColumns = oIndex.getColumns(false);
            alIndexColumns.removeAllElements();
            for (int iColumn = 0; iColumn < nodeIndex.getChildCount(); ++iColumn) {
                IndexTreeNode nodeColumn = (IndexTreeNode)nodeIndex.getChildAt(iColumn);
                Column oColumn = nodeColumn.getColumn();
                alIndexColumns.add((Object)oColumn);
            }
            int eUnique = (Boolean)nodeIndex.getProperty("Unique") != false ? 1 : 0;
            int eNoMiss = (Boolean)nodeIndex.getProperty("NoMiss") != false ? 1 : 0;
            int n = eClustered = (Boolean)nodeIndex.getProperty("Clustered") != false ? 1 : 0;
            if (oIndex.getIsUnique() != eUnique) {
                oIndex.setIsUnique(eUnique);
            }
            if (oIndex.getIsNoMiss() != eNoMiss) {
                oIndex.setIsNoMiss(eNoMiss);
            }
            if (oIndex.getIsClustered() != eClustered) {
                oIndex.setIsClustered(eClustered);
            }
            Boolean bPrimary = (Boolean)nodeIndex.getProperty("Primary");
            OptionsPropertyHandler op = new OptionsPropertyHandler((Root)oIndex, true);
            op.setUseSetProperties(true);
            op.setSpecificProperty("Primary", "Primary", bPrimary.toString(), "OPTION", null, 1, null, 16, false);
            alIndexes.add((Object)oIndex);
        }
        MdObjectStore store = (MdObjectStore)this.m_oTable.getObjectStore();
        store.removeObjectsFromStore(alOldIndexes);
    }

    protected TreeNode createRootNode() {
        return new IndexTreeNode("");
    }

    public IndexTreeNode createIndexNode() {
        String sName;
        while (!this.isIndexNameUnique(sName = bundle.formatString("IndexTreeModel2.NewIndexName.fmt.notrans", (Object)new Integer(++this.m_nIndexNodes)), null)) {
        }
        IndexTreeNode nodeIndex = new IndexTreeNode(sName);
        nodeIndex.setIndex(null);
        nodeIndex.setProperty("Clustered", new Boolean(false));
        nodeIndex.setProperty("Unique", new Boolean(false));
        nodeIndex.setProperty("NoMiss", new Boolean(false));
        nodeIndex.setProperty("Primary", new Boolean(false));
        return nodeIndex;
    }

    protected IndexTreeNode createIndexNode(Index oIndex) {
        try {
            IndexTreeNode nodeIndex = new IndexTreeNode(oIndex.getName());
            nodeIndex.setProperty("Clustered", new Boolean(oIndex.getIsClustered() != 0));
            nodeIndex.setProperty("Unique", new Boolean(oIndex.getIsUnique() != 0));
            nodeIndex.setProperty("NoMiss", new Boolean(oIndex.getIsNoMiss() != 0));
            nodeIndex.setIndex(oIndex);
            try {
                OptionsPropertyHandler op = new OptionsPropertyHandler((Root)oIndex, true);
                op.setUseSetProperties(true);
                nodeIndex.setProperty("Primary", new Boolean(op.getSpecificOptionValue("Primary", "false").equals("true")));
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            return nodeIndex;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public IndexTreeNode createColumnNode(Column oColumn) {
        int iRow = this.m_mdlColumns.findColumnsRow(oColumn);
        if (iRow != -1) {
            String sName = (String)this.m_mdlColumns.getValueAt(iRow, 0);
            String sType = (String)this.m_mdlColumns.getValueAt(iRow, 3);
            String sDesc = (String)this.m_mdlColumns.getValueAt(iRow, 1);
            IndexTreeNode nodeColumn = new IndexTreeNode(sName, oColumn);
            nodeColumn.setType(sType);
            nodeColumn.setDescription(sDesc);
            nodeColumn.setColumn(oColumn);
            return nodeColumn;
        }
        return null;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object oValue) {
        String sValue = (String)oValue;
        IndexTreeNode node = (IndexTreeNode)path.getLastPathComponent();
        if (!node.getName().equals(sValue)) {
            node.setName(sValue);
            this.nodeChanged(node);
        }
    }
}

