/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

public class ColumnsTableModel2
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ColumnsTableModel2.class);
    public static final int NAME_COL = 0;
    public static final int DESC_COL = 1;
    public static final int LENGTH_COL = 2;
    public static final int TYPE_COL = 3;
    public static final int ROLE_COL = 4;
    public static final int SORT_COL = 5;
    public static final int INFORMAT_COL = 6;
    public static final int FORMAT_COL = 7;
    public static final int NULL_COL = 8;
    public static final int BEGINPOS_COL = 9;
    public static final int ENDPOS_COL = 10;
    public static final int KEY_COL = 11;
    public static final int NOTES_COL = 12;
    public static final int EXTATTR_COL = 13;
    public static final int ACTUAL_COL = 14;
    protected static final int W_NAME_COL = 175;
    protected static final int W_DESC_COL = 225;
    protected static final int W_LENGTH_COL = 50;
    protected static final int W_TYPE_COL = 75;
    protected static final int W_ROLE_COL = 100;
    protected static final int W_SORT_COL = 100;
    protected static final int W_INFORMAT_COL = 100;
    protected static final int W_FORMAT_COL = 100;
    protected static final int W_NULLABLE_COL = 100;
    protected static final int W_BEGINPOS_COL = 50;
    protected static final int W_ENDPOS_COL = 50;
    protected static final int TOTAL_COLS = 11;
    protected static final int TOTAL_HIDDEN_COLS = 4;
    private static final int NUMERIC_MIN_LENGTH = 2;
    private static final int NUMERIC_MAX_LENGTH = 8;
    private static final int CHARACTER_MIN_LENGTH = 1;
    private static final int CHARACTER_MAX_LENGTH = Integer.MAX_VALUE;
    protected DataTable m_oTable;
    protected AssociationList m_alColumns;
    protected int[] m_aRowMappings;
    protected boolean m_overlappingColumns;
    protected cBeginPositionTableColumn m_tableColumnBegin;
    protected cEndPositionTableColumn m_tableColumnEnd;

    public ColumnsTableModel2() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        String[] saTypes = WsColumnMetadataUtil.getViewTypes();
        String[] saRoles = this.loadRoleValues();
        String[] saSorts = this.loadSortValues();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("ColumnsTableModel2.Name.txt"), 175, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ColumnsTableModel2.Description.txt"), 225, 200);
        this.m_aColumns[2] = new WsIntegerTableColumn(2, bundle.getString("ColumnsTableModel2.Length.txt"), 50, 8, 1, Integer.MAX_VALUE);
        this.m_aColumns[3] = this.createTypeColumn(saTypes);
        this.m_aColumns[4] = new WsEnumeratedTableColumn(4, bundle.getString("ColumnsTableModel2.Role.txt"), 100, saRoles, saRoles[4]);
        this.m_aColumns[5] = new WsEnumeratedTableColumn(5, bundle.getString("ColumnsTableModel2.Sort.txt"), 100, saSorts, saSorts[5]);
        this.m_aColumns[6] = this.createInformatsTableColumn();
        this.m_aColumns[7] = this.createFormatsTableColumn();
        this.m_aColumns[8] = new WsBooleanTableColumn(8, bundle.getString("ColumnsTableModel2.Nullable.txt"), 100, true);
        this.m_aColumns[9] = this.createBeginPositionTableColumn();
        this.m_aColumns[10] = this.createEndPositionTableColumn();
        this.m_aColumns[11] = new WsBooleanTableColumn(11, null, 0, false);
        this.m_aColumns[12] = new WsBooleanTableColumn(12, null, 0, false);
        this.m_aColumns[13] = new WsBooleanTableColumn(13, null, 0, false);
        this.m_aColumns[14] = new WsMetadataTableColumn();
    }

    protected WsAbstractTableColumn createTypeColumn(String[] saTypes) {
        return new cTypeTableColumn(saTypes);
    }

    protected WsAbstractTableColumn createInformatsTableColumn() {
        return new cInformatsTableColumn();
    }

    protected WsAbstractTableColumn createFormatsTableColumn() {
        return new cFormatsTableColumn();
    }

    protected WsAbstractTableColumn createBeginPositionTableColumn() {
        this.m_tableColumnBegin = new cBeginPositionTableColumn();
        return this.m_tableColumnBegin;
    }

    protected WsAbstractTableColumn createEndPositionTableColumn() {
        this.m_tableColumnEnd = new cEndPositionTableColumn();
        return this.m_tableColumnEnd;
    }

    protected String[] loadRoleValues() {
        String[] saRoles = new String[]{bundle.getString("ColumnsTableModel2.Class.txt"), bundle.getString("ColumnsTableModel2.Id.txt"), bundle.getString("ColumnsTableModel2.Statistic.txt"), bundle.getString("ColumnsTableModel2.Default.txt"), bundle.getString("ColumnsTableModel2.None.txt")};
        return saRoles;
    }

    protected String[] loadSortValues() {
        String[] saSorts = new String[]{bundle.getString("CommonTableModel.Ascending.notrans"), bundle.getString("CommonTableModel.Descending.notrans"), bundle.getString("CommonTableModel.AscFormatted.notrans"), bundle.getString("CommonTableModel.DscFormatted.notrans"), bundle.getString("CommonTableModel.DSOrder.notrans"), bundle.getString("CommonTableModel.None.txt")};
        return saSorts;
    }

    protected String[] loadFormatValues() {
        int nFormats = bundle.getInt("ColumnsTableModel2.Format.Count.notrans");
        String[] saFormats = new String[nFormats + 1];
        saFormats[0] = bundle.getString("ColumnsTableModel2.None.txt");
        for (int iFormat = 1; iFormat <= nFormats; ++iFormat) {
            String sFormatKey = "ColumnsTableModel2.Format." + iFormat + ".notrans";
            saFormats[iFormat] = bundle.getString(sFormatKey);
        }
        return saFormats;
    }

    protected String[] loadInformatValues() {
        int nInformats = bundle.getInt("ColumnsTableModel2.Informat.Count.notrans");
        String[] saInformats = new String[nInformats + 1];
        saInformats[0] = bundle.getString("ColumnsTableModel2.None.txt");
        for (int iInformat = 1; iInformat <= nInformats; ++iInformat) {
            String sInformatKey = "ColumnsTableModel2.Informat." + iInformat + ".notrans";
            saInformats[iInformat] = bundle.getString(sInformatKey);
        }
        return saInformats;
    }

    public void setMetadataTable(DataTable oTable) {
        this.m_oTable = oTable;
    }

    public DataTable getMetadataTable() {
        return this.m_oTable;
    }

    public void setColumnsAssociationList(AssociationList alColumns) {
        this.m_alColumns = alColumns;
    }

    public AssociationList getColumnsAssociationList() {
        return this.m_alColumns;
    }

    public void setRowMappings(int[] aRowMappings) {
        this.m_aRowMappings = aRowMappings;
    }

    public int[] getRowMappings() {
        return this.m_aRowMappings;
    }

    public int getColumnCount() {
        return 11;
    }

    public int getHiddenColumnCount() {
        return 4;
    }

    public void setOverlapColumns(boolean overlap) {
        this.m_overlappingColumns = overlap;
        this.m_tableColumnBegin.setOverlapColumns(this.m_overlappingColumns);
        this.m_tableColumnEnd.setOverlapColumns(this.m_overlappingColumns);
    }

    public boolean getOverlappingColumns() {
        return this.m_overlappingColumns;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
        if (iCol == 3 || iCol == 11 || iCol == 12 || iCol == 13) {
            this.fireTableCellUpdated(iRow, 0);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_oTable != null && !this.m_oTable.isNewObject()) {
            ArrayList<String> lAssocs = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer("<Templates>");
            lAssocs.add("Columns");
            sbTemplate.append("<Column><Keys/><Notes/><Extensions/><Documents/></Column>");
            if (this.m_oTable.getCMetadataType().equals("PhysicalTable") || this.m_oTable.getCMetadataType().equals("WorkTable")) {
                lAssocs.add("Indexes");
                lAssocs.add("TablePackage");
                sbTemplate.append("<Index><Columns/><Options/></Index><DatabaseSchema><DeployedComponents/></DatabaseSchema>");
            }
            sbTemplate.append("</Templates>");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oTable, null, lAssocs, sbTemplate.toString(), 12, true);
        }
        if (this.m_oTable != null) {
            this.m_alColumns = this.m_oTable.getColumns();
        }
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        if (this.m_alColumns == null) {
            return;
        }
        int nRows = this.m_alColumns.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            Column oColumn = (Column)this.m_alColumns.get(iRow);
            this.m_lData.add(this.getRowValuesForColumn(oColumn));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        int iColumn;
        int nColumns = this.m_alColumns.size();
        ArrayList<Object> alOldColumns = new ArrayList<Object>(nColumns);
        for (iColumn = 0; iColumn < nColumns; ++iColumn) {
            alOldColumns.add(this.m_alColumns.get(iColumn));
        }
        this.m_alColumns.removeAllElements();
        String sNone = bundle.getString("ColumnsTableModel2.None.txt");
        String sNoneFmt = WsColumnMetadataUtil.NONE;
        int nRows = this.m_lData.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            Integer iEnd;
            Integer iBegin;
            Boolean bNullable;
            int iNullable;
            Integer iLength;
            String sInformat;
            String sFormat;
            String sSort;
            iColumn = this.m_aRowMappings != null ? this.m_aRowMappings[iRow] : iRow;
            Column oColumn = (Column)this.getValueAt(iColumn, 14);
            String sName = (String)this.getValueAt(iColumn, 0);
            if (!sName.equals(oColumn.getSASColumnName())) {
                oColumn.setSASColumnName(sName);
                oColumn.setName(sName);
            }
            String sDescription = (String)this.getValueAt(iColumn, 1);
            if (!oColumn.getDesc().equals(sDescription)) {
                oColumn.setDesc(sDescription);
            }
            String sViewType = (String)this.getValueAt(iColumn, 3);
            WsColumnMetadataUtil.updateType((Column)oColumn, (String)sViewType);
            String sSummary = (String)this.getValueAt(iColumn, 4);
            if (sSummary.equalsIgnoreCase(sNone)) {
                sSummary = "";
            }
            if (!oColumn.getSummaryRole().equals(sSummary)) {
                oColumn.setSummaryRole(sSummary);
            }
            if ((sSort = (String)this.getValueAt(iColumn, 5)).equalsIgnoreCase(sNone)) {
                sSort = "";
            }
            if (!oColumn.getSortOrder().equals(sSort)) {
                oColumn.setSortOrder(sSort);
            }
            if ((sFormat = (String)this.getValueAt(iColumn, 7)).equalsIgnoreCase(sNoneFmt)) {
                sFormat = "";
            }
            if (!oColumn.getSASFormat().equals(sFormat)) {
                oColumn.setSASFormat(sFormat);
            }
            if ((sInformat = (String)this.getValueAt(iColumn, 6)).equalsIgnoreCase(sNoneFmt)) {
                sInformat = "";
            }
            if (!oColumn.getSASInformat().equals(sInformat)) {
                oColumn.setSASInformat(sInformat);
            }
            if ((iLength = (Integer)this.getValueAt(iColumn, 2)).intValue() != oColumn.getSASColumnLength()) {
                oColumn.setSASColumnLength(iLength.intValue());
            }
            int n = iNullable = (bNullable = (Boolean)this.getValueAt(iColumn, 8)) != false ? 1 : 0;
            if (oColumn.getIsNullable() != iNullable) {
                oColumn.setIsNullable(iNullable);
            }
            if ((iBegin = (Integer)this.getValueAt(iColumn, 9)).intValue() != oColumn.getBeginPosition()) {
                oColumn.setBeginPosition(iBegin.intValue());
            }
            if ((iEnd = (Integer)this.getValueAt(iColumn, 10)).intValue() != oColumn.getEndPosition()) {
                oColumn.setEndPosition(iEnd.intValue());
            }
            this.m_alColumns.add((Object)oColumn);
            if (!alOldColumns.contains(oColumn)) continue;
            alOldColumns.remove(oColumn);
        }
        MdObjectStore store = (MdObjectStore)this.m_oTable.getObjectStore();
        nColumns = alOldColumns.size();
        for (iColumn = 0; iColumn < nColumns; ++iColumn) {
            Column oColumn = (Column)alOldColumns.get(iColumn);
            store.removeObjectFromStore((CMetadata)oColumn, "<Column><Extensions/><SourceFeatureMaps/><TargetFeatureMaps/><PropertySets><SetProperties/><Properties/></PropertySets></Column>");
        }
    }

    public int findColumnsRow(Column oColumn) {
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            if (!oColumn.equals(this.getValueAt(iRow, 14))) continue;
            return iRow;
        }
        return -1;
    }

    public void setRowFromColumn(Column oNewColumn, int iRow) {
        try {
            String sNone = bundle.getString("ColumnsTableModel2.None.txt");
            String sType = WsColumnMetadataUtil.getColumnViewTypeString((Column)oNewColumn);
            Integer iLen = new Integer(oNewColumn.getSASColumnLength());
            String sRole = oNewColumn.getSummaryRole();
            String sSort = oNewColumn.getSortOrder();
            String sInformat = oNewColumn.getSASInformat();
            String sFormat = oNewColumn.getSASFormat();
            Boolean bNullable = new Boolean(oNewColumn.getIsNullable() == 1);
            Integer iBegin = new Integer(oNewColumn.getBeginPosition());
            Integer iEnd = new Integer(oNewColumn.getEndPosition());
            sRole = sRole.length() == 0 ? sNone : sRole;
            sSort = sSort.length() == 0 ? sNone : sSort;
            sInformat = sInformat.length() == 0 ? sNone : sInformat;
            sFormat = sFormat.length() == 0 ? sNone : sFormat;
            this.setValueAt(oNewColumn.getSASColumnName(), iRow, 0);
            this.setValueAt(oNewColumn.getDesc(), iRow, 1);
            this.setValueAt(sType, iRow, 3);
            this.setValueAt(iLen, iRow, 2);
            this.setValueAt(sRole, iRow, 4);
            this.setValueAt(sSort, iRow, 5);
            this.setValueAt(sInformat, iRow, 6);
            this.setValueAt(sFormat, iRow, 7);
            this.setValueAt(bNullable, iRow, 8);
            this.setValueAt(oNewColumn, iRow, 14);
            this.setValueAt(iBegin, iRow, 9);
            this.setValueAt(iEnd, iRow, 10);
            this.m_alColumns.add((Object)oNewColumn);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public List getRowValuesForColumn(Column oColumn) throws MdException, RemoteException {
        String sNone = bundle.getString("ColumnsTableModel2.None.txt");
        String sNoneFmt = WsColumnMetadataUtil.NONE;
        String sType = WsColumnMetadataUtil.getColumnViewTypeString((Column)oColumn);
        String sRole = oColumn.getSummaryRole();
        String sSort = oColumn.getSortOrder();
        String sInformat = oColumn.getSASInformat();
        String sFormat = oColumn.getSASFormat();
        int iNullable = oColumn.getIsNullable();
        ArrayList<Object> lRowValues = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        lRowValues.add(oColumn.getSASColumnName());
        lRowValues.add(oColumn.getDesc());
        lRowValues.add(new Integer(oColumn.getSASColumnLength()));
        lRowValues.add(sType);
        lRowValues.add(sRole.length() == 0 ? sNone : sRole);
        lRowValues.add(sSort.length() == 0 ? sNone : sSort);
        lRowValues.add(sInformat.length() == 0 ? sNoneFmt : sInformat);
        lRowValues.add(sFormat.length() == 0 ? sNoneFmt : sFormat);
        lRowValues.add(iNullable == 1);
        lRowValues.add(new Integer(oColumn.getBeginPosition()));
        lRowValues.add(new Integer(oColumn.getEndPosition()));
        lRowValues.add(!oColumn.getKeys().isEmpty());
        lRowValues.add(!oColumn.getNotes().isEmpty() || !oColumn.getDocuments().isEmpty());
        lRowValues.add(!oColumn.getExtensions().isEmpty());
        lRowValues.add(oColumn);
        return lRowValues;
    }

    public void setBeginPosition(int iRow, int begin) {
        this.setValueAt(new Integer(begin), iRow, 9);
    }

    public int getBeginPosition(int iRow) {
        return (Integer)this.getValueAt(iRow, 9);
    }

    public void setEndPosition(int iRow, int end) {
        this.setValueAt(new Integer(end), iRow, 10);
    }

    public int getEndPosition(int iRow) {
        return (Integer)this.getValueAt(iRow, 10);
    }

    public void setLength(int iRow, int length) {
        this.setValueAt(new Integer(length), iRow, 2);
    }

    public int getLength(int iRow) {
        return (Integer)this.getValueAt(iRow, 2);
    }

    public boolean validateValueAt(Object oValue, int iRow, int iCol) {
        if (iCol == 2) {
            int iValue = (Integer)oValue;
            String type = (String)this.getValueAt(iRow, 3);
            return this.validateLengthByType(iValue, type);
        }
        return super.validateValueAt(oValue, iRow, iCol);
    }

    public boolean validateLengthByType(int iValue, String type) {
        if (type.equals(WsColumnMetadataUtil.getViewCharacterType())) {
            if (iValue < 1 || iValue > Integer.MAX_VALUE) {
                MessageUtil.displayMessage((String)bundle.getString("ColumnsTableModel2.InvalidCharacterLength.txt"), (int)0);
                return false;
            }
            return true;
        }
        if (iValue < 2 || iValue > 8) {
            MessageUtil.displayMessage((String)bundle.formatString("ColumnsTableModel2.InvalidNumericLength.txt", (Object)2, (Object)8), (int)0);
            return false;
        }
        return true;
    }

    protected class cEndPositionTableColumn
    extends WsIntegerTableColumn {
        private boolean m_overlap;

        public cEndPositionTableColumn() {
            super(10, bundle.getString("ColumnsTableModel2.EndPosition.txt"), 50, 0);
        }

        public void setOverlapColumns(boolean overlap) {
            this.m_overlap = overlap;
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (this.m_overlap) {
                return true;
            }
            int end = (Integer)oValue;
            if (end < ColumnsTableModel2.this.getBeginPosition(iRow)) {
                String sMessage = bundle.getString("ColumnsTableModel2.Error.EndPositionTooSmall.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (iRow < ColumnsTableModel2.this.getRowCount() - 1 && end >= ColumnsTableModel2.this.getBeginPosition(iRow + 1)) {
                String sMessage = bundle.getString("ColumnsTableModel2.Error.EndPositionTooLarge.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    protected class cBeginPositionTableColumn
    extends WsIntegerTableColumn {
        protected boolean m_overlap;

        public cBeginPositionTableColumn() {
            super(9, bundle.getString("ColumnsTableModel2.BeginPosition.txt"), 50, 0);
        }

        public void setOverlapColumns(boolean overlap) {
            this.m_overlap = overlap;
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (this.m_overlap) {
                return true;
            }
            int begin = (Integer)oValue;
            if (iRow != 0 && begin <= ColumnsTableModel2.this.getEndPosition(iRow - 1)) {
                String sMessage = bundle.getString("ColumnsTableModel2.Error.BeginPositionTooSmall.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (begin < 1) {
                String sMessage = bundle.getString("ColumnsTableModel2.Error.BeginPositionLessThan1.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (begin > ColumnsTableModel2.this.getEndPosition(iRow)) {
                String sMessage = bundle.getString("ColumnsTableModel2.Error.BeginPositionTooLarge.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    protected class cFormatsTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public cFormatsTableColumn() {
            super(7, bundle.getString("ColumnsTableModel2.Format.txt"), 100, bundle.getString("ColumnsTableModel2.None.txt"));
            this.setEditorEditable(true);
            this.setMaximumCharacters(32);
        }

        public void populate(JTable tbl, int row, int col) {
            String sType = (String)ColumnsTableModel2.this.getValueAt(row = ((WsTable)tbl).convertRowIndexToModel(row), 3);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterFormats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericFormats());
            }
        }
    }

    protected class cInformatsTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public cInformatsTableColumn() {
            super(6, bundle.getString("ColumnsTableModel2.Informat.txt"), 100, bundle.getString("ColumnsTableModel2.None.txt"));
            this.setEditorEditable(true);
            this.setMaximumCharacters(32);
        }

        public void populate(JTable tbl, int row, int col) {
            String sType = (String)ColumnsTableModel2.this.getValueAt(row = ((WsTable)tbl).convertRowIndexToModel(row), 3);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterInformats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericInformats());
            }
        }
    }

    protected class cTypeTableColumn
    extends WsEnumeratedTableColumn {
        public cTypeTableColumn(String[] saTypes) {
            super(3, bundle.getString("ColumnsTableModel2.Type.txt"), 75, saTypes);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            int length;
            String selectedType = (String)oValue;
            if (selectedType.equals(WsColumnMetadataUtil.getViewNumericType()) && ((length = ((Integer)mdlTable.getValueAt(iRow, 2)).intValue()) < 2 || length > 8)) {
                mdlTable.setValueAt((Object)8, iRow, 2);
            }
            return true;
        }
    }
}

