/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.lineage;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DirectorySelectorDialog {
    private static String lastSavePath = null;
    private String fileName = null;
    private String fullFileName = null;
    private Component m_cmp = null;
    private String m_defaultPath = "";
    private int m_fileTypes = 1;
    private int m_dialogType = 0;
    private JFileChooser m_fc;
    private FileFilter m_fileFilter;

    public DirectorySelectorDialog(Component cmp, String defaultPath) {
        this.m_cmp = cmp;
        this.m_defaultPath = defaultPath;
    }

    public DirectorySelectorDialog(Component cmp, String defaultPath, int fileType, int dialogType) {
        this(cmp, defaultPath);
        this.m_fileTypes = fileType;
        this.m_dialogType = dialogType;
    }

    public boolean showSelectDialog() {
        if (this.m_defaultPath.length() > 0) {
            lastSavePath = this.m_defaultPath;
        }
        this.m_fc = new JFileChooser(lastSavePath);
        if (this.m_fileFilter != null) {
            this.m_fc.setFileFilter(this.m_fileFilter);
        }
        this.m_fc.setDialogType(this.m_dialogType);
        this.m_fc.setFileSelectionMode(this.m_fileTypes);
        int rc = this.m_fc.showOpenDialog(this.m_cmp);
        if (rc == 0) {
            File file = this.m_fc.getSelectedFile();
            lastSavePath = file.getParent();
            this.fileName = file.getName();
            this.fullFileName = file.getPath();
            return true;
        }
        return false;
    }

    public String getFilePath() {
        return this.fullFileName;
    }

    public String getFilename() {
        return this.fileName;
    }

    public void setFileFilter(FileFilter filter) {
        this.m_fileFilter = filter;
        if (this.m_fc != null) {
            this.m_fc.setFileFilter(filter);
        }
    }
}

