/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.etl.models.IObject;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.ITransform;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.runtimedetails.StatusTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Icon;

public class StatusTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(StatusTableModel.class);
    public static final int NUMBER_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int STATUS_COLUMN = 2;
    public static final int DETAILS_COLUMN = 3;
    public static final int MODEL_COLUMN = 4;
    public static final int TRANSFORM_ICON_COLUMN = 5;
    public static final int STATUS_ICON_COLUMN = 6;
    protected static final int TOTAL_COLS = 4;
    protected static final int TOTAL_HIDDEN_COLS = 3;
    private static final int NUMBER_WIDTH = 50;
    private static final int NAME_WIDTH = 150;
    private static final int STATUS_WIDTH = 200;
    private static final int DETAILS_WIDTH = 300;

    public StatusTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsIntegerTableColumn(0, bundle.getString("StatusTableModel.NodeNumber.txt"), 50);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("StatusTableModel.Name.txt"), 150);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("StatusTableModel.Status.txt"), 200);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("StatusTableModel.Details.txt"), 300);
        this.m_aColumns[4] = new WsObjectTableColumn();
        this.m_aColumns[5] = new WsIconTableColumn();
        this.m_aColumns[6] = new WsIconTableColumn();
        ((WsStringTableColumn)this.m_aColumns[1]).setIconColumn(5);
        ((WsStringTableColumn)this.m_aColumns[2]).setIconColumn(6);
        ((WsIntegerTableColumn)this.m_aColumns[0]).setMissingValue(Integer.valueOf(Integer.MAX_VALUE));
    }

    public void insertRowForObject(String name, IObject object, boolean showNodeNumber, boolean bUnsupported) {
        ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        if (showNodeNumber) {
            alRow.add(this.getRowCount() + 1);
        } else {
            alRow.add(((WsIntegerTableColumn)this.m_aColumns[0]).getMissingValue());
        }
        alRow.add(name);
        if (object instanceof ICodeGenerator && !((ICodeGenerator)object).isCodeGenerationEnabled()) {
            alRow.add(StatusTab.STATUS_EXCLUDED);
        } else if (object instanceof ITransform && !((ITransform)object).isCompleteWithUserWritten()) {
            alRow.add(StatusTab.STATUS_INCOMPLETE);
        } else if (object instanceof ITransform && !((ITransform)object).isValidateAvailable() && bUnsupported) {
            alRow.add(StatusTab.STATUS_UNSUPPORTED);
        } else {
            alRow.add(StatusTab.STATUS_IN_PROGRESS);
        }
        alRow.add("");
        alRow.add(object);
        Icon icon = null;
        if (object instanceof ITransform) {
            icon = AppIconFactory.getAppInstance().getIconForTransformation(((ITransform)object).getType());
        } else if (object instanceof SimpleObject) {
            icon = AppIconFactory.getInstance().getIconForSimpleObject((SimpleObject)object);
        }
        alRow.add(icon);
        if (object instanceof ICodeGenerator && !((ICodeGenerator)object).isCodeGenerationEnabled()) {
            alRow.add(bundle.getImageIcon("StatusTableModel.Excluded.image"));
        } else if (object instanceof ITransform && !((ITransform)object).isCompleteWithUserWritten()) {
            alRow.add(bundle.getImageIcon("StatusTableModel.Incomplete.image"));
        } else if (object instanceof ITransform && !((ITransform)object).isValidateAvailable()) {
            alRow.add(bundle.getImageIcon("StatusTableModel.Unsupported.image"));
        } else {
            alRow.add(bundle.getImageIcon("StatusTableModel.InProgress.image"));
        }
        this.m_lData.add(alRow);
        this.fireTableRowsInserted(this.m_lData.size() - 1, this.m_lData.size() - 1);
    }

    public int getColumnCount() {
        return 4;
    }

    public int getHiddenColumnCount() {
        return 3;
    }

    public void moveDataToModel() {
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }
}

