/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.etl.models.job.impl.BaseJob;
import com.sas.etl.models.job.transforms.loop.impl.LoopEndTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.storage.jdbc.JDBCToTableModelAdapter;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsTab;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsTableModel;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class StatisticsGraphTableModel {
    private cGetPerfDataThread m_perfDataThread;
    private TableModel m_tableModel = new JDBCToTableModelAdapter();
    private StatisticsTab.PerfModel m_perfModel;
    private StatisticsTableModel m_statsModel;

    public void startPerfDataThreads(StatisticsTableModel statsModel) {
        this.m_statsModel = statsModel;
        this.m_perfModel.fireModelEvent("ModelNotUpdated");
        this.m_perfDataThread = new cGetPerfDataThread(this.m_tableModel, statsModel);
        this.m_perfDataThread.start();
    }

    public void setPerfModel(StatisticsTab.PerfModel model) {
        this.m_perfModel = model;
    }

    public TableModel getTableModel() {
        return this.m_perfDataThread.getModel();
    }

    public void moveDataToModel() {
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }

    private double getDoublePrimitiveFromTable(int iRow, int iCol) {
        Double DValue = (Double)this.m_statsModel.getValueAt(iRow, iCol);
        if (DValue == null) {
            return 0.0;
        }
        return DValue;
    }

    protected class ArmData
    extends DefaultTableModel {
        private Class[] columnClass = new Class[]{Double.class, String.class, Double.class, String.class, String.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};
        private String[] columnNames = new String[]{"Start", "aStart", "Duration", "Task", "TransID", "records", "real", "cpu", "memory", "OS memory", "I/O", "OS I/O", "lstart", "hstop"};
        double m_iLowestStartTime = 0.0;
        double m_iHighestStopTime = 0.0;

        public ArmData(StatisticsTableModel tModel) {
            Double DValue;
            String sVal;
            this.setColumnIdentifiers(this.columnNames);
            Vector<Object> rowData = null;
            double iRecs = 0.0;
            double iCpu = 0.0;
            double iReal = 0.0;
            double iMemory = 0.0;
            double iMemory2 = 0.0;
            double iIo = 0.0;
            double iIo2 = 0.0;
            double iStartTime = 0.0;
            double iStopTime = 0.0;
            double dValue = 0.0;
            for (int k = 0; k < tModel.getRowCount(); ++k) {
                boolean jobRow = false;
                if (tModel.getValueAt(k, 23) instanceof BaseJob) {
                    jobRow = true;
                }
                if (tModel.getValueAt(k, 23) instanceof LoopEndTransformModel) {
                    jobRow = true;
                }
                if (jobRow || ((String)tModel.getValueAt(k, 2)).trim().length() != 0) continue;
                sVal = (String)tModel.getValueAt(k, 17);
                DValue = Double.valueOf(sVal);
                dValue = DValue;
                if (dValue == 0.0) {
                    iStartTime = this.m_iLowestStartTime == 0.0 ? 0.0 : this.m_iLowestStartTime;
                } else {
                    if (dValue < iStartTime || iStartTime == 0.0) {
                        iStartTime = dValue;
                    }
                    if (this.m_iLowestStartTime == 0.0) {
                        this.m_iLowestStartTime = iStartTime;
                    } else if (this.m_iLowestStartTime > iStartTime) {
                        this.m_iLowestStartTime = iStartTime;
                    }
                }
                sVal = (String)tModel.getValueAt(k, 20);
                DValue = Double.valueOf(sVal);
                dValue = DValue;
                if (dValue == 0.0) {
                    iStopTime = this.m_iHighestStopTime == 0.0 ? 0.0 : this.m_iHighestStopTime;
                } else {
                    if (dValue > iStopTime || iStopTime == 0.0) {
                        iStopTime = dValue;
                    }
                    if (this.m_iHighestStopTime == 0.0) {
                        this.m_iHighestStopTime = iStopTime;
                    } else if (this.m_iHighestStopTime < iStopTime) {
                        this.m_iHighestStopTime = iStopTime;
                    }
                }
                dValue = StatisticsGraphTableModel.this.getDoublePrimitiveFromTable(k, 4);
                if (dValue > iRecs) {
                    iRecs = dValue;
                }
                if ((dValue = (DValue = Double.valueOf(sVal = (String)tModel.getValueAt(k, 18))).doubleValue()) > iReal) {
                    iReal = dValue;
                }
                if ((dValue = (DValue = Double.valueOf(sVal = (String)tModel.getValueAt(k, 19))).doubleValue()) > iCpu) {
                    iCpu = dValue;
                }
                if ((dValue = (DValue = (Double)tModel.getValueAt(k, 9)).doubleValue()) > iMemory) {
                    iMemory = dValue;
                }
                if ((dValue = (DValue = (Double)tModel.getValueAt(k, 10)).doubleValue()) > iMemory2) {
                    iMemory2 = dValue;
                }
                if ((dValue = StatisticsGraphTableModel.this.getDoublePrimitiveFromTable(k, 11)) > iIo) {
                    iIo = dValue;
                }
                if (!((dValue = StatisticsGraphTableModel.this.getDoublePrimitiveFromTable(k, 12)) > iIo2)) continue;
                iIo2 = dValue;
            }
            this.m_iHighestStopTime -= this.m_iLowestStartTime;
            for (int i = 0; i < tModel.getRowCount(); ++i) {
                boolean jobRow = false;
                if (tModel.getValueAt(i, 23) instanceof BaseJob) {
                    jobRow = true;
                }
                if (tModel.getValueAt(i, 23) instanceof LoopEndTransformModel) {
                    jobRow = true;
                }
                if (jobRow) continue;
                rowData = new Vector<Object>();
                sVal = (String)tModel.getValueAt(i, 17);
                DValue = Double.valueOf(sVal);
                double d = DValue;
                double t = d > 0.0 ? d - this.m_iLowestStartTime : d;
                rowData.add(new Double(t));
                sVal = (String)tModel.getValueAt(i, 5);
                rowData.add(sVal);
                DValue = (Double)tModel.getValueAt(i, 13);
                rowData.add(DValue);
                rowData.add(tModel.getValueAt(i, 1));
                rowData.add(tModel.getValueAt(i, 22));
                dValue = StatisticsGraphTableModel.this.getDoublePrimitiveFromTable(i, 4);
                Double iRecVal = iRecs == 0.0 ? new Double(0.0) : new Double(dValue / iRecs * 100.0);
                rowData.add(iRecVal);
                dValue = StatisticsGraphTableModel.this.getDoublePrimitiveFromTable(i, 7);
                Double iRealVal = iReal == 0.0 ? new Double(0.0) : new Double(dValue / iReal * 100.0);
                rowData.add(iRealVal);
                dValue = StatisticsGraphTableModel.this.getDoublePrimitiveFromTable(i, 8);
                Double iCpuVal = iCpu == 0.0 ? new Double(0.0) : new Double(dValue / iCpu * 100.0);
                rowData.add(iCpuVal);
                DValue = (Double)tModel.getValueAt(i, 9);
                dValue = DValue;
                Double iMemoryVal = iMemory == 0.0 ? new Double(0.0) : new Double(dValue / iMemory * 100.0);
                rowData.add(iMemoryVal);
                DValue = (Double)tModel.getValueAt(i, 10);
                dValue = DValue;
                Double iMemoryVal2 = iMemory2 == 0.0 ? new Double(0.0) : new Double(dValue / iMemory2 * 100.0);
                rowData.add(iMemoryVal2);
                DValue = (Double)tModel.getValueAt(i, 11);
                dValue = DValue;
                Double iIoVal = iIo == 0.0 ? new Double(0.0) : new Double(dValue / iIo * 100.0);
                rowData.add(iIoVal);
                DValue = (Double)tModel.getValueAt(i, 12);
                dValue = DValue;
                Double iIoVal2 = iIo2 == 0.0 ? new Double(0.0) : new Double(dValue / iIo2 * 100.0);
                rowData.add(iIoVal2);
                rowData.add(new Double(this.m_iLowestStartTime));
                rowData.add(new Double(this.m_iHighestStopTime));
                this.addRow(rowData);
            }
        }

        public Class getColumnClass(int column) {
            return this.columnClass[column];
        }
    }

    public class cGetPerfDataThread
    extends Thread {
        TableModel tableModel;

        public cGetPerfDataThread(TableModel model, StatisticsTableModel statsModel) {
            super("PerfData");
            this.setName("PerfData");
            this.tableModel = model;
            StatisticsGraphTableModel.this.m_statsModel = statsModel;
        }

        @Override
        public void run() {
            this.tableModel = new ArmData(StatisticsGraphTableModel.this.m_statsModel);
            StatisticsGraphTableModel.this.m_perfModel.fireModelEvent("ModelUpdated");
        }

        public TableModel getModel() {
            return this.tableModel;
        }
    }
}

