/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.AbstractDetailsTab;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.runtimedetails.ControlFlowTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class ControlFlowTab
extends AbstractDetailsTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ControlFlowTab.class);
    private static final int UP = 0;
    private static final int DOWN = 1;
    private IJob m_job;
    private ControlFlowTableModel m_mdlControlFlow;
    private JToolBar m_tools;
    private JScrollPane m_scrControlFlow;
    private WsTable m_tblControlFlow;
    private WsAbstractAction m_actAppend;
    private WsAbstractAction m_actValidate;
    private WsAbstractAction m_actProperties;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private WsAbstractAction m_actUndo;
    private WsAbstractAction m_actRedo;
    private WsAbstractAction m_actSelectAll;
    private ChangeListener m_lsnrUndo;
    private IModelListener m_lsnrModel;

    public ControlFlowTab(IJob job) {
        this.m_job = job;
        this.initialize();
        this.setName(bundle.getString("ControlFlowTab.Name.txt"));
    }

    protected void initialize() {
        this.createActions();
        this.createToolBar();
        this.createModel();
        this.createTable();
        this.layoutComponents();
        WsUndoManager mgrUndo = (WsUndoManager)this.m_job.getModel().getUndoManager();
        this.m_actUndo.setEnabled(mgrUndo.canUndo());
        this.m_actRedo.setEnabled(mgrUndo.canRedo());
        this.m_lsnrUndo = new UndoManagerListener();
        mgrUndo.addChangeListener(this.m_lsnrUndo);
        this.m_lsnrModel = new ModelListener();
        this.m_job.getModel().addModelListener(this.m_lsnrModel);
        this.updateActions();
    }

    private void createActions() {
        this.m_actAppend = new AppendAction();
        this.m_actValidate = new ValidateAction();
        this.m_actProperties = new PropertiesAction();
        this.m_actMoveUp = new MoveUpAction();
        this.m_actMoveDown = new MoveDownAction();
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
        this.m_actSelectAll = new SelectAllTransformsAction();
    }

    private void createToolBar() {
        this.m_tools = WsUIUtilities.createToolBar();
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actAppend));
        this.m_tools.addSeparator();
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveUp));
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveDown));
        this.m_tools.addSeparator();
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actValidate));
        this.m_tools.addSeparator();
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actUndo));
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRedo));
        this.m_tools.addSeparator();
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actProperties));
    }

    private void createModel() {
        this.m_mdlControlFlow = new ControlFlowTableModel(this.m_job);
        this.m_mdlControlFlow.moveDataToModel();
    }

    private void createTable() {
        this.m_tblControlFlow = new WsTable((WsAbstractTableModel)this.m_mdlControlFlow);
        this.m_scrControlFlow = new JScrollPane((Component)this.m_tblControlFlow);
        this.m_tblControlFlow.setSortingEnabled(false);
        this.m_tblControlFlow.setAutoResizeMode(3);
        this.m_tblControlFlow.setDefaultAction((Action)this.m_actProperties);
        TableColumn colWarning = this.m_tblControlFlow.getColumnModel().getColumn(0);
        colWarning.setResizable(false);
        colWarning.setMaxWidth(18);
        colWarning.setMinWidth(18);
        TablePopupMenuListener lsnrPopup = new TablePopupMenuListener();
        this.m_tblControlFlow.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnrPopup);
        this.m_tblControlFlow.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnrPopup);
        this.m_tblControlFlow.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new ViewportPopupMenuListener());
        this.m_tblControlFlow.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        ((WsDefaultTableRowModel)this.m_tblControlFlow.getRowModel()).addRowModelListener((WsTableRowModelListener)new RowModelListener());
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.m_tools, "North");
        this.add(this.m_scrControlFlow, "Center");
    }

    public void moveDataToView() {
        this.m_mdlControlFlow.moveDataToModel();
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlControlFlow.dispose();
        IModel mdl = this.m_job.getModel();
        ((WsUndoManager)mdl.getUndoManager()).removeChangeListener(this.m_lsnrUndo);
        mdl.removeModelListener(this.m_lsnrModel);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblControlFlow.setEditable(bEditable);
        this.m_tblControlFlow.setRowsReorderable(bEditable);
        this.updateActions();
    }

    private void updateActions() {
        int nInControlFlow = this.m_job.getControlOrderedTransformsList().size();
        int[] aRows = this.m_tblControlFlow.getSelectedRowsFromSelectedCells();
        boolean bOneSelected = aRows.length == 1;
        boolean bAtLeastOneSelected = aRows.length > 0;
        boolean bAllInControlFlow = bAtLeastOneSelected && aRows[aRows.length - 1] < nInControlFlow;
        boolean bAllNotInControlFlow = bAtLeastOneSelected && aRows[0] >= nInControlFlow;
        boolean bFirstSelected = bAllInControlFlow && aRows[0] == 0;
        boolean bLastSelected = bAllInControlFlow && aRows[aRows.length - 1] == nInControlFlow - 1;
        boolean bEditable = this.isEditable();
        this.m_actAppend.setEnabled(bEditable && bAtLeastOneSelected && bAllNotInControlFlow);
        this.m_actValidate.setEnabled(nInControlFlow > 0);
        this.m_actProperties.setEnabled(bOneSelected);
        this.m_actMoveUp.setEnabled(bEditable && bAllInControlFlow && !bFirstSelected);
        this.m_actMoveDown.setEnabled(bEditable && bAllInControlFlow && !bLastSelected);
        this.m_actSelectAll.setEnabled(this.m_tblControlFlow.getRowCount() > 0);
    }

    @Override
    public void setSelectedModelObjects(IObject[] aObjects) {
        this.setSelectionInProgress(true);
        this.m_tblControlFlow.clearSelection();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            int iRow;
            if (!(aObjects[iObject] instanceof ITransform) || (iRow = this.m_mdlControlFlow.getRowIndex((ITransform)aObjects[iObject])) == -1) continue;
            this.m_tblControlFlow.addRowToSelection(iRow);
        }
        this.setSelectionInProgress(false);
    }

    public WsTable getControlFlowTable() {
        return this.m_tblControlFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendTransformsToControlFlow() {
        this.m_job.getModel().startCompoundUndoable();
        try {
            int iTransform;
            int[] aSelectedRows = this.m_tblControlFlow.getSelectedRowsFromSelectedCells();
            this.m_tblControlFlow.clearSelection();
            ITransform[] aTransforms = new ITransform[aSelectedRows.length];
            for (iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
                aTransforms[iTransform] = this.m_mdlControlFlow.getTransformForRow(aSelectedRows[iTransform]);
            }
            this.m_job.getModel().undoableEditHappened((UndoableEdit)new SelectTransformUndoable(aTransforms, true, false));
            for (iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
                this.m_job.getControlOrderedTransformsList().add(aTransforms[iTransform]);
            }
            this.m_job.getModel().undoableEditHappened((UndoableEdit)new SelectTransformUndoable(aTransforms, false, true));
            this.m_tblControlFlow.clearSelection();
            this.selectTransforms(aTransforms);
        }
        finally {
            this.m_job.getModel().endCompoundUndoable();
        }
    }

    private void validateControlFlow() {
        List lBadTransformations = ((DesignTimeJobModel)this.m_job.getModel()).validateControlFlow();
        String sTitle = bundle.getString("ControlFlowTab.ValidationTitle.txt");
        if (lBadTransformations.isEmpty()) {
            String sMessage = bundle.getString("ControlFlowTab.Success.ControlFlow.txt");
            MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)1);
        } else {
            ITransform[] aBadTransformations = lBadTransformations.toArray(new ITransform[lBadTransformations.size()]);
            ArrayList<String> lBadTransformationNames = new ArrayList<String>(aBadTransformations.length);
            for (int iBadTransformation = 0; iBadTransformation < aBadTransformations.length; ++iBadTransformation) {
                lBadTransformationNames.add(aBadTransformations[iBadTransformation].getName());
            }
            String sMessage = bundle.getString("ControlFlowTab.Error.ControlFlow.txt");
            MessageUtil.displayListMessage((String)sMessage, lBadTransformationNames, (String)sTitle, (int)2);
            this.selectTransforms(aBadTransformations);
        }
    }

    private void showProperties() {
        int[] aSelectedRows = this.m_tblControlFlow.getSelectedRowsFromSelectedCells();
        ITransform xfm = this.m_mdlControlFlow.getTransformForRow(aSelectedRows[0]);
        IDiagramNodeAdapter adapter = DiagramNodeAdapterFactory.getInstance().createAdapter((IObject)xfm);
        adapter.showPropertiesDialog((Window)Workspace.getWorkspace());
    }

    private void selectAllTransforms() {
        this.m_tblControlFlow.selectAll();
    }

    private void selectTransforms(ITransform[] aTransforms) {
        this.m_tblControlFlow.clearSelection();
        for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
            int iRow = this.m_mdlControlFlow.getRowIndex(aTransforms[iTransform]);
            if (iRow == -1) continue;
            this.m_tblControlFlow.addRowToSelection(iRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedTransforms(int eDir) {
        if (eDir != 0 && eDir != 1) {
            throw new IllegalArgumentException("Direction must be UP or DOWN but is: " + eDir);
        }
        if (!this.m_tblControlFlow.stopCellEditing()) {
            return;
        }
        this.m_job.getModel().startCompoundUndoable();
        try {
            int[] aRows = this.m_tblControlFlow.getSelectedRowsFromSelectedCells();
            this.m_tblControlFlow.clearSelection();
            this.m_job.getModel().undoableEditHappened(this.m_tblControlFlow.createSelectRowsUndoable(aRows, true));
            List lTransforms = this.m_job.getControlOrderedTransformsList();
            if (eDir == 1) {
                for (int iRow = aRows.length - 1; iRow >= 0; --iRow) {
                    ITransform transform = this.m_mdlControlFlow.getTransformForRow(aRows[iRow]);
                    lTransforms.remove(transform);
                    int n = iRow;
                    aRows[n] = aRows[n] + 1;
                    lTransforms.add(aRows[iRow], transform);
                }
            } else {
                for (int iRow = 0; iRow < aRows.length; ++iRow) {
                    ITransform transform = this.m_mdlControlFlow.getTransformForRow(aRows[iRow]);
                    lTransforms.remove(transform);
                    int n = iRow;
                    aRows[n] = aRows[n] - 1;
                    lTransforms.add(aRows[iRow], transform);
                }
            }
            this.m_tblControlFlow.selectRows(aRows);
            this.m_job.getModel().undoableEditHappened(this.m_tblControlFlow.createSelectRowsUndoable(aRows, false));
        }
        finally {
            this.m_job.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTransform(int iFrom, int iTo) {
        if (!this.m_tblControlFlow.stopCellEditing()) {
            return;
        }
        this.m_job.getModel().startCompoundUndoable();
        try {
            this.m_job.getModel().undoableEditHappened(this.m_tblControlFlow.createSelectRowUndoable(iFrom, true));
            this.m_tblControlFlow.clearSelection();
            ITransform xfm = this.m_mdlControlFlow.getTransformForRow(iFrom);
            List lExecution = this.m_job.getControlOrderedTransformsList();
            boolean bInExecution = lExecution.contains(xfm);
            if (bInExecution) {
                lExecution.remove(xfm);
            }
            if (iTo <= lExecution.size()) {
                lExecution.add(iTo, xfm);
            }
            this.m_tblControlFlow.selectRow(iTo);
            this.m_job.getModel().undoableEditHappened(this.m_tblControlFlow.createSelectRowUndoable(iTo, false));
        }
        finally {
            this.m_job.getModel().endCompoundUndoable();
        }
    }

    private class SelectTransformUndoable
    extends AbstractUndoableEdit {
        private ITransform[] m_aTransforms;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectTransformUndoable(ITransform xfm, boolean bOnUndo, boolean bOnRedo) {
            this(new ITransform[]{xfm}, bOnUndo, bOnRedo);
        }

        public SelectTransformUndoable(ITransform[] aTransforms, boolean bOnUndo, boolean bOnRedo) {
            this.m_aTransforms = aTransforms;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            ControlFlowTab.this.m_tblControlFlow.clearSelection();
            if (this.m_bOnUndo) {
                ControlFlowTab.this.selectTransforms(this.m_aTransforms);
            }
        }

        @Override
        public void redo() {
            super.redo();
            ControlFlowTab.this.m_tblControlFlow.clearSelection();
            if (this.m_bOnRedo) {
                ControlFlowTab.this.selectTransforms(this.m_aTransforms);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aTransforms, null);
            this.m_aTransforms = null;
        }
    }

    private class SelectAllTransformsAction
    extends WsAbstractAction {
        public SelectAllTransformsAction() {
            super(bundle, "ControlFlowTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ControlFlowTab.this.selectAllTransforms();
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Redo"));
            this.setToolTipText(bundle.getString("ControlFlowTab.Action.Redo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            ControlFlowTab.this.m_job.getModel().getUndoManager().redo();
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Undo"));
            this.setToolTipText(bundle.getString("ControlFlowTab.Action.Undo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            ControlFlowTab.this.m_job.getModel().getUndoManager().undo();
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "ControlFlowTab.Action.MoveDown", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        public void actionPerformed(ActionEvent ev) {
            ControlFlowTab.this.moveSelectedTransforms(1);
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "ControlFlowTab.Action.MoveUp", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        public void actionPerformed(ActionEvent ev) {
            ControlFlowTab.this.moveSelectedTransforms(0);
        }
    }

    private class PropertiesAction
    extends WsAbstractAction {
        public PropertiesAction() {
            super(bundle, "ControlFlowTab.Action.Properties", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Properties"));
        }

        public void actionPerformed(ActionEvent ev) {
            ControlFlowTab.this.showProperties();
        }
    }

    private class ValidateAction
    extends WsAbstractAction {
        public ValidateAction() {
            super(bundle, "ControlFlowTab.Action.Validate", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Validate"));
        }

        public void actionPerformed(ActionEvent ev) {
            ControlFlowTab.this.validateControlFlow();
        }
    }

    private class AppendAction
    extends WsAbstractAction {
        public AppendAction() {
            super(bundle, "ControlFlowTab.Action.Append", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Append"));
        }

        public void actionPerformed(ActionEvent ev) {
            ControlFlowTab.this.appendTransformsToControlFlow();
        }
    }

    private class RowModelListener
    implements WsTableRowModelListener {
        private RowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)ControlFlowTab.this.m_tblControlFlow.getRowModel();
            mdlRows.clearRowMoves();
            ControlFlowTab.this.moveTransform(ev.getFromIndex(), ev.getToIndex());
        }

        public void rowsRemapped(ChangeEvent ev) {
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class ViewportPopupMenuListener
    implements WsPopupMenuRequestListener {
        private ViewportPopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)ControlFlowTab.this.m_actSelectAll));
            mnuPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class TablePopupMenuListener
    implements WsPopupMenuRequestListener {
        private TablePopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)ControlFlowTab.this.m_actAppend));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)ControlFlowTab.this.m_actMoveUp));
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)ControlFlowTab.this.m_actMoveDown));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)ControlFlowTab.this.m_actSelectAll));
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)ControlFlowTab.this.m_actProperties));
            mnuPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            ControlFlowTab.this.updateActions();
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            UndoManager mgrUndo = ControlFlowTab.this.m_job.getModel().getUndoManager();
            ControlFlowTab.this.m_actUndo.setEnabled(mgrUndo.canUndo());
            ControlFlowTab.this.m_actRedo.setEnabled(mgrUndo.canRedo());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            ControlFlowTab.this.m_tblControlFlow.cancelCellEditing();
            String sType = ev.getType();
            if (sType == "ModelController:UnknownChanges" || sType == "Job:TransformAddedToExecutionOrder" || sType == "Job:TransformRemovedFromExecutionOrder") {
                ControlFlowTab.this.updateActions();
            }
        }
    }
}

