/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.data.IDataNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IWorkTableNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.AdapterNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataNode;
import com.sas.workspace.Workspace;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class WorkTableNode
extends DataNode
implements IWorkTableNode {
    private String m_sTransformNodeId;
    protected String m_sId;
    private int m_iXLocation;
    private int m_iYLocation;

    public WorkTableNode() {
    }

    public WorkTableNode(IDataNodeAdapter adapter) {
        super(adapter);
        if (this.getUIPlacement() != null && this.getUIPlacement().getNodeId() != null) {
            this.setSpotLocation(1, new Point(this.getUIPlacement().getXPosition(), this.getUIPlacement().getYPosition()));
            this.refresh();
        } else {
            this.setId(GUID.newGUID());
            if (this.getUIPlacement() != null) {
                this.getUIPlacement().setNodeId(this.getId());
            }
        }
    }

    protected WorkTableNode(List lAttributes, List lValues, IDesignTimeModel jobModel) {
        int iTransformIndex = -1;
        int iIndex = -1;
        for (int i = 0; i < lAttributes.size(); ++i) {
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.m_sId = sValue;
                continue;
            }
            if (sAttribute.equalsIgnoreCase("TransformNodeId")) {
                this.setTransformNodeId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionX")) {
                this.m_iXLocation = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionY")) {
                this.m_iYLocation = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("TransformIndex")) {
                iTransformIndex = Integer.parseInt(sValue);
                continue;
            }
            if (!sAttribute.equalsIgnoreCase("Index")) continue;
            iIndex = Integer.parseInt(sValue);
        }
        IDataObject[] tables = null;
        try {
            IDataTransform transform = (IDataTransform)jobModel.getJob().getTransformsList().get(iTransformIndex);
            tables = transform.getDataTargets();
            IDiagramNodeAdapter adapter = DiagramNodeAdapterFactory.getInstance().createAdapter((IObject)tables[iIndex]);
            if (!(adapter.getObject() instanceof IWorkTable)) {
                if (tables != null) {
                    ArrayList<IDataObject> tableList = new ArrayList<IDataObject>();
                    for (int iData = 0; iData < tables.length; ++iData) {
                        tableList.add(tables[iData]);
                    }
                    String message = "The wrong adapter was being created for a work table node with the index - " + iIndex + " in the transformation target list: " + ((Object)tableList).toString() + " the type of adapter created was " + adapter.getObject().getClass().toString();
                    Workspace.getDefaultLogger().debug((Object)message);
                }
                this.setCleanUpRequired(true);
                return;
            }
            this.setAdapterNode(new AdapterNode(adapter, this));
            this.getUIPlacement().setNodeId(this.m_sId);
            this.getUIPlacement().setXPosition(this.m_iXLocation);
            this.getUIPlacement().setYPosition(this.m_iYLocation);
            this.getUIPlacement().setChanged(false);
            this.setSpotLocation(1, new Point(this.getUIPlacement().getXPosition(), this.getUIPlacement().getYPosition()));
            this.refresh();
            this.setNodeStyleContext("NodeStyle3");
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            if (tables != null) {
                ArrayList<IDataObject> tableList = new ArrayList<IDataObject>();
                for (int iData = 0; iData < tables.length; ++iData) {
                    tableList.add(tables[iData]);
                }
                String message = "An exception occurred while trying to create a work table node with the index - " + iIndex + " in the transformation target list: " + ((Object)tableList).toString();
                Workspace.getDefaultLogger().debug((Object)message);
            } else {
                String message = "An exception occurred while trying to create a work table node because it could not find the transform with the index - " + iTransformIndex + " in the tranformation list " + jobModel.getJob().getTransformsList().toString();
                Workspace.getDefaultLogger().debug((Object)message);
            }
            this.setCleanUpRequired(true);
            return;
        }
    }

    @Override
    public String getTransformNodeId() {
        return this.m_sTransformNodeId;
    }

    @Override
    public void setTransformNodeId(String sTransformNodeId) {
        this.m_sTransformNodeId = sTransformNodeId;
    }

    @Override
    public void setLocation(Point location) {
        super.setSpotLocation(1, location);
    }

    @Override
    public void setUIPlacement(IDesignTimeModel designModel) {
    }

    @Override
    public IUIPlacement getUIPlacement() {
        if (this.getObject() instanceof IWorkTable) {
            return ((IWorkTable)this.getObject()).getUIPlacement();
        }
        return null;
    }
}

