/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPasteModify;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.graphics.components.pfd.PFDNote;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.jobeditor.diagram.IPFDModel;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class StickyNoteNode
extends PFDNote
implements IDiagramStickyNote {
    private String m_name;
    private String m_sId;
    private String m_sOldText;
    private int m_iUndoableCounter = 0;
    private boolean m_bFirstTime = true;
    private FocusListener m_lsnrTextPane;

    public StickyNoteNode() {
        this.m_sId = GUID.newGUID();
        this.initializeListeners();
        this.setOldTextForUndoable(this.getText());
    }

    protected StickyNoteNode(List lAttributes, List lValues) {
        int xPos = 0;
        int yPos = 0;
        for (int i = 0; i < lAttributes.size(); ++i) {
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.setId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionX")) {
                xPos = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionY")) {
                yPos = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("Expanded")) {
                this.setCollapsed(Boolean.parseBoolean(sValue));
                continue;
            }
            if (sAttribute.equalsIgnoreCase("Style")) {
                this.setNoteStyleContext(sValue);
                continue;
            }
            if (!sAttribute.equalsIgnoreCase("Text")) continue;
            this.setText(sValue);
        }
        this.setOldTextForUndoable(this.getText());
        this.setSpotLocation(1, new Point(xPos, yPos));
        this.initializeListeners();
    }

    private void setId(String sId) {
        this.m_sId = sId;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void setNoteStyleContext(String styleContext) {
        if (this.getModel() != null && ((IPFDModel)this.getModel()).getObjectModel() != null && ((IPFDModel)this.getModel()).getObjectModel().isUndoSupported()) {
            ((IPFDModel)this.getModel()).getObjectModel().undoableEditHappened((UndoableEdit)new SetNoteStyleUndoable(this.getNoteStyleContext(), styleContext));
        }
        super.setNoteStyleContext(styleContext);
    }

    public void setLocation(Point location) {
        super.setSpotLocation(1, location);
    }

    @Override
    public String getId() {
        return this.m_sId;
    }

    private String getOldTextForUndoable() {
        return this.m_sOldText;
    }

    private void setOldTextForUndoable(String sOldText) {
        this.m_sOldText = sOldText;
    }

    private void initializeListeners() {
        Document doc = this.getTextPane().getDocument();
        DocumentUndoableEditListener edit = new DocumentUndoableEditListener();
        doc.addUndoableEditListener(edit);
        this.m_lsnrTextPane = new TextPaneFocusListener();
        this.addFocusListener(this.m_lsnrTextPane);
    }

    public List getMenuItems() {
        List menuItems = super.getMenuItems();
        ArrayList newMenuItems = new ArrayList();
        newMenuItems.addAll(menuItems);
        for (int iItem = 0; iItem < menuItems.size(); ++iItem) {
            if (!(menuItems.get(iItem) instanceof JMenuItem) || ((JMenuItem)menuItems.get(iItem)).getAction() != this.getAction("ACTION_CUT") && ((JMenuItem)menuItems.get(iItem)).getAction() != this.getAction("ACTION_COPY")) continue;
            newMenuItems.remove(menuItems.get(iItem));
        }
        menuItems.clear();
        menuItems.addAll(newMenuItems);
        return menuItems;
    }

    @Override
    public String writeToXML(IDesignTimeModel job) {
        StringBuffer outXML = new StringBuffer();
        outXML.append("<StickyNoteNode>");
        outXML.append("<NodeId>");
        outXML.append(this.getId());
        outXML.append("</NodeId>");
        Point point = this.getSpotLocation(1, null);
        outXML.append("<PositionX>");
        outXML.append(String.valueOf(point.x));
        outXML.append("</PositionX>");
        outXML.append("<PositionY>");
        outXML.append(String.valueOf(point.y));
        outXML.append("</PositionY>");
        outXML.append("<Expanded>");
        outXML.append(String.valueOf(this.isCollapsed()));
        outXML.append("</Expanded>");
        outXML.append("<Style>");
        outXML.append(this.getNoteStyleContext());
        outXML.append("</Style>");
        if (this.getText() != null && !this.getText().equalsIgnoreCase("")) {
            outXML.append("<Text>");
            outXML.append(MetadataUtil.cleanStringForXML((String)this.getText()));
            outXML.append("</Text>");
        }
        outXML.append("</StickyNoteNode>");
        return outXML.toString();
    }

    public void addFocusListener(FocusListener f) {
        this.getTextPane().addFocusListener(f);
    }

    public List<IObject> pasteAction() throws MdException, RemoteException {
        this.setId(GUID.newGUID());
        return new ArrayList<IObject>();
    }

    public List<IPasteModify> getPasteChildObjects() {
        return null;
    }

    private class TextPaneFocusListener
    implements FocusListener {
        private TextPaneFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (StickyNoteNode.this.m_iUndoableCounter > 0) {
                System.out.println("focus time");
                ((IPFDModel)StickyNoteNode.this.getModel()).getObjectModel().undoableEditHappened((UndoableEdit)new SetTextUndoable(StickyNoteNode.this.getOldTextForUndoable(), StickyNoteNode.this.getText()));
                StickyNoteNode.this.setOldTextForUndoable(StickyNoteNode.this.getText());
                StickyNoteNode.this.m_iUndoableCounter = 0;
            }
        }
    }

    class DocumentUndoableEditListener
    implements UndoableEditListener {
        DocumentUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (StickyNoteNode.this.m_bFirstTime) {
                ((IPFDModel)StickyNoteNode.this.getModel()).getObjectModel().undoableEditHappened((UndoableEdit)new SetTextUndoable(StickyNoteNode.this.getOldTextForUndoable(), StickyNoteNode.this.getText()));
                StickyNoteNode.this.setOldTextForUndoable(StickyNoteNode.this.getText());
                StickyNoteNode.this.m_bFirstTime = false;
                System.out.println("first time");
            } else if (StickyNoteNode.this.m_iUndoableCounter < 25) {
                StickyNoteNode.this.m_iUndoableCounter++;
            } else {
                System.out.println("25 time");
                ((IPFDModel)StickyNoteNode.this.getModel()).getObjectModel().undoableEditHappened((UndoableEdit)new SetTextUndoable(StickyNoteNode.this.getOldTextForUndoable(), StickyNoteNode.this.getText()));
                StickyNoteNode.this.setOldTextForUndoable(StickyNoteNode.this.getText());
                StickyNoteNode.this.m_iUndoableCounter = 0;
            }
        }
    }

    private class SetTextUndoable
    extends AbstractUndoableEdit {
        private String m_oldText;
        private String m_newText;

        public SetTextUndoable(String oldText, String newText) {
            this.m_oldText = oldText;
            this.m_newText = newText;
        }

        @Override
        public void undo() {
            super.undo();
            StickyNoteNode.this.setText(this.m_oldText);
        }

        @Override
        public void redo() {
            super.redo();
            StickyNoteNode.this.setText(this.m_newText);
        }
    }

    private class SetNoteStyleUndoable
    extends AbstractUndoableEdit {
        private String m_oldStyle;
        private String m_newStyle;

        public SetNoteStyleUndoable(String oldStyle, String newStyle) {
            this.m_oldStyle = oldStyle;
            this.m_newStyle = newStyle;
        }

        @Override
        public void undo() {
            super.undo();
            PFDAbstractAction oldAction = StickyNoteNode.this.getStyleAction(this.m_oldStyle);
            oldAction.setSelected(true);
            StickyNoteNode.this.setNoteStyleContext(this.m_oldStyle);
        }

        @Override
        public void redo() {
            super.redo();
            PFDAbstractAction newAction = StickyNoteNode.this.getStyleAction(this.m_newStyle);
            newAction.setSelected(true);
            StickyNoteNode.this.setNoteStyleContext(this.m_newStyle);
        }
    }
}

