/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramPersistable;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BaseLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramContentHandler;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.StickyNoteNode;
import com.sas.workspace.Workspace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DiagramUtil {
    private static final String STRHEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    public static final String XMLTAG_STARTOFLIST = "ShapeList";
    public static final String XMLTAG_CONTROL_LINK = "ControlLink";
    public static final String XMLTAG_DATA_LINK = "DataLink";
    public static final String XMLTAG_WORKTABLE_NODE = "WorkTableNode";
    public static final String XMLTAG_DATA_NODE = "DataNode";
    public static final String XMLTAG_DATATRANSFORM_NODE = "DataTransformNode";
    public static final String XMLTAG_STICKYNOTE_NODE = "StickyNoteNode";
    public static final String XMLTAG_CONTROLTRANSFORM_NODE = "ControlTransformNode";

    private DiagramUtil() {
    }

    public static void getObjectsFromXML(String xml, List alLinks, List alNodes, List alNotes, IDesignTimeModel jobModel) throws SAXException, IOException, ParserConfigurationException {
        DiagramUtil.getObjectsFromXML(new DiagramContentHandler(alLinks, alNodes, alNotes, jobModel), xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getObjectsFromXML(DiagramContentHandler handler, String xml) throws SAXException, IOException, ParserConfigurationException {
        String encoding = "UTF-8";
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
            InputSource source = new InputSource(reader);
            parser.parse(source, (DefaultHandler)handler);
            ((InputStream)stream).reset();
        }
    }

    public static void testDiagramUtil() {
        ArrayList<IDiagramPersistable> listOfObjects = new ArrayList<IDiagramPersistable>();
        BaseLink cl = new BaseLink();
        cl.setName("3");
        cl.setIsControl(true);
        cl.setToNodeId("toNodecl1");
        cl.setFromNodeId("fromNodecl1");
        cl.setFromNodePortIndex(50);
        cl.setToNodePortIndex(51);
        listOfObjects.add(cl);
        BaseLink dl = new BaseLink();
        dl.setName("3");
        dl.setToNodeId("toNodecl1");
        dl.setFromNodeId("fromNodecl1");
        dl.setFromNodePortIndex(50);
        dl.setToNodePortIndex(51);
        listOfObjects.add(dl);
        StickyNoteNode snn = new StickyNoteNode();
        snn.setName("10");
        snn.setLocation(1, 2);
        snn.setNoteStyleContext("NoteStyleBlue");
        snn.setText("Now is the time for all good men");
        listOfObjects.add(snn);
        String test = DiagramUtil.getXMLForObjects(listOfObjects);
        System.out.println("OUTXML =" + test);
        ArrayList alLinks = new ArrayList();
        ArrayList alNodes = new ArrayList();
        ArrayList alNotes = new ArrayList();
        try {
            DiagramUtil.getObjectsFromXML(test, alLinks, alNodes, alNotes, null);
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
    }

    public static String getXMLForObjects(Collection listOfObjects) {
        return DiagramUtil.getXMLForObjects(listOfObjects, null);
    }

    public static String getXMLForObjects(Collection listOfObjects, IDesignTimeModel jobModel) {
        StringBuffer outXML = new StringBuffer();
        outXML.append(STRHEADER);
        outXML.append("<ShapeList>");
        for (IDiagramPersistable shape : listOfObjects) {
            outXML.append(shape.writeToXML(jobModel));
        }
        outXML.append("</ShapeList>");
        return outXML.toString();
    }

    public String cleanStringForXML(String s) throws RemoteException {
        if (s == null) {
            return "";
        }
        StringBuffer parsed = new StringBuffer(s.length());
        int len = s.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '<': 
                case '>': 
                case '\\': {
                    parsed.append("&#");
                    parsed.append(Integer.toString(c));
                    parsed.append(';');
                    continue block3;
                }
                default: {
                    parsed.append(c);
                }
            }
        }
        return parsed.toString();
    }
}

