/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.ControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.ControlTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramParserException;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.StickyNoteNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.WorkTableNode;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DiagramContentHandler
extends DefaultHandler {
    protected static int STATE_NOTSTARTED = 0;
    protected static int STATE_DOCUMENT_STARTED = 1;
    protected static int STATE_HEADER_STARTED = 2;
    protected static int STATE_NODE_STARTED = 3;
    protected static int STATE_ELEMENT_STARTED = 4;
    protected static int STATE_ELEMENT_ENDED = 5;
    protected static int STATE_NODE_ENDED = 6;
    protected static int STATE_HEADER_ENDED = 7;
    protected static int STATE_DOCUMENT_ENDED = 8;
    protected static int STATE_ERROR = 50;
    protected static String STATE_BLANK = "";
    private String m_sCurrentElement;
    private String m_sCurrentValue;
    private String m_sWhichElement;
    private int m_elementState;
    private int m_documentState;
    private ArrayList m_alAttributeList;
    private ArrayList m_alValueList;
    private List m_lLinks;
    private List m_lNodes;
    private List m_lNotes;
    private IDesignTimeModel m_jobModel;
    private static final WAdminResource bundle = WAdminResource.getBundle(DiagramContentHandler.class);

    public DiagramContentHandler(List links, List nodes, List notes, IDesignTimeModel jobModel) {
        links.clear();
        nodes.clear();
        notes.clear();
        this.m_documentState = STATE_NOTSTARTED;
        this.m_elementState = STATE_NOTSTARTED;
        this.m_sCurrentElement = STATE_BLANK;
        this.m_sCurrentValue = null;
        this.m_sWhichElement = "";
        this.m_alAttributeList = new ArrayList();
        this.m_alValueList = new ArrayList();
        this.m_lLinks = links;
        this.m_lNodes = nodes;
        this.m_lNotes = notes;
        this.m_jobModel = jobModel;
    }

    public List getNodes() {
        return this.m_lNodes;
    }

    public List getNotes() {
        return this.m_lNotes;
    }

    public List getLinks() {
        return this.m_lLinks;
    }

    public void addNode(IDiagramNode node) {
        this.m_lNodes.add(node);
    }

    public void addNote(StickyNoteNode node) {
        this.m_lNotes.add(node);
    }

    public void addLink(IDiagramLink link) {
        this.m_lLinks.add(link);
    }

    @Override
    public void startDocument() {
        if (this.m_documentState == STATE_ERROR) {
            return;
        }
        this.m_documentState = STATE_DOCUMENT_STARTED;
    }

    @Override
    public void endDocument() {
        if (this.m_documentState == STATE_ERROR) {
            return;
        }
        this.m_documentState = STATE_DOCUMENT_ENDED;
    }

    private boolean checkStartState() {
        if (this.m_documentState == STATE_ERROR) {
            return false;
        }
        if (this.m_documentState < STATE_DOCUMENT_STARTED || this.m_documentState == STATE_DOCUMENT_ENDED) {
            this.m_documentState = STATE_ERROR;
            return false;
        }
        return true;
    }

    public void setDocumentState(int state) {
        this.m_documentState = state;
    }

    public void setElement(String element) {
        this.m_sWhichElement = element;
    }

    public String getElement() {
        return this.m_sWhichElement;
    }

    public void setCurrentValue(String value) {
        this.m_sCurrentValue = value;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.m_documentState == STATE_ERROR) {
            return;
        }
        if (!this.checkStartState()) {
            return;
        }
        if ((this.m_documentState >= STATE_HEADER_STARTED || this.m_documentState >= STATE_HEADER_ENDED) && this.m_sCurrentElement.compareTo("ShapeList") == 0) {
            this.m_documentState = STATE_ERROR;
            return;
        }
        String elementName = "";
        if ("".equals(uri)) {
            this.m_sCurrentValue = "";
            elementName = qName;
        } else {
            elementName = name;
        }
        if (elementName.compareTo("ShapeList") == 0) {
            this.m_documentState = STATE_HEADER_STARTED;
        } else if (elementName.equalsIgnoreCase("ControlLink")) {
            this.m_documentState = STATE_NODE_STARTED;
            this.m_sWhichElement = "ControlLink";
        } else if (elementName.equalsIgnoreCase("DataLink")) {
            this.m_documentState = STATE_NODE_STARTED;
            this.m_sWhichElement = "DataLink";
        } else if (elementName.equalsIgnoreCase("DataNode")) {
            this.m_documentState = STATE_NODE_STARTED;
            this.m_sWhichElement = "DataNode";
        } else if (elementName.equalsIgnoreCase("DataTransformNode")) {
            this.m_documentState = STATE_NODE_STARTED;
            this.m_sWhichElement = "DataTransformNode";
        } else if (elementName.equalsIgnoreCase("ControlTransformNode")) {
            this.m_documentState = STATE_NODE_STARTED;
            this.m_sWhichElement = "ControlTransformNode";
        } else if (elementName.equalsIgnoreCase("WorkTableNode")) {
            this.m_documentState = STATE_NODE_STARTED;
            this.m_sWhichElement = "WorkTableNode";
        } else if (elementName.equalsIgnoreCase("StickyNoteNode")) {
            this.m_documentState = STATE_NODE_STARTED;
            this.m_sWhichElement = "StickyNoteNode";
        } else if (this.m_documentState == STATE_NODE_STARTED) {
            this.m_elementState = STATE_ELEMENT_STARTED;
            this.m_sCurrentElement = elementName;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.m_documentState == STATE_ERROR) {
            return;
        }
        if (this.m_elementState == STATE_ELEMENT_STARTED) {
            this.m_elementState = STATE_ELEMENT_ENDED;
            this.m_alAttributeList.add(this.m_sCurrentElement);
            this.m_alValueList.add(this.m_sCurrentValue);
            this.m_sCurrentValue = "";
            this.m_sCurrentElement = STATE_BLANK;
        } else if (this.m_documentState == STATE_NODE_STARTED) {
            this.m_elementState = STATE_ELEMENT_ENDED;
            this.m_documentState = STATE_NODE_ENDED;
            try {
                this.createNode();
            }
            catch (Exception ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                this.m_elementState = STATE_ELEMENT_ENDED;
                this.m_documentState = STATE_ERROR;
                throw new DiagramParserException(bundle.getString("DiagramParserError.txt"));
            }
            this.m_alAttributeList.clear();
            this.m_alValueList.clear();
        } else if (this.m_documentState == STATE_HEADER_STARTED) {
            this.m_elementState = STATE_ELEMENT_ENDED;
            this.m_documentState = STATE_HEADER_ENDED;
        }
    }

    public List getAttributeList() {
        return this.m_alAttributeList;
    }

    public List getValueList() {
        return this.m_alValueList;
    }

    public IDesignTimeModel getModel() {
        return this.m_jobModel;
    }

    protected void createNode() {
        if (this.m_documentState == STATE_ERROR) {
            return;
        }
        if (this.m_sWhichElement == "ControlLink") {
            ControlLink cl = new ControlLink(this.m_alAttributeList, this.m_alValueList);
            this.m_lLinks.add(cl);
        } else if (this.m_sWhichElement == "DataLink") {
            DataLink cl = new DataLink(this.m_alAttributeList, this.m_alValueList);
            this.m_lLinks.add(cl);
        } else if (this.m_sWhichElement == "WorkTableNode") {
            WorkTableNode cl = new WorkTableNode(this.m_alAttributeList, this.m_alValueList, this.m_jobModel);
            this.m_lNodes.add(cl);
        } else if (this.m_sWhichElement == "DataNode") {
            DataNode cl = new DataNode(this.m_alAttributeList, this.m_alValueList, this.m_jobModel);
            this.m_lNodes.add(cl);
        } else if (this.m_sWhichElement == "DataTransformNode") {
            DataTransformNode cl = new DataTransformNode(this.m_alAttributeList, this.m_alValueList, this.m_jobModel);
            this.m_lNodes.add(cl);
        } else if (this.m_sWhichElement == "ControlTransformNode") {
            ControlTransformNode cl = new ControlTransformNode(this.m_alAttributeList, this.m_alValueList, this.m_jobModel);
            this.m_lNodes.add(cl);
        } else if (this.m_sWhichElement == "StickyNoteNode") {
            StickyNoteNode cl = new StickyNoteNode(this.m_alAttributeList, this.m_alValueList);
            this.m_lNotes.add(cl);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_documentState == STATE_ERROR) {
            return;
        }
        if (!this.checkStartState()) {
            return;
        }
        if (this.m_sCurrentElement.equalsIgnoreCase(STATE_BLANK)) {
            return;
        }
        if (this.m_documentState == STATE_HEADER_STARTED) {
            return;
        }
        if (this.m_elementState != STATE_ELEMENT_STARTED) {
            return;
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(ch, start, length);
        this.m_sCurrentValue = this.m_sCurrentValue + strBuf.toString();
    }
}

