/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.graphics.components.pfd.PFDAbstractButton;
import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.PFDWorkTableGroupNode;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollection;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IDataTransformNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.ITransformNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IAdapterNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.ITransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.AdapterNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BasePort;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.mutable.MutableInt;

public class DataTransformNode
extends PFDWorkTableGroupNode
implements IDataTransformNode,
WsPFDPrimitive {
    private static final WAdminResource bundle = WAdminResource.getBundle(DataTransformNode.class);
    private IAdapterNode m_adapterNode;
    private List m_lIndicatorButtons;
    private int m_eValidateStatus;
    private String[] m_eValidateStatusMessages;
    private int m_eRunStatus;
    private String[] m_eRunStatusMessages;
    private int m_eMode;
    private String m_sId;
    private int m_xPosition;
    private int m_yPosition;
    private boolean m_bActive;
    private boolean m_bCleanUpRequired;
    private int m_eStatus;
    private String m_sStatusContent;

    public DataTransformNode(ITransformNodeAdapter adapter) {
        this.m_adapterNode = new AdapterNode(adapter, this);
        this.setNodeStyleContext("NodeStyle1");
        this.m_lIndicatorButtons = new ArrayList();
        this.getIndicatorButtons();
        if (this.getUIPlacement().getNodeId() != null) {
            this.setForceShowPorts(!this.getUIPlacement().getCollapsed());
            this.setSpotLocation(1, new Point(this.getUIPlacement().getXPosition(), this.getUIPlacement().getYPosition()));
            this.setCollapsed(this.getUIPlacement().getCollapsed());
            this.refresh();
        } else {
            this.getUIPlacement().setNodeId(GUID.newGUID());
            this.setCollapsed(DiagramPanel.isUserPreferenceToCollapse());
        }
        this.m_eStatus = -1;
    }

    protected DataTransformNode(List lAttributes, List lValues, IDesignTimeModel jobModel) {
        String message;
        this.m_lIndicatorButtons = new ArrayList();
        boolean bCollapsed = false;
        int iIndex = -1;
        for (int i = 0; i < lAttributes.size(); ++i) {
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.m_sId = sValue;
                continue;
            }
            if (sAttribute.equalsIgnoreCase("Expanded")) {
                bCollapsed = Boolean.parseBoolean(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionX")) {
                this.m_xPosition = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionY")) {
                this.m_yPosition = Integer.parseInt(sValue);
                continue;
            }
            if (!sAttribute.equalsIgnoreCase("Index")) continue;
            iIndex = Integer.parseInt(sValue);
        }
        try {
            IDiagramNodeAdapter adapter = DiagramNodeAdapterFactory.getInstance().createAdapter((IObject)jobModel.getJob().getTransformsList().get(iIndex));
            if (!(adapter.getObject() instanceof IDataTransform)) {
                message = "The wrong type of adapter was created while trying to create a data transform node with the index - " + iIndex + " in the transformation list: " + jobModel.getJob().getTransformsList().toString() + " the adapter type created was: " + adapter.getObject().getClass().toString();
                Workspace.getDefaultLogger().debug((Object)message);
                this.setCleanUpRequired(true);
                return;
            }
            this.m_adapterNode = new AdapterNode(adapter, this);
            this.getUIPlacement().setNodeId(this.m_sId);
            this.getUIPlacement().setCollapsed(bCollapsed);
            this.getUIPlacement().setXPosition(this.m_xPosition);
            this.getUIPlacement().setYPosition(this.m_yPosition);
            this.setSpotLocation(1, new Point(this.getUIPlacement().getXPosition(), this.getUIPlacement().getYPosition()));
            this.refresh();
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            message = "An exception occurred while trying to create a data transform node with the index - " + iIndex + " in the transformation list: " + jobModel.getJob().getTransformsList().toString();
            Workspace.getDefaultLogger().debug((Object)message);
            this.setCleanUpRequired(true);
            return;
        }
        this.setCollapsed(bCollapsed);
        this.setForceShowPorts(!bCollapsed);
    }

    public PFDButtonCollection getIndicatorButtons() {
        List indicatorButtons = this.getAdapterNode().getAdapter().getIndicatorButtons();
        PFDButtonCollection buttons = super.getIndicatorButtons();
        if (!this.m_lIndicatorButtons.equals(indicatorButtons)) {
            int iButton;
            for (iButton = 0; iButton < indicatorButtons.size(); ++iButton) {
                if (buttons.containsButton((PFDAbstractButton)((PFDButton)indicatorButtons.get(iButton)))) continue;
                buttons.addButton((PFDAbstractButton)((PFDButton)indicatorButtons.get(iButton)));
            }
            for (iButton = 0; iButton < this.m_lIndicatorButtons.size(); ++iButton) {
                if (indicatorButtons.contains(this.m_lIndicatorButtons.get(iButton))) continue;
                buttons.removeButton((PFDAbstractButton)((PFDButton)this.m_lIndicatorButtons.get(iButton)));
            }
            this.m_lIndicatorButtons.clear();
            this.m_lIndicatorButtons.addAll(indicatorButtons);
        }
        this.refreshCodeIndicators();
        return buttons;
    }

    public boolean isDatabasePushDown() {
        return ((IDataTransformNodeAdapter)this.getAdapter()).isDatabasePushDown();
    }

    @Override
    public void setDatabasePushDown(boolean bDatabasePushDown) {
        ((IDataTransformNodeAdapter)this.getAdapter()).setDatabasePushDown(bDatabasePushDown);
    }

    @Override
    public void setMode(int eMode) {
        if (eMode != 0 && eMode != 1 && eMode != 2) {
            throw new IllegalArgumentException("illegal mode: " + eMode);
        }
        if (this.m_eMode == eMode) {
            return;
        }
        this.m_eMode = eMode;
        this.refresh();
    }

    @Override
    public int getMode() {
        return this.m_eMode;
    }

    @Override
    public void setRunStatus(int eStatus) {
        if (eStatus != 0 && eStatus != 1 && eStatus != 2 && eStatus != 3 && eStatus != 4 && eStatus != 5) {
            throw new IllegalArgumentException("run status is invalid " + eStatus);
        }
        if (this.m_eRunStatus == eStatus) {
            return;
        }
        this.m_eRunStatus = eStatus;
        if (this.m_eMode == 1) {
            this.refreshRunStatus();
        }
    }

    @Override
    public void setValidateStatus(int eStatus) {
        if (eStatus != 0 && eStatus != 1 && eStatus != 2 && eStatus != 3 && eStatus != 5 && eStatus != 4 && eStatus != 6) {
            throw new IllegalArgumentException("validate status is invalid " + eStatus);
        }
        if (this.m_eValidateStatus == eStatus) {
            return;
        }
        this.m_eValidateStatus = eStatus;
        if (this.m_eMode == 2) {
            this.refreshValidateStatus();
        }
    }

    @Override
    public int getValidateStatus() {
        return this.m_eValidateStatus;
    }

    @Override
    public void setValidateStatusMessages(String[] messages) {
        this.m_eValidateStatusMessages = messages;
    }

    @Override
    public String[] getValidateStatusMessages() {
        return this.m_eValidateStatusMessages;
    }

    @Override
    public int getRunStatus() {
        return this.m_eRunStatus;
    }

    @Override
    public void setRunStatusMessages(String[] messages) {
        this.m_eRunStatusMessages = messages;
    }

    @Override
    public String[] getRunStatusMessages() {
        return this.m_eRunStatusMessages;
    }

    private IAdapterNode getAdapterNode() {
        return this.m_adapterNode;
    }

    @Override
    public IDiagramNodeAdapter getAdapter() {
        return this.getAdapterNode().getAdapter();
    }

    @Override
    public PFDPort getInputPort(IObject obj) {
        if (obj instanceof ITransform) {
            Vector links = this.getInputPort(0).getToLinks();
            for (int iLink = 0; iLink < links.size(); ++iLink) {
                IDiagramLink link = (IDiagramLink)links.get(iLink);
                if (link.getFromNode() == null || !(link.getFromNode() instanceof ITransformNode) || ((ITransformNode)link.getFromNode()).getObject() != obj) continue;
                return this.getInputPort(0);
            }
        }
        return this.getAdapterNode().getInputPort(obj);
    }

    @Override
    public PFDPort getOutputPort(IObject obj) {
        if (obj instanceof ITransform) {
            Vector links = this.getOutputPort(0).getFromLinks();
            for (int iLink = 0; iLink < links.size(); ++iLink) {
                IDiagramLink link = (IDiagramLink)links.get(iLink);
                if (link.getToNode() == null || !(link.getToNode() instanceof ITransformNode) || ((ITransformNode)link.getToNode()).getObject() != obj) continue;
                return this.getOutputPort(0);
            }
        }
        return this.getAdapterNode().getOutputPort(obj);
    }

    @Override
    public IObject getObject() {
        return this.getAdapterNode().getObject();
    }

    @Override
    public boolean isAutomaticAddToControlFlow() {
        return ((ITransformNodeAdapter)this.getAdapter()).isAutomaticAddToControlFlow();
    }

    @Override
    public void refresh(ModelEvent ev) {
        List lPortInfo;
        String sType = ev.getType();
        Object additionalData = ev.getAdditionalData();
        int portIndex = -1;
        if (additionalData instanceof Integer) {
            portIndex = (Integer)additionalData;
        }
        IPortDescription portDescription = null;
        if (sType.equals("DataTransform.InputAdded")) {
            if (portIndex == -1) {
                portDescription = ((IDataTransformNodeAdapter)this.getAdapter()).addInputPortDescription(ev.getData());
            } else {
                MutableInt index = new MutableInt(portIndex);
                portDescription = ((IDataTransformNodeAdapter)this.getAdapter()).addInputPortDescription(ev.getData(), index);
                portIndex = index.intValue();
            }
            if (portDescription != null) {
                PFDPort port = this.getAdapterNode().createPort(portDescription);
                if (portIndex == -1) {
                    this.addInputPort(port);
                } else {
                    this.addInputPort(portIndex, port);
                }
            }
        } else if (sType.equals("DataTransform.InputRemoved")) {
            int iPort = -1;
            iPort = portIndex == -1 ? ((IDataTransformNodeAdapter)this.getAdapter()).deleteInputPort(ev.getData()) : ((IDataTransformNodeAdapter)this.getAdapter()).deleteInputPort(ev.getData(), portIndex);
            if (iPort > -1) {
                this.removeInputPort(iPort);
            }
        } else if (sType.equals("DataTransform.OutputAdded")) {
            if (portIndex == -1) {
                portDescription = ((IDataTransformNodeAdapter)this.getAdapter()).addOutputPortDescription(ev.getData());
            } else {
                MutableInt index = new MutableInt(portIndex);
                portDescription = ((IDataTransformNodeAdapter)this.getAdapter()).addOutputPortDescription(ev.getData(), index);
                portIndex = index.intValue();
            }
            if (portDescription != null) {
                PFDPort port = this.getAdapterNode().createPort(portDescription);
                if (portIndex == -1) {
                    this.addOutputPort(port);
                } else {
                    this.addOutputPort(portIndex, port);
                }
            }
        } else if (sType.equals("DataTransform.OutputRemoved")) {
            int iPort = -1;
            iPort = portIndex == -1 ? ((IDataTransformNodeAdapter)this.getAdapter()).deleteOutputPort(ev.getData()) : ((IDataTransformNodeAdapter)this.getAdapter()).deleteOutputPort(ev.getData(), portIndex);
            if (iPort > -1) {
                this.removeOutputPort(iPort);
            }
        } else if (sType.equals("DataTransform.InputUpdated")) {
            List lPortInfo2 = ((IDataTransformNodeAdapter)this.getAdapter()).updateInputPort(ev.getData());
            if (lPortInfo2 != null) {
                int iPort = (Integer)lPortInfo2.get(0);
                BasePort port = (BasePort)this.getInputPort(iPort);
                port.setToolTipText((String)lPortInfo2.get(1));
            }
        } else if (sType.equals("DataTransform.OutputUpdated") && (lPortInfo = ((IDataTransformNodeAdapter)this.getAdapter()).updateOutputPort(ev.getData())) != null) {
            int iPort = (Integer)lPortInfo.get(0);
            BasePort port = (BasePort)this.getOutputPort(iPort);
            port.setToolTipText((String)lPortInfo.get(1));
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        this.m_adapterNode.refresh();
        if (this.getMode() == 0) {
            this.refreshDesignStatus();
        } else if (this.getMode() == 1) {
            this.refreshRunStatus();
        } else {
            this.refreshValidateStatus();
        }
        this.getIndicatorButtons();
        this.refreshCodeIndicators();
    }

    protected ITransformNodeAdapter getTransformAdapter() {
        return (ITransformNodeAdapter)this.m_adapterNode.getAdapter();
    }

    @Override
    public Point getUpperLeftPoint() {
        return new Point(this.getUIPlacement().getXPosition(), this.getUIPlacement().getYPosition());
    }

    @Override
    public void setLocation(Point location) {
        super.setSpotLocation(1, location);
    }

    @Override
    public String getId() {
        return this.getUIPlacement().getNodeId();
    }

    protected void setId(String sId) {
        this.getUIPlacement().setNodeId(sId);
    }

    protected IDataTransform getDataTransform() {
        return (IDataTransform)this.m_adapterNode.getObject();
    }

    public void setDefaultAction(Action actDefault) {
        this.getAdapter().setDefaultAction(actDefault);
    }

    public Action getDefaultAction() {
        return this.getAdapter().getDefaultAction();
    }

    public void setDeleteAction(Action actDelete) {
        this.getAdapter().setDeleteAction(actDelete);
    }

    public Action getDeleteAction() {
        return this.getAdapter().getDeleteAction();
    }

    public void addPopupMenuItems(JPopupMenu menuPopup) {
    }

    public boolean drop(Point ptEvent, List lObjects) {
        return false;
    }

    public boolean isActive() {
        return this.m_bActive;
    }

    public void setActive(boolean bActive) {
        this.m_bActive = bActive;
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        return false;
    }

    @Override
    public boolean isCleanUpRequired() {
        return this.m_bCleanUpRequired;
    }

    @Override
    public void setCleanUpRequired(boolean bRequired) {
        this.m_bCleanUpRequired = bRequired;
    }

    private void refreshDesignStatus() {
        String sTitle;
        String sToolTip;
        int eStatus;
        String sContent;
        IDataTransform dataTransform = this.getDataTransform();
        if (dataTransform.isCodeGenerationEnabled() && !dataTransform.isCompleteWithUserWritten()) {
            List lMessages = this.getDataTransform().getReasonsIncomplete();
            StringBuffer sbContent = new StringBuffer(128);
            for (int iMessage = 0; iMessage < lMessages.size(); ++iMessage) {
                sbContent.append("- ").append(lMessages.get(iMessage)).append("<br>");
            }
            if (lMessages.isEmpty()) {
                sbContent.append("TODO: This transform needs reasons incomplete!");
            }
            sContent = sbContent.toString();
            eStatus = 4;
            sToolTip = bundle.getString("DataTransformNode.Incomplete.tip");
            sTitle = bundle.getString("DataTransformNode.Errors.Title.txt");
        } else if (dataTransform.isCodeGenerationEnabled() && dataTransform.hasWarnings()) {
            List lMessages = this.getDataTransform().getWarnings();
            StringBuffer sbContent = new StringBuffer(128);
            for (int iMessage = 0; iMessage < lMessages.size(); ++iMessage) {
                sbContent.append("- ").append(lMessages.get(iMessage)).append("<br>");
            }
            if (lMessages.isEmpty()) {
                sbContent.append("TODO: This transform needs warnings!");
            }
            sContent = sbContent.toString();
            eStatus = 1;
            sToolTip = bundle.getString("DataTransformNode.DesignWarnings.tip");
            sTitle = bundle.getString("DataTransformNode.DesignWarnings.Title.txt");
        } else {
            eStatus = 5;
            sToolTip = bundle.getString("DataTransformNode.Complete.tip");
            sTitle = null;
            sContent = null;
        }
        this.setStatus(eStatus, sToolTip, sTitle, sContent, null);
    }

    private void refreshRunStatus() {
        StringBuffer sbContent = new StringBuffer(128);
        if (this.getRunStatus() == 3 || this.getRunStatus() == 4) {
            int maxMessages;
            String[] aMessages = this.getRunStatusMessages();
            if (aMessages.length <= (maxMessages = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt("WarningsAndErrorsTab.MaxMessagesPerStep", 20))) {
                maxMessages = aMessages.length;
            }
            for (int iMessage = 0; iMessage < maxMessages; ++iMessage) {
                sbContent.append("- ").append(aMessages[iMessage]).append("<br>");
            }
            if (aMessages.length > maxMessages) {
                sbContent.append("- ");
                if (maxMessages == 0) {
                    sbContent.append(bundle.getString("DataTransformNode.TooManyMessages.None.txt"));
                } else if (maxMessages == 1) {
                    sbContent.append(bundle.getString("DataTransformNode.TooManyMessages.One.txt"));
                } else {
                    sbContent.append(bundle.formatString("DataTransformNode.TooManyMessages.Many.fmt.txt", (Object)String.valueOf(maxMessages)));
                }
            }
        }
        switch (this.getRunStatus()) {
            case 0: {
                this.setStatus(0);
                break;
            }
            case 1: {
                this.setStatus(3);
                break;
            }
            case 2: {
                this.setStatus(5, bundle.getString("DataTransformNode.Successful.tip"));
                break;
            }
            case 3: {
                this.setStatus(1, bundle.getString("DataTransformNode.Warnings.tip"), bundle.getString("DataTransformNode.Warnings.Title.txt"), sbContent.toString(), null);
                break;
            }
            case 4: {
                this.setStatus(2, bundle.getString("DataTransformNode.Errors.tip"), bundle.getString("DataTransformNode.Errors.Title.txt"), sbContent.toString(), null);
                break;
            }
            case 5: {
                this.setStatus(5, bundle.getString("DataTransformNode.Successful.tip"));
            }
        }
    }

    private void refreshValidateStatus() {
        StringBuffer sbContent = new StringBuffer(128);
        if (this.getValidateStatus() == 3 || this.getValidateStatus() == 4) {
            int maxMessages;
            String[] aMessages = this.getValidateStatusMessages();
            if (aMessages.length <= (maxMessages = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt("WarningsAndErrorsTab.MaxMessagesPerStep", 20))) {
                maxMessages = aMessages.length;
            }
            for (int iMessage = 0; iMessage < maxMessages; ++iMessage) {
                sbContent.append("- ").append(aMessages[iMessage]).append("<br>");
            }
            if (aMessages.length > maxMessages) {
                sbContent.append("- ");
                if (maxMessages == 0) {
                    sbContent.append(bundle.getString("DataTransformNode.TooManyMessages.None.txt"));
                } else if (maxMessages == 1) {
                    sbContent.append(bundle.getString("DataTransformNode.TooManyMessages.One.txt"));
                } else {
                    sbContent.append(bundle.formatString("DataTransformNode.TooManyMessages.Many.fmt.txt", (Object)String.valueOf(maxMessages)));
                }
            }
        }
        switch (this.getValidateStatus()) {
            case 0: {
                this.setStatus(0);
                break;
            }
            case 1: {
                this.setStatus(3);
                break;
            }
            case 5: {
                this.setStatus(0);
                break;
            }
            case 2: {
                this.setStatus(5, bundle.getString("DataTransformNode.Successful.tip"));
                break;
            }
            case 6: {
                this.setStatus(5, bundle.getString("DataTransformNode.Successful.tip"));
                break;
            }
            case 3: {
                this.setStatus(1, bundle.getString("DataTransformNode.Warnings.tip"), bundle.getString("DataTransformNode.Warnings.Title.txt"), sbContent.toString(), null);
                break;
            }
            case 4: {
                this.setStatus(2, bundle.getString("DataTransformNode.Errors.tip"), bundle.getString("DataTransformNode.Errors.Title.txt"), sbContent.toString(), null);
            }
        }
    }

    public void setStatus(PFDStatus status) {
        String sContent = (String)status.getValue("MessgeContent");
        Integer value = (Integer)status.getValue("ID");
        if (value == this.m_eStatus && (this.m_sStatusContent == null && sContent == null || this.m_sStatusContent != null && this.m_sStatusContent.equals(sContent))) {
            return;
        }
        this.m_eStatus = value;
        this.m_sStatusContent = sContent;
        super.setStatus(status);
    }

    private void refreshCodeIndicators() {
        this.setGhosted(!this.getDataTransform().isCodeGenerationEnabled());
        String sNote = ((ITransform)this.m_adapterNode.getAdapter().getObject()).getPrivateNote();
        if (sNote == null || sNote.equals("")) {
            this.removeNote();
        } else {
            this.setNoteText(sNote);
            this.getNoteTextPane().setFocusable(false);
            this.getNoteTextPane().setEditable(false);
        }
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        this.getUIPlacement().setCollapsed(collapsed);
        super.setCollapsed(collapsed);
    }

    @Override
    public int[] getInputPortIndexes(IObject obj) {
        return ((IDataTransformNodeAdapter)this.getAdapter()).getInputPortIndexes(obj);
    }

    @Override
    public int[] getOutputPortIndexes(IObject obj) {
        return ((IDataTransformNodeAdapter)this.getAdapter()).getOutputPortIndexes(obj);
    }

    @Override
    public String writeToXML(IDesignTimeModel job) {
        return null;
    }

    @Override
    public IUIPlacement getUIPlacement() {
        return this.getDataTransform().getUIPlacement();
    }
}

