/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.etl.models.job.impl.UIPlacement;
import com.sas.graphics.components.pfd.PFDAbstractButton;
import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollection;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.data.IDataNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IAdapterNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.AdapterNode;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class DataNode
extends PFDCompositeNode
implements IDataNode,
WsPFDPrimitive {
    private IAdapterNode m_adapterNode;
    private List m_lIndicatorButtons;
    protected String m_sId;
    private int m_iXLocation;
    private int m_iYLocation;
    private boolean m_bActive;
    private boolean m_showColumns;
    private boolean m_bCleanUpRequired;
    private IUIPlacement m_placement;

    public DataNode() {
        this.setTitleTextWrapEnabled(false);
        this.m_lIndicatorButtons = new ArrayList();
    }

    public DataNode(IDataNodeAdapter adapter) {
        this.m_lIndicatorButtons = new ArrayList();
        this.m_adapterNode = new AdapterNode(adapter, this);
        this.setNodeStyleContext("NodeStyle3");
        this.setTitleTextWrapEnabled(false);
        this.setShowColumns(false);
        this.getIndicatorButtons();
        this.refreshNoteIndicator();
        this.m_sId = GUID.newGUID();
        if (this.getUIPlacement() != null && this.getUIPlacement().getNodeId() != null) {
            this.setSpotLocation(1, new Point(this.getUIPlacement().getXPosition(), this.getUIPlacement().getYPosition()));
            this.refresh();
        }
    }

    protected DataNode(List lAttributes, List lValues, IDesignTimeModel jobModel) {
        this.m_lIndicatorButtons = new ArrayList();
        this.setTitleTextWrapEnabled(false);
        int iIndex = -1;
        for (int i = 0; i < lAttributes.size(); ++i) {
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.m_sId = sValue;
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionX")) {
                this.m_iXLocation = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionY")) {
                this.m_iYLocation = Integer.parseInt(sValue);
                continue;
            }
            if (!sAttribute.equalsIgnoreCase("Index")) continue;
            iIndex = Integer.parseInt(sValue);
        }
        try {
            IDiagramNodeAdapter adapter = DiagramNodeAdapterFactory.getInstance().createAdapter((IObject)jobModel.getJob().getDataObjectsList().get(iIndex));
            if (!(adapter.getObject() instanceof IDataObject)) {
                String message = "The wrong adapter was being created for a data node with the index - " + iIndex + " in the data objects list: " + jobModel.getJob().getDataObjectsList().toString() + " the type of adapter created was " + adapter.getObject().getClass().toString();
                Workspace.getDefaultLogger().debug((Object)message);
                this.setCleanUpRequired(true);
                return;
            }
            this.m_adapterNode = new AdapterNode(adapter, this);
            this.setUIPlacement(jobModel);
            this.getUIPlacement().setNodeId(this.m_sId);
            this.getUIPlacement().setXPosition(this.m_iXLocation);
            this.getUIPlacement().setYPosition(this.m_iYLocation);
            this.getUIPlacement().setChanged(false);
            this.setSpotLocation(1, new Point(this.m_iXLocation, this.m_iYLocation));
            this.refresh();
            this.setNodeStyleContext("NodeStyle3");
        }
        catch (Exception ex) {
            String message = "An exception occurred while trying to create a data node with the index - " + iIndex + " in the data objects list: " + jobModel.getJob().getDataObjectsList().toString();
            Workspace.getDefaultLogger().debug((Object)message);
            this.setCleanUpRequired(true);
            return;
        }
    }

    @Override
    public IObject getObject() {
        return this.getAdapterNode().getObject();
    }

    @Override
    public String getId() {
        return this.getUIPlacement().getNodeId();
    }

    private IAdapterNode getAdapterNode() {
        return this.m_adapterNode;
    }

    protected void setAdapterNode(IAdapterNode adapterNode) {
        this.m_adapterNode = adapterNode;
    }

    protected void setId(String sId) {
        this.getUIPlacement().setNodeId(sId);
    }

    public String getObjectId() {
        return this.getAdapterNode().getObjectId();
    }

    @Override
    public PFDPort getInputPort(IObject obj) {
        return this.getAdapterNode().getInputPort(obj);
    }

    @Override
    public PFDPort getOutputPort(IObject obj) {
        return this.getAdapterNode().getOutputPort(obj);
    }

    public void addPopupMenuItems(JPopupMenu menuPopup) {
    }

    public boolean drop(Point ptEvent, List lObjects) {
        return false;
    }

    public boolean isActive() {
        return this.m_bActive;
    }

    public void setActive(boolean bActive) {
        this.m_bActive = bActive;
    }

    public PFDButtonCollection getIndicatorButtons() {
        List indicatorButtons = this.getAdapterNode().getAdapter().getIndicatorButtons();
        PFDButtonCollection buttons = super.getIndicatorButtons();
        if (indicatorButtons != null && !this.m_lIndicatorButtons.equals(indicatorButtons)) {
            int iButton;
            for (iButton = 0; iButton < indicatorButtons.size(); ++iButton) {
                if (buttons.containsButton((PFDAbstractButton)((PFDButton)indicatorButtons.get(iButton)))) continue;
                buttons.addButton((PFDAbstractButton)((PFDButton)indicatorButtons.get(iButton)));
            }
            for (iButton = 0; iButton < this.m_lIndicatorButtons.size(); ++iButton) {
                if (indicatorButtons.contains(this.m_lIndicatorButtons.get(iButton))) continue;
                buttons.removeButton((PFDAbstractButton)((PFDButton)this.m_lIndicatorButtons.get(iButton)));
            }
            this.m_lIndicatorButtons.clear();
            this.m_lIndicatorButtons.addAll(indicatorButtons);
        }
        this.refreshNoteIndicator();
        return buttons;
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        return false;
    }

    @Override
    public boolean isCleanUpRequired() {
        return this.m_bCleanUpRequired;
    }

    @Override
    public void setCleanUpRequired(boolean bRequired) {
        this.m_bCleanUpRequired = bRequired;
    }

    public void setDefaultAction(Action actDefault) {
        this.getAdapter().setDefaultAction(actDefault);
    }

    public Action getDefaultAction() {
        return this.getAdapter().getDefaultAction();
    }

    public void setDeleteAction(Action actDelete) {
        this.getAdapter().setDeleteAction(actDelete);
    }

    public Action getDeleteAction() {
        return this.getAdapter().getDeleteAction();
    }

    public boolean isShowColumns() {
        return this.m_showColumns;
    }

    @Override
    public void setShowColumns(boolean value) {
        if (this.m_showColumns == value) {
            return;
        }
        this.m_showColumns = value;
        IDataNodeAdapter adapter = (IDataNodeAdapter)this.getAdapter();
        this.setTable(adapter.getTableComponent());
        this.setTableVisible(value);
    }

    @Override
    public void refresh() {
        this.getAdapterNode().refresh();
        this.getIndicatorButtons();
    }

    protected void refreshNoteIndicator() {
        String sNote = ((IDataObject)this.m_adapterNode.getAdapter().getObject()).getPrivateNote();
        if (sNote == null || sNote.equals("")) {
            this.removeNote();
        } else {
            this.setNoteText(sNote);
            this.getNoteTextPane().setFocusable(false);
            this.getNoteTextPane().setEditable(false);
        }
    }

    @Override
    public IDiagramNodeAdapter getAdapter() {
        if (this.getAdapterNode() != null) {
            return this.getAdapterNode().getAdapter();
        }
        return null;
    }

    @Override
    public String writeToXML(IDesignTimeModel job) {
        return null;
    }

    @Override
    public IUIPlacement getUIPlacement() {
        return this.m_placement;
    }

    @Override
    public void setUIPlacement(IUIPlacement placement) {
        this.m_placement = placement;
    }

    @Override
    public void setUIPlacement(IDesignTimeModel designModel) {
        if (this.m_placement != null) {
            return;
        }
        this.m_placement = this.addUIPlacement(designModel);
        this.m_placement.setNodeId(this.m_sId);
    }

    private UIPlacement addUIPlacement(IDesignTimeModel designModel) {
        UIPlacement placement = new UIPlacement();
        designModel.getJob().addUIPlacemnentToJob((IDataObject)this.getObject(), (IUIPlacement)placement);
        return placement;
    }
}

