/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.copypaste;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPasteModify;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.CopyPasteAdapter;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectFactoryException;
import com.sas.etl.models.job.CopyPasteDependentItem;
import com.sas.etl.models.job.ICopyPasteAdvanced;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.WorkTable;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.wadmin.jobeditor.diagram.DiagramModel;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.copypaste.CopyContainer;
import com.sas.wadmin.jobeditor.diagram.copypaste.PFDCopyPaste;
import com.sas.wadmin.jobeditor.diagram.copypaste.PFDCopyPasteSerializer;
import com.sas.wadmin.jobeditor.diagram.copypaste.PasteItemsContainer;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.workspace.Workspace;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class PFDObjectSelection
implements ClipboardOwner {
    private PFDCopyPasteSerializer copySerial;

    public PFDObjectSelection(PFDCopyPasteSerializer cpSerial) {
        this.copySerial = cpSerial;
    }

    private boolean doesObjectExist(ServerInterface child, CMetadata type) throws RemoteException {
        if (type == null || type.isNewObject()) {
            return false;
        }
        String key = type.getFQID() + "/" + type.getCMetadataType();
        MetadataInterface metaObject = null;
        try {
            metaObject = child.fetch(key, false);
            return metaObject != null;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    private boolean isTopLevelType(ServerInterface child, CMetadata type) throws RemoteException, ServiceException {
        TypeDescriptorInterface desc;
        if (type.isNewObject()) {
            return false;
        }
        String key = type.getFQID() + "/" + type.getCMetadataType();
        if (type instanceof PrimaryType && ((PrimaryType)type).getPublicType().length() > 0) {
            return !((PrimaryType)type).getPublicType().startsWith("Embedded:");
        }
        if ("ResponsibleParty".equals(type.getCMetadataType())) {
            return true;
        }
        if ("UniqueKey".equals(type.getCMetadataType())) {
            return true;
        }
        if (!this.doesObjectExist(child, type)) {
            return false;
        }
        MetadataInterface metaObject = child.fetch(key, false);
        return metaObject != null && (desc = metaObject.getTypeDescriptor()) != null && !desc.getTypeName().startsWith("Embedded:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyObjects(IModel model, MdFactory factory, CopyContainer copyContainer) throws RemoteException, MdException, IOException {
        if (copyContainer.isEmpty()) {
            return;
        }
        this.copySerial = new PFDCopyPasteSerializer();
        CopyPasteAdapter omr = new CopyPasteAdapter(model, factory, "CopyUtil.ObjectCopyStore");
        boolean isCopy = model.isCopyPaste();
        model.setIsCopyPaste(true);
        MdObjectStore store = omr.getOMRStore();
        try {
            Map map;
            HashMap<CopyPasteDependentItem, Point> objs = new HashMap<CopyPasteDependentItem, Point>();
            for (Map.Entry<IPersistableObject, Point> entry : copyContainer.getCopyObjects().entrySet()) {
                List dpCP;
                entry.getKey().saveToOMR((OMRAdapter)omr);
                this.updateCopyItems((IObject)entry.getKey(), objs, entry.getKey() instanceof ITransform, entry.getValue(), true);
                if (entry.getKey() instanceof IDataTransform) {
                    IDataTransform iDataTransform = (IDataTransform)entry.getKey();
                    for (IDataObject dao : iDataTransform.getDataTargets()) {
                        this.updateTableDependencies(model, factory, objs, dao, true);
                    }
                    for (IDataObject dao : iDataTransform.getDataSources()) {
                        this.updateTableDependencies(model, factory, objs, dao, false);
                    }
                }
                if (!(entry.getKey() instanceof ICopyPasteAdvanced)) continue;
                ICopyPasteAdvanced iCopyPasteAdvanced = (ICopyPasteAdvanced)entry.getKey();
                List addCP = iCopyPasteAdvanced.getAdditionalCopyObjects();
                if (addCP != null) {
                    for (CopyPasteDependentItem dao : addCP) {
                        objs.put(dao, null);
                        if (!(dao.getItem() instanceof IPersistableObject)) continue;
                        ((IPersistableObject)dao.getItem()).saveToOMR((OMRAdapter)omr);
                    }
                }
                if ((dpCP = iCopyPasteAdvanced.getDependentObjects()) == null) continue;
                for (IDataObject dao : dpCP) {
                    this.copySerial.addIgnoreObject(dao.getID());
                }
            }
            this.copySerial.setCopiedObjects(objs);
            HashMap<IDiagramStickyNote, Point> serialz = new HashMap<IDiagramStickyNote, Point>();
            for (Map.Entry<IDiagramStickyNote, Point> entry : copyContainer.getAdditionalCopyObjects().entrySet()) {
                serialz.put(entry.getKey(), entry.getValue());
            }
            this.copySerial.setAdditionalObjects(serialz);
            omr.save();
            Map map2 = map = store.getDetailObjectMap();
            synchronized (map2) {
                Object[] map3 = map.keySet().toArray();
                for (int i = 0; i < map3.length; ++i) {
                    String objectID = (String)map3[i];
                    CMetadata inObject = store.getObject(objectID, true);
                    if (null != inObject && !inObject.isNewObject() && inObject instanceof PrimaryType && ((PrimaryType)inObject).getPublicType().length() == 0) {
                        ((PrimaryType)inObject).setPublicType(factory.getOMIUtil().getMetadataSimple(inObject.getCMetadataType(), objectID, "PublicType"));
                        continue;
                    }
                    if (null != inObject) continue;
                    store.deleteObjectFromStore(objectID);
                }
            }
            this.copySerial.setMetadataXML("<CopyStore>" + store.createXMLforStore() + "</CopyStore>");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
            out.writeObject(this.copySerial);
            out.close();
            Workspace.getDefaultLogger().debug((Object)new String(byteArrayOutputStream.toByteArray()));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new PFDCopyPaste(this.copySerial), null);
        }
        finally {
            model.setIsCopyPaste(isCopy);
            omr.dispose();
        }
    }

    private void updateTableDependencies(IModel model, MdFactory factory, Map<CopyPasteDependentItem, Point> objs, IDataObject dao, boolean copy) throws RemoteException, MdException {
        this.updateTable(model, factory, (IObject)dao, objs, dao instanceof IWorkTable && copy);
    }

    private boolean updateCopyItems(IObject object, Map<CopyPasteDependentItem, Point> objs, boolean copy, Point p, boolean isPFDItem) {
        boolean updated = false;
        CopyPasteDependentItem item = this.findItem(objs, object.getID());
        if (null == item) {
            item = new CopyPasteDependentItem(object, copy, isPFDItem);
            objs.put(item, p);
            updated = true;
        } else {
            Point oldPoint = objs.get(item);
            if (oldPoint != null) {
                p = oldPoint;
            }
            objs.put(item, p);
            if (!item.isMakeCopy() && copy) {
                item.setMakeCopy(copy);
                updated = true;
            }
            if (!item.isPfdItem() && isPFDItem) {
                item.setPfdItem(isPFDItem);
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(IModel model, MdFactory factory, IObject object, Map<CopyPasteDependentItem, Point> objs, boolean copy) throws RemoteException, MdException {
        boolean updated = this.updateCopyItems(object, objs, copy, null, false);
        if (object instanceof IPersistableObject && updated) {
            IPersistableObject pObject = (IPersistableObject)object;
            CopyPasteAdapter objectManagement = new CopyPasteAdapter(model, factory, "CopyUtil.objectManagement");
            try {
                pObject.saveToOMR((OMRAdapter)objectManagement);
                HashMap objectMap = new HashMap(objectManagement.getOMRStore().getDetailObjectMap());
                for (Map.Entry entry : objectMap.entrySet()) {
                    String id = (String)entry.getKey();
                    if (!copy) {
                        this.copySerial.addConnectObject(id);
                        continue;
                    }
                    this.copySerial.removeConnectObject(id);
                }
            }
            finally {
                objectManagement.dispose();
            }
        }
    }

    private CopyPasteDependentItem findItem(Map<CopyPasteDependentItem, Point> objs, String id) {
        for (Map.Entry<CopyPasteDependentItem, Point> entry : objs.entrySet()) {
            if (!StringUtils.equals((String)entry.getKey().getId(), (String)id)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public PFDCopyPaste getCopyPasteBuffer() throws IOException, UnsupportedFlavorException, ClassNotFoundException {
        boolean hasTransferableText;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(PFDCopyPaste.PFDFlavor);
        if (hasTransferableText) {
            return (PFDCopyPaste)contents.getTransferData(PFDCopyPaste.PFDFlavor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public PasteItemsContainer pasteObjects(DiagramModel diagram, IModel model, MdFactory factory, IJob job, boolean isVerticalOrientation) throws RemoteException, MdException, IOException, UnsupportedFlavorException, ServiceException, ClassNotFoundException, ParserConfigurationException, SAXException {
        CopyPasteAdapter topLevelStore = new CopyPasteAdapter(model, factory, "CopyUtil.DeletePasteStore");
        CopyPasteAdapter load = new CopyPasteAdapter(model, factory, "CopyUtil.ObjectPasteStore");
        boolean isCopyPaste = model.isCopyPaste();
        model.setIsCopyPaste(true);
        ChildServerInterface child = Workspace.getWorkspace().getUserContext().getAuthServer().newChild(true);
        DesignTimeJobModel tempJobModel = DesignTimeJobModel.createModelForExistingJob((String)job.getID());
        tempJobModel.setIsCopyPaste(true);
        CopyPasteAdapter loadForDelete = new CopyPasteAdapter((IModel)tempJobModel, factory, "CopyUtil.LoadForDelete");
        try {
            if (this.copySerial == null) {
                PasteItemsContainer pasteItemsContainer = null;
                return pasteItemsContainer;
            }
            MdObjectStore store = load.getOMRStore();
            Workspace.getDefaultLogger().debug((Object)("Paste buffer...  " + this.copySerial.getMetadataXML()));
            factory.getOMIUtil().populateStoreFromString((MdStore)store, this.copySerial.getMetadataXML(), 1, false);
            factory.getOMIUtil().populateStoreFromString((MdStore)topLevelStore.getOMRStore(), this.copySerial.getMetadataXML(), 1, false);
            ArrayList<Root> transforms = new ArrayList<Root>();
            ArrayList<IOMRPersistable> deletes = new ArrayList<IOMRPersistable>();
            boolean goToServer = store.isGoToServerForMetadata();
            store.setGoToServerForMetadata(true);
            try {
                HashMap tempMap = new HashMap(store.getDetailObjectMap());
                for (Map.Entry entry : tempMap.entrySet()) {
                    CMetadata metaObject = (CMetadata)entry.getValue();
                    String string = (String)entry.getKey();
                    CopyPasteDependentItem item = this.copySerial.getObjectCopied(string);
                    boolean isTopLevelObject = this.isTopLevelType((ServerInterface)child, metaObject);
                    if ((!isTopLevelObject || item == null || item.isMakeCopy()) && !this.copySerial.isIgnoreObject(string) && !this.copySerial.isConnectObject(string) || item != null && !item.isMakeCopy() && this.copySerial.isConnectObject(string) && null != model.getObject(string)) continue;
                    if (this.doesObjectExist((ServerInterface)child, metaObject)) {
                        store.refreshObjectFromServer(metaObject, true, true);
                        try {
                            deletes.add(loadForDelete.acquireObjectUsingTemplate((Root)metaObject));
                        }
                        catch (ObjectFactoryException objectFactoryException) {}
                        continue;
                    }
                    if (!isTopLevelObject) continue;
                    deletes.add(loadForDelete.createObjectFromOMRObject((Root)metaObject));
                }
            }
            finally {
                store.setGoToServerForMetadata(goToServer);
            }
            for (IOMRPersistable delete : deletes) {
                try {
                    delete.deleteFromOMR((OMRAdapter)loadForDelete);
                }
                catch (Exception entry) {}
            }
            ArrayList<String> deleted = new ArrayList<String>();
            HashMap<String, String> transIdMap = new HashMap<String, String>();
            HashMap objectMap = new HashMap(store.getDetailObjectMap());
            for (Map.Entry entry : objectMap.entrySet()) {
                CMetadata metaObject = (CMetadata)entry.getValue();
                String oldId = (String)entry.getKey();
                CopyPasteDependentItem item = this.copySerial.getObjectCopied(oldId);
                if (!(this.isTopLevelType((ServerInterface)child, metaObject) || loadForDelete.getOMRStore().isDeletedObject((String)entry.getKey()) || this.copySerial.isIgnoreObject(oldId) || this.copySerial.isConnectObject(oldId))) {
                    String newId = item == null || item != null && item.isMakeCopy() ? model.createIDForNewObject(job.getID()) : oldId;
                    metaObject.setFQID(newId);
                    if ("TransformationStep".equals(metaObject.getCMetadataType()) && item != null) {
                        transforms.add((Root)metaObject);
                    }
                    transIdMap.put(oldId, newId);
                    continue;
                }
                if (!loadForDelete.getOMRStore().isDeletedObject((String)entry.getKey())) continue;
                deleted.add((String)entry.getKey());
                if (item == null || item.isMakeCopy() || !(metaObject instanceof WorkTable)) continue;
                store.deleteObject(metaObject);
            }
            String modifiedXML = this.createXMLforStore((ServerInterface)child, factory, store, true, deleted);
            modifiedXML = "<PasteObjects>" + modifiedXML + "</PasteObjects>";
            Workspace.getDefaultLogger().debug((Object)("Modified xml...  " + modifiedXML));
            factory.getOMIUtil().populateStoreFromString((MdStore)load.getOMRStore(), modifiedXML, 1, false);
            PasteItemsContainer pasteItemsContainer = new PasteItemsContainer(job);
            model.addModelListener((IModelListener)pasteItemsContainer);
            boolean ignoreEvents = diagram.getIgnoreEvents();
            diagram.setIgnoreEvents(true);
            try {
                this.copySerial.setIsOrientationVertical(isVerticalOrientation);
                for (Map.Entry<CopyPasteDependentItem, Point> entry : this.copySerial.getCopiedObjects().entrySet()) {
                    String id = entry.getKey().getId();
                    if (transIdMap.containsKey(id)) {
                        id = (String)transIdMap.get(id);
                    }
                    IObject iObject = model.getObject(id);
                    Root root = (Root)load.getOMRStore().getObject(id);
                    if (null == root || iObject != null || load.getOMRStore().getObject(id) instanceof WorkTable || !(root instanceof PhysicalTable)) continue;
                    OMRAdapter loader = new OMRAdapter(model, factory, "PFDObjectSelection:PasteLoader");
                    try {
                        IObject iObject2 = (IObject)loader.acquireObjectUsingTemplate(root);
                    }
                    finally {
                        loader.dispose();
                    }
                }
                model.startCompoundUndoable();
                Iterator<Map.Entry<CopyPasteDependentItem, Point>> it2 = this.copySerial.getCopiedObjects().entrySet().iterator();
                try {
                    while (it2.hasNext()) {
                        void var26_52;
                        IObject iObject;
                        void var25_41;
                        Map.Entry<CopyPasteDependentItem, Point> entry = it2.next();
                        String string = entry.getKey().getId();
                        if (transIdMap.containsKey(string)) {
                            String string2 = (String)transIdMap.get(string);
                        }
                        IObject iObject3 = model.getObject((String)var25_41);
                        Root metaObj = (Root)load.getOMRStore().getObject((String)var25_41);
                        if (null == metaObj) continue;
                        if (iObject3 == null && !(load.getOMRStore().getObject((String)var25_41) instanceof WorkTable) && !(metaObj instanceof PhysicalTable) && (iObject = model.getObjectFactory().createObjectFromOMRObject(metaObj)) instanceof IOMRPersistable) {
                            ((IOMRPersistable)iObject).loadFromOMR((OMRAdapter)load);
                        }
                        if (!(var26_52 instanceof IDataObject) || !((CopyPasteDependentItem)entry.getKey()).isPfdItem() || var25_41.indexOf(36) < 0 && !this.doesObjectExist((ServerInterface)child, (CMetadata)metaObj)) continue;
                        pasteItemsContainer.addPasteObject((IObject)var26_52, (Point)entry.getValue());
                    }
                    for (Map.Entry entry : this.copySerial.getAdditionalObjects().entrySet()) {
                        pasteItemsContainer.addNote((IDiagramStickyNote)entry.getKey(), (Point)entry.getValue());
                    }
                    for (Root root : transforms) {
                        void var26_56;
                        ITransform iTransform = (ITransform)job.getModel().getObject(root.getFQID());
                        if (iTransform == null) {
                            ITransform iTransform2 = (ITransform)load.createObjectFromOMRObject(root);
                        }
                        job.getTransformsList().add(var26_56);
                    }
                    HashMap<String, Point> pts = new HashMap<String, Point>();
                    for (Map.Entry entry : transIdMap.entrySet()) {
                        Point origLocation = this.copySerial.getObjectLocation((String)entry.getKey());
                        if (origLocation == null) continue;
                        pts.put((String)entry.getValue(), origLocation);
                    }
                    pasteItemsContainer.updateModelPoints(pts);
                    for (IPasteModify iPasteModify : pasteItemsContainer.getPasteModifiedDependent()) {
                        List lst = iPasteModify.pasteAction();
                        if (lst == null || lst.isEmpty()) continue;
                        for (IObject o : lst) {
                            IDiagramNodeAdapter ad = DiagramNodeAdapterFactory.getInstance().createAdapter(o);
                            if (ad == null || pasteItemsContainer.hasItem(o)) continue;
                            pasteItemsContainer.addPasteObject(o, null);
                        }
                    }
                    model.undoableEditHappened((UndoableEdit)new FixLinksUndoable(diagram));
                    diagram.setIgnoreEvents(ignoreEvents);
                    pasteItemsContainer.fireModelEventForPasteComplete();
                }
                finally {
                    model.endCompoundUndoable();
                }
            }
            finally {
                diagram.setIgnoreEvents(ignoreEvents);
                model.removeModelListener((IModelListener)pasteItemsContainer);
            }
            PasteItemsContainer pasteItemsContainer2 = pasteItemsContainer;
            return pasteItemsContainer2;
        }
        finally {
            if (child != null) {
                child.destroy();
            }
            model.setIsCopyPaste(isCopyPaste);
            load.dispose();
            topLevelStore.dispose();
            tempJobModel.dispose();
            loadForDelete.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createXMLforStore(ServerInterface server, MdFactory factory, MdObjectStore store, boolean beautifyOutput, List<String> ignore) throws RemoteException {
        Map ObjectMap;
        StringBuffer outXML = new StringBuffer();
        Map map = ObjectMap = store.getDetailObjectMap();
        synchronized (map) {
            CMetadata inObject;
            String objectID;
            int i;
            Object[] map2 = ObjectMap.keySet().toArray();
            for (i = 0; i < map2.length; ++i) {
                objectID = (String)map2[i];
                inObject = store.getObject(objectID, true);
                if (inObject == null || inObject.isNewObject() || this.doesObjectExist(server, inObject)) continue;
                store.deleteObjectFromStore(objectID);
            }
            map2 = ObjectMap.keySet().toArray();
            for (i = 0; i < map2.length; ++i) {
                objectID = (String)map2[i];
                if (ignore.contains(objectID)) continue;
                inObject = store.getObject(objectID, true);
                outXML.append(inObject.createObjectXML(inObject, beautifyOutput));
            }
        }
        if (beautifyOutput) {
            return factory.getOMIUtil().formatXML(outXML.toString());
        }
        return outXML.toString();
    }

    private class FixLinksUndoable
    extends AbstractUndoableEdit {
        private DiagramModel diagram;

        public FixLinksUndoable(DiagramModel diagram) {
            this.diagram = diagram;
        }

        @Override
        public void undo() {
        }

        @Override
        public void redo() {
            this.diagram.createLinksNotExistingInXML();
        }
    }
}

