/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.copypaste;

import com.sas.etl.models.job.CopyPasteDependentItem;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramUtil;
import java.awt.Point;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PFDCopyPasteSerializer
implements Serializable {
    private static final long serialVersionUID = -5967147247724518532L;
    private boolean _vertical = true;
    private HashMap<CopyPasteDependentItem, Point> copiedObjects = new HashMap();
    private HashMap<String, Point> additionalObjs = new HashMap();
    private String metadataXML;
    private ArrayList<String> ignoreObjects = new ArrayList();
    private ArrayList<String> connectObjects = new ArrayList();

    public void setMetadataXML(String xml) {
        this.metadataXML = xml;
    }

    public String getMetadataXML() {
        return this.metadataXML;
    }

    public void setCopiedObjects(HashMap<CopyPasteDependentItem, Point> objs) {
        for (Map.Entry<CopyPasteDependentItem, Point> entry : objs.entrySet()) {
            this.addCopyObject(entry.getKey(), entry.getValue());
        }
    }

    public void addIgnoreObject(String id) {
        if (this.ignoreObjects.contains(id)) {
            return;
        }
        this.ignoreObjects.add(id);
    }

    public boolean isIgnoreObject(String id) {
        return this.ignoreObjects.contains(id);
    }

    public void removeIgnoreObject(String id) {
        this.ignoreObjects.remove(id);
    }

    public void addConnectObject(String id) {
        if (this.connectObjects.contains(id)) {
            return;
        }
        this.connectObjects.add(id);
    }

    public boolean isConnectObject(String id) {
        return this.connectObjects.contains(id);
    }

    public void removeConnectObject(String id) {
        this.connectObjects.remove(id);
    }

    public CopyPasteDependentItem getObjectCopied(String id) {
        for (Map.Entry<CopyPasteDependentItem, Point> item : this.copiedObjects.entrySet()) {
            if (!item.getKey().getId().equals(id)) continue;
            return item.getKey();
        }
        return null;
    }

    public Map<CopyPasteDependentItem, Point> getCopiedObjects() {
        return this.copiedObjects;
    }

    private Map<IDiagramStickyNote, Point> getNotes() throws SAXException, IOException, ParserConfigurationException {
        HashMap<IDiagramStickyNote, Point> m = new HashMap<IDiagramStickyNote, Point>();
        for (Map.Entry<String, Point> note : this.additionalObjs.entrySet()) {
            ArrayList notes = new ArrayList();
            DiagramUtil.getObjectsFromXML(note.getKey(), new ArrayList(), new ArrayList(), notes, null);
            if (notes.isEmpty()) continue;
            IDiagramStickyNote dsn = (IDiagramStickyNote)notes.get(0);
            m.put(dsn, note.getValue());
        }
        return m;
    }

    public Map<IDiagramStickyNote, Point> getAdditionalObjects() throws SAXException, IOException, ParserConfigurationException {
        Map<IDiagramStickyNote, Point> dsns = this.getNotes();
        ValueComparator bvc = new ValueComparator(dsns);
        TreeMap<IDiagramStickyNote, Point> sorted_map = new TreeMap<IDiagramStickyNote, Point>(bvc);
        sorted_map.putAll(dsns);
        return sorted_map;
    }

    public void setAdditionalObjects(HashMap<IDiagramStickyNote, Point> objs) {
        for (Map.Entry<IDiagramStickyNote, Point> entry : objs.entrySet()) {
            this.addAdditionalObject(entry.getKey(), entry.getValue());
        }
    }

    public void addAdditionalObject(IDiagramStickyNote obj, Point point) {
        this.additionalObjs.put(obj.writeToXML(null), point);
    }

    public Point getObjectLocation(String id) {
        CopyPasteDependentItem item = this.getObjectCopied(id);
        if (item != null) {
            return this.copiedObjects.get(item);
        }
        return null;
    }

    public void addCopyObject(CopyPasteDependentItem id, Point point) {
        this.copiedObjects.put(id, point);
    }

    public void setIsOrientationVertical(boolean vertical) {
        this._vertical = vertical;
    }

    class ValueComparator
    implements Comparator {
        Map base;

        public ValueComparator(Map base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            int bC;
            Point aP = (Point)this.base.get(a);
            Point bP = (Point)this.base.get(b);
            if (aP == null && bP == null) {
                return 0;
            }
            if (bP == null) {
                return 1;
            }
            if (aP == null) {
                return -1;
            }
            int aC = PFDCopyPasteSerializer.this._vertical ? aP.x : aP.y;
            int n = bC = PFDCopyPasteSerializer.this._vertical ? bP.x : bP.y;
            if (aC < bC) {
                return -1;
            }
            if (aC == bC) {
                return 0;
            }
            return 1;
        }
    }
}

