/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.XMLWriterTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.xmlwriter.XMLDefaultODSTemplate;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XMLWriterTransformAdapter
extends AbstractDataTransformAdapter {
    private XMLWriterTransformModel m_writer;
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(XMLWriterTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(XMLWriterTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(XMLWriterTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(XMLWriterTransformModel.getTransformTypeID(), 24);

    public XMLWriterTransformAdapter(XMLWriterTransformModel transform) {
        super((IDataTransform)transform);
        this.m_writer = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        OptionsTab optionsTab = null;
        try {
            optionsTab = new OptionsTab(this.m_writer.getOptionModel(), "options_tab_xmlwriter", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_writer, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_writer));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(optionsTab);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_writer, true, false));
            lTabs.add(this.createPreProcessCode(this.m_writer));
            lTabs.add(new ConditionActionsTab((IConditionActionSetContainer)this.m_writer));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_writer));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_writer));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_writer, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServerException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrePostCodeTab createPreProcessCode(XMLWriterTransformModel omodel) throws ServerException {
        IModel model = omodel.getModel();
        PrePostCodeTab prePostTab = new PrePostCodeTab((IPrePostCode)this.m_writer);
        model.startCompoundUndoable();
        try {
            prePostTab.setPreCodeSource(XMLDefaultODSTemplate.getUWCode());
        }
        finally {
            model.endCompoundUndoable();
        }
        return prePostTab;
    }
}

