/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.impl.BasePhysicalTable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IMultiplePortTransformModel;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.waitforcompletion.WaitForCompletionTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractMultiplePortTransformAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IDataTransformNodeAdapter;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class WaitForCompletionTransformAdapter
extends AbstractMultiplePortTransformAdapter
implements IDataTransformNodeAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(WaitForCompletionTransformAdapter.class);
    private static final WAdminResource appActionsManagerBundle = WAdminResource.getBundle(AppActionsManager.class);
    public static final int CONTROL_PORT = 0;
    public static final int TARGET_PORT = 1;
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(WaitForCompletionTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(WaitForCompletionTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(WaitForCompletionTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(WaitForCompletionTransformModel.getTransformTypeID(), 24);
    private WaitForCompletionTransformModel m_transform;

    public WaitForCompletionTransformAdapter(WaitForCompletionTransformModel transform) {
        super((IMultiplePortTransformModel)transform);
        this.m_transform = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionsTab = new OptionsTab(this.m_transform.getOptionModel(), "options_tab_waitforcomp", false);
            optionsTab.setHelpTopic("options_tab_waitforcomp");
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(optionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, false));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public int deleteInputPort(Object obj) {
        if (obj != null) {
            int iPort = this.m_transform.getSourcePorts().indexOf(obj);
            return iPort;
        }
        return -1;
    }

    @Override
    public int deleteInputPort(Object obj, int inputPortIndex) {
        if (obj != null && obj instanceof IPortDescription) {
            if (inputPortIndex > 0) {
                return inputPortIndex;
            }
            int iPort = this.m_transform.getTargetPorts().indexOf(obj);
            if (iPort > -1) {
                return iPort + 1;
            }
        }
        return -1;
    }

    public boolean isAddInputAvailable() {
        return true;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.isValidConnectToInput(obj, portIndex);
        }
        if (portIndex > 0 && obj instanceof IDataObject) {
            return this.isValidPhysicalTableInput((BasePhysicalTable)obj);
        }
        return false;
    }

    public boolean isValidPhysicalTableInput(BasePhysicalTable oInputTable) {
        if (oInputTable.getColumnCount() != 6) {
            return false;
        }
        IColumn[] oColumnList = oInputTable.getColumns();
        if (oColumnList[0].getName().compareToIgnoreCase("etls_handleName") != 0) {
            return false;
        }
        if (oColumnList[1].getName().compareToIgnoreCase("etls_machineId") != 0) {
            return false;
        }
        if (oColumnList[2].getName().compareToIgnoreCase("etls_startTime") != 0) {
            return false;
        }
        if (oColumnList[3].getName().compareToIgnoreCase("etls_endTime") != 0) {
            return false;
        }
        if (oColumnList[4].getName().compareToIgnoreCase("etls_status") != 0) {
            return false;
        }
        return oColumnList[5].getName().compareToIgnoreCase("etls_jobRC") == 0;
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.formatString("WaitForCompletionTransformAdapter.InvalidInputMessage.txt", (Object)this.getName());
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex == 1 && obj instanceof IPhysicalTable && !this.m_transform.containsInDataTargets((IDataObject)obj);
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        return portIndex == 1 && obj instanceof IPhysicalTable;
    }
}

