/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.data.dbmstypes.SASIOLAType;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLPort;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.impl.SQLJoinTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.drill.DrillComponent;
import com.sas.wadmin.jobeditor.diagram.adapters.IDrillableAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.transforms.sql.AliasNameDialog;
import com.sas.wadmin.transforms.sql.editor.JoinEditorPanel;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SQLJoinTransformAdapter
extends AbstractDataTransformAdapter
implements IDrillableAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLJoinTransformAdapter.class);
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(SQLJoinTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(SQLJoinTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(SQLJoinTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(SQLJoinTransformModel.getTransformTypeID(), 24);
    private SQLJoinTransformModel m_sql;
    private WsAbstractToggleAction m_actAutoJoinConditions;

    public SQLJoinTransformAdapter(SQLJoinTransformModel transform) {
        super((IDataTransform)transform);
        this.m_sql = transform;
        this.setDefaultAction((Action)AppActionsManager.getInstance().getAction("Context:Open"));
        this.m_actAutoJoinConditions = new AutoJoinConditionsAction();
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj) {
        if (obj != null && obj instanceof ISQLPort) {
            return this.createInputPortDescription((ISQLPort)obj);
        }
        return null;
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj, int inputPortIndex) {
        if (obj != null && obj instanceof ISQLPort) {
            return this.createInputPortDescription((ISQLPort)obj);
        }
        return null;
    }

    private IPortDescription createInputPortDescription(ISQLPort portModel) {
        return PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(portModel.getName(), 1, DEFAULT_TABLE_TYPES);
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        ISQLPort[] aSourcePorts = this.m_sql.getPortDescriptions();
        IPortDescription[] aPortDesc = new IPortDescription[aSourcePorts.length + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlInputPortDescriptionForTransform(1);
        for (int i = 0; i < aSourcePorts.length; ++i) {
            ISQLPort srcPort = aSourcePorts[i];
            aPortDesc[i + 1] = this.createInputPortDescription(srcPort);
        }
        return aPortDesc;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        if (obj instanceof IDataObject) {
            return this.m_sql.findInSourcePort((IPhysicalTable)obj) + 1;
        }
        return -1;
    }

    @Override
    public int[] getInputPortIndexes(IObject obj) {
        if (obj instanceof IDataObject) {
            ISourceTable[] alSources = this.m_sql.getQuery().findInAllQuerySourceTables((ITable)obj);
            int[] alInts = new int[alSources.length];
            block0: for (int index = 0; index < alSources.length; ++index) {
                ISourceTable srcTable = alSources[index];
                ISQLPort[] alPorts = this.m_sql.getPortDescriptions();
                for (int iPort = 0; iPort < alPorts.length; ++iPort) {
                    ISQLPort port = alPorts[iPort];
                    IObject object = port.getObject();
                    if (object != srcTable) continue;
                    alInts[index] = iPort + 1;
                    continue block0;
                }
            }
            return alInts;
        }
        return null;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex >= 1 && obj instanceof IDataObject && this.m_sql.isValidAsSourceTable((IDataObject)obj);
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex > 0 && obj instanceof IDataObject) {
            ISourceTable[] aSources;
            String aliasName = "";
            if (obj instanceof ITable) {
                aliasName = ((ITable)obj).getTableName(false);
            }
            if ((aSources = this.m_sql.getQuery().findInAllQuerySourceTables((ITable)obj)).length > 0) {
                AliasNameDialog dlg = new AliasNameDialog();
                dlg.setDefault((IPhysicalTable)obj);
                if (dlg.showDialog() == 0) {
                    aliasName = dlg.getAliasText();
                } else {
                    return false;
                }
            }
            this.m_sql.addAliasedDataSource(portIndex, (IDataObject)obj, aliasName);
            return true;
        }
        return false;
    }

    @Override
    public List updateInputPort(Object obj) {
        int iIndex;
        ArrayList<Object> lRtn = new ArrayList<Object>(2);
        if (obj != null && obj instanceof ISQLPort && (iIndex = this.m_sql.getPortDescriptionList().indexOf(obj)) > -1) {
            int iPortIndex = iIndex + 1;
            lRtn.add(iPortIndex);
            lRtn.add(((ISQLPort)obj).getName());
            return lRtn;
        }
        return null;
    }

    @Override
    public boolean disconnectFromInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex > 0 && obj instanceof IDataObject) {
            this.m_sql.getModel().startCompoundUndoable();
            try {
                this.m_sql.removeQuerySourceTable(portIndex);
                this.m_sql.updatePortDescriptionName(portIndex, bundle.getString("AbstractDataTransformAdapter.InputDataPort.ToolTip.txt"));
            }
            finally {
                this.m_sql.getModel().endCompoundUndoable();
            }
            return true;
        }
        return false;
    }

    @Override
    public int deleteInputPort(Object obj) {
        int iPort;
        if (obj != null && obj instanceof ISQLPort && (iPort = this.m_sql.getPortDescriptionList().indexOf(obj)) > -1) {
            return iPort + 1;
        }
        return -1;
    }

    @Override
    public int deleteInputPort(Object obj, int inputPortIndex) {
        if (obj != null && obj instanceof ISQLPort) {
            if (inputPortIndex > 0) {
                return inputPortIndex;
            }
            int iPort = this.m_sql.getPortDescriptionList().indexOf(obj);
            if (iPort > -1) {
                return iPort + 1;
            }
        }
        return -1;
    }

    @Override
    public boolean isMappingAutomatically(int iPortIndex) {
        return this.determineMappingAndPropagating(iPortIndex);
    }

    @Override
    public boolean isPropagatingAutomatically(int iPortIndex) {
        return this.determineMappingAndPropagating(iPortIndex);
    }

    private boolean determineMappingAndPropagating(int iPortIndex) {
        if (iPortIndex == 0) {
            return true;
        }
        IQuery query = this.m_sql.getQuery();
        ISQLPort[] alPorts = this.m_sql.getPortDescriptions();
        ISQLPort port = alPorts[iPortIndex - 1];
        IObject container = port.getObjectContainer();
        IQuery portQuery = null;
        if (container instanceof IJoin) {
            portQuery = ((IJoin)container).getParentQuery();
        } else if (container instanceof IQuery) {
            portQuery = (IQuery)container;
        }
        return portQuery == null || portQuery == query;
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionTab = new OptionsTab(this.m_sql.getOptionModel(), "options_tab_transform", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_sql, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_sql));
            lTabs.add(optionTab);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_sql, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_sql));
            lTabs.add(new ConditionActionsTab((IConditionActionSetContainer)this.m_sql));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_sql));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_sql));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_sql, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    protected WAPropertyTab createMappingsTab(boolean details) {
        ISelectResultsContainer select = this.m_sql.getQuery().getSelectResults();
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setMultipleSourceTablesEnabled(true);
        config.setDragMultipleSourceColumnsEnabled(true);
        config.setUseSQLSyntax(true);
        config.setHiddenColumnsInTargetColumnsTable(new int[]{5, 6});
        config.setHiddenExpressionActions(new int[0]);
        config.setWhereUsedSettingsKeyPrefix(details ? "Details" : "Properties");
        config.setTargetTableSettingsKeyPrefix("SQLJoin.TargetColumnsTable");
        IQuery parent = select.getParentQuery();
        if (parent instanceof ISubquery) {
            config.setPropagationActionsVisible(1);
            config.setSettingsActionVisible(false);
        }
        return new MappingsTab((IMappingsContainer)select, config);
    }

    @Override
    public DrillComponent getDrillComponent(RunModel model) {
        JoinEditorPanel pnl = new JoinEditorPanel((ISQLTransform)this.m_sql);
        pnl.setRunModel(model);
        return pnl;
    }

    @Override
    public void addContextMenuItems(JPopupMenu mnuPopup) {
        mnuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actAutoJoinConditions));
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        if (obj instanceof IPhysicalTable) {
            IDBMSType dbmsType = ((IPhysicalTable)obj).getDBMSType();
            if (dbmsType instanceof SASHDATType) {
                return bundle.formatString("AbstractDataTransformAdapter.SASHDATInvalidAsInputMessage.txt", (Object)this.getName());
            }
            if (dbmsType instanceof SASIOLAType) {
                return bundle.formatString("AbstractDataTransformAdapter.SASIOLAInvalidAsInputMessage.txt", (Object)this.getName());
            }
        }
        return bundle.formatString("AbstractDataTransformAdapter.InvalidInputMessage.txt", (Object)this.getName());
    }

    private class AutoJoinConditionsAction
    extends WsAbstractToggleAction {
        public AutoJoinConditionsAction() {
            super(bundle, "SQLJoinTransformAdapter.Action.AutoJoinCondition", 256);
            this.setSelected(SQLJoinTransformAdapter.this.m_sql.isAutoJoinEnabled());
        }

        public void actionPerformed(ActionEvent ev) {
            SQLJoinTransformAdapter.this.m_sql.setAutoJoinEnabled(this.isSelected());
        }
    }
}

