/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.etl.models.job.transforms.miningresults.impl.MiningResultsTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.miningresults.MiningResultAttributesTab;
import com.sas.wadmin.transforms.miningresults.MiningResultSelectorTab;
import com.sas.wadmin.transforms.miningresults.MiningResultTargetColumnsTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MiningResultsTransformAdapter
extends AbstractDataTransformAdapter {
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(MiningResultsTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(MiningResultsTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(MiningResultsTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(LookupTransformModel.getTransformTypeID(), 24);
    private MiningResultsTransformModel m_MiningResults;

    public MiningResultsTransformAdapter(MiningResultsTransformModel transform) {
        super((IDataTransform)transform);
        this.m_MiningResults = transform;
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab tabOptions = new OptionsTab(this.m_MiningResults.getOptionModel(), "options_tab_transform", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_MiningResults, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_MiningResults));
            lTabs.add(new MiningResultSelectorTab(this.m_MiningResults));
            lTabs.add(new MiningResultAttributesTab(this.m_MiningResults));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(new MiningResultTargetColumnsTab(this.m_MiningResults));
            lTabs.add(tabOptions);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_MiningResults, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_MiningResults));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_MiningResults));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_MiningResults));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_MiningResults, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab createMappingsTab(boolean details) {
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setTargetTablesEditable(false);
        config.setPropagationActionsVisible(1);
        MappingsTab mappingTab = new MappingsTab((IMappingsContainer)this.m_MiningResults, config);
        mappingTab.setHelpProduct("wdb");
        mappingTab.setHelpTopic("mapping_tab_mresults");
        return mappingTab;
    }
}

