/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.lookup.LookupPortDescriptionModel;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.ISourceInvalidMessage;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.lookup.visuals.ErrorsTab;
import com.sas.wadmin.transforms.lookup.visuals.LookupTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class LookupTransformAdapter
extends AbstractDataTransformAdapter
implements ISourceInvalidMessage {
    private static final WAdminResource bundle = WAdminResource.getBundle(LookupTransformAdapter.class);
    public static final int CONTROL_PORT = 0;
    public static final int SOURCE_PORT = 1;
    public static final int FIRST_LOOKUP_PORT = 2;
    public static final int TARGET_PORT = 1;
    public static final int ERROR_PORT = 2;
    public static final int EXCEPTION_PORT = 3;
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(LookupTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(LookupTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(LookupTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(LookupTransformModel.getTransformTypeID(), 24);
    private LookupTransformModel m_lookup;

    public LookupTransformAdapter(LookupTransformModel transform) {
        super((IDataTransform)transform);
        this.m_lookup = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        LookupPortDescriptionModel[] aInputPorts = this.m_lookup.getInputPortDescriptions();
        IPortDescription[] aPortDesc = new IPortDescription[aInputPorts.length + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlInputPortDescriptionForTransform(1);
        for (int i = 0; i < aInputPorts.length; ++i) {
            LookupPortDescriptionModel inputPort = aInputPorts[i];
            aPortDesc[i + 1] = PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(inputPort.getTooltipText(), inputPort.getName(), 1, DEFAULT_TABLE_TYPES);
        }
        return aPortDesc;
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj) {
        if (obj != null && obj instanceof LookupPortDescriptionModel) {
            String sPortName = ((LookupPortDescriptionModel)obj).getName();
            String sPortText = ((LookupPortDescriptionModel)obj).getTooltipText();
            return PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(sPortText, sPortName, 1, DEFAULT_TABLE_TYPES);
        }
        return null;
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj, int inputPortIndex) {
        if (obj != null && obj instanceof LookupPortDescriptionModel) {
            String sPortName = ((LookupPortDescriptionModel)obj).getName();
            String sPortText = ((LookupPortDescriptionModel)obj).getTooltipText();
            return PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(sPortText, sPortName, 1, DEFAULT_TABLE_TYPES);
        }
        return null;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        LookupPortDescriptionModel[] aOutputPorts = this.m_lookup.getOutputPortDescriptions();
        IPortDescription[] aPortDesc = new IPortDescription[aOutputPorts.length + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlOutputPortDescriptionForTransform(1);
        for (int i = 0; i < aOutputPorts.length; ++i) {
            LookupPortDescriptionModel outputPort = aOutputPorts[i];
            aPortDesc[i + 1] = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(outputPort.getTooltipText(), outputPort.getName(), 1, DEFAULT_TABLE_TYPES);
        }
        return aPortDesc;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        int[] iaPorts;
        if (obj instanceof IPhysicalTable && (iaPorts = this.m_lookup.findInSourcePorts((IPhysicalTable)obj)).length > 0) {
            return iaPorts[0] + 1;
        }
        return -1;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        int[] iaPorts;
        if (obj instanceof IPhysicalTable && (iaPorts = this.m_lookup.findInTargetPorts((IPhysicalTable)obj)).length > 0) {
            return iaPorts[0] + 1;
        }
        return -1;
    }

    @Override
    public int[] getInputPortIndexes(IObject obj) {
        int[] iaPorts = this.m_lookup.findInSourcePorts((IPhysicalTable)obj);
        int i = 0;
        while (i < iaPorts.length) {
            int n = i++;
            iaPorts[n] = iaPorts[n] + 1;
        }
        return iaPorts;
    }

    @Override
    public int[] getOutputPortIndexes(IObject obj) {
        int[] iaPorts = this.m_lookup.findInTargetPorts((IPhysicalTable)obj);
        int i = 0;
        while (i < iaPorts.length) {
            int n = i++;
            iaPorts[n] = iaPorts[n] + 1;
        }
        return iaPorts;
    }

    @Override
    public int deleteInputPort(Object obj) {
        int iPort;
        if (obj != null && obj instanceof LookupPortDescriptionModel && (iPort = this.m_lookup.getInputPortDescriptionList().indexOf(obj)) > 0) {
            return iPort + 1;
        }
        return -1;
    }

    @Override
    public int deleteInputPort(Object obj, int inputPortIndex) {
        if (obj != null && obj instanceof LookupPortDescriptionModel) {
            if (inputPortIndex > 0) {
                return inputPortIndex;
            }
            int iPort = this.m_lookup.getInputPortDescriptionList().indexOf(obj);
            if (iPort > -1) {
                return iPort + 1;
            }
        }
        return -1;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex >= 1 && obj instanceof IPhysicalTable;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            if (obj instanceof ITransform) {
                return true;
            }
        } else if (portIndex == 1) {
            if (obj instanceof IPhysicalTable && !this.m_lookup.containsInDataTargets((IDataObject)obj)) {
                return true;
            }
        } else if (portIndex == 2 || portIndex == 3) {
            return false;
        }
        return false;
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1) {
            if (obj instanceof IPhysicalTable) {
                this.m_lookup.setSourceTable((IPhysicalTable)obj);
                return true;
            }
        } else if (portIndex >= 2 && obj instanceof IPhysicalTable) {
            this.m_lookup.addLookupTable(portIndex - 1, (IPhysicalTable)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1) {
            if (obj instanceof IPhysicalTable) {
                this.m_lookup.setTargetTable((IPhysicalTable)obj);
                return true;
            }
        } else if (portIndex == 2) {
            if (obj instanceof IPhysicalTable) {
                this.m_lookup.setErrorTable((IPhysicalTable)obj);
                return true;
            }
        } else if (portIndex == 3 && obj instanceof IPhysicalTable) {
            this.m_lookup.setExceptionTable((IPhysicalTable)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1) {
            if (obj instanceof IPhysicalTable) {
                this.m_lookup.setSourceTable(null);
                return true;
            }
        } else if (portIndex >= 2 && obj instanceof IPhysicalTable) {
            this.m_lookup.removeLookupTable(portIndex - 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1) {
            if (obj instanceof IPhysicalTable) {
                this.m_lookup.setTargetTable(null);
                return true;
            }
        } else if (portIndex == 2) {
            if (obj instanceof IPhysicalTable) {
                this.m_lookup.setErrorTable(null);
                return true;
            }
        } else if (portIndex == 3 && obj instanceof IPhysicalTable) {
            this.m_lookup.setExceptionTable(null);
            return true;
        }
        return false;
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionsTab = new OptionsTab(this.m_lookup.getOptionModel(), "options_tab_transform", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_lookup, null, false);
            ArrayList<Object> lTabs = new ArrayList<Object>();
            lTabs.add((Object)new GeneralTab((IObject)this.m_lookup));
            lTabs.add((Object)new LookupTab(this.m_lookup));
            lTabs.add((Object)new ErrorsTab(this.m_lookup));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add((Object)optionsTab);
            lTabs.add((Object)tableOptionsTab);
            lTabs.add((Object)new ProcessTab((ICodeGenerator)this.m_lookup, true, true));
            lTabs.add((Object)new PrePostCodeTab((IPrePostCode)this.m_lookup));
            lTabs.add((Object)new ParameterTab((IParametersContainer)this.m_lookup));
            lTabs.add((Object)new NotesTab((INotesAndDocumentsContainer)this.m_lookup));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_lookup, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        if (portIndex > 1) {
            return bundle.formatString("LookupTransformAdapter.InvalidOutputMessage.txt", (Object)this.getName());
        }
        return null;
    }
}

