/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.LibraryContentsTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.visuals.common.ExtractRowSelectorTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class LibraryContentsTransformAdapter
extends AbstractDataTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(LibraryContentsTransformAdapter.class);
    private static final String[] LIBRARY_TYPE = new String[]{"SASLibrary"};
    private static final IPortDescription LIBRARYCONTENTS_INPUT_DATA_PORT = PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(bundle.getString("LibraryContentsTransformAdapter.InputDataPort.ToolTip.txt"), 1, LIBRARY_TYPE);
    private static final IPortDescription[] LIBRARYCONTENTS_INPUT_PORTS = new IPortDescription[]{DEFAULT_INPUT_CONTROL_PORT, LIBRARYCONTENTS_INPUT_DATA_PORT};
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(LibraryContentsTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(LibraryContentsTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(LibraryContentsTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(LibraryContentsTransformModel.getTransformTypeID(), 24);
    private LibraryContentsTransformModel m_contents;

    public LibraryContentsTransformAdapter(LibraryContentsTransformModel transform) {
        super((IDataTransform)transform);
        this.m_contents = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return LIBRARYCONTENTS_INPUT_PORTS;
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab tabOptions = new OptionsTab(this.m_contents.getOptionModel(), "options_tab_transform", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_contents, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_contents));
            lTabs.add(new ExtractRowSelectorTab(this.m_contents.getRowSelector(), null, false, true));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(tabOptions);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_contents, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_contents));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_contents));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_contents));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_contents, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        if (obj instanceof ILibrary) {
            return this.m_contents.getInputLibrary() == obj ? 1 : -1;
        }
        return -1;
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        if (obj instanceof ILibrary && ((ILibrary)obj).isClientLibrary()) {
            return bundle.getString("LibraryContentsTransformAdapter.InvalidInputMessageClient.txt");
        }
        return bundle.formatString("LibraryContentsTransformAdapter.InvalidInputMessage.txt", (Object)this.getName());
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex == 1 && obj instanceof ILibrary && !this.m_contents.containsInDataSources((IDataObject)((ILibrary)obj)) && !((ILibrary)obj).isClientLibrary();
    }
}

