/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.ExtractTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.visuals.common.ExtractRowSelectorTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.GroupByPanel;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.OrderByPanel;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ExtractTransformAdapter
extends AbstractDataTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(ExtractTransformAdapter.class);
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(ExtractTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(ExtractTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(ExtractTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(ExtractTransformModel.getTransformTypeID(), 24);
    private ExtractTransformModel m_extract;

    public ExtractTransformAdapter(ExtractTransformModel transform) {
        super((IDataTransform)transform);
        this.m_extract = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        GroupByPanel groupByPanel = new GroupByPanel(this.m_extract.getGroupBy(), this.m_extract.getTargetTables(), new ITable[0]);
        groupByPanel.setName(bundle.getString("ExtractTransformAdapter.GroupBy.txt"));
        OrderByPanel orderByPanel = new OrderByPanel(this.m_extract.getOrderBy(), this.m_extract.getTargetTables(), new ITable[0]);
        orderByPanel.setName(bundle.getString("ExtractTransformAdapter.OrderBy.txt"));
        ExtractRowSelectorTab rowSelectorTab = new ExtractRowSelectorTab(this.m_extract, null, false, true);
        OptionsTab optionsTab = null;
        try {
            optionsTab = new OptionsTab(this.m_extract.getOptionModel(), "options_tab_extract", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_extract, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_extract));
            lTabs.add(rowSelectorTab);
            lTabs.add(groupByPanel);
            lTabs.add(orderByPanel);
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(optionsTab);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_extract, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_extract));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_extract));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_extract));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_extract, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }
}

