/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.IMultiplePortTransformModel;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.dataloader.DataLoaderDirectiveTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractMultiplePortTransformAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IDataTransformNodeAdapter;
import com.sas.wadmin.transforms.dataloader.DataLoaderDirectiveAttributesTab;
import com.sas.wadmin.transforms.dataloader.DirectiveInputOutputTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DataLoaderDirectiveTransformAdapter
extends AbstractMultiplePortTransformAdapter
implements IDataTransformNodeAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(DataLoaderDirectiveTransformAdapter.class);
    private static final WAdminResource appActionsManagerBundle = WAdminResource.getBundle(AppActionsManager.class);
    public static final int CONTROL_PORT = 0;
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(DataLoaderDirectiveTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(DataLoaderDirectiveTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(DataLoaderDirectiveTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(DataLoaderDirectiveTransformModel.getTransformTypeID(), 24);
    private DataLoaderDirectiveTransformModel m_transform;

    public DataLoaderDirectiveTransformAdapter(DataLoaderDirectiveTransformModel transform) {
        super((IMultiplePortTransformModel)transform);
        this.m_transform = transform;
    }

    @Override
    protected WAPropertyTab createMappingsTab(boolean details) {
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setMultipleSourceTablesEnabled(this.m_transform.getMaximumSourceTableCount() > 1);
        config.setMultipleTargetTablesEnabled(this.m_transform.getMaximumTargetTableCount() > 1);
        config.setHiddenColumnsInSourceColumnsTable(new int[0]);
        config.setHiddenColumnsInTargetColumnsTable(new int[0]);
        config.setWhereUsedSettingsKeyPrefix(details ? "Details" : "Properties");
        config.setSourceTableSettingsKeyPrefix("GeneratedTransform.SourceColumnsTable");
        config.setTargetTableSettingsKeyPrefix("GeneratedTransform.TargetColumnsTable");
        return new MappingsTab((IMappingsContainer)this.m_transform, config);
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected MappingsTab.Configuration createMappingsConfiguration(boolean details) {
        MappingsTab.Configuration config = super.createMappingsConfiguration(details);
        config.setHiddenColumnsInTargetColumnsTable(new int[]{4});
        config.setMultipleTargetTablesEnabled(true);
        return config;
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionsTab = new OptionsTab(this.m_transform.getOptionModel(), "options_tab_dl_directive", false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(this.getNodeDetailsPanel());
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(new DirectiveInputOutputTab(this.m_transform));
            lTabs.add(optionsTab);
            lTabs.add(new TransformTableOptionsTab((IDataTransform)this.m_transform, null, false));
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, false));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return new DataLoaderDirectiveAttributesTab(this.m_transform);
    }

    @Override
    public void addContextMenuItems(JPopupMenu popupMenu) {
        boolean isSeparator = false;
        for (int index = 0; index < popupMenu.getSubElements().length; ++index) {
            MenuElement element = popupMenu.getSubElements()[index];
            if (element instanceof JMenu) {
                if (!((JMenu)element).getText().equalsIgnoreCase(this.removeAndCharacter(appActionsManagerBundle.getString("AppActionsManager.ContextAction.PropagateColumnsForJob.txt")))) continue;
                popupMenu.remove(index);
                --index;
                continue;
            }
            if (element instanceof JMenuItem) {
                if (!((JMenuItem)element).getText().equalsIgnoreCase(this.removeAndCharacter(appActionsManagerBundle.getString("AppActionsManager.ContextAction.MapColumnsForTransformations.txt"))) && !((JMenuItem)element).getText().equalsIgnoreCase(this.removeAndCharacter(appActionsManagerBundle.getString("AppActionsManager.Action.ContextSettingsIncludeInPropagation.txt"))) && !((JMenuItem)element).getText().equalsIgnoreCase(this.removeAndCharacter(appActionsManagerBundle.getString("AppActionsManager.Action.ContextSettingsIncludeInMappings.txt")))) continue;
                popupMenu.remove(index);
                --index;
                continue;
            }
            if (element instanceof JPopupMenu.Separator) {
                if (!isSeparator) continue;
                popupMenu.remove(index);
                continue;
            }
            isSeparator = element instanceof JPopupMenu.Separator;
        }
    }

    private String removeAndCharacter(String word) {
        return word.replaceAll("&", "");
    }
}

